﻿using System.Runtime.Serialization;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Common.DTO.PatientIdentifier
{
    /// <summary>
    /// This Patient Identifier is used for patients who is registered at the enterprise level
    /// </summary>
    [KnownType(typeof(PatientIdentifierBase))]
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class RegisteredEnterprisePatient : PatientIdentifierBase
    {
        #region Properties

        /// <summary>
        /// Gets or sets a facility-level ID for the patient.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 20)]
        public string Mrn { get; set; }

        /// <summary>
        /// Gets or sets an enterprise-level ID for the patient.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 20)]
        public string StatePatientId { get; set; }

        #endregion Properties
    }
}