﻿using System;
using System.Collections.Generic;
using System.ServiceModel;
using HIPS.P2P.Service.Contract.Common.DTO;
using HIPS.P2P.Service.Contract.Common.DTO.UserIdentity;
using HIPS.P2P.Service.Contract.Common.Fault;
using HIPS.P2P.Service.Contract.Messaging.Delivery.Message;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;
using System.IO;

namespace Test.HiCcaNoc.CCA.UC_330
{
    /// <summary>
    /// The software shall not include a healthcare identifier (IHI, HPI-O, HPI-I)
    /// in an eHealth message/document if an unresolved exception or alert exists
    /// for that identifier in the local system.
    /// </summary>
    [TestClass]
    public class HI_CCA_330_010613 : CcaTest
    {
        /// <summary>
        /// Inclusion of a healthcare identifier in an eHealth message/document with
        /// an unresolved exception or alert
        /// 
        /// a. Verify that the software shall not include a healthcare identifier 
        /// (IHI, HPI-O, HPI-I) in an eHealth message/document if an unresolved
        /// exception or alert exists for that identifier in the local system.
        /// </summary>
        [TestMethod]
        [TestCategory("HI_CCA_330")]
        public void HI_CCA_330_010613_1()
        {
            this.patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: true, testDataId: "NOC ID 17");
            this.provider = CcaProviders.GetProvider("NOC ID 1");
            CdaDocument document = patient.CreateNewDocument(SampleDocumentType.DischargeSummary);

            var request = new SendMessageRequest
            {
                ContentPackage = new CdaMessageContentPackage
                {
                    Content = new CdaMessageContent
                    {
                        Document = document.GetBytes()
                    },
                    HospitalCode = this.patient.TargetPatientIdentifier.HospitalCode,
                    HospitalCodeSystem = this.patient.TargetPatientIdentifier.HospitalCodeSystem
                },
                Expiry = DateTime.Now.AddHours(1),
                Receiver = new MessageAddressee
                {
                    Individual = new ProviderIndividualIdentity
                    {
                        Identifier = new ProviderIndividualIdentifier
                        {
                            Value = this.provider.TestProviderHpiiNumber,
                            Type = new ProviderIdentifierType
                            {
                                Code = "HPII"
                            }
                        }
                    },
                    Organisation = new ProviderOrganisationIdentity
                    {
                        Identifier = new ProviderOrganisationIdentifier
                        {
                            Value = this.provider.TestProviderHpioNumber,
                            Type = new ProviderIdentifierType
                            {
                                Code = "HPIO"
                            }
                        }
                    }
                },
                Sender = new MessageAddressee
                {
                    Organisation = new ProviderOrganisationIdentity
                    {
                        Identifier = new ProviderOrganisationIdentifier
                        {
                            Value = this.patient.TargetHospital.HpiO,
                            Type = new ProviderIdentifierType
                            {
                                Code = "HPIO"
                            }
                        }
                    }
                },
                User = new LocalUser
                {
                    AccessingHpio = this.patient.TargetHospital.HpiO,
                    Domain = this.patient.GetTestUser().Domain,
                    Login = this.patient.GetTestUser().Login,
                    FamilyName = this.patient.GetTestUser().Name,
                    GivenNames = this.patient.GetTestUser().Name,
                }
            };

            try
            {
                var response = ProxyHelper.MessageDeliveryProxy.SendMessage(request);
                LogAssert.Fail("Expected Exception");
            }
            catch (FaultException<ServiceOperationFault> ex)
            {
                LogAssert.AreEqual("An error occurred while executing the service operation.", ex.Detail.Message, "Fault Message");
            }
        }
    }
}
