﻿using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrSchemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalInformationSystem.UC_CIS_001
{
    /// <summary>
    /// Conformance Test Specification: Clinical Information Systems Connecting to the PCEHR System
    ///                                 Version 1.6 — 27 September 2012
    /// Use Case #:	    UC.CIS.001
    /// Use Case Name:	Check if an advertised PCEHR exists
    /// Test Case ID:   PCEHR_CIS_019378
    /// Objective:
    /// To check there is a capability to create audit logs for interactions with the PCEHR System.
    /// </summary>
    [TestClass]
    public class PCEHR_CIS_019378 : CcaTest
    {
        /// <summary>
        /// Perform an operation to invoke doesPCEHRExist service on the PCEHR system.
        /// a. Demonstrate that an audit capability exists.
        /// </summary>
        [TestMethod]
        [TestCategory("CIS_CCA_001")]
        public void CIS_001_019378_A()
        {
            patient = CcaPatient.GetPatient(ihiValid: true, validatedWithinPeriod: true, hasUnresolvedAlerts: false);
            DoesPcehrExistResponse response = ProxyHelper.PcehrProxy.IsPcehrAdvertised(patient.TargetPatientIdentifier, patient.TargetPatient.DateOfBirth, patient.GetTestUser());
            LogAssert.ExpectResponse(HipsResponseIndicator.OK, response.HipsResponse, DialogueResource.HipsServiceIsPcehrAdvertised);

            // Check that the PCEHR service invocation was audited
            PcehrAudit audit = patient.GetLastPcehrAudit();
            LogAssert.AreEqual(patient.TargetPatientMasterId, audit.PatientMasterId, DialogueResource.PcehrAuditPatientMasterId);
            LogAssert.AreEqual(AuditOperationNames.DoesPcehrExist, audit.ServiceName, DialogueResource.PcehrAuditServiceName);
        }
    }
}