﻿using System;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Xsl;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void DownloadDocPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            DownloadDocHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            DownloadDocMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            DownloadDocDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            DownloadDocHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            DownloadDocumentButton.Enabled = true;
        }

        private void DownloadDocumentButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            DownloadDocMessagesTextBox.Visible = false;
            DownloadDocMessagesTextBox.Text = "";
            AttachmentListBox.Items.Clear();
            var client = GetPcehrServiceClient();
            StringBuilder message = new StringBuilder();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DocumentResponse documentResponse = new DocumentResponse();
                DocumentRequest documentRequest = new DocumentRequest();

                documentRequest.DocumentUniqueId = DownloadDocDocumentUniqueIdTextBox.Text;
                documentRequest.RepositoryUniqueId = DownloadDocRepositoryUniqueIdTextBox.Text;

                documentResponse = client.RetrieveDocument(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), documentRequest);

                if (documentResponse.FileName != null)
                {
                    DownloadDocRootFileName.Text = documentResponse.FileName;

                    try
                    {
                        if (!Directory.Exists(DownloadDocSavePath.Text))
                        {
                            System.IO.Directory.CreateDirectory(DownloadDocSavePath.Text);
                        }

                        FileStream stream = new FileStream(Path.Combine(DownloadDocSavePath.Text, documentResponse.FileName), FileMode.Create, FileAccess.Write);
                        stream.Write(documentResponse.Document, 0, documentResponse.Document.Length);
                        stream.Close();
                    }
                    catch (Exception fioe)
                    {
                        message.AppendLine("Error Writing Root File:" + documentResponse.FileName);
                        message.AppendLine(fioe.ToString());
                    }

                    if (documentResponse.Attachments.Count != 0)
                    {
                        foreach (HIPS.PcehrSchemas.Attachment attact in documentResponse.Attachments)
                        {
                            AttachmentListBox.Items.Add(attact.FileName);
                            try
                            {
                                FileStream stream = new FileStream(Path.Combine(DownloadDocSavePath.Text, attact.FileName), FileMode.Create, FileAccess.Write);
                                stream.Write(attact.Contents, 0, attact.Contents.Length);
                                stream.Close();
                            }
                            catch (Exception fioe)
                            {
                                message.AppendLine("Error Writing Attachment File: " + attact.FileName);
                                message.AppendLine(attact.FileName + fioe.ToString());
                            }
                        }
                    }
                }
                message.AppendLine("Status:" + documentResponse.HipsResponse.Status);

                if (documentResponse.HipsResponse.Status != HipsResponseIndicator.OK)
                {
                    message.AppendLine("ResponseCode:" + documentResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + documentResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + documentResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + documentResponse.HipsResponse.HipsErrorMessage);
                }
                DownloadDocMessagesTextBox.Text = message.ToString();
                DownloadDocMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, DownloadDocMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }

        private void OpenExplorerFolderButton_Click(object sender, EventArgs e)
        {
            DownloadDocMessagesTextBox.Text = "";
            DownloadDocMessagesTextBox.Visible = false;
            if (Directory.Exists(DownloadDocSavePath.Text))
            {
                Process.Start("explorer.exe", DownloadDocSavePath.Text);
            }
            else
            {
                StringBuilder message = new StringBuilder();
                message.AppendLine("'" + DownloadDocSavePath.Text + "' is not a valid path.");
                DownloadDocMessagesTextBox.Text = message.ToString();
                DownloadDocMessagesTextBox.Visible = true;
            }
        }

        private void ViewDocumentButton_Click(object sender, EventArgs e)
        {
            if (DownloadDocRootFileName.Text != string.Empty)
            {
                using (Stream strm = Assembly.GetExecutingAssembly().GetManifestResourceStream("HIPS.DemoHarness.Xslt.NEHTA_Generic_CDA_Stylesheet-1.2.7.xsl"))
                {
                    using (XmlReader reader = XmlReader.Create(strm))
                    {
                        XslCompiledTransform xslt = new XslCompiledTransform();
                        xslt.Load(reader);
                        // use the XslTransform object

                        string xmlFilename = (DownloadDocSavePath.Text + Path.AltDirectorySeparatorChar + DownloadDocRootFileName.Text).ToLower();
                        string htmlFilename = xmlFilename.Replace(".xml", ".html");

                        if (File.Exists(xmlFilename))
                        {

                            XmlDocument xml = new XmlDocument();
                            xml.Load(xmlFilename);

                            FileStream html = new FileStream(htmlFilename, FileMode.Create);

                            xslt.Transform(xml, null, html);

                            html.Close();

                            ViewDocumentForm viewDoc = new ViewDocumentForm(htmlFilename);
                            viewDoc.ShowDialog();
                        }
                    }
                }
            }
        }
    }
}
