﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrSchemas;
using Nehta.VendorLibrary.PCEHR;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void CreationStartDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                CreationStartDateTimePicker.Enabled = true;
            }
            else
            {
                CreationStartDateTimePicker.Enabled = false;
            }
        }

        private void CreationEndDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                CreationEndDateTimePicker.Enabled = true;
            }
            else
            {
                CreationEndDateTimePicker.Enabled = false;
            }
        }

        private void ServiceStartDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                ServiceStartDateTimePicker.Enabled = true;
            }
            else
            {
                ServiceStartDateTimePicker.Enabled = false;
            }
        }

        private void ServiceEndDateCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (((CheckBox)sender).Checked)
            {
                ServiceEndDateTimePicker.Enabled = true;
            }
            else
            {
                ServiceEndDateTimePicker.Enabled = false;
            }
        }

        private void DocListPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            DocListHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            DocListMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            DocListDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            DocListHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();
            GetDocListButton.Enabled = true;
        }

        private void GetDocListButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            DocListMessagesTextBox.Visible = false;
            DocListMessagesTextBox.Text = "";

            bool active = false;
            IList<DocumentStatus> statusList = new List<DocumentStatus>();
            if (DocListStatus.SelectedIndices.Count > 0)
            {
                foreach (String item in DocListStatus.SelectedItems)
                {
                    switch ((DocumentStatus)Enum.Parse(typeof(DocumentStatus), item, true))
                    {
                        case DocumentStatus.Approved:
                            statusList.Add(DocumentStatus.Approved);
                            active = true;
                            break;
                        case DocumentStatus.Deleted:
                            statusList.Add(DocumentStatus.Deleted);
                            break;
                        case DocumentStatus.Deprecated:
                            statusList.Add(DocumentStatus.Deprecated);
                            break;
                        case DocumentStatus.Submitted:
                            statusList.Add(DocumentStatus.Submitted);
                            break;
                    }
                }
            }

            var client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DocumentListResponse<PatientIdentifierBase> documentListResponseResponse = new DocumentListResponse<PatientIdentifierBase>();

                if (CreationStartDateCheckBox.Checked || CreationEndDateCheckBox.Checked
                || ServiceStartDateCheckBox.Checked || ServiceEndDateCheckBox.Checked)
                {
                    DateTime? creationStartDate = null;
                    DateTime? creationEndDate = null;
                    DateTime? serviceStartDate = null;
                    DateTime? serviceEndDate = null;

                    if (CreationStartDateCheckBox.Checked)
                    {
                        creationStartDate = CreationStartDateTimePicker.Value;
                    }
                    if (CreationEndDateCheckBox.Checked)
                    {
                        creationEndDate = CreationEndDateTimePicker.Value;
                    }
                    if (ServiceStartDateCheckBox.Checked)
                    {
                        serviceStartDate = ServiceStartDateTimePicker.Value;
                    }
                    if (ServiceEndDateCheckBox.Checked)
                    {
                        serviceEndDate = ServiceEndDateTimePicker.Value;
                    }

                    if (statusList.Count == 0)
                    {
                        //GetDocumentListFilterDates
                        documentListResponseResponse = client.GetDocumentList(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), creationStartDate, creationEndDate, serviceStartDate, serviceEndDate);
                    }
                    else
                    {
                        if (active)
                        {
                            //GetDocumentListActiveFilterDates
                            documentListResponseResponse = client.GetDocumentList(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), creationStartDate, creationEndDate, serviceStartDate, serviceEndDate);

                        }
                        else
                        {
                            //GetDocumentListFilterStatusAndDates
                            //(all except active)
                            documentListResponseResponse = client.GetDocumentList(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), statusList.ToArray<DocumentStatus>(), creationStartDate, creationEndDate, serviceStartDate, serviceEndDate);
                        }
                    }
                }
                else //no dates
                {
                    if (statusList.Count == 0)
                    {
                        //GetDocumentList
                        documentListResponseResponse = client.GetDocumentList(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());
                    }
                    else
                    {
                        if (active)
                        {
                            //GetDocumentListActive
                            documentListResponseResponse = client.GetDocumentListActive(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());
                        }
                        else
                        {
                            //GetDocument List with other statuses besides active - tests base docQuery also
                            DocumentQuery docQuery = new DocumentQuery();
                            docQuery.DocumentStatus = statusList.ToArray<DocumentStatus>();
                            documentListResponseResponse = client.GetDocumentList(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser(), docQuery);
                        }
                    }

                }

                DocumentListGridView.DataSource = documentListResponseResponse.DocumentList;

                StringBuilder message = new StringBuilder();
                message.AppendLine("Status:" + documentListResponseResponse.HipsResponse.Status);

                if (documentListResponseResponse.HipsResponse.Status != HipsResponseIndicator.OK)
                {
                    message.AppendLine("ResponseCode:" + documentListResponseResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + documentListResponseResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + documentListResponseResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + documentListResponseResponse.HipsResponse.HipsErrorMessage);
                }
                DocListMessagesTextBox.Text = message.ToString();
                DocListMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, DocListMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;

        }

        private void DocumentListGridView_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex < 0 || (e.ColumnIndex != DocumentListGridView.Columns["ChangeHistoryColumnButton"].Index
                                        && e.ColumnIndex != DocumentListGridView.Columns["OpenDocColumnButton"].Index))
            {
                return;
            }
            //String documentUniqueId  = ((DataGridView)sender).CurrentRow.Cells["DocumentUniqueId"].Value.ToString();
            //String RepositoryUniqueId = ((DataGridView)sender).CurrentRow.Cells["RepositoryUniqueId"].Value.ToString();

            String documentUniqueId = DocumentListGridView.Rows[e.RowIndex].Cells["DocumentUniqueId"].Value.ToString();
            String repositoryUniqueId = DocumentListGridView.Rows[e.RowIndex].Cells["RepositoryUniqueId"].Value.ToString();

            if (e.ColumnIndex == DocumentListGridView.Columns["ChangeHistoryColumnButton"].Index)
            {
                ChangeHistoryDocumentUniqueIdTextBox.Text = documentUniqueId;
                HipsTestHarnessTabControl.SelectedTab = ChangeHistoryPage;
            }
            else if (e.ColumnIndex == DocumentListGridView.Columns["OpenDocColumnButton"].Index)
            {
                DownloadDocDocumentUniqueIdTextBox.Text = documentUniqueId;
                DownloadDocRepositoryUniqueIdTextBox.Text = repositoryUniqueId;
                HipsTestHarnessTabControl.SelectedTab = DownloadDocumentPage;
            }

        }
    }
}
