﻿/*
 * Copyright 2012 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Security;
using System.Security.Cryptography.X509Certificates;
using System.ServiceModel;
using Nehta.VendorLibrary.Common;
using Nehta.VendorLibrary.PCEHR;
using Nehta.VendorLibrary.PCEHR.RegisterPCEHR;
using System.IO;

namespace PCEHR.Sample
{
    /// <summary>
    /// Sample demonstrating how to use the 'RegisterPCEHRClient'.
    /// </summary>
    public class RegisterPCEHRClientSample
    {
        public void Sample()
        {
            // Obtain the certificate for use with TLS and signing
            X509Certificate2 cert = X509CertificateUtil.GetCertificate(
                "Serial Number",
                X509FindType.FindBySerialNumber,
                StoreName.My,
                StoreLocation.CurrentUser,
                true
                );

            // Create PCEHR header
            CommonPcehrHeader header = PcehrHeaderHelper.CreateHeader();
            header.IhiNumber = "IHI"; // This value is required in the absence of demographic information.


            // Create the client
            RegisterPCEHRClient registerClient = new RegisterPCEHRClient(
                new Uri("https://RegisterPCEHREndpoint"), cert, cert);

            // Add server certificate validation callback
            ServicePointManager.ServerCertificateValidationCallback += ValidateServiceCertificate;

            // Create a request
            registerPCEHR request = new registerPCEHR();

            // Set required assertion values
            request.assertions = new registerPCEHRAssertions()
            {
                acceptedTermsAndConditions = true,
                documentConsent = new registerPCEHRAssertionsDocument[]
                {
                    new registerPCEHRAssertionsDocument()
                    {
                        status = registerPCEHRAssertionsDocumentStatus.ConsentGiven,
                        type = registerPCEHRAssertionsDocumentType.ACIR
                    }
                },
                identity = new registerPCEHRAssertionsIdentity()
                {
                    evidenceOfIdentity = new registerPCEHRAssertionsIdentityEvidenceOfIdentity()
                    {
                        type = registerPCEHRAssertionsIdentityEvidenceOfIdentityType.IdentityVerificationMethod5
                    },
                    indigenousStatus = registerPCEHRAssertionsIdentityIndigenousStatus.Item3,
                    signedConsentForm = File.ReadAllBytes("signedConsentForm.pdf")
                },
                ivcCorrespondence = new registerPCEHRAssertionsIvcCorrespondence()
                {
                    channel = registerPCEHRAssertionsIvcCorrespondenceChannel.email,
                    contactDetails = new contactDetailsType()
                    {
                        emailAddress = "patient@emails.com",
                        mobilePhoneNumber = "patient phone number"
                    }
                },
                representativeDeclaration = false,
                representativeDeclarationSpecified = true
            };

            // Populate a new individual
            request.individual = new registerPCEHRIndividual()
            {
                demographics = new registerPCEHRIndividualDemographics()
                {
                    name = new nameTypeSupp()
                    {
                        givenName = new string[] { "First Name" },
                        familyName = "Family Name",                        
                    },
                    sex = sex.M,
                    dateOfBirth = DateTime.Parse("1 Jan 1978")
                }
            };

            try
            {
                // Invoke the service
                registerPCEHRResponse response = registerClient.RegisterPCEHR(header, request);
            }
            catch (FaultException e)
            {
                // Handle any errors
            }
        }

        private bool ValidateServiceCertificate(object sender, X509Certificate certificate, X509Chain chain, SslPolicyErrors sslPolicyErrors)
        {
            // Checks can be done here to validate the service certificate.
            // If the service certificate contains any problems or is invalid, return false. Otherwise, return true.
            // This example returns true to indicate that the service certificate is valid.
            return true;
        }
    }
}
