-- Search for all MPPs and TPPs based with an intendend active ingredient a word containing 'amoxy'
select
    v3_mpp_to_tpp.mppid,
    v3_mpp_to_tpp.mppterm,
    v3_mpp_to_tpp.tppid,
    v3_mpp_to_tpp.tppterm
from v3_mpp_to_tpp
    join v3_ingredient_strength
        on v3_mpp_to_tpp.mppid = v3_ingredient_strength.mppid
where v3_ingredient_strength.substanceterm regexp (

    @search_term:='(^|[^a-zA-Z]+)amox' collate utf8_unicode_ci

    )
or v3_mpp_to_tpp.mppterm regexp @search_term
or v3_mpp_to_tpp.tppterm like @search_term
;

-- Show dose forms of 4 sample MPPs
select
    v3_ingredient_strength.mppid,
    v3_ingredient_strength.mppterm,
    v3_ingredient_strength.bossterm,
    toPt(hasDoseForm.destinationid)
from v3_ingredient_strength

    join rf2_ss_relationships hasDoseForm
        on hasDoseForm.sourceid = v3_ingredient_strength.mpuuid
        and hasDoseForm.typeid = 30523011000036108 -- has manufactured dose form (relationship type)
        and hasDoseForm.active = 1

where v3_ingredient_strength.mppid in (
    26624011000036107, -- 'amoxycillin 100 mg/mL oral...'
    51572011000036101, -- 'goserelin 3.6 mg implant [...'
    26781011000036107, -- 'peginterferon alfa-2a 135 ...'
    28051011000036109  -- 'peginterferon alfa-2b 150 ...'
)
;

-- List ingredient strengths for a given MPP
select *
from v3_ingredient_strength
where mppid = 63182011000036107
;

-- List unit of use size and quantity for a given MPP
select *
from v3_unit_of_use
where mppid = 26624011000036107
;

-- List acceptable TPPs (for dispensing) for a given MPP
select 
mppid,mppterm,
tppid, tppterm
from v3_mpp_to_tpp
where mppid = 63919011000036102
order by tppterm
;

-- List acceptable substitutable TPPs, and associated CTPPs (for dispensing) for a given TPP (brand substitute)
select 
    tpp1.tppid as originaltppid,
    tpp1.tppterm as originaltppterm,
    substitutetpp.tppid as substitutetppid,
    substitutetpp.tppterm as substitutetppterm,
    ctpps.sourceid as substitutectpp,
    toPt(ctpps.sourceid) as substitutectppterm

from v3_mpp_to_tpp tpp1
join v3_mpp_to_tpp substitutetpp
    on tpp1.mppid = substitutetpp.mppid
    and tpp1.tppid = 12809011000036105 -- Amoxil 250 mg capsule: hard, 20
join rf2_ss_relationships ctpps
    on substitutetpp.tppid = ctpps.destinationid
    and ctpps.sourceId in (select id from v3_ctpp)
;

-- Find all MPUUs containing more than 10 milligrams of codeine, in tablet form
select distinct
    mpuu.mpuuid,
    mpuu.mpuuterm,
    mpuu.substanceterm,    
    mpuu.bossterm,    
    mpuu.strengthvalue,
    mpuu.unitterm,
    toPt(hasDoseForm.destinationid)
from v3_ingredient_strength mpuu
join rf2_ss_relationships hasDoseForm
        on mpuu.mpuuid = hasDoseForm.sourceid
        and hasDoseForm.typeid = 30523011000036108 -- has manufactured dose form (relationship type)
        and hasDoseForm.active = 1
        and hasDoseForm.destinationid in (select distinct conceptid from rf2_ss_descriptions where term like 'tablet%')                
        
        and mpuu.bossterm like '%codeine%'
        and mpuu.strengthvalue > 10
        and mpuu.unitid = 700000801000036102 -- mg/each
;

-- Find all MPUUs containing dihydrocodeine, in any tablet form
select
    v3_ingredient_strength.mpuuid,
    v3_ingredient_strength.mpuuterm,    
    v3_ingredient_strength.bossterm,
    v3_ingredient_strength.substanceterm,
    v3_ingredient_strength.strengthvalue,    
    v3_ingredient_strength.unitterm,
    toPt(hasDoseForm.destinationid)
from v3_ingredient_strength

    join rf2_ss_relationships hasDoseForm
       on hasDoseForm.sourceid = v3_ingredient_strength.mpuuid
       and hasDoseForm.typeid = 30523011000036108 -- has manufactured dose form (relationship type)
       and hasDoseForm.active = 1

where v3_ingredient_strength.substanceid = (
    select distinct conceptid 
    from rf2_ss_descriptions where term = 'dihydrocodeine (AU substance)'
     )
    and hasDoseForm.destinationid in (
            select source from v3_tc where dest = 154011000036109 -- tablet dose form (AU qualifier)
            )
;


-- Query MPPs and corresponding concepts that have sub roles to subtype MPUUs of 'paracetamol 500 mg tablet' in them
select 
    hasMpuu.sourceid as mppid,
    toPt(hasMpuu.sourceid) as mppterm,
    hasMpuu.typeid as hasmpuu_typeid,
    toPt(hasMpuu.typeid) as hasmpuu_typeterm,
    hasMpuu.destinationid as mpuuid,
    toPt(hasMpuu.destinationid) as mpuuterm,       
    subRole.sourceid as sub_sourceid,
    toPt(subRole.sourceid) as sub_sourceterm,
    subRole.typeid as sub_typeid,
    toPt(subRole.typeid) as sub_typeterm,
    subRole.destinationid as sub_destinationid,
    toPt(subRole.destinationid) as sub_destinationterm
from rf2_ss_relationships hasMpuu
    join rf2_ss_relationships subRole
        on  hasMpuu.active = 1 and subRole.active = 1
        and hasMpuu.typeid = 30348011000036104                   
        and hasMpuu.destinationid = 23628011000036109
        and subRole.typeid in (select source from v3_tc where dest = 30348011000036104)
        and subRole.destinationid in (select source from v3_tc where dest = 23628011000036109)
	and subRole.sourceid in (select source from v3_tc where dest = hasMpuu.sourceid)
order by mppterm, sub_sourceterm;


