﻿<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:cda="urn:hl7-org:v3" xmlns:dh="cpv:fn" xmlns:iq="iq:fn" xmlns:ext="http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0">
  <!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
  <xsl:param name="archiveDirParameter" />
  <xsl:param name="archiveNameParameter" />
  <xsl:param name="fileNameParameter" />
  <xsl:param name="fileDirParameter" />
  <!--PHASES-->
  <!--PROLOG-->
  <xsl:output xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" method="xml" omit-xml-declaration="no" standalone="yes" indent="yes" />
  <!--KEYS-->
  <!--DEFAULT RULES-->
  <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
  <!--This mode can be used to generate an ugly though full XPath for locators-->
  <xsl:template match="*" mode="schematron-select-full-path">
    <xsl:apply-templates select="." mode="schematron-get-full-path" />
  </xsl:template>
  <!--MODE: SCHEMATRON-FULL-PATH-->
  <!--This mode can be used to generate an ugly though full XPath for locators-->
  <xsl:template match="*" mode="schematron-get-full-path">
    <xsl:apply-templates select="parent::*" mode="schematron-get-full-path" />
    <xsl:text>/</xsl:text>
    <xsl:choose>
      <xsl:when test="namespace-uri()=''">
        <xsl:value-of select="name()" />
        <xsl:variable name="p_1" select="1+    count(preceding-sibling::*[name()=name(current())])" />
        <xsl:if test="$p_1&gt;1 or following-sibling::*[name()=name(current())]">[<xsl:value-of select="$p_1" />]</xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>*[local-name()='</xsl:text>
        <xsl:value-of select="local-name()" />
        <xsl:text>' and namespace-uri()='</xsl:text>
        <xsl:value-of select="namespace-uri()" />
        <xsl:text>']</xsl:text>
        <xsl:variable name="p_2" select="1+   count(preceding-sibling::*[local-name()=local-name(current())])" />
        <xsl:if test="$p_2&gt;1 or following-sibling::*[local-name()=local-name(current())]">[<xsl:value-of select="$p_2" />]</xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="@*" mode="schematron-get-full-path">
    <xsl:text>/</xsl:text>
    <xsl:choose>
      <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()" /></xsl:when>
      <xsl:otherwise>
        <xsl:text>@*[local-name()='</xsl:text>
        <xsl:value-of select="local-name()" />
        <xsl:text>' and namespace-uri()='</xsl:text>
        <xsl:value-of select="namespace-uri()" />
        <xsl:text>']</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <!--MODE: SCHEMATRON-FULL-PATH-2-->
  <!--This mode can be used to generate prefixed XPath for humans-->
  <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
    <xsl:for-each select="ancestor-or-self::*">
      <xsl:text>/</xsl:text>
      <xsl:value-of select="name(.)" />
      <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
        <xsl:text>[</xsl:text>
        <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1" />
        <xsl:text>]</xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:if test="not(self::*)">
      <xsl:text />/@<xsl:value-of select="name(.)" /></xsl:if>
  </xsl:template>
  <!--MODE: GENERATE-ID-FROM-PATH -->
  <xsl:template match="/" mode="generate-id-from-path" />
  <xsl:template match="text()" mode="generate-id-from-path">
    <xsl:apply-templates select="parent::*" mode="generate-id-from-path" />
    <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')" />
  </xsl:template>
  <xsl:template match="comment()" mode="generate-id-from-path">
    <xsl:apply-templates select="parent::*" mode="generate-id-from-path" />
    <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')" />
  </xsl:template>
  <xsl:template match="processing-instruction()" mode="generate-id-from-path">
    <xsl:apply-templates select="parent::*" mode="generate-id-from-path" />
    <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')" />
  </xsl:template>
  <xsl:template match="@*" mode="generate-id-from-path">
    <xsl:apply-templates select="parent::*" mode="generate-id-from-path" />
    <xsl:value-of select="concat('.@', name())" />
  </xsl:template>
  <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
    <xsl:apply-templates select="parent::*" mode="generate-id-from-path" />
    <xsl:text>.</xsl:text>
    <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')" />
  </xsl:template>
  <!--MODE: SCHEMATRON-FULL-PATH-3-->
  <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
  <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
    <xsl:for-each select="ancestor-or-self::*">
      <xsl:text>/</xsl:text>
      <xsl:value-of select="name(.)" />
      <xsl:if test="parent::*">
        <xsl:text>[</xsl:text>
        <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1" />
        <xsl:text>]</xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:if test="not(self::*)">
      <xsl:text />/@<xsl:value-of select="name(.)" /></xsl:if>
  </xsl:template>
  <!--MODE: GENERATE-ID-2 -->
  <xsl:template match="/" mode="generate-id-2">U</xsl:template>
  <xsl:template match="*" mode="generate-id-2" priority="2">
    <xsl:text>U</xsl:text>
    <xsl:number level="multiple" count="*" />
  </xsl:template>
  <xsl:template match="node()" mode="generate-id-2">
    <xsl:text>U.</xsl:text>
    <xsl:number level="multiple" count="*" />
    <xsl:text>n</xsl:text>
    <xsl:number count="node()" />
  </xsl:template>
  <xsl:template match="@*" mode="generate-id-2">
    <xsl:text>U.</xsl:text>
    <xsl:number level="multiple" count="*" />
    <xsl:text>_</xsl:text>
    <xsl:value-of select="string-length(local-name(.))" />
    <xsl:text>_</xsl:text>
    <xsl:value-of select="translate(name(),':','.')" />
  </xsl:template>
  <!--Strip characters-->
  <xsl:template match="text()" priority="-1" />
  <!--SCHEMA METADATA-->
  <xsl:template match="/">
    <svrl:schematron-output xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" title="Schematron schema for validating CDA documents" schemaVersion="">
      <xsl:comment>
        <xsl:value-of select="$archiveDirParameter" />   
		 <xsl:value-of select="$archiveNameParameter" />  
		 <xsl:value-of select="$fileNameParameter" />  
		 <xsl:value-of select="$fileDirParameter" /></xsl:comment>
      <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="cda" />
      <svrl:ns-prefix-in-attribute-values uri="cpv:fn" prefix="dh" />
      <svrl:ns-prefix-in-attribute-values uri="iq:fn" prefix="iq" />
      <svrl:ns-prefix-in-attribute-values uri="http://ns.electronichealth.net.au/Ci/Cda/Extensions/3.0" prefix="ext" />
      <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xs" />
      <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-About</xsl:attribute>
        <xsl:attribute name="name">p-About</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M21" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-About-test</xsl:attribute>
        <xsl:attribute name="name">p-About-test</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M22" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coding</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coding</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M23" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Records-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Records-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M24" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Records-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Records-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M25" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Statistics-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Statistics-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M26" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Statistics-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Statistics-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M27" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Statistics-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Statistics-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M28" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACDCustodian-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACDCustodian-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M29" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACDCustodian-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACDCustodian-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M30" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M31" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M32" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M33" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-EncapsulatedData-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-EncapsulatedData-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M34" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-EncapsulatedData-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-EncapsulatedData-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M35" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M36" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M37" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACI-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACI-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M38" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M39" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M40" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M41" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M42" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M43" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M44" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M45" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M46" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M47" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M48" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M49" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M50" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M51" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M52" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M53" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M54" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M55" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M56" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M57" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M58" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M59" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M60" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M61" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-Integer-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-Integer-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M62" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-Integer-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-Integer-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M63" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-Integer-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-Integer-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M64" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M65" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M66" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M67" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ACIR-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ACIR-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M68" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M69" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M70" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-Boolean-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-Boolean-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M71" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-Boolean-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-Boolean-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M72" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M73" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M74" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-Duration-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-Duration-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M75" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M76" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M77" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M78" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M79" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M80" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-CodedSimple-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-CodedSimple-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M81" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Admin-CodedSimple-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Admin-CodedSimple-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M82" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M83" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M84" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M85" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M86" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M87" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M88" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M89" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M90" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M91" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M92" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M93" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M94" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M95" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M96" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M97" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M98" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M99" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M100" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M101" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M102" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M103" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M104" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-21</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-21</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M105" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-22</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-22</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M106" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-23</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-23</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M107" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-24</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-24</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M108" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-25</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-25</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M109" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-26</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-26</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M110" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodeableText-27</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodeableText-27</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M111" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M112" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M113" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M114" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M115" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodedText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodedText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M116" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Adverse-CodedText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Adverse-CodedText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M117" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M118" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M119" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M120" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M121" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M122" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M123" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M124" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M125" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M126" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M127" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M128" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M129" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M130" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M131" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M132" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M133" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M134" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodeableText-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodeableText-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M135" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M136" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M137" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M138" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M139" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M140" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M141" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M142" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M143" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-Integer-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-Integer-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M144" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-Integer-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-Integer-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M145" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-Integer-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-Integer-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M146" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M147" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M148" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M149" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M150" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-II-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-II-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M151" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-II-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-II-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M152" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-II-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-II-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M153" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-II-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-II-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M154" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AIR-II-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-AIR-II-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M155" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Alerts-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Alerts-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M156" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Alerts-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Alerts-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M157" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Alerts-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Alerts-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M158" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Alerts-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Alerts-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M159" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Alerts-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Alerts-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M160" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Alerts-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Alerts-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M161" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M162" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M163" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M164" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M165" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M166" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M167" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M168" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M169" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M170" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M171" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M172" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M173" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M174" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M175" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M176" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M177" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M178" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M179" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M180" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M181" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M182" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M183" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M184" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AODR-Boolean-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-AODR-Boolean-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M185" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Arranged-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Arranged-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M186" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Arranged-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Arranged-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M187" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Arranged-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Arranged-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M188" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Arranged-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Arranged-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M189" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Arranged-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Arranged-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M190" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Arranged-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Arranged-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M191" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Diag-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Diag-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M192" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Diag-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Diag-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M193" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Diag-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Diag-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M194" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M195" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M196" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M197" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M198" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M199" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M200" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M201" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M202" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-TimeInterval-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-TimeInterval-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M203" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-TimeInterval-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-TimeInterval-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M204" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-EncapsulatedData-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-EncapsulatedData-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M205" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-EncapsulatedData-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-EncapsulatedData-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M206" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M207" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DiagImaging-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DiagImaging-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M208" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M209" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M210" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M211" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M212" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M213" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M214" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M215" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M216" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M217" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M218" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M219" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M220" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M221" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M222" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M223" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CeaseMed-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CeaseMed-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M224" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M225" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M226" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M227" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M228" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M229" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M230" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M231" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M232" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M233" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M234" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M235" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M236" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M237" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M238" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Duration-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Duration-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M239" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Duration-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Duration-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M240" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Duration-TimeInterval-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Duration-TimeInterval-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M241" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M242" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M243" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M244" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M245" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M246" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M247" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M248" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M249" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M250" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CurrMed-Text-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-CurrMed-Text-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M251" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisEvent-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisEvent-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M252" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisEvent-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisEvent-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M253" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisEvent-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisEvent-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M254" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisInter-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisInter-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M255" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisInter-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisInter-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M256" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisInter-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisInter-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M257" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisInter-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisInter-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M258" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisInter-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisInter-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M259" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisInter-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisInter-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M260" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisMed-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisMed-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M261" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisMed-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisMed-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M262" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisMed-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisMed-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M263" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M264" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M265" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M266" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M267" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M268" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M269" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M270" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M271" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M272" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M273" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodedText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodedText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M274" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisProb-CodedText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisProb-CodedText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M275" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisRec-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisRec-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M276" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisRec-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisRec-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M277" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisRec-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisRec-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M278" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisRec-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisRec-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M279" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisRec-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisRec-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M280" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisRec-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisRec-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M281" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisSynopsis-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisSynopsis-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M282" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisSynopsis-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisSynopsis-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M283" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisSynopsis-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisSynopsis-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M284" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DisSynopsis-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DisSynopsis-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M285" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M286" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M287" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M288" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M289" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M290" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M291" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M292" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M293" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M294" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M295" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M296" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M297" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M298" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M299" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M300" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M301" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M302" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-UniqueIdentifier-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-UniqueIdentifier-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M303" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-UniqueIdentifier-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-UniqueIdentifier-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M304" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-UniqueIdentifier-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-UniqueIdentifier-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M305" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-UniqueIdentifier-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-UniqueIdentifier-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M306" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M307" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Integer-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Integer-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M308" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Integer-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Integer-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M309" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Integer-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Integer-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M310" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Boolean-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Boolean-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M311" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Boolean-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Boolean-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M312" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M313" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M314" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M315" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M316" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M317" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M318" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M319" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M320" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M321" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M322" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M323" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M324" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M325" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M326" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M327" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Text-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Text-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M328" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DispItem-Link-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DispItem-Link-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M329" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Event-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Event-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M330" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Event-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Event-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M331" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Event-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Event-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M332" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Event-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Event-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M333" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M334" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M335" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M336" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M337" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M338" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M339" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M340" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M341" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M342" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-DateTime-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-DateTime-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M343" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M344" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M345" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-TimeInterval-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-TimeInterval-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M346" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-TimeInterval-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-TimeInterval-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M347" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-TimeInterval-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-TimeInterval-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M348" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M349" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M350" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M351" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M352" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M353" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M354" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M355" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M356" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M357" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M358" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M359" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M360" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Header-UniqueIdentifier-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Header-UniqueIdentifier-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M361" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M362" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M363" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M364" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M365" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M366" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M367" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M368" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M369" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M370" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M371" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M372" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M373" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M374" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M375" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M376" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M377" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M378" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M379" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M380" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M381" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M382" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M383" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-21</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-21</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M384" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-22</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-22</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M385" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-23</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-23</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M386" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodeableText-24</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodeableText-24</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M387" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M388" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M389" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M390" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M391" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M392" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M393" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M394" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M395" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-CodedText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-CodedText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M396" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M397" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M398" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M399" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M400" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-DateTime-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-DateTime-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M401" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-DateTime-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-DateTime-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M402" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-QuantityRange-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-QuantityRange-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M403" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-QuantityRange-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-QuantityRange-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M404" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M405" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M406" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M407" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M408" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M409" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M410" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M411" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M412" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M413" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Observation-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Observation-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M414" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M415" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M416" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M417" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M418" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M419" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M420" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M421" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M422" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-EncapsulatedData-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-EncapsulatedData-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M423" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Link-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Link-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M424" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M425" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M426" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M427" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M428" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M429" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M430" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M431" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M432" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M433" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M434" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M435" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M436" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M437" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M438" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M439" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M440" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-Text-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-Text-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M441" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M442" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-UniqueIdentifier-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-UniqueIdentifier-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M443" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-UniqueIdentifier-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-UniqueIdentifier-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M444" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ImagExamRes-UniqueIdentifier-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ImagExamRes-UniqueIdentifier-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M445" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M446" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M447" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M448" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M449" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M450" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M451" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M452" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M453" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M454" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M455" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M456" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M457" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M458" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M459" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M460" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M461" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M462" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M463" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M464" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M465" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M466" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M467" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Immun-Integer-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Immun-Integer-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M468" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M469" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M470" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M471" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M472" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M473" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M474" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M475" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M476" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M477" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M478" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M479" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M480" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M481" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M482" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M483" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M484" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M485" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M486" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M487" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M488" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodeableText-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodeableText-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M489" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M490" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M491" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M492" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M493" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M494" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M495" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M496" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-CodedText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-CodedText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M497" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M498" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M499" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M500" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M501" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M502" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M503" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M504" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M505" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M506" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M507" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M508" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M509" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M510" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M511" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M512" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Med-Text-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-Med-Text-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M513" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M514" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M515" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M516" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M517" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M518" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M519" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M520" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M521" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M522" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M523" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M524" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M525" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M526" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M527" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M528" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M529" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M530" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M531" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M532" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-TimeInterval-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-TimeInterval-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M533" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-TimeInterval-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-TimeInterval-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M534" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M535" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M536" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M537" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M538" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-DateTime-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-DateTime-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M539" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-DateTime-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-DateTime-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M540" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M541" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M542" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M543" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M544" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M545" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M546" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M547" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M548" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-MedHist-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-MedHist-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M549" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M550" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M551" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M552" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M553" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M554" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M555" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-Boolean-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-Boolean-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M556" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-Boolean-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-Boolean-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M557" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M558" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Medicare-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Medicare-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M559" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M560" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M561" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M562" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M563" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M564" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M565" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M566" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M567" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M568" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M569" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M570" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M571" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M572" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M573" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M574" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M575" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M576" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M577" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M578" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M579" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M580" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-21</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-21</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M581" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-22</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-22</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M582" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-23</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-23</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M583" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-24</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-24</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M584" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-25</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-25</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M585" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-26</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-26</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M586" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-27</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-27</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M587" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodeableText-28</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodeableText-28</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M588" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M589" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M590" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M591" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M592" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M593" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M594" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M595" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M596" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M597" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M598" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M599" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M600" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M601" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M602" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M603" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M604" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M605" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M606" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M607" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-Text-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-Text-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M608" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Participant-ECD-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Participant-ECD-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M609" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M610" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M611" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M612" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M613" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M614" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M615" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M616" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M617" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-TimeInterval-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-TimeInterval-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M618" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-TimeInterval-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-TimeInterval-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M619" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-EncapsulatedData-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-EncapsulatedData-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M620" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-EncapsulatedData-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-EncapsulatedData-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M621" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M622" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M623" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M624" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pathology-UniqueIdentifier-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pathology-UniqueIdentifier-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M625" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M626" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M627" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M628" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M629" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M630" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M631" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M632" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M633" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M634" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M635" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M636" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M637" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M638" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M639" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M640" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M641" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M642" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M643" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M644" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M645" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M646" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M647" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-21</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-21</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M648" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-22</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-22</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M649" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-23</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-23</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M650" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-24</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-24</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M651" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-25</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-25</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M652" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-26</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-26</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M653" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-27</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-27</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M654" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-28</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-28</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M655" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-29</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-29</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M656" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-30</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-30</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M657" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-31</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-31</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M658" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-32</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-32</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M659" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-33</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-33</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M660" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-34</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-34</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M661" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-35</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-35</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M662" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-36</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-36</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M663" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-37</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-37</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M664" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-38</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-38</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M665" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-39</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-39</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M666" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-40</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-40</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M667" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-41</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-41</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M668" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-42</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-42</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M669" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-43</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-43</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M670" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-44</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-44</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M671" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-45</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-45</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M672" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-46</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-46</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M673" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-47</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-47</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M674" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-48</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-48</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M675" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-49</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-49</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M676" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-50</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-50</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M677" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-51</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-51</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M678" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-52</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-52</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M679" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-53</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-53</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M680" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-54</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-54</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M681" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-55</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-55</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M682" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-56</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-56</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M683" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-57</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-57</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M684" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-58</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-58</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M685" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-59</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-59</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M686" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-60</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-60</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M687" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-61</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-61</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M688" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-62</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-62</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M689" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-63</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-63</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M690" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodeableText-64</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodeableText-64</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M691" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M692" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M693" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M694" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M695" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M696" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M697" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M698" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M699" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M700" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-CodedText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-CodedText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M701" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M702" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M703" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M704" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M705" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M706" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M707" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M708" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M709" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M710" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M711" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M712" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M713" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M714" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-DateTime-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-DateTime-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M715" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-QuantityRange-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-QuantityRange-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M716" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-QuantityRange-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-QuantityRange-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M717" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Quantity-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Quantity-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M718" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Quantity-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Quantity-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M719" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Quantity-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Quantity-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M720" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Quantity-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Quantity-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M721" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M722" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M723" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M724" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M725" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M726" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M727" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M728" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M729" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M730" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Observation-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Observation-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M731" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-EncapsulatedData-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-EncapsulatedData-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M732" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-EncapsulatedData-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-EncapsulatedData-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M733" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-EncapsulatedData-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-EncapsulatedData-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M734" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-EncapsulatedData-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-EncapsulatedData-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M735" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-EncapsulatedData-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-EncapsulatedData-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M736" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-EncapsulatedData-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-EncapsulatedData-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M737" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-EncapsulatedData-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-EncapsulatedData-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M738" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M739" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M740" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M741" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M742" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M743" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M744" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M745" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M746" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M747" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M748" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M749" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M750" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M751" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M752" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M753" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M754" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M755" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M756" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M757" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M758" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-21</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-21</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M759" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-Text-22</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-Text-22</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M760" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M761" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-UniqueIdentifier-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-UniqueIdentifier-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M762" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-UniqueIdentifier-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-UniqueIdentifier-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M763" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-UniqueIdentifier-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-UniqueIdentifier-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M764" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-UniqueIdentifier-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-UniqueIdentifier-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M765" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-UniqueIdentifier-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-UniqueIdentifier-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M766" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PathTestRes-UniqueIdentifier-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PathTestRes-UniqueIdentifier-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M767" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M768" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M769" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M770" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M771" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M772" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M773" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M774" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M775" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M776" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M777" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M778" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M779" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Quantity-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Quantity-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M780" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Quantity-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Quantity-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M781" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M782" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M783" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PBItems-Integer-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PBItems-Integer-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M784" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M785" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M786" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M787" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M788" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M789" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M790" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M791" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M792" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M793" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M794" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M795" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M796" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M797" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M798" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M799" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M800" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M801" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-DateTime-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-DateTime-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M802" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-DateTime-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-DateTime-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M803" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M804" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-Integer-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-Integer-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M805" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-Integer-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-Integer-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M806" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PD-Integer-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PD-Integer-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M807" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Plan-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Plan-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M808" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Plan-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Plan-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M809" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Plan-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Plan-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M810" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M811" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M812" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M813" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M814" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M815" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M816" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M817" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M818" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M819" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M820" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M821" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M822" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M823" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M824" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M825" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M826" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-CodeableText-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-CodeableText-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M827" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M828" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M829" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M830" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M831" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Duration-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Duration-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M832" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Duration-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Duration-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M833" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M834" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-UniqueIdentifier-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-UniqueIdentifier-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M835" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-UniqueIdentifier-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-UniqueIdentifier-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M836" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-UniqueIdentifier-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-UniqueIdentifier-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M837" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M838" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M839" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M840" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M841" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M842" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M843" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M844" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M845" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M846" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M847" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M848" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M849" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M850" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M851" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Text-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Text-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M852" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Integer-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Integer-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M853" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Integer-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Integer-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M854" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PresItem-Link-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PresItem-Link-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M855" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Profile-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Profile-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M856" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Profile-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Profile-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M857" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Profile-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Profile-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M858" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M859" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M860" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-DateTime-Duration-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-DateTime-Duration-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M861" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-DateTime-Duration-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-DateTime-Duration-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M862" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-DateTime-Duration-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-DateTime-Duration-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M863" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M864" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M865" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M866" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Recommend-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Recommend-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M867" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M868" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M869" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M870" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M871" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-Duration-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-Duration-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M872" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-Duration-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-Duration-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M873" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-Duration-TimeInterval-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-Duration-TimeInterval-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M874" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M875" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RefDetail-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-RefDetail-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M876" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M877" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M878" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M879" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M880" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M881" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M882" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-DateTime-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-DateTime-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M883" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-DateTime-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-DateTime-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M884" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M885" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-TimeInterval-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-TimeInterval-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M886" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-TimeInterval-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-TimeInterval-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M887" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-TimeInterval-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-TimeInterval-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M888" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M889" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Request-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Request-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M890" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M891" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M892" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M893" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M894" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M895" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M896" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M897" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M898" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M899" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-CodeableText-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-CodeableText-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M900" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-Text-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-Text-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M901" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-Text-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-Text-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M902" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-Text-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-Text-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M903" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Response-Text-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Response-Text-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M904" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M905" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M906" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M907" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-CodeableText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-CodeableText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M908" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-CodedText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-CodedText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M909" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-CodedText-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-CodedText-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M910" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-DateTime-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-DateTime-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M911" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-DateTime-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-DateTime-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M912" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-EncapsulatedData-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-EncapsulatedData-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M913" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-EncapsulatedData-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-EncapsulatedData-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M914" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UndiffDiag-EncapsulatedData-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-UndiffDiag-EncapsulatedData-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M915" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AdminObs-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AdminObs-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M916" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Body-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Body-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M917" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Body-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Body-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M918" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M919" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M920" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M921" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M922" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M923" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M924" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M925" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M926" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M927" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M928" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M929" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M930" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M931" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M932" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M933" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M934" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M935" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M936" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M937" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M938" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-21</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-21</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M939" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-22</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-22</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M940" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Disp-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Disp-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M941" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Disp-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Disp-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M942" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Disp-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Disp-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M943" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Disp-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Disp-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M944" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Disp-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Disp-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M945" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Disp-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Disp-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M946" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Disp-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Disp-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M947" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-ImagExamRes-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-ImagExamRes-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M948" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-PathTestRes-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-PathTestRes-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M949" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Pres-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Pres-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M950" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Pres-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Pres-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M951" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Pres-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Pres-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M952" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Pres-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Pres-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M953" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Dext-Pres-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Dext-Pres-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M954" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M955" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M956" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M957" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M958" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M959" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M960" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M961" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M962" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-DocIdent-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-DocIdent-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M963" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M964" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M965" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M966" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M967" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M968" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M969" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M970" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M971" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M972" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M973" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M974" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M975" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M976" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M977" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M978" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M979" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M980" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M981" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M982" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-20</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-20</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M983" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-21</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-21</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M984" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-22</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-22</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M985" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-23</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-23</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M986" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-24</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-24</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M987" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-25</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-25</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M988" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-26</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-26</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M989" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-27</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-27</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M990" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-28</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-28</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M991" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-29</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-29</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M992" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-30</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-30</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M993" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-31</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-31</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M994" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-32</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-32</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M995" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-33</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-33</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M996" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-34</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-34</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M997" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M998" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M999" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1000" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1001" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1002" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1003" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1004" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1005" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1006" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1007" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1008" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1009" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1010" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1011" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-15</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-15</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1012" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-16</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-16</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1013" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-17</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-17</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1014" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-18</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-18</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1015" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DG-19</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DG-19</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1016" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Prof-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Prof-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1017" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Prof-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Prof-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1018" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Prof-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Prof-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1019" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Prof-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Prof-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1020" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Prof-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Prof-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1021" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Prof-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Prof-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1022" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1023" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1024" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1025" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1026" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1027" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1028" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1029" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1030" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1031" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1032" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Disp-Map-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Disp-Map-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1033" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1034" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1035" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1036" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1037" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1038" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1039" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1040" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Excl-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Excl-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1041" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Diag-Prof-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Diag-Prof-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1042" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Diag-Map-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Diag-Map-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1043" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Diag-Map-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Diag-Map-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1044" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Diag-Map-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Diag-Map-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1045" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Diag-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Diag-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1046" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-DisMed-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-DisMed-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1047" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-MedHist-Map-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-MedHist-Map-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1048" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-MedHist-Map-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-MedHist-Map-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1049" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-Prof-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-Prof-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1050" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-Map-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-Map-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1051" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-Map-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-Map-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1052" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-Map-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-Map-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1053" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-Map-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-Map-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1054" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1055" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1056" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1057" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Path-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Path-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1058" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Prof-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Prof-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1059" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Prof-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Prof-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1060" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Prof-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Prof-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1061" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Prof-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Prof-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1062" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Prof-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Prof-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1063" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1064" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1065" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1066" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1067" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1068" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1069" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1070" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1071" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1072" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1073" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1074" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1075" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-Map-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-Map-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1076" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-Pres-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-Pres-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1077" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SHS-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SHS-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1078" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1079" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1080" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1081" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1082" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1083" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1084" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1085" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-Excl-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-Excl-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1086" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-VSN-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-VSN-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1087" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-ART-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-ART-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1088" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-GCD-SS-ART-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-GCD-SS-ART-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1089" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Head-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Head-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1090" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Head-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Head-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1091" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Head-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Head-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1092" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Head-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Head-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1093" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Level-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Level-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1094" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Level-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Level-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1095" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Level-Diag-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Level-Diag-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1096" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Level-Path-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Level-Path-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1097" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Level-Path-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Level-Path-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1098" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Logo-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Logo-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1099" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Auto-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Auto-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1100" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Auto-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Auto-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1101" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Ext-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Ext-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1102" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1103" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1104" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1105" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1106" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1107" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1108" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1109" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1110" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-9</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-9</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1111" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-10</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-10</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1112" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-11</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-11</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1113" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-12</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-12</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1114" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-13</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-13</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1115" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Info-14</xsl:attribute>
        <xsl:attribute name="name">p-TS-Info-14</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1116" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Mark-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Mark-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1117" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Mark-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Mark-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1118" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Ref-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Ref-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1119" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Ref-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Ref-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1120" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Style-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Style-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1121" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Tab-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Tab-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1122" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Tab-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Tab-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1123" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-AddrDG-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-AddrDG-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1124" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coded-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coded-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1125" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coded-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coded-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1126" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coded-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coded-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1127" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coded-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coded-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1128" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coded-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coded-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1129" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coded-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coded-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1130" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Coded-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Coded-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1131" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-EntId-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-EntId-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1132" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-EntId-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-EntId-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1133" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Entit-UniqueIdentifier-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Entit-UniqueIdentifier-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1134" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Entit-CodeableText-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Entit-CodeableText-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1135" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Entit-TimeInterval-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Entit-TimeInterval-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1136" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Entit-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Entit-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1137" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Entit-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Entit-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1138" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-BL-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-BL-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1139" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CD-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CD-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1140" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CD-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-CD-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1141" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CD-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-CD-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1142" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-CS-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-CS-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1143" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ED-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ED-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1144" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ED-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-ED-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1145" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ED-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-ED-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1146" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ED-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-ED-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1147" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-II-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-II-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1148" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-II-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-II-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1149" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-II-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-II-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1150" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-INT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-INT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1151" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-IVL-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-IVL-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1152" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-IVL-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-IVL-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1153" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-IVL-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-IVL-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1154" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PIVL-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PIVL-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1155" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-PQ-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-PQ-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1156" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-REAL-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-REAL-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1157" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-RTO-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-RTO-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1158" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-ST-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-ST-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1159" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-TEL-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-TEL-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1160" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-TEL-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-TEL-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1161" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-TEL-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-TEL-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1162" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-TS-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-TS-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1163" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-TS-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-TS-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1164" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UID-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-UID-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1165" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UID-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-UID-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1166" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-UNK-Type-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-UNK-Type-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1167" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1168" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1169" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-ACI-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-ACI-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1170" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Admin-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Admin-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1171" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Admin-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Admin-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1172" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Diag-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Diag-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1173" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-DispItem-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-DispItem-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1174" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1175" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1176" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1177" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1178" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1179" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1180" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-7</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-7</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1181" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-DT-8</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-DT-8</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1182" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1183" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-TI-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-TI-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1184" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-TI-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-TI-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1185" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-TI-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-TI-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1186" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Header-Midnight-TI-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Header-Midnight-TI-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1187" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Imaging-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Imaging-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1188" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Imaging-Midnight-TI-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Imaging-Midnight-TI-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1189" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Imaging-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Imaging-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1190" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Imaging-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Imaging-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1191" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Immun-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Immun-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1192" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-ImmunRegister-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-ImmunRegister-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1193" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-ImmunRegister-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-ImmunRegister-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1194" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-ImmunRegister-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-ImmunRegister-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1195" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Med-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Med-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1196" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-MedHist-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-MedHist-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1197" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-MedHist-Midnight-TI-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-MedHist-Midnight-TI-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1198" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-MedHist-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-MedHist-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1199" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-MedHist-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-MedHist-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1200" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-MedHist-Midnight-DT-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-MedHist-Midnight-DT-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1201" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1202" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-TI-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-TI-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1203" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1204" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1205" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-DT-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-DT-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1206" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-DT-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-DT-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1207" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-DT-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-DT-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1208" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Pathology-Midnight-DT-6</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Pathology-Midnight-DT-6</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1209" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-PBItems-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-PBItems-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1210" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-PBItems-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-PBItems-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1211" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-PD-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-PD-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1212" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-PD-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-PD-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1213" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-PD-Midnight-DT-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-PD-Midnight-DT-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1214" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Plan-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Plan-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1215" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-PresItem-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-PresItem-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1216" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-PresItem-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-PresItem-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1217" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Recommend-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Recommend-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1218" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-RefDetail-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-RefDetail-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1219" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Request-Midnight-DT-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Request-Midnight-DT-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1220" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Request-Midnight-DT-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Request-Midnight-DT-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1221" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Content-Request-Midnight-TI-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Content-Request-Midnight-TI-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1222" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-eComm-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-eComm-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1223" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-eComm-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-eComm-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1224" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pers-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pers-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1225" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pers-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pers-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1226" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pers-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pers-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1227" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pers-4</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pers-4</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1228" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-Pers-5</xsl:attribute>
        <xsl:attribute name="name">p-TS-Pers-5</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1229" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-U-Adverse-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-U-Adverse-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1230" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-U-Adverse-2</xsl:attribute>
        <xsl:attribute name="name">p-TS-U-Adverse-2</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1231" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-U-Adverse-3</xsl:attribute>
        <xsl:attribute name="name">p-TS-U-Adverse-3</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1232" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-U-MedHist-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-U-MedHist-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1233" />
      <svrl:active-pattern>
        <xsl:attribute name="id">p-TS-U-Med-1</xsl:attribute>
        <xsl:attribute name="name">p-TS-U-Med-1</xsl:attribute>
        <xsl:apply-templates />
      </svrl:active-pattern>
      <xsl:apply-templates select="/" mode="M1234" />
    </svrl:schematron-output>
  </xsl:template>
  <!--SCHEMATRON PATTERNS-->
  <svrl:text xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schematron schema for validating CDA documents</svrl:text>
  <xsl:variable name="meta-pattern-no-pipe" select=" '\\~\\~\^~\^~\$~\$~\.~\.~\?~\?~\*~\*~\+~\+~\(~\(~\)~\)~\[~\[~\]~\]~\{~\{~\}~\}~[ ]{2,}~ ~^ +~~ +$~' " />
  <xsl:variable name="meta-pattern" select=" concat($meta-pattern-no-pipe, '~ \|~|~\| ~|') " />
  <xsl:variable name="meta-pattern-with-pipe" select=" concat($meta-pattern-no-pipe, '~\|~\|') " />
  <xsl:variable name="space-meta-pattern" select=" concat($meta-pattern, '~ ~\s+') " />
  <xsl:variable name="space-meta-pattern-with-pipe" select=" concat($meta-pattern-with-pipe, '~ ~\s+') " />
  <xsl:variable name="knowledge" select="document('TEMPLATE/VALDN/Knowledge.xml', .)/knowledge" />
  <xsl:variable name="booleans" select="$knowledge/booleans" />
  <xsl:variable name="caseSignificances" select="$knowledge/caseSignificances" />
  <xsl:variable name="code-systems" select="document('TEMPLATE/VALDN/CodeSystems.xml', .)/systems" />
  <xsl:variable name="documents" select="(collection('file:///C:/DigitalHealth/ClinicalDocuments/Collection?select=*.XML;recurse=yes') |           collection('file:///C:/DigitalHealth/ClinicalDocuments/Collection?select=*.xml;recurse=yes') )[cda:ClinicalDocument]" />
  <xsl:variable name="document-types" select="$knowledge/document-types" />
  <xsl:variable name="iq-config" select="document('file:///C:/DigitalHealth/ClinicalDocuments/IQConfig.xml')/config" />
  <xsl:variable name="min-word-match-ratio" select="$knowledge/min-word-match-ratio/@value" />
  <xsl:variable name="section-types" select="$knowledge/section-types" />
  <xsl:variable name="cd-definitions" select="$knowledge/cd-definitions" />
  <xsl:variable name="ended-meds" select="$code-systems/system[@codeSystem='1.2.36.1.2001.1001.101.104.16592']/code[@code=('03', '05')]" />
  <xsl:variable name="ended-meds-regex" select="concat('^(', dh:XQueryRecursiveReplace(string-join(($ended-meds/@displayName, $ended-meds/@synonyms, $ended-meds/@related-terms,         $ended-meds/@typo), '|'), $meta-pattern, ''), ')$')" />
  <xsl:variable name="exclusion-regex-1" select="($code-systems/system[@codeSystem = '1.2.36.1.2001.1001.101.104.16299']/code/@displayName,         $code-systems/system[@codeSystem = '1.2.36.1.2001.1001.101.104.16299']/code/@synonyms,        $code-systems/system[@codeSystem = '1.2.36.1.2001.1001.101.104.16299']/code/@related-terms,        'Nil Entered', 'Nil') " />
  <xsl:variable name="exclusion-regex" select="if (exists($exclusion-regex-1)) then concat('^\s*(', dh:XQueryRecursiveReplace(string-join($exclusion-regex-1, '|'),         $space-meta-pattern, ''), ')\s*$') else '' " />
  <xsl:variable name="conjunction-regex" select="'^([^a-zA-Z]*?[a-zA-Z]+.*?)(\s+and\s+|\s+\+\s+|\s+\+/-\s+)(.*?)$' " />
  <xsl:variable name="ei-codes-for-consumers" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/code[contains(@EntId, 'consumers')]/@code" />
  <xsl:variable name="ei-codes-for-hpis" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/code[contains(@EntId, 'provider-individuals')]/@code" />
  <xsl:variable name="ei-codes-for-hpos" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/code[contains(@EntId, 'provider-organisations')]/@code" />
  <xsl:variable name="ei-codes-for-devices" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/code[contains(@EntId, 'devices')]/@code" />
  <xsl:variable name="ei-codes-only-for-consumers" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/         code[contains(@EntId, 'consumers') and not(contains(@EntId, 'provider-individuals') or contains(@EntId, 'provider-organisations')         or contains(@EntId, 'devices'))]/@code" />
  <xsl:variable name="ei-codes-only-for-hpis" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/         code[contains(@EntId, 'provider-individuals') and not(contains(@EntId, 'consumers') or contains(@EntId, 'provider-organisations')         or contains(@EntId, 'devices'))]/@code" />
  <xsl:variable name="ei-codes-only-for-hpos" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/         code[contains(@EntId, 'provider-organisations') and not(contains(@EntId, 'consumers') or contains(@EntId, 'provider-individuals')         or contains(@EntId, 'devices'))]/@code" />
  <xsl:variable name="ei-codes-only-for-devices" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.12.203']/         code[contains(@EntId, 'devices') and not(contains(@EntId, 'consumers') or contains(@EntId, 'provider-individuals')         or contains(@EntId, 'provider-organisations'))]/@code" />
  <xsl:variable name="flags" select="$iq-config/flags" />
  <xsl:variable name="flag-assess-values" select="not($flags/@test-data = 'true') and ($flags/@assess-values = 'true' or not(exists($flags/@assess-values))) " />
  <xsl:variable name="namespaces" select="$knowledge/namespaces" />
  <xsl:variable name="narr-non-values" select="$knowledge/narr-non-values" />
  <xsl:variable name="nullFlavors" select="$knowledge/nullFlavors" />
  <xsl:variable name="numbers" select="$knowledge/numbers" />
  <xsl:variable name="superseded" select="(collection('file:///C:/DigitalHealth/ClinicalDocuments/Superseded?select=*.XML;recurse=yes') |           collection('file:///C:/DigitalHealth/ClinicalDocuments/Superseded?select=*.xml;recurse=yes') )[cda:ClinicalDocument]" />
  <xsl:variable name="UCUM" select="$knowledge/UCUM" />
  <xsl:variable name="uri-schemes" select="$knowledge/uri-schemes" />
  <xsl:variable name="oid-arc-regex" select="$knowledge/oid-arc-regex" />
  <xsl:variable name="document-number" select="count($documents)" />
  <xsl:variable name="document-count" select="if ($numbers/number[@value = $document-number]) then $numbers/number[number(@value) = $document-number]/@name else $document-number" />
  <xsl:variable name="invalid-authorities" select="if (not($flags/@test-data = 'true') and $knowledge/assigning-authority/invalid/@value)          then tokenize(replace($knowledge/assigning-authority/invalid/@value, '\s+', ''), '\|')         else () " />
  <xsl:variable name="less-than" select="concat(codepoints-to-string(38), 'lt;')" />
  <xsl:variable name="greater-than" select="concat(codepoints-to-string(38), 'gt;')" />
  <xsl:variable name="ampersand" select="concat(codepoints-to-string(38), 'amp;')" />
  <xsl:variable name="markup-pattern-replacement" select="concat('&amp;~', $ampersand, '~&lt;~', $less-than, '~&gt;~', $greater-than) " />
  <xsl:variable name="bullet-regex" select="concat('([\|\-\+\*', codepoints-to-string((183, 8210, 8211, 8212, 8213, 8226, 8227, 8231, 8259, 8268, 8269, 8270, 8275, 8729, 9632, 9633, 9642, 9643, 9670,                9671, 9675, 9679, 9702, 10033, 10133, 65291)), ']{1,2})') " />
  <xsl:variable name="ulist-regex" select="concat('(^|[', codepoints-to-string((13, 10)), ']+)(\s*)', $bullet-regex, '([^\w]*?\w+[^', codepoints-to-string((13, 10)), ']*?)',        '([', codepoints-to-string((13, 10)), ']+)(\s*)', $bullet-regex, '([^\w]*?\w+[^', codepoints-to-string((13, 10)), ']*?)')" />
  <xsl:variable name="ulist-item-regex" select="concat('(^|[', codepoints-to-string((13, 10)), ']+)(\s*)', $bullet-regex, '([^\w]*?\w+[^', codepoints-to-string((13, 10)), ']*)')" />
  <xsl:variable name="alt-ulist-1a-regex" select="'(^|\s)([\-]{1,2})([^\-\w]*?\w+[^\-]*?)(\s[\-]{1,2})([^\-\w]*?\w+[^\-]*?)(\s[\-]{1,2})([^\-\w]*?\w)'" />
  <xsl:variable name="alt-ulist-1b-regex" select="'(^|\s)([\+]{1,2})([^\+\w]*?\w+[^\+]*?)(\s[\+]{1,2})([^\+\w]*?\w+[^\+]*?)(\s[\+]{1,2})([^\+\w]*?\w)'" />
  <xsl:variable name="bullet-chars" select="concat('\|\*', codepoints-to-string((183, 8210, 8211, 8212, 8213, 8226, 8227, 8231, 8259, 8268, 8269, 8270, 8275, 8729, 9632, 9633, 9642, 9643, 9670,                9671, 9675, 9679, 9702, 10033, 10133, 65291))) " />
  <xsl:variable name="alt-bullet-regex" select="concat('([', $bullet-chars, ']{1,2})') " />
  <xsl:variable name="alt-ulist-2-regex" select="concat($alt-bullet-regex, '([^', $bullet-chars, '\w]*?\w+[^', $bullet-chars, ']*?)',               $alt-bullet-regex, '([^', $bullet-chars, '\w]*?\w+[^', $bullet-chars, ']*?)',               $alt-bullet-regex, '([^', $bullet-chars, '\w]*?\w+)')" />
  <xsl:variable name="olist-item-1arabic-regex" select="'(^|\(|\[|\s)(1)(\.\s|\.?\)|\.?\])([^\w]*?\w+.*?)'" />
  <xsl:variable name="olist-item-1alpha-regex" select="'(^|\(|\[|\s)(a)(\.\s|\.?\)|\.?\])([^\w]*?\w+.*?)'" />
  <xsl:variable name="olist-item-1roman-regex" select="'(^|\(|\[|\s)(i)(\.\s|\.?\)|\.?\])([^\w]*?\w+.*?)'" />
  <xsl:variable name="olist-item-2arabic-regex" select="'(^|\(|\[|\s)(2)(\.\s|\.?\)|\.?\])([^\w]*?\w+)'" />
  <xsl:variable name="olist-item-2alpha-regex" select="'(^|\(|\[|\s)(b)(\.\s|\.?\)|\.?\])([^\w]*?\w+)'" />
  <xsl:variable name="olist-item-2roman-regex" select="'(^|\(|\[|\s)(ii)(\.\s|\.?\)|\.?\])([^\w]*?\w+)'" />
  <xsl:variable name="olist-arabic-regex" select="concat($olist-item-1arabic-regex, $olist-item-2arabic-regex)" />
  <xsl:variable name="olist-alpha-regex" select="concat($olist-item-1alpha-regex, $olist-item-2alpha-regex)" />
  <xsl:variable name="olist-roman-regex" select="concat($olist-item-1roman-regex, $olist-item-2roman-regex)" />
  <xsl:variable name="new-line-regex" select="concat('(', codepoints-to-string((13, 10)),  '|',             codepoints-to-string((10)),   '|',             codepoints-to-string((13)),   ')') " />
  <xsl:variable name="para-regex" select="concat($new-line-regex, '(\s*)', $new-line-regex, '(\s*)(.*?[^', codepoints-to-string((13, 10)), ']*)')" />
  <xsl:variable name="unicode-br-regex" select="concat('(', codepoints-to-string((13, 10)),  '|',             codepoints-to-string((10)),   '|',            codepoints-to-string((13)),   '|',             codepoints-to-string((8233)),  ')') " />
  <xsl:variable name="unicode-dash-regex" select="concat('([\-', codepoints-to-string((8208, 8209, 8210, 8211, 8212, 8213, 65112, 65123, 65293)), '])') " />
  <xsl:variable name="sentence-regex" select="'([A-Z]([^a-zA-Z0-9\.]+\w+)+?\.|[A-Z](\w+[^a-zA-Z0-9\.]+\w+)+?\.)'" />
  <xsl:variable name="multi-sentence-regex" select="concat('^\s*', $sentence-regex, '\s+', $sentence-regex)" />
  <xsl:variable name="char-escape-regex" select="concat('(', '&lt;', ')|(', '&gt;', ')|(', '&amp;', ')')" />
  <xsl:variable name="inline-chars-1" select="concat('[', codepoints-to-string(34), '/%0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ= ', ']+')" />
  <xsl:variable name="inline-chars-2" select="'[a-zA-Z]+'" />
  <xsl:variable name="markup-type-1" select="concat($less-than, $inline-chars-1, $greater-than)" />
  <xsl:variable name="markup-type-2" select="concat($ampersand, $inline-chars-2, ';')" />
  <xsl:variable name="markup-type-3" select="concat('&lt;', $inline-chars-1, '&gt;')" />
  <xsl:variable name="markup-type-4" select="concat('&amp;', $inline-chars-2, ';')" />
  <xsl:variable name="markup-regex" select="concat('(', $markup-type-1, ')|(', $markup-type-2, ')|(', $markup-type-3, ')|(', $markup-type-4, ')')" />
  <xsl:variable name="amp-esc-err-regex" select="concat('(', $ampersand, 'amp;)|(&amp;', 'amp;)')" />
  <xsl:variable name="lt-esc-err-regex" select="concat('(', $ampersand, 'lt;)|(&amp;', 'lt;)')" />
  <xsl:variable name="gt-esc-err-regex" select="concat('(', $ampersand, 'gt;)|(&amp;', 'gt;)')" />
  <xsl:variable name="apos-esc-err-regex" select="concat('(', $ampersand, 'apos;)|(&amp;', 'apos;)')" />
  <xsl:variable name="nbsp-esc-err-regex" select="concat('(', $ampersand, 'nbsp;)|(&amp;', 'nbsp;)')" />
  <xsl:variable name="quot-esc-err-regex" select="concat('(', $ampersand, 'quot;)|(&amp;', 'quot;)')" />
  <xsl:variable name="example1-markup-type-1" select="concat($less-than, '(/?td/?|td[ ]+(ID|language|styleCode|abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example2-markup-type-1" select="concat($less-than, '(/?th/?|th[ ]+(ID|language|styleCode|abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example3-markup-type-1" select="concat($less-than, '(/?tr/?|tr[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example4-markup-type-1" select="concat($less-than, '(/?tbody/?|tbody[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example5-markup-type-1" select="concat($less-than, '(/?thead/?|thead[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example6-markup-type-1" select="concat($less-than, '(/?tfoot/?|tfoot[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example7-markup-type-1" select="concat($less-than, '(/?table/?|table[ ]+(ID|language|styleCode|summary|width|border|frame|rules|cellspacing|cellpadding|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example8-markup-type-1" select="concat($less-than, '(/?item/?|item[ ]+(ID|language|styleCode|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example9-markup-type-1" select="concat($less-than, '(/?list/?|list[ ]+(ID|language|styleCode|listType|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example10-markup-type-1" select="concat($less-than, '(/?paragraph/?|paragraph[ ]+(ID|language|styleCode|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example11-markup-type-1" select="concat($less-than, '(/?renderMultiMedia/?|renderMultiMedia[ ]+(referencedObject|ID|language|styleCode|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example12-markup-type-1" select="concat($less-than, '(/?footnoteRef/?|footnoteRef[ ]+(ID|language|styleCode|IDREF|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example13-markup-type-1" select="concat($less-than, '(/?footnote/?|footnote[ ]+(ID|language|styleCode|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example14-markup-type-1" select="concat($less-than, '(/?caption/?|caption[ ]+(ID|language|styleCode|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example15-markup-type-1" select="concat($less-than, 'br/', $greater-than)" />
  <xsl:variable name="example16-markup-type-1" select="concat($less-than, '/?sub/?', $greater-than)" />
  <xsl:variable name="example17-markup-type-1" select="concat($less-than, '/?sup/?', $greater-than)" />
  <xsl:variable name="example18-markup-type-1" select="concat($less-than, '(/?linkHtml/?|linkHtml[ ]+(name|href|rel|rev|title|ID|language|styleCode|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example19-markup-type-1" select="concat($less-than, '(/?content/?|content[ ]+(ID|language|styleCode|revised|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example20-markup-type-1" select="concat($less-than, '/?cr/?', $greater-than)" />
  <xsl:variable name="example21-markup-type-1" select="concat($less-than, '(/?colgroup/?|colgroup[ ]+(ID|language|styleCode|span|width|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example22-markup-type-1" select="concat($less-than, '(/?col/?|col[ ]+(ID|language|styleCode|span|width|align|char|charoff|valign|xsi:type).*?)', $greater-than)" />
  <xsl:variable name="example1-markup-type-2" select="concat($ampersand, 'nbsp', ';')" />
  <xsl:variable name="example2-markup-type-2" select="concat($ampersand, 'lt', ';')" />
  <xsl:variable name="example3-markup-type-2" select="concat($ampersand, 'gt', ';')" />
  <xsl:variable name="example1-markup-type-3" select="concat('&lt;', '(/?td/?|td[ ]+(ID|language|styleCode|abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example2-markup-type-3" select="concat('&lt;', '(/?th/?|th[ ]+(ID|language|styleCode|abbr|axis|headers|scope|rowspan|colspan|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example3-markup-type-3" select="concat('&lt;', '(/?tr/?|tr[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example4-markup-type-3" select="concat('&lt;', '(/?tbody/?|tbody[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example5-markup-type-3" select="concat('&lt;', '(/?thead/?|thead[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example6-markup-type-3" select="concat('&lt;', '(/?tfoot/?|tfoot[ ]+(ID|language|styleCode|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example7-markup-type-3" select="concat('&lt;', '(/?table/?|table[ ]+(ID|language|styleCode|summary|width|border|frame|rules|cellspacing|cellpadding|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example8-markup-type-3" select="concat('&lt;', '(/?item/?|item[ ]+(ID|language|styleCode|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example9-markup-type-3" select="concat('&lt;', '(/?list/?|list[ ]+(ID|language|styleCode|listType|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example10-markup-type-3" select="concat('&lt;', '(/?paragraph/?|paragraph[ ]+(ID|language|styleCode|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example11-markup-type-3" select="concat('&lt;', '(/?renderMultiMedia/?|renderMultiMedia[ ]+(referencedObject|ID|language|styleCode|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example12-markup-type-3" select="concat('&lt;', '(/?footnoteRef/?|footnoteRef[ ]+(ID|language|styleCode|IDREF|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example13-markup-type-3" select="concat('&lt;', '(/?footnote/?|footnote[ ]+(ID|language|styleCode|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example14-markup-type-3" select="concat('&lt;', '(/?caption/?|caption[ ]+(ID|language|styleCode|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example15-markup-type-3" select="concat('&lt;', 'br/', '&gt;')" />
  <xsl:variable name="example16-markup-type-3" select="concat('&lt;', '/?sub/?', '&gt;')" />
  <xsl:variable name="example17-markup-type-3" select="concat('&lt;', '/?sup/?', '&gt;')" />
  <xsl:variable name="example18-markup-type-3" select="concat('&lt;', '(/?linkHtml/?|linkHtml[ ]+(name|href|rel|rev|title|ID|language|styleCode|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example19-markup-type-3" select="concat('&lt;', '(/?content/?|content[ ]+(ID|language|styleCode|revised|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example20-markup-type-3" select="concat('&lt;', '/?cr/?', '&gt;')" />
  <xsl:variable name="example21-markup-type-3" select="concat('&lt;', '(/?colgroup/?|colgroup[ ]+(ID|language|styleCode|span|width|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example22-markup-type-3" select="concat('&lt;', '(/?col/?|col[ ]+(ID|language|styleCode|span|width|align|char|charoff|valign|xsi:type).*?)', '&gt;')" />
  <xsl:variable name="example1-markup-type-4" select="'&amp;nbsp;'" />
  <xsl:variable name="example2-markup-type-4" select="'&amp;lt;'" />
  <xsl:variable name="example3-markup-type-4" select="'&amp;gt;'" />
  <xsl:variable name="example4-markup-type-4" select="'&amp;amp;'" />
  <xsl:variable name="example5-markup-type-4" select="'&amp;quot;'" />
  <xsl:variable name="example6-markup-type-4" select="'&amp;apos;'" />
  <xsl:variable name="confirmed-markup-regex" select="concat('(', $example1-markup-type-1, ')|(', $example2-markup-type-1, ')|(', $example3-markup-type-1, ')|(', $example4-markup-type-1, ')|(',        $example5-markup-type-1, ')|(', $example6-markup-type-1, ')|(', $example7-markup-type-1, ')|(', $example8-markup-type-1, ')|(',        $example9-markup-type-1, ')|(', $example10-markup-type-1, ')|(', $example11-markup-type-1, ')|(', $example12-markup-type-1, ')|(',        $example13-markup-type-1, ')|(', $example14-markup-type-1, ')|(', $example15-markup-type-1, ')|(', $example16-markup-type-1, ')|(',        $example17-markup-type-1, ')|(', $example18-markup-type-1, ')|(', $example19-markup-type-1, ')|(', $example20-markup-type-1, ')|(',         $example21-markup-type-1, ')|(', $example22-markup-type-1, ')|(',         $example1-markup-type-2, ')|(', $example2-markup-type-2, ')|(', $example3-markup-type-2, ')|(',          $example1-markup-type-3, ')|(', $example2-markup-type-3, ')|(', $example3-markup-type-3, ')|(', $example4-markup-type-3, ')|(',         $example5-markup-type-3, ')|(', $example6-markup-type-3, ')|(', $example7-markup-type-3, ')|(', $example8-markup-type-3, ')|(',         $example9-markup-type-3, ')|(', $example10-markup-type-3, ')|(', $example11-markup-type-3, ')|(', $example12-markup-type-3, ')|(',        $example13-markup-type-3, ')|(', $example14-markup-type-3, ')|(', $example15-markup-type-3, ')|(', $example16-markup-type-3, ')|(',         $example17-markup-type-3, ')|(', $example18-markup-type-3, ')|(', $example19-markup-type-3, ')|(', $example20-markup-type-3, ')|(',        $example21-markup-type-3, ')|(', $example22-markup-type-3, ')|(',         $example1-markup-type-4, ')|(', $example2-markup-type-4, ')|(', $example3-markup-type-4, ')|(', $example4-markup-type-4, ')|(', $example5-markup-type-4, ')|(',         $example6-markup-type-4, ')')" />
  <xsl:variable name="invalid-CDA-markup-regex" select="concat('(', $example1-markup-type-1, ')|(', $example2-markup-type-1, ')|(', $example3-markup-type-1, ')|(', $example4-markup-type-1, ')|(',        $example5-markup-type-1, ')|(', $example6-markup-type-1, ')|(', $example7-markup-type-1, ')|(', $example8-markup-type-1, ')|(',        $example9-markup-type-1, ')|(', $example10-markup-type-1, ')|(', $example11-markup-type-1, ')|(', $example12-markup-type-1, ')|(',        $example13-markup-type-1, ')|(', $example14-markup-type-1, ')|(', $example15-markup-type-1, ')|(', $example16-markup-type-1, ')|(',        $example17-markup-type-1, ')|(', $example18-markup-type-1, ')|(', $example19-markup-type-1, ')|(', $example20-markup-type-1, ')|(',         $example21-markup-type-1, ')|(', $example22-markup-type-1, ')') " />
  <xsl:variable name="invalid-concept-regex" select="concat('(', $example1-markup-type-1, ')|(', $example2-markup-type-1, ')|(', $example3-markup-type-1, ')|(', $example4-markup-type-1, ')|(',        $example5-markup-type-1, ')|(', $example6-markup-type-1, ')|(', $example7-markup-type-1, ')|(', $example8-markup-type-1, ')|(',        $example9-markup-type-1, ')|(', $example10-markup-type-1, ')|(', $example11-markup-type-1, ')|(', $example12-markup-type-1, ')|(',        $example13-markup-type-1, ')|(', $example14-markup-type-1, ')|(', $example15-markup-type-1, ')|(', $example18-markup-type-1, ')|(',         $example19-markup-type-1, ')|(', $example20-markup-type-1, ')|(', $example21-markup-type-1, ')|(',         $example1-markup-type-3, ')|(', $example2-markup-type-3, ')|(', $example3-markup-type-3, ')|(', $example4-markup-type-3, ')|(',         $example5-markup-type-3, ')|(', $example6-markup-type-3, ')|(', $example7-markup-type-3, ')|(', $example8-markup-type-3, ')|(',         $example9-markup-type-3, ')|(', $example10-markup-type-3, ')|(', $example11-markup-type-3, ')|(', $example12-markup-type-3, ')|(',        $example13-markup-type-3, ')|(', $example14-markup-type-3, ')|(', $example15-markup-type-3, ')|(', $example18-markup-type-3, ')|(',         $example19-markup-type-3, ')|(', $example20-markup-type-3, ')|(', $example21-markup-type-3, ')')" />
  <xsl:variable name="chars-no-space-pipe" select="concat(codepoints-to-string((10, 13, 34, 38, 39, 60, 62, 160, 8211, 8212, 8216, 8217)), '^\/?%(){}[]*:;.,+-=')" />
  <xsl:variable name="chars-no-space" select="concat($chars-no-space-pipe, '|')" />
  <xsl:variable name="chars-no-pipe" select="concat($chars-no-space-pipe, ' ')" />
  <xsl:variable name="chars-to-remove" select="concat($chars-no-space, ' ')" />
  <xsl:variable name="regex-date-type-1" select="concat('(',       '^[0-9]{1,2}/{1}[0-9]{1,2}/{1}[1-2]{1}[0-9]{3}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}/{1}[0-9]{1,2}/{1}[0-9]{2}($|[^0-9a-z])',    ')')" />
  <xsl:variable name="date-sep" select="'[, -/\.]{1,2}'" />
  <xsl:variable name="regex-date-type-2" select="concat('(',       '^jan[uary]{0,4}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^feb[ruay]{0,5}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^mar[ch]{0,2}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^apr[il]{0,2}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^may', $date-sep, '[0-9]{2}($|[^0-9a-z])',       ')|(',       '^jun[e]{0,1}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^jul[y]{0,1}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^aug[ust]{0,3}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^sep[tembr]{0,6}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^oct[ober]{0,4}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^nov[embr]{0,5}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^dec[embr]{0,5}', $date-sep, '[0-9]{2}($|[^0-9a-z])',      ')|(',       '^jan[uary]{0,4}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^feb[ruay]{0,5}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^mar[ch]{0,2}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^apr[il]{0,2}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^may', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',       ')|(',       '^jun[e]{0,1}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^jul[y]{0,1}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^aug[ust]{0,3}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^sep[tembr]{0,6}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',     ')|(',       '^oct[ober]{0,4}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^nov[embr]{0,5}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^dec[embr]{0,5}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',      ')|(',       '^[0-9]{1,2}', $date-sep, 'jan[uary]{0,4}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'feb[ruay]{0,5}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'mar[ch]{0,2}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'apr[il]{0,2}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'may', $date-sep, '[0-9]{2}($|[^0-9a-z])',    ')|(',       '^[0-9]{1,2}', $date-sep, 'jun[e]{0,1}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'jul[y]{0,1}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'aug[ust]{0,3}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'sep[tembr]{0,6}', $date-sep, '[0-9]{2}($|[^0-9a-z])',  ')|(',       '^[0-9]{1,2}', $date-sep, 'oct[ober]{0,4}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'nov[embr]{0,5}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'dec[embr]{0,5}', $date-sep, '[0-9]{2}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'jan[uary]{0,4}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',  ')|(',       '^[0-9]{1,2}', $date-sep, 'feb[ruay]{0,5}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',  ')|(',       '^[0-9]{1,2}', $date-sep, 'mar[ch]{0,2}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'apr[il]{0,2}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'may', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',    ')|(',       '^[0-9]{1,2}', $date-sep, 'jun[e]{0,1}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'jul[y]{0,1}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'aug[ust]{0,3}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',   ')|(',       '^[0-9]{1,2}', $date-sep, 'sep[tembr]{0,6}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])', ')|(',       '^[0-9]{1,2}', $date-sep, 'oct[ober]{0,4}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',  ')|(',       '^[0-9]{1,2}', $date-sep, 'nov[embr]{0,5}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',  ')|(',       '^[0-9]{1,2}', $date-sep, 'dec[embr]{0,5}', $date-sep, '[1-2]{1}[0-9]{3}($|[^0-9a-z])',  ')|(',       '^[1-2]{1}[0-9]{3}($|[^0-9a-z])',        ')')" />
  <xsl:variable name="regex-space-date-type-2" select="'(^[0-9]{1,2}[ ]{1}[a-z]{3,}[ ]{1}[1-2]{1}[0-9]{3})|(^[a-z]{3,}[ ]{1}[1-2]{1}[0-9]{3})|(^[1-2]{1}[0-9]{3})|         (^[0-9]{1,2}[ ]{1}[a-z]{3,}[ ]{1}[0-9]{2})|(^[a-z]{3,}[ ]{1}[0-9]{2})'" />
  <xsl:variable name="regex-dash-date-type-2" select="'(^[0-9]{1,2}[-]{1}[a-z]{3,}[-]{1}[1-2]{1}[0-9]{3})|(^}[a-z]{3,}[-]{1}[1-2]{1}[0-9]{3})|(^[1-2]{1}[0-9]{3})|         (^[0-9]{1,2}[-]{1}[a-z]{3,}[-]{1}[0-9]{2})|(^[a-z]{3,}[-]{1}[0-9]{2})'" />
  <xsl:variable name="regex-other-date-type-2" select="'(^[0-9]{1,2}([^0-9a-z -]+|[ -]{2,})[a-z]{3,}([^0-9a-z -]+|[ -]{2,})[1-2]{1}[0-9]{3})|          (^[a-z]{3,}([^0-9a-z -]+|[ -]{2,})[1-2]{1}[0-9]{3})|          (^[0-9]{1,2}([^0-9a-z -]+|[ -]{2,})[a-z]{3,}([^0-9a-z -]+|[ -]{2,})[0-9]{2})|          (^[a-z]{3,}([^0-9a-z -]+|[ -]{2,})[0-9]{2})'" />
  <xsl:variable name="regex-date-type-3" select="'^[1-2]{1}[0-9]{5,}\.{0,1}[0-9]*[-+]{0,1}[0-9]*$'" />
  <xsl:variable name="regex-time" select="'^[0-9]{1,2}:{1}[0-9]{2}'" />
  <xsl:variable name="regex-seconds" select="'^:{1}[0-9]{2}'" />
  <xsl:variable name="regex-timezone" select="'^[+-]{1}[0-9]{4}'" />
  <xsl:variable name="narr-time-regex" select="'[0-9]{1,2}:[0-9]{2}(\s*|:[0-9]{2}\s*)(am\s*|pm\s*|\s*)([+-][0-9]{2}:?[0-9]{2}\s*|\s*)'" />
  <xsl:variable name="fixed-text-ordered" select="tokenize(dh:OrderByLength(string-join(for $text in ($iq-config/narrative-fixed-text/fixed-text, $knowledge/narrative-fixed-text/fixed-text)          return $text/@value, '|'), false()), '\|') " />
  <xsl:variable name="fixed-text-regex" select="concat('^(', string-join(for $text in $fixed-text-ordered return normalize-space(translate($text, $chars-no-space, '')), '|'), ')$') " />
  <xsl:variable name="fixed-text-pattern" select="string-join(for $text in $fixed-text-ordered return          concat('(^|\W+)(', normalize-space(translate($text, $chars-no-space, '')), ')(\W+|$)~$1 $3'), '~') " />
  <xsl:variable name="narr-nv-ordered" select="tokenize(dh:OrderByLength(string-join(for $text in ($iq-config/narr-non-values/non-value, $narr-non-values/non-value)          return $text/@non-value, '|'), false()), '\|') " />
  <xsl:variable name="narr-non-values-pattern" select="string-join(for $text in $narr-nv-ordered return          concat('(^|.*?\W+)(', normalize-space(translate($text, $chars-no-space, '')), ')(\W+.*?|$)~$1 $3'), '~') " />
  <xsl:variable name="regex-non-values" select="if (exists($knowledge/non-values)) then concat('(', dh:OrderByLength(string-join($knowledge/non-values/non-value/@regex, '|'), false()), ')')         else '' " />
  <xsl:variable name="ext-att-uri-regex" select="'(^|[^a-z])(file:|ftp:|http:|https:)'" />
  <xsl:variable name="pcehr-uri-regex" select="'^pcehr:1.2.36.1.2001.1007.10.800364[0-9]{10}/[.0-9a-fA-F^]+$'" />
  <xsl:variable name="mailto-uri-regex" select="'^[^ ()&lt;&gt;@,;:\.\\\[\]][^ ()&lt;&gt;@,;:\\\[\]]+@[^ ()&lt;&gt;@,;:\.\\\[\]][^ ()&lt;&gt;@,;:\\\[\]]+$'" />
  <xsl:variable name="uri-chars" select="concat(codepoints-to-string((38, 39)), 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~%!$()*+,;=:@/?')" />
  <xsl:variable name="oid-chars" select="'0123456789.'" />
  <xsl:variable name="uuid-chars" select="'0123456789abcdefABCDEF-'" />
  <xsl:variable name="oid-regex" select="'^[0-2]{1}\.[0-9.]+$'" />
  <xsl:variable name="invalid-arc-regex" select="'(\.0[0-9]+)|(\.\.)|(\.$)'" />
  <xsl:variable name="uuid-regex" select="'(^[0-9a-f]{8}\-[0-9a-f]{4}\-[0-9a-f]{4}\-[0-9a-f]{4}\-[0-9a-f]{12}$)|(^[0-9A-F]{8}\-[0-9A-F]{4}\-[0-9A-F]{4}\-[0-9A-F]{4}\-[0-9A-F]{12}$)'" />
  <xsl:variable name="invalid-uuid-regex" select="'00000000-0000-0000-0000-000000000000'" />
  <xsl:variable name="abn-oid-regex" select="'(^1\.2\.36\.[0-9]{10,11}\.[0-9.]*[0-9]{1}$|^1\.2\.36\.[0-9]{10,11}$|^1\.2\.36\.1\.2001\.1005\.7[01]{1}\.[0-9]{10,11}\.[0-9.]*[0-9]{1}$|^1\.2\.36\.1\.2001\.1005\.7[01]{1}\.[0-9]{10,11}$)'" />
  <xsl:variable name="acn-oid-regex" select="'(^1\.2\.36\.[0-9]{2,9}\.[0-9.]*[0-9]{1}$|^1\.2\.36\.[0-9]{2,9}$|^1\.2\.36\.1\.2001\.1005\.7[01]{1}\.[0-9]{2,9}\.[0-9.]*[0-9]{1}$|^1\.2\.36\.1\.2001\.1005\.7[01]{1}\.[0-9]{2,9}$)'" />
  <xsl:variable name="known-abn-arcs" select="('174030967')" />
  <xsl:variable name="known-abn-names" select="('Medicare Australia')" />
  <xsl:variable name="known-acn-arcs" select="('104808988', '129710685', '132172957', '174030967')" />
  <xsl:variable name="known-acn-names" select="('Best Practice', 'Health Industry Exchange', 'Medisecure', 'Medicare Australia')" />
  <xsl:variable name="hi-regex" select="'^80036[0-2]{1}[0-9]{10}$'" />
  <xsl:variable name="ihi-regex" select="'^800360[0-9]{10}$'" />
  <xsl:variable name="hpii-regex" select="'^800361[0-9]{10}$'" />
  <xsl:variable name="hpio-regex" select="'^800362[0-9]{10}$'" />
  <xsl:variable name="medicare-card-regex" select="'^[0-9]{10}$'" />
  <xsl:variable name="medicare-ind-regex" select="'^[0-9]{11}$'" />
  <xsl:variable name="dva-270091-regex" select="'^(N|V|Q|W|S|T)([A-Z]{1}[0-9]{6}|[A-Z]{2}[0-9]{5}|[A-Z]{3}[0-9]{4})[A-Z]?$'" />
  <xsl:variable name="dva-339127-regex" select="'^(N|V|Q|W|S|T)([ A-Z]{1}[0-9]{6}|[A-Z]{2}[0-9]{5}|[A-Z]{3}[0-9]{4})[A-Z]?$'" />
  <xsl:variable name="centrelink-crn-regex" select="'^[0-9]{9}[A-Z]$'" />
  <xsl:variable name="latin-term-regex" select="'(^|^.*?[^a-z0-9\.&amp;/]+[0-9]*?|^.*?[^a-z\.]+[0-9]+|^\s*[0-9/]+|^.*?\s[0-9/]+)(ad|ante|aqua|bis|da|die|et|guttae|gutta|gutte|mane|mitte|nocte)([^a-z\./]+.*?$|\.$|\. .*?$|$)'" />
  <xsl:variable name="latin-mabbr-regex" select="'(^|^.*?[^a-z0-9\.&amp;/]+[0-9]*?|^.*?[^a-z\.]+[0-9]+|^\s*[0-9/]+|^.*?\s[0-9/]+)(ad lib\.?|ad us\.?|alt\.? d\.?|alt\. ?d\.?|alt\.? dieb\.?|alt\. ?dieb\.?|alt\.? die\.?|alt\. ?die\.?|alt\.? hor\.?|alt\. ?hor\.?|alt\.? h\.?|alt\. ?h\.?|aq\.? bull\.?|aq\. ?bull\.?|aq\.? com\.?|aq\. ?com\.?|aq\.? dest\.?|aq\. ?dest\.?|aq\.? ferv\.?|aq\. ?ferv\.?|bis ind\.?|bis in [\-0-9]+[ ]?d\.?|cochl\.? ampl\.?|cochl\. ?ampl\.?|cochl\.? infant\.?|cochl\. ?infant\.?|cochl\.? mag\.?|cochl\. ?mag\.?|cochl\.? mod\.?|cochl\. ?mod\.?|cochl\.? parv\.?|cochl\. ?parv\.?|cyath\.? vinos\.?|cyath\. ?vinos\.?|dieb\.? alt\.?|dieb\. ?alt\.?|d\.? in p\.? ae\.?|dolent\.? part\.?|dolent\. ?part\.?|dol\.? urg|dol\. ?urg|ex aq\.?|f\.? pil\.?|f\. ?pil\.?|hor\.? alt\.?|hor\. ?alt\.?|hor\.? decub\.?|hor\. ?decub\.?|hor\.? intermed\.?|hor\. ?intermed\.?|hor\.? tert\.?|hor\. ?tert\.?|lat\.? dol\.?|lat\. ?dol\.?|mod\.? praescript\.?|non rep\.?|n\.? et m\.?|o\.? alt\.? hor\.?|o\. ?alt\. ?hor\.?|omn\.? bih\.?|omn\. ?bih\.?|omn\.? hor\.?|omn\. ?hor\.?|part\.? aeq\.?|part\. ?aeq\.?|p\.? aeq\.?|p\. ?aeq\.?|part\.? dolent\.?|part\. ?dolent\.?|q\.? ?[\-0-9]+\.? ?d\.?|q\.? ?[\-0-9]+\.? ?h\.?|q\.?[0-9]+\.?a\.?m\.?|q\.?[0-9]+\.?p\.?m\.?|q\.?[0-9]{1,2}/[0-9]{1,2}\.?|q\.?s\.? a\.?d|q\.?s\. ?a\.?d|si op\.? sit|ut\.? dict\.?|ut\. ?dict\.?)([^a-z\./]+.*?$|\.$|\. .*?$|$)'" />
  <xsl:variable name="latin-abbr-regex" select="'(^|^.*?[^a-z0-9\.&amp;/]+[0-9]*?|^.*?[^a-z\.]+[0-9]+|^\s*[0-9/]+|^.*?\s[0-9/]+)(aa\.?|a\.?c\.?h\.?s\.?|a\.?c\.?|a\.?d\.?d\.?|admov\.?|a\.?d\.?|aeq\.?|agit\.?|amp\.?|a\.?m\.?|applic\.?|aq\.?|a\.?l\.?|a\.s\.|aurist\.?|aur\.?|a\.?u\.?|b\.?d\.?s|b\.?d\.?|bib\.?|b\.?i\.?d\.?|bol\.?|bucc\.?|b\.?|calid\.?|c\.?c\.?|c\.?m\.?s\.?|c\.m\.?|cib\.?|c\.?c\.?|c\.?f\.?|c\.?n\.?|cochl\.?|colet\.?|collut\.?|collyr\.?|comp\.?|contin\.?|cpt\.?|cuj\.?|c\.?v\.?|cyath\.?|decoct\.?|dest\.?|det\.?|dim\.?|d\.?t\.?d\.?|d\.?|e\.?m\.?p\.?|emuls\.?|exhib\.?|f\.?h\.?|fld\.?|fl\.?|f\.?m\.?|fort\.?|f\.?s\.?a\.?|ft\.?|f\.?|garg\.?|gr\.?|gtts?\.?|gutt\.?|hor\.?|habt\.?|h\.?s\.?|i\.?c\.?|IJ|inj\.?|ind\.?|inf\.?|i/d|ii/d|iii/d|iv/d|iv|i-ii|i-iii|i-iv|iii|ii|i|lb\.?|l\.?c\.?d\.?|lin\.?|lot\.?|m\.?d\.?u\.?|m\.?d\.?|mEq|mist\.?|mitt\.?|mit\.?|m\.?|narist\.?|noct\.?|n\.?p\.?o\.?|n\.?p\.?|occ?ulent\.?|occ?\.?|o\.?d\.?|o\.?m\.?|o\.n\.|o\.?s\.?|o\.?u\.?|p\.?a\.?a\.?|p\.?a\.?|p\.?c\.?h\.?s\.?|p\.?c\.?|pigm\.?|pig\.?|p\.?m\.?|p\.?o\.?|ppt\.?|p\.?r\.?n\.?|pt\.?|pulv\.?|p\.?|q\.?a\.?d\.?|q\.?a\.?m\.?|q\.?d\.?|q\.?d\.?a\.?m\.?|q\.?d\.?p\.?m\.?|q\.?d\.?s\.?|q\.?p\.?m\.?|q\.?h\.?s\.?|q\.?h\.?|q\.?i\.?d\.?|q\.?l\.?|q\.?n\.?|q\.?o\.?d\.?|q\.?q\.?h\.?|q\.?q\.?|q\.?s\.?|q\.?v\.?|q\.?|rept\.?|rep\.?|Rx\.?|s\.?a\.?|sem\.?|s\.?i\.?d\.?|sig\.?|sing\.?|sol\.?|s\.?o\.?s\.?|s\.?s\.?|stat|sum\.?|supp\.?|susp\.?|syr\.?|s\.?|tal\.?|t\.?d\.?s\.?|t\.?i\.?d\.?|t\.?d\.?d\.?|t\.?d\.?|trit\.?|troche?\.?|tr|t\.?|u\.?a\.?|u\.?d\.?|ung\.?|ut\.?)([^a-z\./]+.*?$|\.$|\. .*?$|$)'" />
  <xsl:variable name="other-abbr-regex" select="'(^|^.*?[^a-z0-9\.&amp;/]+[0-9]*?|^.*?[^a-z\.]+[0-9]+|^\s*[0-9/]+|^.*?\s[0-9/]+)(AAA|alt\.?|amt\.?|appl\.?|A\.?T\.?C\.?|B\.?M\.?|B\.?S\.?A\.?|B\.?S\.?|b\.?t\.?|c\.?|caps\.?|cap\.?|conc\.?|co\.?|crem\.?|crm\.?|cr\.?|CST|D5LR|D5NS|D5W|D10W|DAQ|D/?C|D\.?A\.?W\.?|d/?c\.?|disc\.?|dil\.?|disp\.?|dev\.?|div\.?|dL|dos\.?|DS|DTO|D\.?W\.?|elix\.?|EOD|extemp\.?|ext\.?|e\.?|G\.?I\.?|gm\.?|H|hrs?|hrly|IBW|ID|i\.?m\.?|i\.?n\.|IO|IP|IU|i\.?v\.?|i\.?v\.?p\.?|IVI|IVPB|IVP|L\.?A\.?S\.?|liq\.?|max\.?|mcg\.?|mdi|MgSO4|midi|mins?\.?|mls\.?|MSO4|MS|nas\.?|N\.?M\.?T\.?|NS|1/2NS|N\.?T\.?E\.?|nebul\.?|neb\.?|n\.?|o_?2|OJ|OPD|o\.?w\.?|oz\.?|o\.?|past\.?|p/?\.?f\.?|P\.?V\.?|p\.?r\.?|p\.?v\.?|QWK|R/?L|r\.?e\.?|R\.?|S\.?C\.?|S\.?/?L\.?|SOB|SSI|S\.?Q\.?|SSRI|Sub\.?C\.?|Sub\.?Cut\.?|Sub\.?Q\.?|tabs\.?|tab\.?|tbsp|tb\.?|t\.?d\.?|t\.?e\.?|t\.?i\.?w\.?|tinct\.?|tinc\.?|top\.|T\.?P\.?N\.?|tsf\.?|tsp\.?|ug\.?|U|vag\.?|w/a|w/f|wks?\.?|w/o|W\.?S\.?P\.?|w/?\.?|x|y\.?o\.?|Y\.?S\.?P\.?)([^a-z\./]+.*?$|\.$|\. .*?$|$)'" />
  <xsl:variable name="directions-dec-regex" select="'(^|^.*?[^0-9a-z])(\.[0-9]+)([^0-9]+.*?$|$)'" />
  <xsl:variable name="directions-frac-regex" select="'(^|^.*?[^0-9\./])([0-9]{1,2}/[0-9]{1,2})([^0-9/]+.*?$|$)'" />
  <xsl:variable name="sig-risk-regex" select="'^(gutte|q\.?d\.?s\.?|dc|D/?C|IO|IP|IU|IVI|mcg|o\.?d\.?|OJ|U|u|SSRI|SSI)$'" />
  <xsl:variable name="narr-ceased-med-regex" select="if ($knowledge/narr-regex/narr-ceased-med/@regex) then $knowledge/narr-regex/narr-ceased-med/@regex else '' " />
  <xsl:variable name="narr-ceased-med-neg-regex" select="if ($knowledge/narr-regex/narr-ceased-med-neg/@regex) then $knowledge/narr-regex/narr-ceased-med-neg/@regex else '' " />
  <xsl:variable name="narr-current-med-regex" select="if ($knowledge/narr-regex/narr-current-med/@regex) then $knowledge/narr-regex/narr-current-med/@regex else '' " />
  <xsl:variable name="narr-current-med-neg-regex" select="if ($knowledge/narr-regex/narr-current-med-neg/@regex) then $knowledge/narr-regex/narr-current-med-neg/@regex else '' " />
  <xsl:variable name="narr-med-regex" select="if ($knowledge/narr-regex/narr-med/@regex) then $knowledge/narr-regex/narr-med/@regex else '' " />
  <xsl:variable name="narr-med-neg-regex" select="if ($knowledge/narr-regex/narr-med-neg/@regex) then $knowledge/narr-regex/narr-med-neg/@regex else '' " />
  <xsl:variable name="narr-adverse-regex" select="if ($knowledge/narr-regex/narr-adverse/@regex) then $knowledge/narr-regex/narr-adverse/@regex else '' " />
  <xsl:variable name="narr-adverse-neg-regex" select="if ($knowledge/narr-regex/narr-adverse-neg/@regex) then $knowledge/narr-regex/narr-adverse-neg/@regex else '' " />
  <xsl:variable name="ts-chars" select="'0123456789+-.'" />
  <xsl:variable name="ts-tz-regex" select="'^[0-9]{4}$'" />
  <xsl:variable name="postcode-regex" select="'^[0-9]{4}$'" />
  <xsl:variable name="state-regex" select="concat('^(', string-join($knowledge/states/state/@abbreviation, '|'), ')$') " />
  <xsl:variable name="state-full-regex" select="replace(concat('(',string-join(($knowledge/states/state/@abbreviation, $knowledge/states/state/@name, $knowledge/states/state/@typo), '|'), ')'), ' ', '\\s+') " />
  <xsl:variable name="state-pattern-replacement" select="replace(string-join(for $item in $knowledge/states/state return         if ($item/@typo) then         concat('(^|[^a-z])', $item/@name, '([^a-z]|$)', '~$1', $item/@abbreviation, '$2~', '(^|[^a-z])', $item/@typo, '([^a-z]|$)', '~$1', $item/@abbreviation, '$2')        else concat('(^|[^a-z])', $item/@name, '([^a-z]|$)', '~$1', $item/@abbreviation, '$2'), '~'), ' ', '\\s+') " />
  <xsl:variable name="street-type-regex" select="concat('^.*?[a-z]+\s+(', string-join(        ($knowledge/street-types/street-type/@name, $knowledge/street-types/street-type/@abbreviation, $knowledge/street-types/street-type/@typo),         '|'), ')$')" />
  <xsl:variable name="name-newborn-g-regex" select="'(baby\s+of|twin\s+of|trip\s+of|triplet\s+of|quad\s+of|quadruplet\s+of|quin\s+of|quintuplet\s+of|sext\s+of|sextuplet\s+of|sept\s+of|septuplet\s+of)'" />
  <xsl:variable name="name-newborn-w-regex" select="'^(baby\s+of|twin\s+of|trip\s+of|triplet\s+of|quad\s+of|quadruplet\s+of|quin\s+of|quintuplet\s+of|sext\s+of|sextuplet\s+of|sept\s+of|septuplet\s+of)$'" />
  <xsl:variable name="name-newborn-w-rep-regex" select="'(^|[^a-z])(baby\s+of|twin\s+of|trip\s+of|triplet\s+of|quad\s+of|quadruplet\s+of|quin\s+of|quintuplet\s+of|sext\s+of|sextuplet\s+of|sept\s+of|septuplet\s+of)([^a-z]|$)'" />
  <xsl:variable name="name-prefix-regex-1" select="concat('(', string-join($knowledge/name-title/title/@full, '|'), '|', string-join($knowledge/name-title/title/@abbreviation, '|'), ')')" />
  <xsl:variable name="name-prefix-regex" select="concat('^', $name-prefix-regex-1, '$')" />
  <xsl:variable name="name-prefix-rep-regex" select="concat('(^|[^a-z])', $name-prefix-regex-1, '([^a-z]|$)')" />
  <xsl:variable name="name-suffix-regex" select="concat('^(', string-join($knowledge/name-suffix/suffix/@full, '|'), '|', string-join($knowledge/name-suffix/suffix/@abbreviation, '|'), ')$')" />
  <xsl:variable name="name-suffix-m-regex-1" select="concat('(', string-join($knowledge/name-suffix/suffix/@full, '|'), '|', string-join($knowledge/name-suffix/suffix[string-length(@abbreviation) &gt; 1]/@abbreviation, '|'), ')')" />
  <xsl:variable name="name-suffix-m-regex" select="concat('^', $name-suffix-m-regex-1, '$')" />
  <xsl:variable name="name-suffix-m-rep-regex" select="concat('(^|[^a-z])', $name-suffix-m-regex-1, '([^a-z]|$)')" />
  <xsl:variable name="uri-scheme-regex" select="'^[a-zA]{1}[0-9a-zA-Z+-.]*$'" />
  <xsl:variable name="ucum-time-unit-regex" select="'(^min$)|(^h$)|(^d$)|(^a_t$)|(^a_j$)|(^a_g$)|(^a$)|(^wk$)|(^mo_s$)|(^mo_j$)|(^mo_g$)|(^mo$)'" />
  <xsl:variable name="ucum-annotation-regex" select="'\{.*\}'" />
  <xsl:variable name="ucum-annotation-replacement" select="'(^|/|\.)\{.*\}$~~\{.*\}~'" />
  <xsl:variable name="ucum-chars" select="'_\[\]''\+\-\./\(\)\^\*%0-9a-z'" />
  <xsl:variable name="ucum-invalid-replacement" select="string-join(for $term in $UCUM/invalid return concat($term/@regex, '~', $term/@correction), '~') " />
  <xsl:variable name="number-regex" select="'^\s*(-?\d*\.\d+|-?\d+\.\d*|\d+)'" />
  <xsl:variable name="number-in-ST-regex" select="'^\s*(-?\d*\.\d+|-?\d+\.\d*|\d+)(.*)$'" />
  <xsl:variable name="PQ-low-regex" select="'^\s*\(?(&gt;|&gt;)\s*(-?\d*\.\d+|-?\d+\.\d*|\d+)'" />
  <xsl:variable name="PQ-high-regex" select="'^\s*\(?&lt;\s*(-?\d*\.\d+|-?\d+\.\d*|\d+)'" />
  <xsl:variable name="IVL_PQ-regex" select="'^\s*\(?\s*(-?\d*\.\d+|-?\d+\.\d*|\d+)\s*-\s*(-?\d*\.\d+|-?\d+\.\d*|\d+)\)?'" />
  <xsl:variable name="RR-regex" select="'(^.+?\(RR)([^\)]+?)(\))' " />
  <xsl:variable name="PQ-replacement" select="concat('^(\s*)(.+?)\(.*\)~$2~[\(\)]~~^[0-9 \.\-]+~~', $ucum-invalid-replacement, '~\s+~')" />
  <xsl:variable name="IVL_PQ-replacement" select="concat('^(\s*)(.+?)\(.*\)~$2~[\(\)]~~^\s*(&gt;|&gt;|&lt;)\s*~~^(\d*\.?\d*\s*-\s*\d*\.?\d*|\d*\.?\d*)\s*~~',          $ucum-invalid-replacement, '~\s+~')" />
  <xsl:variable name="known-templateIds" select="for $i in (1 to count($document-types/doc-type)) return $document-types[$i]/doc-type/@templateId" />
  <xsl:variable name="templateId-root" select="/cda:ClinicalDocument/cda:templateId[exists(index-of($known-templateIds, @root))]/@root" />
  <xsl:variable name="templateId-ext" select="/cda:ClinicalDocument/cda:templateId[exists(index-of($known-templateIds, @root))]/@extension" />
  <xsl:variable name="doc-type" select="if ($document-types/doc-type[@templateId = $templateId-root and @extension = $templateId-ext])         then $document-types/doc-type[@templateId = $templateId-root and @extension = $templateId-ext] else () " />
  <xsl:variable name="document-name" select="if (exists($doc-type)) then $doc-type[@templateId = $templateId-root]/@name else 'unknown document type' " />
  <xsl:variable name="document-id" select="if (/cda:ClinicalDocument/cda:id[@root and not(@extension)]) then /cda:ClinicalDocument/cda:id/@root        else if (/cda:ClinicalDocument/cda:id[@root and @extension])         then concat(/cda:ClinicalDocument/cda:id/@root, '^', /cda:ClinicalDocument/cda:id/@extension)        else 'invalid ID' " />
  <xsl:variable name="rendering-1-0" select="exists(/cda:ClinicalDocument/cda:templateId[@root = '1.2.36.1.2001.1001.100.149' and @extension = '1.0']) " />
  <xsl:variable name="doc-common-conf-profile" select="if ($doc-type/@common-conformance-profile) then $doc-type/@common-conformance-profile else '0' " />
  <xsl:variable name="logical-spec" select="if (/cda:ClinicalDocument/cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.4' and @extension = '3.4'])         then concat($document-name, ' Structured Document Template')         else concat($document-name, ' Structured Content Specification') " />
  <xsl:variable name="doc-type-min-conformance-level" select="if ($doc-type/@min-conformance) then $doc-type/@min-conformance else 'unknown' " />
  <xsl:variable name="conformance-level-3" select="($flags/@conformance-level and upper-case($flags/@conformance-level) = ('3A', '3B')) or $doc-type-min-conformance-level = ('3A', '3B') " />
  <xsl:variable name="no-value-NF" select=" ('NI', 'UNK', 'ASKU', 'NAV', 'NASK', 'MSK', 'NA') " />
  <xsl:variable name="doc-section-seq" select="(/cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section,         /cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section/cda:component/cda:section,         /cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section/cda:component/cda:section/cda:component/cda:section,         /cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section/cda:component/cda:section/cda:component/cda:section/cda:component//cda:section) " />
  <xsl:variable name="doc-sections" select="distinct-values($doc-section-seq/cda:code[@codeSystem='1.2.36.1.2001.1001.101']/@code) " />
  <xsl:variable name="pathTestRes" select="$doc-section-seq[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16144']] " />
  <xsl:variable name="num-pathTestRes" select="count($pathTestRes) " />
  <xsl:variable name="num-imExamRes" select="if ('102.16145' = $doc-sections) then count($doc-section-seq[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16145']]) else 0 " />
  <xsl:variable name="num-undiffDiag" select="if ('102.16029' = $doc-sections) then count($doc-section-seq[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16029']]) else 0 " />
  <xsl:variable name="num-reqService" select="if ('102.20158' = $doc-sections) then count($doc-section-seq[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.20158']]) else 0 " />
  <xsl:variable name="extensions-allowed" select="not(  ($templateId-root = '1.2.36.1.2001.1001.101.100.1002.120' and $templateId-ext = '1.4') or         $templateId-root = '1.2.36.1.2001.1001.100.1002.170'      or          $templateId-root = '1.2.36.1.2001.1001.100.1002.171'      or          $templateId-root = '1.2.36.1.2001.1001.101.100.1002.140'    or         $templateId-root = '1.2.36.1.2001.1001.101.100.1002.142'    or         $templateId-root = '1.2.36.1.2001.1001.101.100.1002.144'    or         $templateId-root = '1.2.36.1.2001.1001.101.100.1002.147'    or         $templateId-root = '1.2.36.1.2001.1001.101.100.1002.234'     )" />
  <xsl:variable name="extension-requirement" select="if ($templateId-root = '1.2.36.1.2001.1001.101.100.1002.120' and $templateId-ext = '1.4')           then 'requirement 024986 of the Shared Health Summary Conformance Profile v1.6'         else if ($templateId-root = '1.2.36.1.2001.1001.100.1002.170')           then 'section 3.2.12 of the eHealth Prescription Record Conformance Profile v1.3'         else if ($templateId-root = '1.2.36.1.2001.1001.100.1002.171')           then 'section 3.2.12 of the eHealth Dispense Record Conformance Profile v1.3'         else if ($templateId-root = '1.2.36.1.2001.1001.101.100.1002.140')          then 'section 3.3 of the Medicare/DVA Benefits Report Conformance Profile v1.0'         else if ($templateId-root = '1.2.36.1.2001.1001.101.100.1002.142')          then 'section 3.3 of the Pharmaceutical Benefits Report Conformance Profile v1.0'         else if ($templateId-root = '1.2.36.1.2001.1001.101.100.1002.144')          then 'section 3.3 of the Australian Childhood Immunisation Register Conformance Profile v1.0'         else if ($templateId-root = '1.2.36.1.2001.1001.101.100.1002.147')          then 'section 3.3 of the Australian Organ Donor Register Conformance Profile v1.0'         else if ($templateId-root = '1.2.36.1.2001.1001.101.100.1002.234')           then 'section 3.3 of the Australian Immunisation Register Conformance Profile v1.0'         else if ($doc-type/@common-conformance-profile = '1.7')           then 'requirement 023722 of the Common Conformance Profile for Clinical Documents v1.7'         else if ($doc-type/@common-conformance-profile = '1.6')           then 'requirement 023722 of the Common Conformance Profile for Clinical Documents v1.6'         else if ($doc-type/@common-conformance-profile = '1.5')           then 'requirement 023722 of the Common Conformance Profile for Clinical Documents v1.5'         else if ($doc-type/@common-conformance-profile = '1.4')           then 'section 3.4.3 of the Common Conformance Profile for Clinical Documents v1.4'         else if ($doc-type/@common-conformance-profile = '1.3')           then 'section 3.4.1.2 of the Common Conformance Profile for Clinical Documents v1.3'         else 'requirement 023722 in the Common Conformance Profile for Clinical Documents v1.6'" />
  <xsl:variable name="same-doc-list" select="if ($flags/@report-statistics = 'true' or $flags/@report-statistics = 'true' or $flags/@collection-same-system = 'true')         then $documents[cda:ClinicalDocument[cda:templateId[@root = $templateId-root and @extension = $templateId-ext]]]        else () " />
  <xsl:variable name="same-doc-num" select="count($same-doc-list)" />
  <xsl:variable name="same-doc-count" select="if ($numbers/number[number(@value) = $same-doc-num]) then $numbers/number[number(@value) = $same-doc-num]/@name else $same-doc-num" />
  <xsl:variable name="doc-timezone" select="if (contains(/cda:ClinicalDocument/cda:effectiveTime/@value, '+'))        then concat('+', substring-after(/cda:ClinicalDocument/cda:effectiveTime/@value, '+'))       else if (contains(/cda:ClinicalDocument/cda:effectiveTime/@value, '-'))        then concat('-', substring-after(/cda:ClinicalDocument/cda:effectiveTime/@value, '-'))       else 'none' " />
  <xsl:variable name="body-date-times" select="distinct-values(/cda:ClinicalDocument[not($flags/@allow-hints = 'false')]/cda:component/cda:structuredBody/cda:component/cda:section/*[not(cda:text)]//*       [@value and (local-name(.) = ('activityTime',                         'availabilityTime',                         'birthTime',                         'copyTime',                         'creationTime',                        'deceasedTime',                         'effectiveTime',                         'executionAndDeliveryTime',                         'lastCalibrationTime',                         'recertificationTime',                         'time')              or       @xsi:type = 'TS' or normalize-space(substring-after(@xsi:type, ':')) = 'TS'         or             (local-name(.) = ('low', 'high', 'center') and (local-name(..) = ('activityTime',                 'availabilityTime',                 'effectiveTime',                 'existenceTime',                 'expectedUseTime',                 'expirationTime',                 'stabilityTime',                 'time',                 'phase') or                   ../@xsi:type = 'IVL_TS' or normalize-space(substring-after(../@xsi:type, ':')) = 'IVL_TS')) )]/@value)" />
  <xsl:variable name="body-dt-timezones-1" select="for $date-time in $body-date-times return        if (matches($date-time, '(\-|\+)[0-9]{4}$')) then replace($date-time, '^(.*?)(\-|\+)([0-9]{4})$', '$2$3') else ''  " />
  <xsl:variable name="body-dt-timezones" select="distinct-values($body-dt-timezones-1[. != '']) " />
  <xsl:variable name="body-mixed-timezones" select="count($body-dt-timezones) &gt; 1 " />
  <xsl:variable name="not-doc-timezone" select="$doc-timezone != 'none' and exists($body-dt-timezones) and exists($body-dt-timezones[. != $doc-timezone]) " />
  <xsl:variable name="body-same-timezones" select="not($body-mixed-timezones or $not-doc-timezone) " />
  <xsl:variable name="body-timezone-message" select="if ($body-mixed-timezones) then concat('The body of the ', $document-name, ' contains date time data elements with more than one timezone.')         else if ($not-doc-timezone) then concat('The body of the ', $document-name, ' contains a date time data element with a timezone that differs ',         'from the timezone (', $doc-timezone, ') of the document creation.')        else if ($doc-timezone != 'none') then concat('The body of the ', $document-name, ' does not contain date time data elements with more than one ',         'timezone and the document creation date does not contain a timezone.')        else concat('The body of the ', $document-name, ' does not contain date time data elements with more than one timezone and ',         'there is no difference with the timezone (', $doc-timezone, ') of the document creation date.') " />
  <xsl:variable name="SHSs" select="if ($flags/@collection-same-record = 'true') then         $documents/cda:ClinicalDocument[cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.120']] else () " />
  <xsl:variable name="SHS-count" select="if ($numbers/number[@value = count($SHSs)]) then $numbers/number[number(@value) = count($SHSs)]/@name else count($SHSs)" />
  <xsl:variable name="SHS-dates" select="for $i in (1 to count($SHSs)) return $SHSs[$i]/cda:effectiveTime/@value " />
  <xsl:variable name="last-SHS" select="if (count($SHSs) &gt; 0) then $SHSs[2] else () " />
  <xsl:variable name="last-amtv2" select="'2.56'" />
  <xsl:variable name="last-amtv2-date" select="'20140531'" />
  <xsl:variable name="first-amtv3" select="'http://snomed.info/sct/900062011000036108/version/20140630'" />
  <xsl:variable name="last-amtv3" select="'http://snomed.info/sct/900062011000036108/version/20151130'" />
  <xsl:variable name="first-amt-in-sctau" select="'http://snomed.info/sct/32506021000036107/version/20151231'" />
  <xsl:variable name="sctau-namespace-id-regex" select="'(1000168|1000036)'" />
  <xsl:variable name="creation-date-yr" select="substring(/cda:ClinicalDocument/cda:effectiveTime/@value, 1, 4)" />
  <xsl:variable name="creation-date-mn-temp" select="substring(/cda:ClinicalDocument/cda:effectiveTime/@value, 5, 2)" />
  <xsl:variable name="creation-date-mn" select="if ($creation-date-mn-temp = '') then '06' else $creation-date-mn-temp" />
  <xsl:variable name="creation-date-dy-temp" select="substring(/cda:ClinicalDocument/cda:effectiveTime/@value, 7, 2)" />
  <xsl:variable name="creation-date-dy" select="if ($creation-date-dy-temp = '') then '15' else $creation-date-dy-temp" />
  <xsl:variable name="creation-date" select="concat($creation-date-yr, $creation-date-mn, $creation-date-dy)" />
  <xsl:variable name="creation-date-xs-temp" select="concat($creation-date-yr, '-', $creation-date-mn, '-', $creation-date-dy)" />
  <xsl:variable name="creation-date-xs" select="if ($creation-date-xs-temp castable as xs:date) then xs:date($creation-date-xs-temp) else 'error' " />
  <xsl:variable name="creation-date-est" select="$creation-date-mn-temp = '' or $creation-date-dy-temp = '' " />
  <xsl:variable name="display-creation-date" select="if ($creation-date-mn-temp = '') then $creation-date-yr        else if ($creation-date-dy-temp = '') then concat($knowledge/months/month[@number = $creation-date-mn]/@abbreviation, ' ', $creation-date-yr)        else concat($creation-date-dy, ' ', $knowledge/months/month[@number = $creation-date-mn]/@abbreviation, ' ', $creation-date-yr) " />
  <xsl:variable name="creation-date-msg" select="if ($creation-date-xs = 'error')          then concat(' The clinical document creation date ''', /cda:ClinicalDocument/cda:effectiveTime/@value, ''' is not a valid date.')        else if ($creation-date-mn-temp = '')         then concat(' The clinical document creation date ''', /cda:ClinicalDocument/cda:effectiveTime/@value,           ''' did not contain a month so the estimated date of ''', $creation-date, ''' was used.')        else if ($creation-date-dy-temp = '')         then concat(' The clinical document creation date ''', /cda:ClinicalDocument/cda:effectiveTime/@value,           ''' did not contain a day so the estimated date of ''', $creation-date, ''' was used.')        else '' " />
  <xsl:variable name="creation-date-length" select="min((8, string-length(/cda:ClinicalDocument/cda:effectiveTime/@value)))" />
  <xsl:variable name="creation-date-actual" select="substring(/cda:ClinicalDocument/cda:effectiveTime/@value, 1, $creation-date-length)" />
  <xsl:variable name="v-amtv2-temp" select="normalize-space(dh:GetCodeSystemVersions('1.2.36.1.2001.1004.100', ''))" />
  <xsl:variable name="v-amtv2" select="if ($v-amtv2-temp = ('', 'Error')) then () else tokenize($v-amtv2-temp, '\|')" />
  <xsl:variable name="v-amtv3-temp" select="normalize-space(dh:GetCodeSystemVersions('2.16.840.1.113883.6.96', '900062011000036108'))" />
  <xsl:variable name="v-amtv3" select="if ($v-amtv3-temp = ('', 'Error')) then () else tokenize($v-amtv3-temp, '\|') " />
  <xsl:variable name="v-pbs-temp" select="normalize-space(dh:GetCodeSystemVersions('1.2.36.1.2001.1005.22', ''))" />
  <xsl:variable name="v-pbs" select="if ($v-pbs-temp = ('', 'Error')) then () else tokenize($v-pbs-temp, '\|') " />
  <xsl:variable name="v-pbsman" select="$v-pbs " />
  <xsl:variable name="v-snomedctau-temp" select="normalize-space(dh:GetCodeSystemVersions('2.16.840.1.113883.6.96', '32506021000036107'))" />
  <xsl:variable name="v-snomedctau" select="if ($v-snomedctau-temp = ('', 'Error')) then () else tokenize($v-snomedctau-temp, '\|')" />
  <xsl:variable name="ts-snomedctau-temp" select="normalize-space(dh:GetCodeSystemVersionsUsingTS('2.16.840.1.113883.6.96', '32506021000036107'))" />
  <xsl:variable name="ts-snomedctau" select="if ($ts-snomedctau-temp = ('', 'Error')) then () else tokenize($ts-snomedctau-temp, '\|')" />
  <xsl:variable name="use-ts-for-sctau" select="exists($ts-snomedctau)" />
  <xsl:variable name="ts-loinc-temp" select="normalize-space(dh:GetCodeSystemVersionsUsingTS('2.16.840.1.113883.6.1', ''))" />
  <xsl:variable name="ts-loinc" select="if ($ts-loinc-temp = ('', 'Error')) then () else tokenize($ts-loinc-temp, '\|')" />
  <xsl:variable name="use-ts-for-loinc" select="exists($ts-loinc)" />
  <xsl:variable name="ts-vaccines-temp" select="normalize-space(dh:GetCodeSystemVersionsUsingTS('1.2.36.1.2001.1005.17', ''))" />
  <xsl:variable name="ts-vaccines" select="if ($ts-vaccines-temp = ('', 'Error')) then () else tokenize($ts-vaccines-temp, '\|')" />
  <xsl:variable name="use-ts-for-vaccines" select="exists($ts-vaccines)" />
  <xsl:variable name="ncts-data-comp" select=" 'https://healthterminologies.gov.au/fhir/CodeSystem/nctis-data-components-1' " />
  <xsl:variable name="ts-ncts-data-comp-temp" select="normalize-space(dh:GetCodeSystemVersionsUsingTS($ncts-data-comp, ''))" />
  <xsl:variable name="ts-ncts-data-comp" select="if ($ts-ncts-data-comp-temp = ('', 'Error')) then () else tokenize($ts-ncts-data-comp-temp, '\|')" />
  <xsl:variable name="use-ts-for-ncts-data-comp" select="exists($ts-ncts-data-comp)" />
  <xsl:variable name="ts-anzsco-temp" select="normalize-space(dh:GetCodeSystemVersionsUsingTS('2.16.840.1.113883.13.62', ''))" />
  <xsl:variable name="ts-anzsco" select="if ($ts-anzsco-temp = ('', 'Error')) then () else tokenize($ts-anzsco-temp, '\|')" />
  <xsl:variable name="use-ts-for-anzsco" select="exists($ts-anzsco)" />
  <xsl:variable name="ts-pbs-temp" select="normalize-space(dh:GetCodeSystemVersionsUsingTS('1.2.36.1.2001.1005.22', ''))" />
  <xsl:variable name="ts-pbs" select="if ($ts-pbs-temp = ('', 'Error')) then () else tokenize($ts-pbs-temp, '\|')" />
  <xsl:variable name="use-ts-for-pbs" select="exists($ts-pbs)" />
  <xsl:variable name="ts-pbsman-temp" select="normalize-space(dh:GetCodeSystemVersionsUsingTS('1.2.36.1.2001.1005.23', ''))" />
  <xsl:variable name="ts-pbsman" select="if ($ts-pbsman-temp = ('', 'Error')) then () else tokenize($ts-pbsman-temp, '\|')" />
  <xsl:variable name="use-ts-for-pbsman" select="exists($ts-pbsman)" />
  <xsl:variable name="v-latest-amtv2" select="$v-amtv2[1]" />
  <xsl:variable name="v-amtv3-dates" select="for $i in (1 to count($v-amtv3)) return substring-after($v-amtv3[$i], 'http://snomed.info/sct/900062011000036108/version/') " />
  <xsl:variable name="v-earliest-amtv3-date" select="if (count($v-amtv3-dates) &lt; 2) then $v-amtv3-dates else substring-before(dh:OrderDates(string-join($v-amtv3-dates, '|'), true()), '|') " />
  <xsl:variable name="v-amtv3-pre" select="(for $i in (1 to count($v-amtv3-dates)) return if ($creation-date - $v-amtv3-dates[$i] &gt; -1)         then $v-amtv3-dates[$i] else '')[. != ''] " />
  <xsl:variable name="v-amtv3-post" select="(for $i in (1 to count($v-amtv3-dates)) return if ($creation-date - $v-amtv3-dates[$i] &lt; 0)         then $v-amtv3-dates[$i] else '')[. != ''] " />
  <xsl:variable name="v-latest-amtv3" select="if (exists($v-amtv3-pre))         then concat('http://snomed.info/sct/900062011000036108/version/', tokenize(dh:OrderDates(string-join($v-amtv3-pre, '|'), false()), '\|')[1])       else if (exists($v-amtv3-post))         then concat('http://snomed.info/sct/900062011000036108/version/', tokenize(dh:OrderDates(string-join($v-amtv3-post, '|'), true()), '\|')[1])       else '' " />
  <xsl:variable name="v-pbs-pre" select="(for $i in (1 to count($v-pbs)) return if ($creation-date - $v-pbs[$i] &gt; -1) then $v-pbs[$i] else '')[. != ''] " />
  <xsl:variable name="v-pbs-post" select="(for $i in (1 to count($v-pbs)) return if ($creation-date - $v-pbs[$i] &lt; 0) then $v-pbs[$i] else '')[. != ''] " />
  <xsl:variable name="v-latest-pbs" select="if (exists($v-pbs-pre)) then tokenize(dh:OrderDates(string-join($v-pbs-pre, '|'), false()), '\|')[1]        else if (exists($v-pbs-post)) then tokenize(dh:OrderDates(string-join($v-pbs-post, '|'), true()), '\|')[1]         else '' " />
  <xsl:variable name="v-pbsman-pre" select="(for $i in (1 to count($v-pbs)) return if ($creation-date - $v-pbs[$i] &gt; -1) then $v-pbs[$i] else '')[. != ''] " />
  <xsl:variable name="v-pbsman-post" select="(for $i in (1 to count($v-pbs)) return if ($creation-date - $v-pbs[$i] &lt; 0) then $v-pbs[$i] else '')[. != ''] " />
  <xsl:variable name="v-latest-pbsman" select="if (exists($v-pbsman-pre)) then tokenize(dh:OrderDates(string-join($v-pbsman-pre, '|'), false()), '\|')[1]        else if (exists($v-pbsman-post)) then tokenize(dh:OrderDates(string-join($v-pbsman-post, '|'), true()), '\|')[1]         else '' " />
  <xsl:variable name="v-snomedctau-dates" select="for $i in (1 to count($v-snomedctau)) return substring-after($v-snomedctau[$i], 'http://snomed.info/sct/32506021000036107/version/') " />
  <xsl:variable name="v-earliest-sctau-date" select="if (count($v-snomedctau-dates) &lt; 2)         then $v-snomedctau-dates else substring-before(dh:OrderDates(string-join($v-snomedctau-dates, '|'), true()), '|') " />
  <xsl:variable name="v-snomedctau-pre" select="(for $i in (1 to count($v-snomedctau-dates)) return if ($creation-date - $v-snomedctau-dates[$i] &gt; -1)         then $v-snomedctau-dates[$i] else '')[. != ''] " />
  <xsl:variable name="v-snomedctau-post" select="(for $i in (1 to count($v-snomedctau-dates)) return if ($creation-date - $v-snomedctau-dates[$i] &lt; 0)         then $v-snomedctau-dates[$i] else '')[. != ''] " />
  <xsl:variable name="v-latest-snomedctau" select="if (exists($v-snomedctau-pre))         then concat('http://snomed.info/sct/32506021000036107/version/', tokenize(dh:OrderDates(string-join($v-snomedctau-pre, '|'), false()), '\|')[1])       else if (exists($v-snomedctau-post))         then concat('http://snomed.info/sct/32506021000036107/version/', tokenize(dh:OrderDates(string-join($v-snomedctau-post, '|'), true()), '\|')[1])       else '' " />
  <xsl:variable name="v-sctau-dates" select="if (exists($v-snomedctau-dates)) then tokenize(dh:OrderDates(string-join($v-snomedctau-dates, '|'), false()), '\|') else () " />
  <xsl:variable name="v-current-sctau" select="if (exists($v-sctau-dates)) then concat('http://snomed.info/sct/32506021000036107/version/', $v-sctau-dates[1]) else '' " />
  <xsl:variable name="ts-snomedctau-dates" select="for $i in (1 to count($ts-snomedctau)) return substring-after($ts-snomedctau[$i], 'http://snomed.info/sct/32506021000036107/version/') " />
  <xsl:variable name="ts-earliest-sctau-date" select="if (not(exists($ts-snomedctau-dates))) then ''        else if (count($ts-snomedctau-dates) &lt; 2) then $ts-snomedctau-dates[1]        else substring-before(dh:OrderDates(string-join($ts-snomedctau-dates, '|'), true()), '|') " />
  <xsl:variable name="ts-snomedctau-pre" select="(for $i in (1 to count($ts-snomedctau-dates)) return if ($creation-date - $ts-snomedctau-dates[$i] &gt; -1)         then $ts-snomedctau-dates[$i] else '')[. != ''] " />
  <xsl:variable name="ts-snomedctau-pre-ordered" select="if (exists($ts-snomedctau-pre)) then dh:OrderDates(string-join($ts-snomedctau-pre, '|'), false()) else '' " />
  <xsl:variable name="ts-snomedctau-post" select="(for $i in (1 to count($ts-snomedctau-dates)) return if ($creation-date - $ts-snomedctau-dates[$i] &lt; 0)         then $ts-snomedctau-dates[$i] else '')[. != ''] " />
  <xsl:variable name="ts-snomedctau-post-ordered" select="if (exists($ts-snomedctau-post)) then dh:OrderDates(string-join($ts-snomedctau-post, '|'), true()) else '' " />
  <xsl:variable name="ts-latest-snomedctau" select="if ($ts-snomedctau-pre-ordered != '') then concat('http://snomed.info/sct/32506021000036107/version/', tokenize($ts-snomedctau-pre-ordered, '\|')[1])        else if ($ts-snomedctau-post-ordered != '')         then concat('http://snomed.info/sct/32506021000036107/version/', tokenize($ts-snomedctau-post-ordered, '\|')[1])        else '' " />
  <xsl:variable name="ts-sctau-dates" select="if (exists($ts-snomedctau)) then tokenize(dh:OrderDates(string-join($ts-snomedctau-dates, '|'), false()), '\|') else () " />
  <xsl:variable name="ts-current-sctau" select="if (exists($ts-sctau-dates)) then concat('http://snomed.info/sct/32506021000036107/version/', $ts-sctau-dates[1]) else '' " />
  <xsl:variable name="ts-reqPath-sctau" select="'http://snomed.info/sct/32506021000036107/version/20180131' " />
  <xsl:variable name="ts-latest-loinc" select="if (exists($ts-loinc[1])) then $ts-loinc[1] else '' " />
  <xsl:variable name="ts-pbs-dates" select="if (exists($ts-pbs)) then tokenize(dh:OrderDates($ts-pbs-temp, false()), '\|') else () " />
  <xsl:variable name="ts-latest-pbs" select="if (exists($ts-pbs-dates[1])) then $ts-pbs-dates[1] else '' " />
  <xsl:variable name="ts-pbsman-dates" select="if (exists($ts-pbsman)) then tokenize(dh:OrderDates($ts-pbsman-temp, false()), '\|') else () " />
  <xsl:variable name="ts-latest-pbsman" select="if (exists($ts-pbs-dates[1])) then $ts-pbs-dates[1] else '' " />
  <xsl:variable name="yyyymm-regex" select="'[1-2]{1}[0-9]{3}[0-1]{1}[0-9]{1}'" />
  <xsl:variable name="yyyymmdd-regex" select="'[1-2]{1}[0-9]{3}[0-1]{1}[0-9]{1}[0-3]{1}[0-9]{1}'" />
  <xsl:variable name="amtv2-version-regex" select="'^2\.[0-9]{2}$'" />
  <xsl:variable name="amtv3-version-regex" select="concat('^http://snomed\.info/sct/900062011000036108/version/', $yyyymmdd-regex, '$')" />
  <xsl:variable name="loinc-version-regex" select="'^[1-2]{1}\.[0-9]{2}$'" />
  <xsl:variable name="mbs-version-regex" select="concat('^', $yyyymm-regex, '$')" />
  <xsl:variable name="pbs-version-regex" select="concat('^', $yyyymmdd-regex, '$')" />
  <xsl:variable name="pbsman-version-regex" select="concat('^', $yyyymmdd-regex, '$')" />
  <xsl:variable name="saan-version-regex" select="concat('^', $yyyymmdd-regex, '$')" />
  <xsl:variable name="snomed-version-regex-1" select="concat('^', $yyyymmdd-regex, '$')" />
  <xsl:variable name="snomed-version-regex-2" select="concat('^http://snomed\.info/sct/[0-9]+/version/', $yyyymmdd-regex, '$')" />
  <xsl:variable name="snomedctau-version-regex" select="concat('^http://snomed\.info/sct/32506021000036107/version/', $yyyymmdd-regex, '$')" />
  <xsl:variable name="amtv2-code-regex" select="'^[1-9]{1}[0-9]{5,17}$'" />
  <xsl:variable name="anzsco-code-regex" select="'^[0-9]{6}$'" />
  <xsl:variable name="anzsic-code-regex" select="'^[0-9]{4}$'" />
  <xsl:variable name="loinc-code-regex" select="'(^|^L[AGLP]{1})[0-9]{1,8}\-[0-9]{1}$'" />
  <xsl:variable name="mims-code-regex" select="'^[0-9]{5,}$'" />
  <xsl:variable name="nctis-code-regex" select="'^[0-9]+\.[0-9.]+$'" />
  <xsl:variable name="pbs-code-regex" select="'^[0-9]{5}[A-Z]{1}$'" />
  <xsl:variable name="pbsman-code-regex" select="'^[a-zA-Z]{2}$'" />
  <xsl:variable name="snomed-code-regex" select="'^[1-9]{1}[0-9]{5,17}$'" />
  <xsl:variable name="sctau-concept-id-regex" select="'^[0-9]+[01]0[0-9]$'" />
  <xsl:variable name="sctau-description-id-regex" select="'^[0-9]+[01]1[0-9]$'" />
  <xsl:variable name="sctau-relationship-id-regex" select="'^[0-9]+[01]2[0-9]$'" />
  <xsl:variable name="sctau-acceptable-age" select="90" />
  <xsl:variable name="sctau-base-date" select="xs:date('2015-11-30')" />
  <xsl:variable name="sctau-last" select="if (exists($ts-snomedctau-pre)) then tokenize(dh:OrderDates(string-join($ts-snomedctau-pre, '|'), false()), '\|')[1]         else if (not($creation-date-est)) then $creation-date else '' " />
  <xsl:variable name="sctau-last-yr" select="substring($sctau-last, 1, 4) " />
  <xsl:variable name="sctau-last-mn" select="substring($sctau-last, 5, 2) " />
  <xsl:variable name="sctau-last-dy" select="substring($sctau-last, 7, 2) " />
  <xsl:variable name="sctau-last-xs" select="if ($sctau-last = '') then '' else xs:date(concat($sctau-last-yr, '-', $sctau-last-mn, '-', $sctau-last-dy)) " />
  <xsl:variable name="sctau-versions" select="if ($creation-date-mn-temp = '' or $creation-date-xs = 'error' or $sctau-last = '') then ()        else if (not(matches($sctau-last-xs - $sctau-base-date, '^P[0-9]+D'))) then ()        else if (number(substring-before(substring-after($sctau-last-xs - $sctau-base-date, 'P'), 'D')) &lt; $sctau-acceptable-age) then ()        else distinct-values(/cda:ClinicalDocument//*[@codeSystem='2.16.840.1.113883.6.96' and @codeSystemVersion and         matches(@codeSystemVersion, $snomedctau-version-regex) and         not(@code = $code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/code[@fixed = 'true']/@code)]/@codeSystemVersion) " />
  <xsl:variable name="sctau-timestamp" select="for $i in (1 to count($sctau-versions)) return substring-after($sctau-versions[$i], '/version/') " />
  <xsl:variable name="sctau-timestamp-yr" select="for $i in (1 to count($sctau-timestamp)) return substring($sctau-timestamp[$i], 1, 4)" />
  <xsl:variable name="sctau-timestamp-mn" select="for $i in (1 to count($sctau-timestamp)) return substring($sctau-timestamp[$i], 5, 2)" />
  <xsl:variable name="sctau-timestamp-dy" select="for $i in (1 to count($sctau-timestamp)) return substring($sctau-timestamp[$i], 7, 2)" />
  <xsl:variable name="sctau-timestamp-xs-temp" select="for $i in (1 to count($sctau-timestamp)) return concat($sctau-timestamp-yr[$i], '-', $sctau-timestamp-mn[$i], '-', $sctau-timestamp-dy[$i]) " />
  <xsl:variable name="sctau-timestamp-xs" select="for $i in (1 to count($sctau-timestamp)) return         if ($sctau-timestamp-xs-temp[$i] castable as xs:date) then xs:date($sctau-timestamp-xs-temp[$i]) else '' " />
  <xsl:variable name="sctau-timestamp-cd-1" select="if ($sctau-last-xs = '') then () else for $i in (1 to count($sctau-timestamp)) return         if ($sctau-timestamp-xs[$i] = '') then '' else string($sctau-last-xs - $sctau-timestamp-xs[$i]) " />
  <xsl:variable name="sctau-timestamp-cd-2" select="for $i in (1 to count($sctau-timestamp)) return         if ($sctau-timestamp-cd-1[$i] = '') then ''        else if (matches($sctau-timestamp-cd-1[$i], '^P[0-9]+D')) then substring-before(substring-after($sctau-timestamp-cd-1[$i], 'P'), 'D')        else '' " />
  <xsl:variable name="sctau-timestamp-cd-3" select="for $i in (1 to count($sctau-timestamp)) return         if ($sctau-timestamp-cd-2[$i] = '') then ''        else if ($sctau-timestamp-cd-2[$i] &gt; $sctau-acceptable-age) then $sctau-timestamp-cd-2[$i]        else '' " />
  <xsl:variable name="sctau-versions-old" select="(for $i in (1 to count($sctau-timestamp)) return if ($sctau-timestamp-cd-3[$i] = '') then '' else $sctau-versions[$i])[. != '']" />
  <xsl:variable name="amtv3-acceptable-age" select="$sctau-acceptable-age" />
  <xsl:variable name="amtv3-end-date" select="'20151130'" />
  <xsl:variable name="amtv3-last" select="if ($creation-date - $amtv3-end-date &gt; -1) then $amtv3-end-date else '' " />
  <xsl:variable name="amtv3-last-yr" select="substring($amtv3-last, 1, 4) " />
  <xsl:variable name="amtv3-last-mn" select="substring($amtv3-last, 5, 2) " />
  <xsl:variable name="amtv3-last-dy" select="substring($amtv3-last, 7, 2) " />
  <xsl:variable name="amtv3-last-xs" select="if ($amtv3-last = '') then '' else xs:date(concat($amtv3-last-yr, '-', $amtv3-last-mn, '-', $amtv3-last-dy)) " />
  <xsl:variable name="amtv3-versions" select="if ($creation-date-mn-temp = '' or $creation-date-xs = 'error') then ()        else distinct-values(/cda:ClinicalDocument//*[@codeSystem='2.16.840.1.113883.6.96' and @codeSystemVersion and         matches(@codeSystemVersion, $amtv3-version-regex)]/@codeSystemVersion) " />
  <xsl:variable name="amtv3-timestamp" select="for $i in (1 to count($amtv3-versions)) return substring-after($amtv3-versions[$i], '/version/') " />
  <xsl:variable name="amtv3-timestamp-yr" select="for $i in (1 to count($amtv3-timestamp)) return substring($amtv3-timestamp[$i], 1, 4)" />
  <xsl:variable name="amtv3-timestamp-mn" select="for $i in (1 to count($amtv3-timestamp)) return substring($amtv3-timestamp[$i], 5, 2)" />
  <xsl:variable name="amtv3-timestamp-dy" select="for $i in (1 to count($amtv3-timestamp)) return substring($amtv3-timestamp[$i], 7, 2)" />
  <xsl:variable name="amtv3-timestamp-xs-temp" select="for $i in (1 to count($amtv3-timestamp)) return concat($amtv3-timestamp-yr[$i], '-', $amtv3-timestamp-mn[$i], '-', $amtv3-timestamp-dy[$i]) " />
  <xsl:variable name="amtv3-timestamp-xs" select="for $i in (1 to count($amtv3-timestamp)) return         if ($amtv3-timestamp-xs-temp[$i] castable as xs:date) then xs:date($amtv3-timestamp-xs-temp[$i]) else '' " />
  <xsl:variable name="amtv3-timestamp-cd-1" select="if ($amtv3-last-xs = '') then () else for $i in (1 to count($amtv3-timestamp)) return         if ($amtv3-timestamp-xs[$i] = '') then '' else string($amtv3-last-xs - $amtv3-timestamp-xs[$i]) " />
  <xsl:variable name="amtv3-timestamp-cd-2" select="for $i in (1 to count($amtv3-timestamp)) return         if ($amtv3-timestamp-cd-1[$i] = '') then ''        else if (matches($amtv3-timestamp-cd-1[$i], '^P[0-9]+D')) then substring-before(substring-after($amtv3-timestamp-cd-1[$i], 'P'), 'D')        else '' " />
  <xsl:variable name="amtv3-timestamp-cd-3" select="for $i in (1 to count($amtv3-timestamp)) return         if ($amtv3-timestamp-cd-2[$i] = '') then ''        else if (number($amtv3-timestamp-cd-2[$i] &gt; $amtv3-acceptable-age)) then $amtv3-timestamp-cd-2[$i]        else '' " />
  <xsl:variable name="amtv3-versions-old" select="(for $i in (1 to count($amtv3-timestamp)) return if ($amtv3-timestamp-cd-3[$i] = '') then '' else $amtv3-versions[$i])[. != '']" />
  <xsl:variable name="spia-sctau" select="document('TEMPLATE/VALDN/SPIA-SCTAU.xml', .)/systems" />
  <xsl:variable name="spia-loinc" select="document('TEMPLATE/VALDN/SPIA-LOINC.xml', .)/systems" />
  <xsl:variable name="loinc-rcpa-terms" select="if ($flag-assess-values and '101.20117' = $doc-sections and '102.16144' = $doc-sections)        then (for $concept in $spia-loinc/system/rcpa[@rcpa-terms or @related-terms] return          if ($concept/@rcpa-terms and $concept/@related-terms) then translate(concat($concept/@rcpa-terms, '|', $concept/@related-terms), $chars-no-pipe, '')         else if ($concept/@rcpa-terms and not($concept/@related-terms)) then translate($concept/@rcpa-terms, $chars-no-pipe, '')         else if (not($concept/@rcpa-terms) and $concept/@related-terms) then translate($concept/@related-terms, $chars-no-pipe, '')         else '')[. != '']         else () " />
  <xsl:variable name="alt-refset-name" select="concat(         'Adverse Reaction Agent \(ARA\)~adverse reaction agent~',          'Adverse Reaction Type \(ART\)~adverse reaction type~',         'Body Structure Foundation \(BSF\)~body structure~',         'Change Status \(CS\)~change status~',         'Change Type \(CT\)~change type~',         'Clinical Finding Foundation \(CFF\)~clinical finding~',         'Clinical Manifestation \(CM\)~clinical manifestation~',         'Containered Trade Product Pack \(CTPP\)~containered trade product pack~',         'Laterality \(L\)~laterality~',         'Medication Form \(MF\)~medication form~',         'Medicinal Product \(MP\)~medicinal product~',         'Medicinal Product Pack \(MPP\)~medicinal product pack~',         'Medicinal Product Unit of Use \(MPUU\)~medicinal product unit of use~',         'Problem Diagnosis \(PD\)~problem diagnosis~',         'Procedure Foundation \(PF\)~procedure~',         'Requesting Pathology Terminology \(RPT\)~requesting pathology terminology~',         'Route Of Administration \(ROA\)~route of administration~',         'Substance Foundation \(SF\)~substance~',         'Trade Product \(TP\)~trade product~',         'Trade Product Pack \(TPP\)~trade product pack~',         'Trade Product Unit of Use \(TPUU\)~trade product unit of use') " />
  <xsl:variable name="clinical-info-question" select="concat(' If this is clinical information then confirm by manual inspection if the information in the entry element is present in the narrative. ',        'All clinical information in entry elements must be present in the narrative.')" />
  <xsl:variable name="clinical-info-confirm" select="' Confirm if this is clinical information as all clinical information in entry elements must be present in the narrative.'" />
  <xsl:variable name="assess-body" select="$flag-assess-values and ('102.16144' = $doc-sections or '102.16145' = $doc-sections) " />
  <xsl:variable name="assess-coll" select="$flag-assess-values and '102.16144' = $doc-sections " />
  <xsl:variable name="assess-diag" select="$flag-assess-values and ('101.16117' = $doc-sections or '101.16142' = $doc-sections or '101.16611' = $doc-sections) " />
  <xsl:variable name="assess-form" select="$flag-assess-values and ('102.16210' = $doc-sections or '102.16211' = $doc-sections) " />
  <xsl:variable name="assess-mfst" select="$flag-assess-values and '101.20113' = $doc-sections " />
  <xsl:variable name="assess-modality" select="$flag-assess-values and '102.16145' = $doc-sections " />
  <xsl:variable name="assess-pathTest" select="$flag-assess-values and '102.16144' = $doc-sections " />
  <xsl:variable name="assess-PDType" select="$flag-assess-values and '101.16142' = $doc-sections " />
  <xsl:variable name="assess-proc" select="$flag-assess-values and ('101.16611' = $doc-sections or '101.16117' = $doc-sections or '101.20109' = $doc-sections) " />
  <xsl:variable name="assess-resPath" select="$flag-assess-values and '102.16144' = $doc-sections " />
  <xsl:variable name="assess-route" select="$flag-assess-values and '102.16211' = $doc-sections " />
  <xsl:variable name="assess-specimen" select="$flag-assess-values and '102.16144' = $doc-sections " />
  <xsl:variable name="assess-subs" select="$flag-assess-values and '101.20113' = $doc-sections " />
  <xsl:variable name="assess-tgi" select="$flag-assess-values and (       '101.16146' = $doc-sections   or       '101.16146.4.1.1' = $doc-sections  or        '101.16146.4.1.2' = $doc-sections or       '102.16210' = $doc-sections   or        '102.16211' = $doc-sections   or        '101.16638' = $doc-sections   or        '101.16649' = $doc-sections  or       '101.16658' = $doc-sections   or        '101.16795' = $doc-sections   or        '101.17039' = $doc-sections   ) " />
  <xsl:variable name="inactive-refSets" select="'^900000000000526001 OR ^900000000000527005 OR ^900000000000530003 OR ^900000000000523009 OR ^900000000000528000' " />
  <xsl:variable name="tgi-formula" select="'^929360021000036102 OR ^929360041000036105 OR ^929360031000036100 OR ^929360051000036108 OR ^929360061000036106 OR ^929360081000036101 OR ^929360071000036103'" />
  <xsl:variable name="defn-body-trusted" select="if (not($assess-body)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/body/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/body/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/body/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-coll-trusted" select="if (not($assess-coll)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/coll/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/coll/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/coll/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-diag-trusted" select="if (not($assess-diag)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/diag/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/diag/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/diag/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-form-trusted" select="if (not($assess-form)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/form/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/form/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/form/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-immun-trusted" select="if (not($flag-assess-values and ('101.16638' = $doc-sections or '101.16658' = $doc-sections or '101.17039' = $doc-sections))) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/immun/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/immun/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/immun/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-meds-trusted" select="if (not($flag-assess-values and ('101.16146' = $doc-sections or '101.16146.4.1.1' = $doc-sections or '101.16146.4.1.2' = $doc-sections))) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/meds/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/meds/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/meds/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-mfst-trusted" select="if (not($assess-mfst)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/mfst/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/mfst/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/mfst/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-modality-trusted" select="if (not($assess-modality)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/modality/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/modality/@core, '\s+', ''), '\|'),          tokenize(replace($cd-definitions/modality/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-pathTest-trusted" select="if (not($assess-pathTest)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/pathTest/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/pathTest/@core, '\s+', ''), '\|'),          tokenize(replace($cd-definitions/pathTest/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-pd-trusted" select="if (not($flag-assess-values and ('102.16210' = $doc-sections or '102.16211' = $doc-sections or '101.16795' = $doc-sections))) then ()         else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/pd/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/pd/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/pd/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-PDType-trusted" select="if (not($assess-PDType)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/PDType/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/PDType/@core, '\s+', ''), '\|'),          tokenize(replace($cd-definitions/PDType/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-proc-trusted" select="if (not($assess-proc)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/proc/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/proc/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/proc/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-resPath-trusted" select="if (not($assess-resPath)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/resPath/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/resPath/@core, '\s+', ''), '\|'),          tokenize(replace($cd-definitions/resPath/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-route-trusted" select="if (not($assess-route)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/route/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/route/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/route/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-shs-meds-trusted" select="if (not($flag-assess-values and '101.16146' = $doc-sections)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/shs-meds/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/shs-meds/@core, '\s+', ''), '\|'),          tokenize(replace($cd-definitions/shs-meds/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-specimen-trusted" select="if (not($assess-specimen)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/specimen/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/specimen/@core, '\s+', ''), '\|'),          tokenize(replace($cd-definitions/specimen/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="defn-subs-trusted" select="if (not($assess-subs)) then () else if ($flags/@report-terminology-concepts = 'true')        then tokenize(replace($cd-definitions/subs/@core, '\s+', ''), '\|')[. != '']        else(tokenize(replace($cd-definitions/subs/@core, '\s+', ''), '\|'), tokenize(replace($cd-definitions/subs/@extra, '\s+', ''), '\|'))[. != ''] " />
  <xsl:variable name="body-typo" select="if ($assess-body and $knowledge/body-replacements/typo)         then string-join(for $x in $knowledge/body-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="coll-typo" select="if ($assess-coll and $knowledge/coll-replacements/typo)         then string-join(for $x in $knowledge/coll-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="diag-typo" select="if ($assess-diag and $knowledge/diag-replacements/typo)         then string-join(for $x in $knowledge/diag-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="form-typo" select="if ($assess-diag or $assess-proc or $assess-subs or $assess-tgi or $assess-form) then string-join((         for $x in $knowledge/form-replacements/typo return concat($x/@pattern, '~', $x/@replacement),         (for $x in $knowledge/dose-forms/dose-form return if ($x/@typo) then concat('(^|[^a-z])(', $x/@typo, ')([^a-z]|$)~$1 ', $x/@name, ' $3') else '')[ . != ''],         (for $x in $knowledge/dose-forms/prop-dose-form return if ($x/@typo) then concat('(^|[^a-z])(', $x/@typo, ')([^a-z]|$)$1 ~', $x/@proprietary, ' $3') else '')[ . != '']), '~')         else '' " />
  <xsl:variable name="mfst-typo" select="if ($assess-mfst and $knowledge/mfst-replacements/typo)         then string-join(for $x in $knowledge/mfst-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="modality-typo" select="if ($assess-modality and $knowledge/modality-replacements/typo)         then string-join(for $x in $knowledge/modality-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="pathTest-typo" select="if ($assess-pathTest and $knowledge/pathTest-replacements/typo)         then string-join(for $x in $knowledge/pathTest-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="PDType-typo" select="if ($assess-PDType and $knowledge/PDType-replacements/typo)         then string-join(for $x in $knowledge/PDType-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="proc-typo" select="if ($assess-proc and $knowledge/proc-replacements/typo)         then string-join(for $x in $knowledge/proc-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="resPath-typo" select="if ($assess-resPath and $knowledge/resPath-replacements/typo)         then string-join(for $x in $knowledge/resPath-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="route-typo" select="if ($assess-route and $knowledge/route-replacements/typo)         then string-join(for $x in $knowledge/route-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="specimen-typo" select="if ($assess-specimen and $knowledge/specimen-replacements/typo)         then string-join(for $x in $knowledge/specimen-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="subs-typo" select="if ($assess-subs and $knowledge/subs-replacements/typo)         then string-join(for $x in $knowledge/subs-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="tgi-typo" select="if (($assess-diag or $assess-proc or $assess-subs or $assess-tgi) and $knowledge/tgi-replacements/typo)        then string-join(for $x in $knowledge/tgi-replacements/typo return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="body-replacements" select="if ($assess-body and $knowledge/body-replacements/replace)         then string-join(for $x in $knowledge/body-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="coll-replacements" select="if ($assess-coll and $knowledge/coll-replacements/replace)         then string-join(for $x in $knowledge/coll-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="diag-replacements" select="if ($assess-diag and $knowledge/diag-replacements/replace)         then string-join(for $x in $knowledge/diag-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="diag-sec-replacements" select="if ($assess-diag and $knowledge/diag-replacements/sec-replace)         then string-join(for $x in $knowledge/diag-replacements/sec-replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="form-replacements" select="if ($assess-form and $knowledge/form-replacements/replace)         then string-join(for $x in $knowledge/form-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="mfst-replacements" select="if ($assess-mfst and $knowledge/mfst-replacements/replace)         then string-join(for $x in $knowledge/mfst-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="modality-replacements" select="if ($assess-modality and $knowledge/modality-replacements/replace)         then string-join(for $x in $knowledge/modality-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="pathTest-replacements" select="if ($assess-pathTest and $knowledge/pathTest-replacements/replace)         then string-join(for $x in $knowledge/pathTest-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="pathTest-sec-replacements" select="if ($assess-pathTest and $knowledge/pathTest-replacements/sec-replace)         then string-join(for $x in $knowledge/pathTest-replacements/sec-replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="PDType-replacements" select="if ($assess-PDType and $knowledge/PDType-replacements/replace)         then string-join(for $x in $knowledge/PDType-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="proc-replacements" select="if ($assess-proc and $knowledge/proc-replacements/replace)         then string-join(for $x in $knowledge/proc-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="proc-sec-replacements" select="if ($assess-proc and $knowledge/proc-replacements/sec-replace)         then string-join(for $x in $knowledge/proc-replacements/sec-replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="resPath-replacements" select="if ($assess-resPath and $knowledge/resPath-replacements/replace)         then string-join(for $x in $knowledge/resPath-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="route-replacements" select="if ($assess-route and $knowledge/route-replacements/replace)         then string-join(for $x in $knowledge/route-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="specimen-replacements" select="if ($assess-specimen and $knowledge/specimen-replacements/replace)         then string-join(for $x in $knowledge/specimen-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="subs-replacements" select="if ($assess-subs and $knowledge/subs-replacements/replace)         then string-join(for $x in $knowledge/subs-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="tgi-replacements" select="if (($assess-diag or $assess-proc or $assess-subs or $assess-tgi) and $knowledge/tgi-replacements/replace)         then string-join(for $x in $knowledge/tgi-replacements/replace return concat($x/@pattern, '~', $x/@replacement), '~') else '' " />
  <xsl:variable name="unicode-br-truncation-regex" select="concat('^([^a-z]*?[a-z]+.*?)', $ulist-item-regex, '(.+)$')" />
  <xsl:variable name="diag-proc-truncation-regex" select="'^([^a-z]*?[a-z]+.*?)(being a service to which item|not being a service|with or without|secondary to)(.+)$'" />
  <xsl:variable name="tgi-truncation-regex" select="'^([^a-z]*?[a-z]+.*?)(as per)(.+)$'" />
  <xsl:variable name="default-char-regex" select="'[^ a-z0-9\-/\[\]\(\)]'" />
  <xsl:variable name="body-char-regex" select="$default-char-regex" />
  <xsl:variable name="coll-char-regex" select="$default-char-regex" />
  <xsl:variable name="diag-proc-char-regex" select="'[^ ''a-z0-9\-/\[\]\(\)]'" />
  <xsl:variable name="form-char-regex" select="$default-char-regex" />
  <xsl:variable name="mfst-char-regex" select="$default-char-regex" />
  <xsl:variable name="modality-char-regex" select="$default-char-regex" />
  <xsl:variable name="pathTest-char-regex" select="$default-char-regex" />
  <xsl:variable name="PDType-char-regex" select="$default-char-regex" />
  <xsl:variable name="resPath-char-regex" select="'[^ a-z0-9\.\-/\[\]\(\)]'" />
  <xsl:variable name="route-char-regex" select="$default-char-regex" />
  <xsl:variable name="specimen-char-regex" select="$default-char-regex" />
  <xsl:variable name="subs-char-regex" select="concat('[^ ', $ucum-chars, ']')" />
  <xsl:variable name="tgi-char-regex" select="concat('[^ ', $ucum-chars, ']')" />
  <xsl:variable name="body-qualifier-regex-1" select="if (not($assess-body)) then () else if ($knowledge/qualifiers/body/@value)         then tokenize(dh:OrderByLength(string-join($knowledge/qualifiers/body/@value, '|'), false()), '\|')        else () " />
  <xsl:variable name="body-qualifier-regex" select="if (not($assess-body)) then '' else if (exists($body-qualifier-regex-1))         then string-join(for $qual in $body-qualifier-regex-1 return concat('(^|[^a-z0-9])', $qual, '([^a-z0-9]|$)~$1 $2'), '~')         else '' " />
  <xsl:variable name="tgi-abbr-latin-regex-1" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then () else tokenize(dh:OrderByLength(string-join((                  $knowledge/qualifiers/abbreviation/@regex,                  $knowledge/qualifiers/latin/@value                  ), '|'), false()), '\|') " />
  <xsl:variable name="tgi-abbr-latin-regex" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join(for $qual in $tgi-abbr-latin-regex-1 return concat('(^|[^a-z0-9])', $qual, '([^a-z0-9]|$)~$1 $2'), '~') " />
  <xsl:variable name="tgi-qualifier-regex-1" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ()         else tokenize(dh:OrderByLength(string-join((                  $numbers/number/@name,                   $knowledge/qualifiers/other/@value,                  $knowledge/qualifiers/other/@plural,                  $knowledge/qualifiers/other/@typo                  ), '|'), false()), '\|') " />
  <xsl:variable name="tgi-qualifier-regex" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join(for $qual in $tgi-qualifier-regex-1 return concat('(^|[^a-z0-9])', $qual, '([^a-z0-9]|$)~$1 $2'), '~') " />
  <xsl:variable name="prop-dose-form-p-regex" select="if (not($assess-form or $assess-subs or $assess-tgi)) then '' else string-join((for $form in $knowledge/dose-forms/prop-dose-form return if ($form/@plural)         then concat('(^|[^a-z])', $form/@plural, '([^a-z]|$)~$1 ', $form/@proprietary, ' $2') else '')[. != ''], '~')" />
  <xsl:variable name="prop-dose-form-s-regex" select="if (not($assess-form or $assess-subs or $assess-tgi)) then '' else string-join((for $form in $knowledge/dose-forms/prop-dose-form return if ($form/@synonyms)         then concat('(^|[^a-z])(', $form/@synonyms, ')([^a-z]|$)~$1 ', $form/@proprietary, ' $3') else '')[. != ''], '~')" />
  <xsl:variable name="dose-form-p-regex" select="if (not($assess-form or $assess-subs or $assess-tgi)) then '' else string-join((for $form in $knowledge/dose-forms/dose-form return if ($form/@plural)         then concat('(^|[^a-z])', $form/@plural, '([^a-z]|$)~$1 ', $form/@name, ' $2') else '')[. != ''], '~')" />
  <xsl:variable name="dose-form-s-regex" select="if (not($assess-form or $assess-subs or $assess-tgi)) then '' else string-join((for $form in $knowledge/dose-forms/dose-form return if ($form/@synonyms)         then concat('(^|[^a-z])(', $form/@synonyms, ')([^a-z]|$)~$1 ', $form/@name, ' $3') else '')[. != ''], '~')" />
  <xsl:variable name="dose-form-names" select="if (not($assess-form or $assess-subs or $assess-tgi)) then () else tokenize(lower-case(dh:OrderByLength(string-join(distinct-values((                 $knowledge/dose-forms/prop-dose-form/@proprietary,                  $knowledge/dose-forms/prop-dose-form/@preferred,                   $knowledge/dose-forms/prop-dose-form/@synonyms,                  $knowledge/dose-forms/prop-dose-form/@typo,                 $knowledge/dose-forms/dose-form/@name,                 $knowledge/dose-forms/dose-form/@plural,                 $knowledge/dose-forms/dose-form/@synonyms,                 $knowledge/dose-forms/dose-form/@typo           )), '|'), false())), '\|') " />
  <xsl:variable name="dose-form-regex-seq" select="if (not($assess-form or $assess-subs or $assess-tgi)) then () else for $form in $dose-form-names return concat('(^|[^a-z])(', $form, ')([^a-z]|$)')" />
  <xsl:variable name="dose-form-rem-regex" select="if (not($assess-form or $assess-subs or $assess-tgi)) then '' else string-join(for $form in $dose-form-regex-seq return concat($form, '~$1 $3'), '~')" />
  <xsl:variable name="dose-form-name-regex" select="if (not($assess-form or $assess-subs or $assess-tgi)) then '' else concat('(', string-join($dose-form-regex-seq, ')|('), ')') " />
  <xsl:variable name="dose-form-replacement" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join((        for $x in $knowledge/dose-forms/dose-form return if ($x/@typo) then concat('(^|[^a-z])(', $x/@typo, ')([^a-z]|$)~$1 ', $x/@name, ' $3') else '',        for $x in $knowledge/dose-forms/dose-form return if ($x/@synonyms) then concat('(^|[^a-z])(', $x/@synonyms, ')([^a-z]|$)~$1 ', $x/@name, ' $3') else '',        for $x in $knowledge/dose-forms/dose-form return if ($x/@drops) then concat('(^|[^a-z])(', $x/@drops, ')([^a-z]|$)~$1 ', $x/@name, ' $3') else '',        for $x in $knowledge/dose-forms/prop-dose-form return if ($x/@typo) then concat('(^|[^a-z])(', $x/@typo, ')([^a-z]|$)~$1 ', $x/@proprietary, ' $3') else '',        for $x in $knowledge/dose-forms/prop-dose-form return if ($x/@synonyms) then concat('(^|[^a-z])(', $x/@synonyms, ')([^a-z]|$)~$1 ', $x/@proprietary, ' $3') else '',        for $x in $knowledge/dose-forms/prop-dose-form return if ($x/@drops) then concat('(^|[^a-z])(', $x/@drops, ')([^a-z]|$)~$1 ', $x/@proprietary, ' $3') else ''        )[. != ''], '~') " />
  <xsl:variable name="tgi-container-replacement" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join(distinct-values((         for $x in $knowledge/container-types/container-type return if ($x/@typo) then concat('(^|[^a-z])(', $x/@typo, ')([^a-z]|$)~$1 ', $x/@preferred, ' $3') else '',         for $x in $knowledge/container-types/container-type return if ($x/@proprietary) then concat('(^|[^a-z])(', $x/@proprietary, ')([^a-z]|$)~$1 ', $x/@preferred, ' $3') else '',         for $x in $knowledge/container-types/container-type return if ($x/@synonyms) then concat('(^|[^a-z])(', $x/@synonyms, ')([^a-z]|$)~$1 ', $x/@preferred, ' $3') else '',         for $x in $knowledge/container-types/container-type return if ($x/@plural) then concat('(^|[^a-z])(', $x/@plural, ')([^a-z]|$)~$1 ', $x/@preferred, ' $3') else ''        )[. != '']), '~') " />
  <xsl:variable name="tgi-container-names" select="if (not($assess-form or $assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ()         else tokenize(lower-case(dh:OrderByLength(string-join(distinct-values($knowledge/container-types/container-type/@preferred), '|'), false())), '\|') " />
  <xsl:variable name="tgi-container-regex-seq" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ()         else for $container in $tgi-container-names return concat('(^|[^a-z])(', replace($container, '\-', '\\-'), ')([^a-z]|$)')" />
  <xsl:variable name="tgi-container-rem-regex" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join(for $container in $tgi-container-regex-seq return concat($container, '~$1 $3'), '~')" />
  <xsl:variable name="tgi-sas-names" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join(distinct-values((                 $knowledge/special-tgi/sas/@name,                 $knowledge/special-tgi/sas/@synonyms,                 $knowledge/special-tgi/sas/@typo           ))[. != ''], '|') " />
  <xsl:variable name="tgi-sas-regex" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else if ($tgi-sas-names = '') then '' else concat('^\W*(', dh:XQueryRecursiveReplace($tgi-sas-names, $meta-pattern, ''), ')\W*$') " />
  <xsl:variable name="tgi-otheru-names" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join(distinct-values((                 $knowledge/special-tgi/other-uncoded/@name,                 $knowledge/special-tgi/other-uncoded/@synonyms,                 $knowledge/special-tgi/other-uncoded/@typo           ))[. != ''], '|') " />
  <xsl:variable name="tgi-otheru-regex" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else if ($tgi-otheru-names = '') then '' else concat('^\W*(', dh:XQueryRecursiveReplace($tgi-otheru-names, $meta-pattern, ''), ')\W*$') " />
  <xsl:variable name="tgi-obsolete-names" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else string-join(distinct-values(($knowledge/special-tgi/obsolete/@name))[. != ''], '|') " />
  <xsl:variable name="tgi-obsolete-regex" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''         else if ($tgi-obsolete-names = '') then '' else concat('^\W*(', dh:XQueryRecursiveReplace($tgi-obsolete-names, $meta-pattern, ''), ')\W*$') " />
  <xsl:variable name="qualifier-regex-1" select="if (not($assess-diag or $assess-proc)) then ()         else if ($knowledge/qualifiers/other/@value)         then tokenize(dh:OrderByLength(string-join((                 $knowledge/qualifiers/other/@value,                      $knowledge/qualifiers/other/@plural,                        $knowledge/qualifiers/other/@typo                 ), '|'), false()), '\|')        else () " />
  <xsl:variable name="qualifier-regex" select="if (not($assess-diag or $assess-proc)) then ()         else if (exists($qualifier-regex-1))         then concat(string-join(for $qual in $qualifier-regex-1 return concat('(^|[^a-z0-9])', $qual, '([^a-z0-9]|$)~$1 $2'), '~'),          '~([0-9a-z]+)\s+secondary\s+to\s+[ 0-9a-z]+$~$1')        else '([0-9a-z]+)\s+secondary\s+to\s+[ 0-9a-z]+$~$1' " />
  <xsl:variable name="no-qual-pattern-1" select="if (not($assess-diag or $assess-proc)) then ''         else if ($qualifier-regex = '') then '[0-9]+\W*x\W+~ ~\(.*?\)~ ~\([^\)]*$~ ~\[.*?\]~ ~'         else concat('[0-9]+\W*x\W+~ ~\(.*?\)~ ~\([^\)]*$~ ~\[.*?\]~ ~', $qualifier-regex) " />
  <xsl:variable name="no-qual-pattern" select="if (not($assess-diag or $assess-proc)) then ''         else if ($tgi-abbr-latin-regex = '') then $no-qual-pattern-1 else concat($no-qual-pattern-1, '~', $tgi-abbr-latin-regex) " />
  <xsl:variable name="tgi-regex-1" select="if (not($assess-subs or $assess-tgi)) then '' else if ($tgi-replacements = '') then '' else $tgi-replacements " />
  <xsl:variable name="tgi-regex-2" select="if (not($assess-subs or $assess-tgi)) then '' else if ($dose-form-p-regex = '') then $tgi-regex-1        else if ($tgi-regex-1 = '') then $dose-form-p-regex        else concat($tgi-regex-1, '~', $dose-form-p-regex) " />
  <xsl:variable name="tgi-regex-3" select="if (not($assess-subs or $assess-tgi)) then '' else if ($dose-form-s-regex = '') then $tgi-regex-2        else if ($tgi-regex-2 = '') then $dose-form-s-regex        else concat($tgi-regex-2, '~', $dose-form-s-regex) " />
  <xsl:variable name="tgi-regex-4" select="if (not($assess-subs or $assess-tgi)) then '' else if ($prop-dose-form-p-regex = '') then $tgi-regex-3        else if ($tgi-regex-3 = '') then $prop-dose-form-p-regex        else concat($tgi-regex-3, '~', $prop-dose-form-p-regex) " />
  <xsl:variable name="tgi-regex-5" select="if (not($assess-subs or $assess-tgi)) then '' else if ($prop-dose-form-s-regex = '') then $tgi-regex-4        else if ($tgi-regex-4 = '') then $prop-dose-form-s-regex        else concat($tgi-regex-4, '~', $prop-dose-form-s-regex) " />
  <xsl:variable name="tgi-regex" select="if (not($assess-subs or $assess-tgi)) then '' else if ($tgi-abbr-latin-regex = '') then $tgi-regex-5        else if ($tgi-regex-5 = '') then $tgi-abbr-latin-regex        else concat($tgi-regex-5, '~', $tgi-abbr-latin-regex) " />
  <xsl:variable name="subs-regex" select="if (not($assess-subs)) then '' else if ($subs-replacements = '') then $tgi-regex        else if ($tgi-regex = '') then $subs-replacements        else concat($tgi-regex, '~', $subs-replacements) " />
  <xsl:variable name="date-replacements" select="concat('(^|[^0-9])[0-9]{1,2}/{1}[0-9]{1,2}/{1}[1-2]{1}[0-9]{3}([^0-9]|$)~$1 $2~',         '(^|[^0-9])[0-9]{1,2}/{1}[0-9]{1,2}/{1}[0-9]{2}([^0-9]|$)~$1 $2~',         '[0-9]{1,2}/{1}[1-2]{1}[0-9]{3}([^0-9]|$)~$1 $2~',         '[0-9]{1,2}/{1}[0-9]{2}([^0-9]|$)~$1 $2~',         '(^|[^0-9])[1-2]{1}[0-9]{3}([^0-9]|$)~$1 $2') " />
  <xsl:variable name="month-replacements" select="string-join(for $x in $knowledge/months/month return concat('(^|[^a-z])', $x/@full, '([^a-z]|$)~ ~(^|[^a-z])', $x/@abbreviation, '([^a-z]|$)~ '), '~') " />
  <xsl:variable name="basic-pattern-replacement" select="'([1-9]{1}[0-9]{0,2}),([0-9]{3})~$1 $2~\((s|of|in)\)~~[,;]~ ~([a-z0-9])([\+\[\(])([a-z0-9])~$1 $2$3~([a-z0-9])([\]\)])([a-z0-9])~$1$2 $3~ - ~ ~[0-9]{10,}~ '" />
  <xsl:variable name="body-fir-1" select="if (not($assess-body)) then '' else concat($basic-pattern-replacement, '~', $body-char-regex, '~ ')" />
  <xsl:variable name="body-fir-pattern-replacement" select="if (not($assess-body)) then '' else if ($body-typo = '') then $body-fir-1 else concat($body-fir-1, '~', $body-typo) " />
  <xsl:variable name="coll-fir-1" select="if (not($assess-coll)) then '' else concat($basic-pattern-replacement, '~', $coll-char-regex, '~ ')" />
  <xsl:variable name="coll-fir-pattern-replacement" select="if (not($assess-coll)) then '' else if ($coll-typo = '') then $coll-fir-1 else concat($coll-fir-1, '~', $coll-typo)" />
  <xsl:variable name="diag-proc-fir-1" select="if (not($assess-diag or $assess-proc)) then '' else concat($basic-pattern-replacement, '~', $diag-proc-char-regex, '~ ~', $date-replacements)" />
  <xsl:variable name="form-fir-1" select="if (not($assess-form)) then '' else concat($basic-pattern-replacement, '~', $form-char-regex, '~ ')" />
  <xsl:variable name="form-fir-pattern-replacement" select="if (not($assess-form)) then '' else if ($form-typo = '') then $form-fir-1 else concat($form-fir-1, '~', $form-typo)" />
  <xsl:variable name="mfst-fir-1" select="if (not($assess-mfst)) then '' else concat($basic-pattern-replacement, '~', $mfst-char-regex, '~ ')" />
  <xsl:variable name="mfst-fir-pattern-replacement" select="if (not($assess-mfst)) then '' else if ($mfst-typo = '') then $mfst-fir-1 else concat($mfst-fir-1, '~', $mfst-typo)" />
  <xsl:variable name="modality-fir-1" select="if (not($assess-modality)) then '' else concat($basic-pattern-replacement, '~', $modality-char-regex, '~ ')" />
  <xsl:variable name="modality-fir-pattern-replacement" select="if (not($assess-modality)) then '' else if ($modality-typo = '') then $modality-fir-1 else concat($modality-fir-1, '~', $modality-typo)" />
  <xsl:variable name="pathTest-fir-1" select="if (not($assess-pathTest)) then '' else concat($basic-pattern-replacement, '~', $pathTest-char-regex, '~ ')" />
  <xsl:variable name="pathTest-fir-pattern-replacement" select="if (not($assess-pathTest)) then '' else if ($pathTest-typo = '') then $pathTest-fir-1 else concat($pathTest-fir-1, '~', $pathTest-typo)" />
  <xsl:variable name="PDType-fir-1" select="if (not($assess-PDType)) then '' else concat($basic-pattern-replacement, '~', $PDType-char-regex, '~ ')" />
  <xsl:variable name="PDType-fir-pattern-replacement" select="if (not($assess-PDType)) then '' else if ($PDType-typo = '') then $PDType-fir-1 else concat($PDType-fir-1, '~', $PDType-typo)" />
  <xsl:variable name="resPath-fir-1" select="if (not($assess-resPath)) then '' else concat($basic-pattern-replacement, '~', $resPath-char-regex, '~ ')" />
  <xsl:variable name="resPath-fir-pattern-replacement" select="if (not($assess-resPath)) then '' else if ($resPath-typo = '') then $resPath-fir-1 else concat($resPath-fir-1, '~', $resPath-typo)" />
  <xsl:variable name="route-fir-1" select="if (not($assess-route)) then '' else concat($basic-pattern-replacement, '~', $route-char-regex, '~ ')" />
  <xsl:variable name="route-fir-pattern-replacement" select="if (not($assess-route)) then '' else if ($route-typo = '') then $route-fir-1 else concat($route-fir-1, '~', $route-typo)" />
  <xsl:variable name="specimen-fir-1" select="if (not($assess-specimen)) then '' else concat($basic-pattern-replacement, '~', $specimen-char-regex, '~ ')" />
  <xsl:variable name="specimen-fir-pattern-replacement" select="if (not($assess-specimen)) then '' else if ($specimen-typo = '') then $specimen-fir-1 else concat($specimen-fir-1, '~', $specimen-typo)" />
  <xsl:variable name="subs-fir-1" select="if (not($assess-subs)) then '' else concat($basic-pattern-replacement, '~', $subs-char-regex, '~ ')" />
  <xsl:variable name="subs-fir-pattern-replacement" select="if (not($assess-subs)) then '' else if ($subs-typo = '') then $subs-fir-1 else concat($subs-fir-1, '~', $subs-typo)" />
  <xsl:variable name="tgi-fir-1" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''           else concat('([^a-z])(strength\s*:)([^a-z])~$1 $3~', $basic-pattern-replacement, '~', $tgi-char-regex, '~ ')" />
  <xsl:variable name="tgi-fir-2" select="if ($tgi-fir-1 = '' or $tgi-container-replacement = '') then $tgi-fir-1 else concat($tgi-fir-1, '~', $tgi-container-replacement)" />
  <xsl:variable name="tgi-fir-3" select="if ($tgi-fir-2 = '' or $dose-form-replacement = '') then $tgi-fir-2 else concat($tgi-fir-2, '~', $dose-form-replacement)" />
  <xsl:variable name="tgi-fir-pattern-replacement" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''           else if ($tgi-typo = '') then $tgi-fir-3 else concat($tgi-fir-3, '~', $tgi-typo)" />
  <xsl:variable name="tgi-sec-pattern-replacement-1" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then '' else concat(              '([0-9])([a-z])~$1 $2~',                 '([a-z])([0-9])~$1 $2~',                   '\(.*\)~ ~',                     '\([^\)]*$~ ~',                   '\[.*\]~ ~',              '[\-,;:/]~ ~',              '(^|[^0-9])\.([^0-9]|$)~$1 $2~',              '(^|[^a-z])[exioqyz]{1}([^a-z]|$)~$1 $2') " />
  <xsl:variable name="tgi-sec-pattern-replacement" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then ''           else if ($tgi-qualifier-regex = '') then $tgi-sec-pattern-replacement-1 else concat($tgi-sec-pattern-replacement-1, '~', $tgi-qualifier-regex) " />
  <xsl:variable name="tgi-thi-pattern-replacement" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then '' else concat(         $dose-form-rem-regex, '~',     $tgi-container-rem-regex, '~',         '(^|[^a-z])g([^a-z]|$)~$1 $2~',    '(^|[^a-z])(gram|grams)([^a-z]|$)~$1 $3~',         '(^|[^a-z])hr([^a-z]|$)~$1 $2~',   '(^|[^a-z])(hour|hours)([^a-z]|$)~$1 $3~',         '(^|[^a-z])IU([^a-z]|$)~$1 $2~',         '(^|[^a-z])L([^a-z]|$)~$1 $2~',    '(^|[^a-z])(litre|litres)([^a-z]|$)~$1 $3~',         '(^|[^a-z])mcg([^a-z]|$)~$1 $2~',   '(^|[^a-z])(microgram|micrograms)([^a-z]|$)~$1 $3~',         '(^|[^a-z])mg([^a-z]|$)~$1 $2~',   '(^|[^a-z])(milligram|milligrams)([^a-z]|$)~$1 $3~',         '(^|[^a-z])mLs{0,1}([^a-z]|$)~$1 $2~',   '(^|[^a-z])(millilitre|millilitres)([^a-z]|$)~$1 $3~',         '(^|[^a-z])mmol([^a-z]|$)~$1 $2~',   '(^|[^a-z])(millimole|millimoles)([^a-z]|$)~$1 $3~',         '(^|[^a-z])umol([^a-z]|$)~$1 $2~',   '(^|[^a-z])(micromole|micromoles)([^a-z]|$)~$1 $3~',         '(^|[^0-9a-z])[0-9%\-\., /]+([^0-9a-z]|$)~$1 $2~',  '(^|[^a-z])[a-z]{1}([^a-z]|$)~$1 $2~',             '/~ '                ) " />
  <xsl:variable name="body-invalid-hierarchy" select="if (not($assess-body)) then '' else if (exists($cd-definitions/body/body-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/body/body-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="coll-invalid-hierarchy" select="if (not($assess-coll)) then '' else if (exists($cd-definitions/coll/coll-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/coll/coll-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="diag-invalid-hierarchy" select="if (not($assess-diag)) then '' else if (exists($cd-definitions/diag/diag-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/diag/diag-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="diag-invalid-refset" select="if (not($assess-diag)) then '' else if (exists($cd-definitions/diag/diag-invalid/refset))         then concat('(', string-join(for $refset in $cd-definitions/diag/diag-invalid/refset return concat('^', $refset/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="diag-invalid-inactive-refset" select="if (not($assess-diag)) then '' else if (exists($cd-definitions/diag/diag-invalid/inactive-refset))         then concat('(', string-join(for $refset in $cd-definitions/diag/diag-invalid/inactive-refset return concat('^', $refset/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="diag-proc-invalid-hierarchy" select="if (not($assess-diag or $assess-proc)) then '' else if (exists($cd-definitions/diag-proc/diag-proc-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/diag-proc/diag-proc-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="diag-proc-invalid-refset" select="if (not($assess-diag or $assess-proc)) then '' else if (exists($cd-definitions/diag-proc/diag-proc-invalid/refset))         then concat('(', string-join(for $refset in $cd-definitions/diag-proc/diag-proc-invalid/refset return concat('^', $refset/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="diag-proc-invalid-inactive-refset" select="if (not($assess-diag or $assess-proc)) then '' else if (exists($cd-definitions/diag-proc/diag-proc-invalid/inactive-refset))         then concat('(', string-join(for $refset in $cd-definitions/diag-proc/diag-proc-invalid/inactive-refset return concat('^', $refset/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="form-invalid-hierarchy" select="if (not($assess-form)) then '' else if (exists($cd-definitions/form/form-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/form/form-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="meds-invalid-hierarchy" select="if (not($assess-tgi)) then '' else if (exists($cd-definitions/meds/meds-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/meds/meds-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="mfst-invalid-hierarchy" select="if (not($assess-mfst)) then '' else if (exists($cd-definitions/mfst/mfst-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/mfst/mfst-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="modality-invalid-hierarchy" select="if (not($assess-modality)) then '' else if (exists($cd-definitions/modality/modality-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/modality/modality-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="pathTest-invalid-hierarchy" select="if (not($assess-pathTest)) then '' else if (exists($cd-definitions/pathTest/pathTest-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/pathTest/pathTest-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="PDType-invalid-hierarchy" select=" '' " />
  <xsl:variable name="proc-invalid-hierarchy" select="if (not($assess-proc)) then '' else if (exists($cd-definitions/proc/proc-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/proc/proc-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="proc-invalid-refset" select="if (not($assess-proc)) then '' else if (exists($cd-definitions/proc/proc-invalid/refset))         then concat('(', string-join(for $refset in $cd-definitions/proc/proc-invalid/refset return concat('^', $refset/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="proc-invalid-inactive-refset" select="if (not($assess-proc)) then '' else if (exists($cd-definitions/proc/proc-invalid/inactive-refset))         then concat('(', string-join(for $refset in $cd-definitions/proc/proc-invalid/inactive-refset return concat('^', $refset/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="route-invalid-hierarchy" select="if (not($assess-route)) then '' else if (exists($cd-definitions/route/route-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/route/route-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="specimen-invalid-hierarchy" select="if (not($assess-specimen)) then '' else if (exists($cd-definitions/specimen/specimen-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/specimen/specimen-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="subs-invalid-hierarchy" select="if (not($assess-subs)) then '' else if (exists($cd-definitions/subs/subs-invalid/hierarchy))         then concat('(', string-join(for $hierarchy in $cd-definitions/subs/subs-invalid/hierarchy return          concat('&gt;&gt;', $hierarchy/@code, ' OR &lt;', $hierarchy/@code), ' OR '), ')')        else '' " />
  <xsl:variable name="laterality-regex" select=" '(^|[^a-z])(bilateral|left and right|right and left|left sided?|left|lh|lt|l|right sided?|right|rh|rt|r)([^a-z]|$)' " />
  <xsl:variable name="vaccine-codes" select="if (not($assess-diag or $assess-proc or $assess-subs or $assess-tgi)) then () else $code-systems/system[@codeSystem = '1.2.36.1.2001.1005.17']/code" />
  <xsl:variable name="vaccine-text" select="($vaccine-codes/@displayName,         tokenize(string-join(($vaccine-codes/@disease, $vaccine-codes/@synonyms, $vaccine-codes/@related-terms), '|'), '\|'))[. != '']" />
  <xsl:variable name="vaccine-text-normalised" select="for $vaccine in $vaccine-text return translate(normalize-space(lower-case($vaccine)), $chars-to-remove, '')" />
  <xsl:variable name="acp-regex" select="'(living\s*will)|(advance\s*(health|health\s*care)\s*directive)|(advance\s*(care\s*|\s*)(plan|directive))|(advance\s*care\s*information)' " />
  <xsl:variable name="name-masked-regex" select="replace(concat('^\s*(', $knowledge/name-masked/@value, ')\s*$'), ' ', '\\s+') " />
  <xsl:variable name="length-err-max" select="200" />
  <xsl:variable name="p-names" select="(/cda:ClinicalDocument/*[not(local-name(.) = 'component')]//cda:name[cda:family or cda:given],        /cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/cda:section/*[not(cda:text)]//cda:name[cda:family or cda:given]) " />
  <xsl:variable name="family-names" select="distinct-values(for $names in $p-names return if (matches($names/cda:family, '[a-z]', 'i'))        then normalize-space(replace(replace(replace($names/cda:family, $name-newborn-w-rep-regex, '$1$3', 'i'), $name-prefix-rep-regex, '$1$3', 'i'), $name-suffix-m-rep-regex, '$1$3', 'i')) else '')[. != '' and not(matches(., $name-masked-regex, 'i'))] " />
  <xsl:variable name="family-regex-1" select="for $name in $family-names return replace(dh:XQueryRecursiveReplace($name, $meta-pattern-with-pipe, ''), ' ', '\\s*')" />
  <xsl:variable name="family-regex" select="if (exists($family-regex-1)) then concat('(^|^.*[^a-z]{1})(', string-join($family-regex-1, '|'), ')([^a-z]{1}.*$|$)') else '' " />
  <xsl:variable name="family-pattern" select="for $name in $family-regex-1 return concat('(^|[^a-z0-9])(', $name, ')([^a-z0-9]|$)') " />
  <xsl:variable name="family-replacement" select="for $name in $family-names return concat('$1', string-join(for $text in tokenize($name, '\s+') return         if (matches($text, $name-masked-regex, 'i')) then $text        else concat(substring($text, 1, 1), translate(substring($text, 2),          'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', 'xxxxxxxxxxxxxxxxxxxxxxxxxxXXXXXXXXXXXXXXXXXXXXXXXXXX')), ' '), '$3') " />
  <xsl:variable name="family-pattern-replacement" select="string-join(for $i in (1 to count($family-names)) return concat($family-pattern[$i], '~', $family-replacement[$i]), '~') " />
  <xsl:variable name="given-names-1" select="tokenize(string-join((for $names in $p-names return if (matches($names/cda:given, '[a-z]', 'i'))        then string-join(normalize-space(replace(replace(replace($names/cda:given, $name-newborn-w-rep-regex, '$1$3', 'i'), $name-prefix-rep-regex, '$1$3', 'i'), $name-suffix-m-rep-regex, '$1$3', 'i')), '|')        else '')[. != '' and not(matches(., $name-masked-regex, 'i'))], '|'), '\|') " />
  <xsl:variable name="given-names" select="distinct-values(for $names in $given-names-1 return normalize-space($names[                      normalize-space(.) != ''    and                       not(matches(., $name-newborn-g-regex, 'i')) ]))[. != ''] " />
  <xsl:variable name="given-pattern-1" select="for $name in $given-names return replace(dh:XQueryRecursiveReplace($name, $meta-pattern-with-pipe, ''), ' ', '\\s*') " />
  <xsl:variable name="given-pattern" select="for $name in $given-pattern-1 return concat('(^|[^a-z0-9])(', $name, ')([^a-z0-9]|$)') " />
  <xsl:variable name="given-replacement" select="for $name in $given-names return concat('$1', string-join(for $text in tokenize($name, '\s+') return         if (matches($text, $name-masked-regex, 'i')) then $text        else concat(substring($text, 1, 1), translate(substring($text, 2),          'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', 'xxxxxxxxxxxxxxxxxxxxxxxxxxXXXXXXXXXXXXXXXXXXXXXXXXXX')), ' '), '$3') " />
  <xsl:variable name="given-pattern-replacement" select="string-join(for $i in (1 to count($given-names)) return concat($given-pattern[$i], '~', $given-replacement[$i]), '~') " />
  <xsl:variable name="p-name-pattern-replacement" select="if ($given-pattern-replacement = '') then $family-pattern-replacement        else if ($family-pattern-replacement = '') then $given-pattern-replacement        else concat($family-pattern-replacement, '~', $given-pattern-replacement) " />
  <xsl:variable name="text-pattern-replacement" select="if ($p-name-pattern-replacement = '') then $markup-pattern-replacement        else if ($markup-pattern-replacement = '') then $p-name-pattern-replacement        else concat($p-name-pattern-replacement, '~', $markup-pattern-replacement) " />
  <xsl:variable name="term-pattern-replacement" select="concat(        '(^|.)', codepoints-to-string((38)), '(.|$)',  '~',  '$1 and $2',    '~',        '(^|.)=\s*&gt;(.|$)',    '~', '$1 greater than or equals $2', '~',        '(^|.)&gt;(.|$)',     '~', '$1 greater than $2',  '~',        '(^|.)&lt;\s*=(.|$)',    '~', '$1 less than or equals $2',  '~',        '(^|.)&lt;(.|$)',    '~', '$1 less than $2'  ) " />
  <xsl:variable name="consumer-eis" select=" /cda:ClinicalDocument//cda:patient/ext:asEntityIdentifier/ext:id " />
  <xsl:variable name="person-eis" select=" /cda:ClinicalDocument//*[        local-name(.) = 'asPersonalRelationship'   or        local-name(.) = 'assignedPerson'    or        local-name(.) = 'associatedPerson'    or        local-name(.) = 'guardianPerson'    or        local-name(.) = 'informationRecipient'    or        local-name(.) = 'maintainingPerson'    or        local-name(.) = 'patient'     or       (local-name(.) = 'playingEntity' and @classCode='PSN')  or        local-name(.) = 'relatedPerson'    or       (local-name(.) = 'scopingEntity' and @classCode='PSN')  or       (local-name(.) = 'specimenPlayingEntity' and @classCode='PSN') or        local-name(.) = 'subject'     ]/ext:asEntityIdentifier/ext:id " />
  <xsl:variable name="org-eis" select=" /cda:ClinicalDocument//*[        local-name(.) = 'employerOrganization'    or        local-name(.) = 'guardianOrganization'    or         local-name(.) = 'manufacturerOrganization'   or       (local-name(.) = 'playingEntity' and @classCode='ORG')  or          local-name(.) = 'providerOrganization'    or         local-name(.) = 'receivedOrganization'    or        local-name(.) = 'representedCustodianOrganization'  or        local-name(.) = 'representedOrganization'   or       (local-name(.) = 'scopingEntity' and @classCode='ORG')  or        local-name(.) = 'scopingOrganization'    or        local-name(.) = 'serviceProviderOrganization'   or       (local-name(.) = 'specimenPlayingEntity' and @classCode='ORG') or        local-name(.) = 'wholeEntity'     or         local-name(.) = 'wholeOrganization'    ]/ext:asEntityIdentifier/ext:id " />
  <xsl:variable name="device-eis" select=" /cda:ClinicalDocument//cda:assignedAuthoringDevice/ext:asEntityIdentifier/ext:id " />
  <xsl:variable name="combined-consumer-eis" select=" distinct-values(for $ei in $consumer-eis return        if ($ei/@root and $ei/@extension) then concat($ei/@root, '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and $ei/@nullFlavor) then concat($ei/@root, '.', 'unknown')        else if (not($ei/@root) and $ei/@nullFlavor and $ei/@extension) then concat('unknown', '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and not($ei/@nullFlavor)) then $ei/@root        else if (not($ei/@root) and not($ei/@nullFlavor) and $ei/@extension) then $ei/@extension        else '') " />
  <xsl:variable name="combined-person-eis" select=" distinct-values(for $ei in $person-eis return        if ($ei/@root and $ei/@extension) then concat($ei/@root, '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and $ei/@nullFlavor) then concat($ei/@root, '.', 'unknown')        else if (not($ei/@root) and $ei/@nullFlavor and $ei/@extension) then concat('unknown', '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and not($ei/@nullFlavor)) then $ei/@root        else if (not($ei/@root) and not($ei/@nullFlavor) and $ei/@extension) then $ei/@extension        else '') " />
  <xsl:variable name="combined-org-eis" select=" distinct-values(for $ei in $org-eis return        if ($ei/@root and $ei/@extension) then concat($ei/@root, '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and $ei/@nullFlavor) then concat($ei/@root, '.', 'unknown')        else if (not($ei/@root) and $ei/@nullFlavor and $ei/@extension) then concat('unknown', '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and not($ei/@nullFlavor)) then $ei/@root        else if (not($ei/@root) and not($ei/@nullFlavor) and $ei/@extension) then $ei/@extension        else '') " />
  <xsl:variable name="combined-device-eis" select=" distinct-values(for $ei in $device-eis return        if ($ei/@root and $ei/@extension) then concat($ei/@root, '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and $ei/@nullFlavor) then concat($ei/@root, '.', 'unknown')        else if (not($ei/@root) and $ei/@nullFlavor and $ei/@extension) then concat('unknown', '.', $ei/@extension)        else if ($ei/@root and not($ei/@extension) and not($ei/@nullFlavor)) then $ei/@root        else if (not($ei/@root) and not($ei/@nullFlavor) and $ei/@extension) then $ei/@extension        else '') " />
  <xsl:variable name="log-concepts-name" select="if ($knowledge/logs/@concepts) then $knowledge/logs/@concepts else '' " />
  <xsl:variable name="log-tab" select="codepoints-to-string(9)" />
  <xsl:variable name="log-concepts-created" select="if (not($flags/@report-terminology-concepts = 'true') or $log-concepts-name = '') then ''         else dh:CreateLog($log-concepts-name, concat(               'Document date',   $log-tab,              'Document ID',    $log-tab,                  'Document type',   $log-tab,                'Document section',   $log-tab,                 'Data element',   $log-tab,                 'Value domain specified?', $log-tab,                 'Concept',    $log-tab,                 'In value domain',   $log-tab,                 'In other value domain',  $log-tab,                 'In no value domain',   $log-tab,                 'SNOMED CT-AU version'  )) " />
  <xsl:variable name="excluded-nomenclatures" select="if ($flags/@report-data-quality = 'true') then $knowledge/nomenclatures/excluded/@codeSystem else () " />
  <xsl:variable name="meds-view-sections" select="('101.16146', '101.16146.4.1.1', '101.16146.4.1.2', '101.16649', '101.20113', '102.16210', '102.16211') " />
  <xsl:variable name="medications-sections" select="('101.16146', '101.16146.4.1.1', '101.16146.4.1.2', '101.16649', '102.16210', '102.16211') " />
  <xsl:variable name="ADI-sections" select="('101.16146', '101.16146.4.1.1', '101.16146.4.1.2', '101.20113', '102.16210', '102.16211') " />
  <xsl:variable name="ratings" select="if (not($flags/@test-data = 'true') and $flags/@allow-ratings = 'true') then document('TEMPLATE/VALDN/IQRatings.xml', .)/ratings else () " />
  <xsl:variable name="initial-priority-nodes" select="if ($ratings/overriding-contexts/initial-priority-node/@node) then $ratings/overriding-contexts/initial-priority-node/@node else () " />
  <xsl:variable name="initial-participants" select="if ($ratings/overriding-participants/participant/@type) then $ratings/overriding-participants/participant/@type else () " />
  <xsl:variable name="rejection-rating" select="if (not($flags/@test-data = 'true') and $flags/@allow-ratings = 'true') then ' (HIGH)' else '' " />
  <xsl:variable name="initial-rating" select="if (not($flags/@test-data = 'true') and $flags/@allow-ratings = 'true') then ' (TRIVIAL)' else '' " />
  <xsl:variable name="FS-Doc-seq" select="$ratings/feature-set[@id='FS-Doc'] " />
  <xsl:variable name="FS-Narr-seq" select="$ratings/feature-set[@id='FS-Narr'] " />
  <xsl:variable name="FS-Types-seq" select="$ratings/feature-set[@id='FS-Types'] " />
  <xsl:variable name="FS-Auth-seq" select="$ratings/feature-set[@id='FS-Auth']" />
  <xsl:variable name="FS-Usability-seq" select="$ratings/feature-set[@id='FS-Usability'] " />
  <xsl:variable name="FS-Terminology-seq" select="$ratings/feature-set[@id='FS-Terminology'] " />
  <xsl:variable name="TS-AdminObs-seq" select="$FS-Doc-seq/test-set[@id='TS-AdminObs'] " />
  <xsl:variable name="TS-Body-seq" select="$FS-Doc-seq/test-set[@id='TS-Body'] " />
  <xsl:variable name="TS-Dext-seq" select="$FS-Doc-seq/test-set[@id='TS-Dext'] " />
  <xsl:variable name="TS-DocIdent-seq" select="$FS-Doc-seq/test-set[@id='TS-DocIdent'] " />
  <xsl:variable name="TS-GCD-seq" select="$FS-Doc-seq/test-set[@id='TS-GCD'] " />
  <xsl:variable name="TS-Head-seq" select="$FS-Doc-seq/test-set[@id='TS-Head'] " />
  <xsl:variable name="TS-Level-seq" select="$FS-Doc-seq/test-set[@id='TS-Level'] " />
  <xsl:variable name="TS-Logo-seq" select="$FS-Doc-seq/test-set[@id='TS-Logo'] " />
  <xsl:variable name="TS-Vers-seq" select="$FS-Doc-seq/test-set[@id='TS-Vers'] " />
  <xsl:variable name="TS-Auto-seq" select="$FS-Narr-seq/test-set[@id='TS-Auto'] " />
  <xsl:variable name="TS-Ext-seq" select="$FS-Narr-seq/test-set[@id='TS-Ext'] " />
  <xsl:variable name="TS-Info-seq" select="$FS-Narr-seq/test-set[@id='TS-Info'] " />
  <xsl:variable name="TS-Mark-seq" select="$FS-Narr-seq/test-set[@id='TS-Mark'] " />
  <xsl:variable name="TS-Narr-seq" select="$FS-Narr-seq/test-set[@id='TS-Narr'] " />
  <xsl:variable name="TS-Ref-seq" select="$FS-Narr-seq/test-set[@id='TS-Ref'] " />
  <xsl:variable name="TS-Style-seq" select="$FS-Narr-seq/test-set[@id='TS-Style'] " />
  <xsl:variable name="TS-Tab-seq" select="$FS-Narr-seq/test-set[@id='TS-Tab'] " />
  <xsl:variable name="TS-AddrDG-seq" select="$FS-Types-seq/test-set[@id='TS-AddrDG' and @context='default'] " />
  <xsl:variable name="TS-AddrDG-alt-seq" select="$FS-Types-seq/test-set[@id='TS-AddrDG' and @context='alternative'] " />
  <xsl:variable name="TS-BTB-seq" select="$FS-Types-seq/test-set[@id='TS-BTB' and @context='default'] " />
  <xsl:variable name="TS-BTB-alt-seq" select="$FS-Types-seq/test-set[@id='TS-BTB' and @context='alternative'] " />
  <xsl:variable name="TS-Class-seq" select="$FS-Types-seq/test-set[@id='TS-Class' and @context='default'] " />
  <xsl:variable name="TS-Class-alt-seq" select="$FS-Types-seq/test-set[@id='TS-Class' and @context='alternative'] " />
  <xsl:variable name="TS-Coded-seq" select="$FS-Types-seq/test-set[@id='TS-Coded' and @context='default'] " />
  <xsl:variable name="TS-Coded-alt-seq" select="$FS-Types-seq/test-set[@id='TS-Coded' and @context='alternative'] " />
  <xsl:variable name="TS-Cont-seq" select="$FS-Types-seq/test-set[@id='TS-Cont' and @context='default'] " />
  <xsl:variable name="TS-Cont-alt-seq" select="$FS-Types-seq/test-set[@id='TS-Cont' and @context='alternative'] " />
  <xsl:variable name="TS-EntId-seq" select="$FS-Types-seq/test-set[@id='TS-EntId' and @context='default'] " />
  <xsl:variable name="TS-EntId-alt-seq" select="$FS-Types-seq/test-set[@id='TS-EntId' and @context='alternative'] " />
  <xsl:variable name="TS-Entit-seq" select="$FS-Types-seq/test-set[@id='TS-Entit' and @context='default'] " />
  <xsl:variable name="TS-Entit-alt-seq" select="$FS-Types-seq/test-set[@id='TS-Entit' and @context='alternative'] " />
  <xsl:variable name="TS-IL-seq" select="$FS-Types-seq/test-set[@id='TS-IL' and @context='default'] " />
  <xsl:variable name="TS-IL-alt-seq" select="$FS-Types-seq/test-set[@id='TS-IL' and @context='alternative'] " />
  <xsl:variable name="TS-PQ.TIME-seq" select="$FS-Types-seq/test-set[@id='TS-PQ.TIME' and @context='default'] " />
  <xsl:variable name="TS-PQ.TIME-alt-seq" select="$FS-Types-seq/test-set[@id='TS-PQ.TIME' and @context='alternative'] " />
  <xsl:variable name="TS-Quant-seq" select="$FS-Types-seq/test-set[@id='TS-Quant' and @context='default'] " />
  <xsl:variable name="TS-Quant-alt-seq" select="$FS-Types-seq/test-set[@id='TS-Quant' and @context='alternative'] " />
  <xsl:variable name="TS-BL-seq" select="$FS-Types-seq/test-set[@id='TS-BL'] " />
  <xsl:variable name="TS-BL-alt-seq" select="$FS-Types-seq/test-set[@id='TS-BL' and @context='alternative'] " />
  <xsl:variable name="TS-CD-seq" select="$FS-Types-seq/test-set[@id='TS-CD'] " />
  <xsl:variable name="TS-CD-alt-seq" select="$FS-Types-seq/test-set[@id='TS-CD' and @context='alternative'] " />
  <xsl:variable name="TS-CS-seq" select="$FS-Types-seq/test-set[@id='TS-CS'] " />
  <xsl:variable name="TS-CS-alt-seq" select="$FS-Types-seq/test-set[@id='TS-CS' and @context='alternative'] " />
  <xsl:variable name="TS-ED-seq" select="$FS-Types-seq/test-set[@id='TS-ED'] " />
  <xsl:variable name="TS-ED-alt-seq" select="$FS-Types-seq/test-set[@id='TS-ED' and @context='alternative'] " />
  <xsl:variable name="TS-II-seq" select="$FS-Types-seq/test-set[@id='TS-II'] " />
  <xsl:variable name="TS-II-alt-seq" select="$FS-Types-seq/test-set[@id='TS-II' and @context='alternative'] " />
  <xsl:variable name="TS-INT-seq" select="$FS-Types-seq/test-set[@id='TS-INT'] " />
  <xsl:variable name="TS-INT-alt-seq" select="$FS-Types-seq/test-set[@id='TS-INT' and @context='alternative'] " />
  <xsl:variable name="TS-IVL-seq" select="$FS-Types-seq/test-set[@id='TS-IVL'] " />
  <xsl:variable name="TS-IVL-alt-seq" select="$FS-Types-seq/test-set[@id='TS-IVL' and @context='alternative'] " />
  <xsl:variable name="TS-NF-seq" select="$FS-Types-seq/test-set[@id='TS-NF'] " />
  <xsl:variable name="TS-NF-alt-seq" select="$FS-Types-seq/test-set[@id='TS-NF' and @context='alternative'] " />
  <xsl:variable name="TS-PIVL-seq" select="$FS-Types-seq/test-set[@id='TS-PIVL'] " />
  <xsl:variable name="TS-PIVL-alt-seq" select="$FS-Types-seq/test-set[@id='TS-PIVL' and @context='alternative'] " />
  <xsl:variable name="TS-PQ-seq" select="$FS-Types-seq/test-set[@id='TS-PQ'] " />
  <xsl:variable name="TS-PQ-alt-seq" select="$FS-Types-seq/test-set[@id='TS-PQ' and @context='alternative'] " />
  <xsl:variable name="TS-REAL-seq" select="$FS-Types-seq/test-set[@id='TS-REAL'] " />
  <xsl:variable name="TS-REAL-alt-seq" select="$FS-Types-seq/test-set[@id='TS-REAL' and @context='alternative'] " />
  <xsl:variable name="TS-RTO-seq" select="$FS-Types-seq/test-set[@id='TS-RTO'] " />
  <xsl:variable name="TS-RTO-alt-seq" select="$FS-Types-seq/test-set[@id='TS-RTO' and @context='alternative'] " />
  <xsl:variable name="TS-ST-seq" select="$FS-Types-seq/test-set[@id='TS-ST'] " />
  <xsl:variable name="TS-ST-alt-seq" select="$FS-Types-seq/test-set[@id='TS-ST' and @context='alternative'] " />
  <xsl:variable name="TS-TEL-seq" select="$FS-Types-seq/test-set[@id='TS-TEL'] " />
  <xsl:variable name="TS-TEL-alt-seq" select="$FS-Types-seq/test-set[@id='TS-TEL' and @context='alternative'] " />
  <xsl:variable name="TS-TS-seq" select="$FS-Types-seq/test-set[@id='TS-TS'] " />
  <xsl:variable name="TS-TS-alt-seq" select="$FS-Types-seq/test-set[@id='TS-TS' and @context='alternative'] " />
  <xsl:variable name="TS-UID-seq" select="$FS-Types-seq/test-set[@id='TS-UID'] " />
  <xsl:variable name="TS-UID-alt-seq" select="$FS-Types-seq/test-set[@id='TS-UID' and @context='alternative'] " />
  <xsl:variable name="TS-Addr-seq" select="$FS-Auth-seq/test-set[@id='TS-Addr'] " />
  <xsl:variable name="TS-Behav-seq" select="$FS-Auth-seq/test-set[@id='TS-Behav'] " />
  <xsl:variable name="TS-Content-seq" select="$FS-Auth-seq/test-set[@id='TS-Content'] " />
  <xsl:variable name="TS-eComm-seq" select="$FS-Auth-seq/test-set[@id='TS-eComm'] " />
  <xsl:variable name="TS-Ident-seq" select="$FS-Auth-seq/test-set[@id='TS-Ident'] " />
  <xsl:variable name="TS-Pers-seq" select="$FS-Auth-seq/test-set[@id='TS-Pers'] " />
  <xsl:variable name="TS-Terminology-seq" select="$FS-Terminology-seq/test-set[@id='TS-Terminology'] " />
  <xsl:variable name="TS-Usability-seq" select="$FS-Usability-seq/test-set[@id='TS-Usability'] " />
  <xsl:variable name="rating-TS-AdminObs" select="if ($TS-AdminObs-seq/@rating) then concat(' (', $TS-AdminObs-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Body" select="if ($TS-Body-seq/@rating) then concat(' (', $TS-Body-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Dext" select="if ($TS-Dext-seq/@rating) then concat(' (', $TS-Dext-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-DocIdent" select="if ($TS-DocIdent-seq/@rating) then concat(' (', $TS-DocIdent-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-GCD" select="if ($TS-GCD-seq/@rating) then concat(' (', $TS-GCD-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Head" select="if ($TS-Head-seq/@rating) then concat(' (', $TS-Head-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Level" select="if ($TS-Level-seq/@rating) then concat(' (', $TS-Level-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Logo" select="if ($TS-Logo-seq/@rating) then concat(' (', $TS-Logo-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Vers" select="if ($TS-Vers-seq/@rating) then concat(' (', $TS-Vers-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Auto" select="if ($TS-Auto-seq/@rating) then concat(' (', $TS-Auto-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Ext" select="if ($TS-Ext-seq/@rating) then concat(' (', $TS-Ext-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Info" select="if ($TS-Info-seq/@rating) then concat(' (', $TS-Info-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Mark" select="if ($TS-Mark-seq/@rating) then concat(' (', $TS-Mark-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Narr" select="if ($TS-Narr-seq/@rating) then concat(' (', $TS-Narr-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Ref" select="if ($TS-Ref-seq/@rating) then concat(' (', $TS-Ref-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Style" select="if ($TS-Style-seq/@rating) then concat(' (', $TS-Style-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Tab" select="if ($TS-Tab-seq/@rating) then concat(' (', $TS-Tab-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-AddrDG" select="if ($TS-AddrDG-seq/@rating) then concat(' (', $TS-AddrDG-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-AddrDG" select="if ($TS-AddrDG-alt-seq/@rating) then concat(' (', $TS-AddrDG-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-BTB" select="if ($TS-BTB-seq/@rating) then concat(' (', $TS-BTB-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-BTB" select="if ($TS-BTB-alt-seq/@rating) then concat(' (', $TS-BTB-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Class" select="if ($TS-Class-seq/@rating) then concat(' (', $TS-Class-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-Class" select="if ($TS-Class-alt-seq/@rating) then concat(' (', $TS-Class-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Coded" select="if ($TS-Coded-seq/@rating) then concat(' (', $TS-Coded-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-Coded" select="if ($TS-Coded-alt-seq/@rating) then concat(' (', $TS-Coded-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Cont" select="if ($TS-Cont-seq/@rating) then concat(' (', $TS-Cont-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-Cont" select="if ($TS-Cont-alt-seq/@rating) then concat(' (', $TS-Cont-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-EntId" select="if ($TS-EntId-seq/@rating) then concat(' (', $TS-EntId-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-EntId" select="if ($TS-EntId-alt-seq/@rating) then concat(' (', $TS-EntId-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Entit" select="if ($TS-Entit-seq/@rating) then concat(' (', $TS-Entit-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-Entit" select="if ($TS-Entit-alt-seq/@rating) then concat(' (', $TS-Entit-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-IL" select="if ($TS-IL-seq/@rating) then concat(' (', $TS-IL-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-IL" select="if ($TS-IL-alt-seq/@rating) then concat(' (', $TS-IL-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-PQ.TIME" select="if ($TS-PQ.TIME-seq/@rating) then concat(' (', $TS-PQ.TIME-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-PQ.TIME" select="if ($TS-PQ.TIME-alt-seq/@rating) then concat(' (', $TS-PQ.TIME-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Quant" select="if ($TS-Quant-seq/@rating) then concat(' (', $TS-Quant-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-Quant" select="if ($TS-Quant-alt-seq/@rating) then concat(' (', $TS-Quant-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-BL" select="if ($TS-BL-seq/@rating) then concat(' (', $TS-BL-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-BL" select="if ($TS-BL-alt-seq/@rating) then concat(' (', $TS-BL-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-CD" select="if ($TS-CD-seq/@rating) then concat(' (', $TS-CD-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-CD" select="if ($TS-CD-alt-seq/@rating) then concat(' (', $TS-CD-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-CS" select="if ($TS-CS-seq/@rating) then concat(' (', $TS-CS-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-CS" select="if ($TS-CS-alt-seq/@rating) then concat(' (', $TS-CS-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-ED" select="if ($TS-ED-seq/@rating) then concat(' (', $TS-ED-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-ED" select="if ($TS-ED-alt-seq/@rating) then concat(' (', $TS-ED-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-II" select="if ($TS-II-seq/@rating) then concat(' (', $TS-II-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-II" select="if ($TS-II-alt-seq/@rating) then concat(' (', $TS-II-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-INT" select="if ($TS-INT-seq/@rating) then concat(' (', $TS-INT-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-INT" select="if ($TS-INT-alt-seq/@rating) then concat(' (', $TS-INT-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-IVL" select="if ($TS-IVL-seq/@rating) then concat(' (', $TS-IVL-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-IVL" select="if ($TS-IVL-alt-seq/@rating) then concat(' (', $TS-IVL-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-NF" select="if ($TS-NF-seq/@rating) then concat(' (', $TS-NF-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-NF" select="if ($TS-NF-alt-seq/@rating) then concat(' (', $TS-NF-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-PIVL" select="if ($TS-PIVL-seq/@rating) then concat(' (', $TS-PIVL-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-PIVL" select="if ($TS-PIVL-alt-seq/@rating) then concat(' (', $TS-PIVL-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-PQ" select="if ($TS-PQ-seq/@rating) then concat(' (', $TS-PQ-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-PQ" select="if ($TS-PQ-alt-seq/@rating) then concat(' (', $TS-PQ-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-REAL" select="if ($TS-REAL-seq/@rating) then concat(' (', $TS-REAL-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-REAL" select="if ($TS-REAL-alt-seq/@rating) then concat(' (', $TS-REAL-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-RTO" select="if ($TS-RTO-seq/@rating) then concat(' (', $TS-RTO-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-RTO" select="if ($TS-RTO-alt-seq/@rating) then concat(' (', $TS-RTO-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-ST" select="if ($TS-ST-seq/@rating) then concat(' (', $TS-ST-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-ST" select="if ($TS-ST-alt-seq/@rating) then concat(' (', $TS-ST-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-TEL" select="if ($TS-TEL-seq/@rating) then concat(' (', $TS-TEL-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-TEL" select="if ($TS-TEL-alt-seq/@rating) then concat(' (', $TS-TEL-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-TS" select="if ($TS-TS-seq/@rating) then concat(' (', $TS-TS-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-TS" select="if ($TS-TS-alt-seq/@rating) then concat(' (', $TS-TS-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-UID" select="if ($TS-UID-seq/@rating) then concat(' (', $TS-UID-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-alt-TS-UID" select="if ($TS-UID-alt-seq/@rating) then concat(' (', $TS-UID-alt-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Addr" select="if ($TS-Addr-seq/@rating) then concat(' (', $TS-Addr-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Content" select="if ($TS-Content-seq/@rating) then concat(' (', $TS-Content-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-eComm" select="if ($TS-eComm-seq/@rating) then concat(' (', $TS-eComm-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Pers" select="if ($TS-Pers-seq/@rating) then concat(' (', $TS-Pers-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Terminology" select="if ($TS-Terminology-seq/@rating) then concat(' (', $TS-Terminology-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TS-Usability" select="if ($TS-Usability-seq/@rating) then concat(' (', $TS-Usability-seq/@rating, ')') else '' " />
  <xsl:variable name="rating-TC-Doc-40" select="if ($TS-AdminObs-seq/test-case[@id='TC-Doc-40']/@rating) then concat(' (', $TS-AdminObs-seq/test-case[@id='TC-Doc-40']/@rating, ')') else $rating-TS-AdminObs " />
  <xsl:variable name="rating-TC-Doc-24" select="if ($TS-Body-seq/test-case[@id='TC-Doc-24']/@rating) then concat(' (', $TS-Body-seq/test-case[@id='TC-Doc-24']/@rating, ')') else $rating-TS-Body " />
  <xsl:variable name="rating-TC-Doc-25" select="if ($TS-Body-seq/test-case[@id='TC-Doc-25']/@rating) then concat(' (', $TS-Body-seq/test-case[@id='TC-Doc-25']/@rating, ')') else $rating-TS-Body " />
  <xsl:variable name="rating-TC-Doc-41" select="if ($TS-Body-seq/test-case[@id='TC-Doc-41']/@rating) then concat(' (', $TS-Body-seq/test-case[@id='TC-Doc-41']/@rating, ')') else $rating-TS-Body " />
  <xsl:variable name="rating-TC-Doc-28-step-1" select="if ($TS-Dext-seq/test-case[@id='TC-Doc-28-step-1' and @context='default']/@rating) then concat(' (', $TS-Dext-seq/test-case[@id='TC-Doc-28-step-1' and @context='default']/@rating, ')') else $rating-TS-Dext " />
  <xsl:variable name="rating-MHRView-TC-Doc-28-step-1" select="if ($TS-Dext-seq/test-case[@id='TC-Doc-28-step-1' and @context='MHRView']/@rating) then concat(' (', $TS-Dext-seq/test-case[@id='TC-Doc-28-step-1' and @context='MHRView']/@rating, ')') else $rating-TC-Doc-28-step-1 " />
  <xsl:variable name="rating-alt-TC-Doc-28-step-1" select="if ($TS-Dext-seq/test-case[@id='TC-Doc-28-step-1' and @context='alternative']/@rating) then concat(' (', $TS-Dext-seq/test-case[@id='TC-Doc-28-step-1' and @context='alternative']/@rating, ')') else $rating-TC-Doc-28-step-1 " />
  <xsl:variable name="rating-TC-Doc-28-step-2" select="if ($TS-Dext-seq/test-case[@id='TC-Doc-28-step-2']/@rating) then concat(' (', $TS-Dext-seq/test-case[@id='TC-Doc-28-step-2']/@rating, ')') else $rating-TS-Dext " />
  <xsl:variable name="rating-TC-Doc-28-step-3" select="if ($TS-Dext-seq/test-case[@id='TC-Doc-28-step-3']/@rating) then concat(' (', $TS-Dext-seq/test-case[@id='TC-Doc-28-step-3']/@rating, ')') else $rating-TS-Dext " />
  <xsl:variable name="rating-TC-Doc-28-step-4" select="if ($TS-Dext-seq/test-case[@id='TC-Doc-28-step-4' and @context='default']/@rating) then concat(' (', $TS-Dext-seq/test-case[@id='TC-Doc-28-step-4' and @context='default']/@rating, ')') else $rating-TS-Dext " />
  <xsl:variable name="rating-alt-TC-Doc-28-step-4" select="if ($TS-Dext-seq/test-case[@id='TC-Doc-28-step-4' and @context='alternative']/@rating) then concat(' (', $TS-Dext-seq/test-case[@id='TC-Doc-28-step-4' and @context='alternative']/@rating, ')') else $rating-TC-Doc-28-step-4 " />
  <xsl:variable name="rating-TC-Doc-32" select="if ($TS-DocIdent-seq/test-case[@id='TC-Doc-32']/@rating) then concat(' (', $TS-DocIdent-seq/test-case[@id='TC-Doc-32']/@rating, ')') else $rating-TS-DocIdent " />
  <xsl:variable name="rating-TC-Doc-33" select="if ($TS-DocIdent-seq/test-case[@id='TC-Doc-33']/@rating) then concat(' (', $TS-DocIdent-seq/test-case[@id='TC-Doc-33']/@rating, ')') else $rating-TS-DocIdent " />
  <xsl:variable name="rating-TC-Doc-38" select="if ($TS-DocIdent-seq/test-case[@id='TC-Doc-38']/@rating) then concat(' (', $TS-DocIdent-seq/test-case[@id='TC-Doc-38']/@rating, ')') else $rating-TS-DocIdent " />
  <xsl:variable name="rating-TC-Doc-01" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-01' and @context='default']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-01' and @context='default']/@rating, ')') else $rating-TS-GCD " />
  <xsl:variable name="rating-TC-Doc-01-low" select="' (LOW)' " />
  <xsl:variable name="rating-TC-Doc-04" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-04']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-04']/@rating, ')') else $rating-TS-GCD " />
  <xsl:variable name="rating-TC-Doc-05-step-1" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-05-step-1' and @context='default']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-05-step-1' and @context='default']/@rating, ')') else $rating-TS-GCD " />
  <xsl:variable name="rating-alt-TC-Doc-05-step-1" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-05-step-1' and @context='alternative']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-05-step-1' and @context='alternative']/@rating, ')') else $rating-TC-Doc-05-step-1 " />
  <xsl:variable name="rating-TC-Doc-05-step-2" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-05-step-2']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-05-step-2']/@rating, ')') else $rating-TS-GCD " />
  <xsl:variable name="rating-alt-TC-Doc-05-step-2" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-05-step-2' and @context='alternative']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-05-step-2' and @context='alternative']/@rating, ')') else $rating-TC-Doc-05-step-2 " />
  <xsl:variable name="rating-TC-Doc-08" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-08']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-08']/@rating, ')') else $rating-TS-GCD " />
  <xsl:variable name="rating-TC-Doc-09" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-09']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-09']/@rating, ')') else $rating-TS-GCD " />
  <xsl:variable name="rating-TC-Doc-37" select="if ($TS-GCD-seq/test-case[@id='TC-Doc-37']/@rating) then concat(' (', $TS-GCD-seq/test-case[@id='TC-Doc-37']/@rating, ')') else $rating-TS-GCD " />
  <xsl:variable name="rating-TC-Doc-11" select="if ($TS-Head-seq/test-case[@id='TC-Doc-11']/@rating) then concat(' (', $TS-Head-seq/test-case[@id='TC-Doc-11']/@rating, ')') else $rating-TS-Head " />
  <xsl:variable name="rating-TC-Doc-39" select="if ($TS-Head-seq/test-case[@id='TC-Doc-39']/@rating) then concat(' (', $TS-Head-seq/test-case[@id='TC-Doc-39']/@rating, ')') else $rating-TS-Head " />
  <xsl:variable name="rating-TC-Doc-16" select="if ($TS-Level-seq/test-case[@id='TC-Doc-16']/@rating) then concat(' (', $TS-Level-seq/test-case[@id='TC-Doc-16']/@rating, ')') else $rating-TS-Level " />
  <xsl:variable name="rating-TC-Doc-17" select="if ($TS-Level-seq/test-case[@id='TC-Doc-17']/@rating) then concat(' (', $TS-Level-seq/test-case[@id='TC-Doc-17']/@rating, ')') else $rating-TS-Level " />
  <xsl:variable name="rating-TC-Doc-19" select="if ($TS-Level-seq/test-case[@id='TC-Doc-19' and @context='default']/@rating) then concat(' (', $TS-Level-seq/test-case[@id='TC-Doc-19' and @context='default']/@rating, ')') else $rating-TS-Level " />
  <xsl:variable name="rating-MHRView-TC-Doc-19" select="if ($TS-Level-seq/test-case[@id='TC-Doc-19' and @context='MHRView']/@rating) then concat(' (', $TS-Level-seq/test-case[@id='TC-Doc-19' and @context='MHRView']/@rating, ')') else $rating-TC-Doc-19 " />
  <xsl:variable name="rating-TC-Doc-26" select="if ($TS-Logo-seq/test-case[@id='TC-Doc-26']/@rating) then concat(' (', $TS-Logo-seq/test-case[@id='TC-Doc-26']/@rating, ')') else $rating-TS-Logo " />
  <xsl:variable name="rating-TC-Narr-11" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-11']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-11']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-TC-Narr-15" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-15']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-15']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-TC-Narr-16" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-16']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-16']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-TC-Narr-17" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-17']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-17']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-TC-Narr-18" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-18']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-18']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-TC-Narr-26" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-26']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-26']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-TC-Narr-27" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-27']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-27']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-TC-Narr-93" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-93' and @context='default']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-93' and @context='default']/@rating, ')') else $rating-TS-Auto " />
  <xsl:variable name="rating-MHRView-TC-Narr-93" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-93' and @context='MHRView']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-93' and @context='MHRView']/@rating, ')') else $rating-TC-Narr-93 " />
  <xsl:variable name="rating-TGI-TC-Narr-93" select="if ($TS-Auto-seq/test-case[@id='TC-Narr-93' and @context='TGI']/@rating) then concat(' (', $TS-Auto-seq/test-case[@id='TC-Narr-93' and @context='TGI']/@rating, ')') else $rating-TC-Narr-93 " />
  <xsl:variable name="rating-TC-Narr-88" select="if ($TS-Ext-seq/test-case[@id='TC-Narr-88']/@rating) then concat(' (', $TS-Ext-seq/test-case[@id='TC-Narr-88']/@rating, ')') else $rating-TS-Ext " />
  <xsl:variable name="rating-TC-Narr-08" select="if ($TS-Info-seq/test-case[@id='TC-Narr-08']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-08']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-1" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-1']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-1']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-2" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-2']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-2']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-3" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-3']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-3']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-4" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-4']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-4']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-5" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-5']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-5']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-6" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-6']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-6']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-7" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-7' and @context='default']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-7' and @context='default']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-noProperValue-TC-Narr-09-step-7" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-7' and @context='noProperValue']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-7' and @context='noProperValue']/@rating, ')') else $rating-TC-Narr-09-step-7 " />
  <xsl:variable name="rating-TC-Narr-09-step-8" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-8']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-8']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-9" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-9']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-9']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-10" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-10']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-10']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-11" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-11']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-11']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-12" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-12']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-12']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-13" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-13']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-13']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-09-step-14" select="if ($TS-Info-seq/test-case[@id='TC-Narr-09-step-14']/@rating) then concat(' (', $TS-Info-seq/test-case[@id='TC-Narr-09-step-14']/@rating, ')') else $rating-TS-Info " />
  <xsl:variable name="rating-TC-Narr-28" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-28']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-28']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-29" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-29' and @context='default']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-29' and @context='default']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-alt-TC-Narr-29" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-29' and @context='alternative']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-29' and @context='alternative']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-30" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-30']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-30']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-31" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-31']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-31']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-33" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-33']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-33']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-38" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-38']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-38']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-39" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-39']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-39']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-41" select="if ($TS-Mark-seq/test-case[@id='TC-Narr-41']/@rating) then concat(' (', $TS-Mark-seq/test-case[@id='TC-Narr-41']/@rating, ')') else $rating-TS-Mark " />
  <xsl:variable name="rating-TC-Narr-89" select="if ($TS-Ref-seq/test-case[@id='TC-Narr-89']/@rating) then concat(' (', $TS-Ref-seq/test-case[@id='TC-Narr-89']/@rating, ')') else $rating-TS-Ref " />
  <xsl:variable name="rating-TC-Narr-91" select="if ($TS-Ref-seq/test-case[@id='TC-Narr-91']/@rating) then concat(' (', $TS-Ref-seq/test-case[@id='TC-Narr-91']/@rating, ')') else $rating-TS-Ref " />
  <xsl:variable name="rating-TC-Narr-92" select="if ($TS-Ref-seq/test-case[@id='TC-Narr-92']/@rating) then concat(' (', $TS-Ref-seq/test-case[@id='TC-Narr-92']/@rating, ')') else $rating-TS-Ref " />
  <xsl:variable name="rating-TC-Narr-64" select="if ($TS-Style-seq/test-case[@id='TC-Narr-64']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-64']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-65" select="if ($TS-Style-seq/test-case[@id='TC-Narr-65']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-65']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-71" select="if ($TS-Style-seq/test-case[@id='TC-Narr-71']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-71']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-72" select="if ($TS-Style-seq/test-case[@id='TC-Narr-72']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-72']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-73" select="if ($TS-Style-seq/test-case[@id='TC-Narr-73']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-73']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-74" select="if ($TS-Style-seq/test-case[@id='TC-Narr-74']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-74']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-75" select="if ($TS-Style-seq/test-case[@id='TC-Narr-75']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-75']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-76" select="if ($TS-Style-seq/test-case[@id='TC-Narr-76']/@rating) then concat(' (', $TS-Style-seq/test-case[@id='TC-Narr-76']/@rating, ')') else $rating-TS-Style " />
  <xsl:variable name="rating-TC-Narr-49" select="if ($TS-Tab-seq/test-case[@id='TC-Narr-49']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Narr-49']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Narr-50" select="if ($TS-Tab-seq/test-case[@id='TC-Narr-50']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Narr-50']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Narr-51" select="if ($TS-Tab-seq/test-case[@id='TC-Narr-51']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Narr-51']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Narr-53" select="if ($TS-Tab-seq/test-case[@id='TC-Narr-53']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Narr-53']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Narr-57" select="if ($TS-Tab-seq/test-case[@id='TC-Narr-57']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Narr-57']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Narr-60" select="if ($TS-Tab-seq/test-case[@id='TC-Narr-60']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Narr-60']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Narr-62" select="if ($TS-Tab-seq/test-case[@id='TC-Narr-62']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Narr-62']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-FixedText" select="if ($TS-Tab-seq/test-case[@id='TC-FixedText']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-FixedText']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Sparse" select="if ($TS-Tab-seq/test-case[@id='TC-Sparse']/@rating) then concat(' (', $TS-Tab-seq/test-case[@id='TC-Sparse']/@rating, ')') else $rating-TS-Tab " />
  <xsl:variable name="rating-TC-Types-40" select="if ($TS-AddrDG-seq/test-case[@id='TC-Types-40']/@rating) then concat(' (', $TS-AddrDG-seq/test-case[@id='TC-Types-40']/@rating, ')') else $rating-TS-AddrDG " />
  <xsl:variable name="rating-alt-TC-Types-40" select="if ($TS-AddrDG-alt-seq/test-case[@id='TC-Types-40']/@rating) then concat(' (', $TS-AddrDG-alt-seq/test-case[@id='TC-Types-40']/@rating, ')') else $rating-alt-TS-AddrDG " />
  <xsl:variable name="rating-TC-Types-41" select="if ($TS-AddrDG-seq/test-case[@id='TC-Types-41']/@rating) then concat(' (', $TS-AddrDG-seq/test-case[@id='TC-Types-41']/@rating, ')') else $rating-TS-AddrDG " />
  <xsl:variable name="rating-alt-TC-Types-41" select="if ($TS-AddrDG-alt-seq/test-case[@id='TC-Types-41']/@rating) then concat(' (', $TS-AddrDG-alt-seq/test-case[@id='TC-Types-41']/@rating, ')') else $rating-alt-TS-AddrDG " />
  <xsl:variable name="rating-TC-Types-42" select="if ($TS-AddrDG-seq/test-case[@id='TC-Types-42']/@rating) then concat(' (', $TS-AddrDG-seq/test-case[@id='TC-Types-42']/@rating, ')') else $rating-TS-AddrDG " />
  <xsl:variable name="rating-alt-TC-Types-42" select="if ($TS-AddrDG-alt-seq/test-case[@id='TC-Types-42']/@rating) then concat(' (', $TS-AddrDG-alt-seq/test-case[@id='TC-Types-42']/@rating, ')') else $rating-alt-TS-AddrDG " />
  <xsl:variable name="rating-TC-Types-43" select="if ($TS-AddrDG-seq/test-case[@id='TC-Types-43']/@rating) then concat(' (', $TS-AddrDG-seq/test-case[@id='TC-Types-43']/@rating, ')') else $rating-TS-AddrDG " />
  <xsl:variable name="rating-alt-TC-Types-43" select="if ($TS-AddrDG-alt-seq/test-case[@id='TC-Types-43']/@rating) then concat(' (', $TS-AddrDG-alt-seq/test-case[@id='TC-Types-43']/@rating, ')') else $rating-alt-TS-AddrDG " />
  <xsl:variable name="rating-TC-Types-01" select="if ($TS-BTB-seq/test-case[@id='TC-Types-01']/@rating) then concat(' (', $TS-BTB-seq/test-case[@id='TC-Types-01']/@rating, ')') else $rating-TS-BTB " />
  <xsl:variable name="rating-alt-TC-Types-01" select="if ($TS-BTB-alt-seq/test-case[@id='TC-Types-01']/@rating) then concat(' (', $TS-BTB-alt-seq/test-case[@id='TC-Types-01']/@rating, ')') else $rating-alt-TS-BTB " />
  <xsl:variable name="rating-TC-Types-02" select="if ($TS-BTB-seq/test-case[@id='TC-Types-02']/@rating) then concat(' (', $TS-BTB-seq/test-case[@id='TC-Types-02']/@rating, ')') else $rating-TS-BTB " />
  <xsl:variable name="rating-alt-TC-Types-02" select="if ($TS-BTB-alt-seq/test-case[@id='TC-Types-02']/@rating) then concat(' (', $TS-BTB-alt-seq/test-case[@id='TC-Types-02']/@rating, ')') else $rating-alt-TS-BTB " />
  <xsl:variable name="rating-TC-Types-03" select="if ($TS-BTB-seq/test-case[@id='TC-Types-03']/@rating) then concat(' (', $TS-BTB-seq/test-case[@id='TC-Types-03']/@rating, ')') else $rating-TS-BTB " />
  <xsl:variable name="rating-alt-TC-Types-03" select="if ($TS-BTB-alt-seq/test-case[@id='TC-Types-03']/@rating) then concat(' (', $TS-BTB-alt-seq/test-case[@id='TC-Types-03']/@rating, ')') else $rating-alt-TS-BTB " />
  <xsl:variable name="rating-TC-Types-110" select="if ($TS-Class-seq/test-case[@id='TC-Types-110']/@rating) then concat(' (', $TS-Class-seq/test-case[@id='TC-Types-110']/@rating, ')') else $rating-TS-Class " />
  <xsl:variable name="rating-alt-TC-Types-110" select="if ($TS-Class-alt-seq/test-case[@id='TC-Types-110']/@rating) then concat(' (', $TS-Class-alt-seq/test-case[@id='TC-Types-110']/@rating, ')') else $rating-alt-TS-Class " />
  <xsl:variable name="rating-TC-Types-04-step-1" select="if ($TS-Coded-seq/test-case[@id='TC-Types-04-step-1']/@rating) then concat(' (', $TS-Coded-seq/test-case[@id='TC-Types-04-step-1']/@rating, ')') else $rating-TS-Coded " />
  <xsl:variable name="rating-alt-TC-Types-04-step-1" select="if ($TS-Coded-alt-seq/test-case[@id='TC-Types-04-step-1']/@rating) then concat(' (', $TS-Coded-alt-seq/test-case[@id='TC-Types-04-step-1']/@rating, ')') else $rating-alt-TS-Coded " />
  <xsl:variable name="rating-TC-Types-04-step-2" select="if ($TS-Coded-seq/test-case[@id='TC-Types-04-step-2']/@rating) then concat(' (', $TS-Coded-seq/test-case[@id='TC-Types-04-step-2']/@rating, ')') else $rating-TS-Coded " />
  <xsl:variable name="rating-alt-TC-Types-04-step-2" select="if ($TS-Coded-alt-seq/test-case[@id='TC-Types-04-step-2']/@rating) then concat(' (', $TS-Coded-alt-seq/test-case[@id='TC-Types-04-step-2']/@rating, ')') else $rating-alt-TS-Coded " />
  <xsl:variable name="rating-TC-Types-06-step-1" select="if ($TS-Coded-seq/test-case[@id='TC-Types-06-step-1']/@rating) then concat(' (', $TS-Coded-seq/test-case[@id='TC-Types-06-step-1']/@rating, ')') else $rating-TS-Coded " />
  <xsl:variable name="rating-alt-TC-Types-06-step-1" select="if ($TS-Coded-alt-seq/test-case[@id='TC-Types-06-step-1']/@rating) then concat(' (', $TS-Coded-alt-seq/test-case[@id='TC-Types-06-step-1']/@rating, ')') else $rating-alt-TS-Coded " />
  <xsl:variable name="rating-TC-Types-06-step-2" select="if ($TS-Coded-seq/test-case[@id='TC-Types-06-step-2']/@rating) then concat(' (', $TS-Coded-seq/test-case[@id='TC-Types-06-step-2']/@rating, ')') else $rating-TS-Coded " />
  <xsl:variable name="rating-alt-TC-Types-06-step-2" select="if ($TS-Coded-alt-seq/test-case[@id='TC-Types-06-step-2']/@rating) then concat(' (', $TS-Coded-alt-seq/test-case[@id='TC-Types-06-step-2']/@rating, ')') else $rating-alt-TS-Coded " />
  <xsl:variable name="rating-TC-Types-07-step-1" select="if ($TS-Coded-seq/test-case[@id='TC-Types-07-step-1']/@rating) then concat(' (', $TS-Coded-seq/test-case[@id='TC-Types-07-step-1']/@rating, ')') else $rating-TS-Coded " />
  <xsl:variable name="rating-alt-TC-Types-07-step-1" select="if ($TS-Coded-alt-seq/test-case[@id='TC-Types-07-step-1']/@rating) then concat(' (', $TS-Coded-alt-seq/test-case[@id='TC-Types-07-step-1']/@rating, ')') else $rating-alt-TS-Coded " />
  <xsl:variable name="rating-TC-Types-07-step-2" select="if ($TS-Coded-seq/test-case[@id='TC-Types-07-step-2']/@rating) then concat(' (', $TS-Coded-seq/test-case[@id='TC-Types-07-step-2']/@rating, ')') else $rating-TS-Coded " />
  <xsl:variable name="rating-alt-TC-Types-07-step-2" select="if ($TS-Coded-alt-seq/test-case[@id='TC-Types-07-step-2']/@rating) then concat(' (', $TS-Coded-alt-seq/test-case[@id='TC-Types-07-step-2']/@rating, ')') else $rating-alt-TS-Coded " />
  <xsl:variable name="rating-TC-Types-08" select="if ($TS-Coded-seq/test-case[@id='TC-Types-08']/@rating) then concat(' (', $TS-Coded-seq/test-case[@id='TC-Types-08']/@rating, ')') else $rating-TS-Coded " />
  <xsl:variable name="rating-alt-TC-Types-08" select="if ($TS-Coded-alt-seq/test-case[@id='TC-Types-08']/@rating) then concat(' (', $TS-Coded-alt-seq/test-case[@id='TC-Types-08']/@rating, ')') else $rating-alt-TS-Coded " />
  <xsl:variable name="rating-TC-Types-21" select="if ($TS-Cont-seq/test-case[@id='TC-Types-21']/@rating) then concat(' (', $TS-Cont-seq/test-case[@id='TC-Types-21']/@rating, ')') else $rating-TS-Cont " />
  <xsl:variable name="rating-alt-TC-Types-21" select="if ($TS-Cont-alt-seq/test-case[@id='TC-Types-21']/@rating) then concat(' (', $TS-Cont-alt-seq/test-case[@id='TC-Types-21']/@rating, ')') else $rating-alt-TS-Cont " />
  <xsl:variable name="rating-TC-Types-22" select="if ($TS-Cont-seq/test-case[@id='TC-Types-22']/@rating) then concat(' (', $TS-Cont-seq/test-case[@id='TC-Types-22']/@rating, ')') else $rating-TS-Cont " />
  <xsl:variable name="rating-alt-TC-Types-22" select="if ($TS-Cont-alt-seq/test-case[@id='TC-Types-22']/@rating) then concat(' (', $TS-Cont-alt-seq/test-case[@id='TC-Types-22']/@rating, ')') else $rating-alt-TS-Cont " />
  <xsl:variable name="rating-TC-Types-23-step-1" select="if ($TS-EntId-seq/test-case[@id='TC-Types-23-step-1']/@rating) then concat(' (', $TS-EntId-seq/test-case[@id='TC-Types-23-step-1']/@rating, ')') else $rating-TS-EntId " />
  <xsl:variable name="rating-alt-TC-Types-23-step-1" select="if ($TS-EntId-alt-seq/test-case[@id='TC-Types-23-step-1']/@rating) then concat(' (', $TS-EntId-alt-seq/test-case[@id='TC-Types-23-step-1']/@rating, ')') else $rating-alt-TS-EntId " />
  <xsl:variable name="rating-TC-Types-23-step-2" select="if ($TS-EntId-seq/test-case[@id='TC-Types-23-step-2']/@rating) then concat(' (', $TS-EntId-seq/test-case[@id='TC-Types-23-step-2']/@rating, ')') else $rating-TS-EntId " />
  <xsl:variable name="rating-alt-TC-Types-23-step-2" select="if ($TS-EntId-alt-seq/test-case[@id='TC-Types-23-step-2']/@rating) then concat(' (', $TS-EntId-alt-seq/test-case[@id='TC-Types-23-step-2']/@rating, ')') else $rating-alt-TS-EntId " />
  <xsl:variable name="rating-TC-Types-24" select="if ($TS-EntId-seq/test-case[@id='TC-Types-24']/@rating) then concat(' (', $TS-EntId-seq/test-case[@id='TC-Types-24']/@rating, ')') else $rating-TS-EntId " />
  <xsl:variable name="rating-alt-TC-Types-24" select="if ($TS-EntId-alt-seq/test-case[@id='TC-Types-24']/@rating) then concat(' (', $TS-EntId-alt-seq/test-case[@id='TC-Types-24']/@rating, ')') else $rating-alt-TS-EntId " />
  <xsl:variable name="rating-TC-Types-25" select="if ($TS-EntId-seq/test-case[@id='TC-Types-25']/@rating) then concat(' (', $TS-EntId-seq/test-case[@id='TC-Types-25']/@rating, ')') else $rating-TS-EntId " />
  <xsl:variable name="rating-alt-TC-Types-25" select="if ($TS-EntId-alt-seq/test-case[@id='TC-Types-25']/@rating) then concat(' (', $TS-EntId-alt-seq/test-case[@id='TC-Types-25']/@rating, ')') else $rating-alt-TS-EntId " />
  <xsl:variable name="rating-TC-Types-28" select="if ($TS-EntId-seq/test-case[@id='TC-Types-28']/@rating) then concat(' (', $TS-EntId-seq/test-case[@id='TC-Types-28']/@rating, ')') else $rating-TS-EntId " />
  <xsl:variable name="rating-alt-TC-Types-28" select="if ($TS-EntId-alt-seq/test-case[@id='TC-Types-28']/@rating) then concat(' (', $TS-EntId-alt-seq/test-case[@id='TC-Types-28']/@rating, ')') else $rating-alt-TS-EntId " />
  <xsl:variable name="rating-TC-Types-29" select="if ($TS-EntId-seq/test-case[@id='TC-Types-29']/@rating) then concat(' (', $TS-EntId-seq/test-case[@id='TC-Types-29']/@rating, ')') else $rating-TS-EntId " />
  <xsl:variable name="rating-alt-TC-Types-29" select="if ($TS-EntId-alt-seq/test-case[@id='TC-Types-29']/@rating) then concat(' (', $TS-EntId-alt-seq/test-case[@id='TC-Types-29']/@rating, ')') else $rating-alt-TS-EntId " />
  <xsl:variable name="rating-TC-Types-30" select="if ($TS-EntId-seq/test-case[@id='TC-Types-30']/@rating) then concat(' (', $TS-EntId-seq/test-case[@id='TC-Types-30']/@rating, ')') else $rating-TS-EntId " />
  <xsl:variable name="rating-alt-TC-Types-30" select="if ($TS-EntId-alt-seq/test-case[@id='TC-Types-30']/@rating) then concat(' (', $TS-EntId-alt-seq/test-case[@id='TC-Types-30']/@rating, ')') else $rating-alt-TS-EntId " />
  <xsl:variable name="rating-TC-Types-33" select="if ($TS-Entit-seq/test-case[@id='TC-Types-33']/@rating) then concat(' (', $TS-Entit-seq/test-case[@id='TC-Types-33']/@rating, ')') else $rating-TS-Entit " />
  <xsl:variable name="rating-alt-TC-Types-33" select="if ($TS-Entit-alt-seq/test-case[@id='TC-Types-33']/@rating) then concat(' (', $TS-Entit-alt-seq/test-case[@id='TC-Types-33']/@rating, ')') else $rating-alt-TS-Entit " />
  <xsl:variable name="rating-TC-Types-34" select="if ($TS-Entit-seq/test-case[@id='TC-Types-34']/@rating) then concat(' (', $TS-Entit-seq/test-case[@id='TC-Types-34']/@rating, ')') else $rating-TS-Entit " />
  <xsl:variable name="rating-alt-TC-Types-34" select="if ($TS-Entit-alt-seq/test-case[@id='TC-Types-34']/@rating) then concat(' (', $TS-Entit-alt-seq/test-case[@id='TC-Types-34']/@rating, ')') else $rating-alt-TS-Entit " />
  <xsl:variable name="rating-TC-Types-35" select="if ($TS-Entit-seq/test-case[@id='TC-Types-35']/@rating) then concat(' (', $TS-Entit-seq/test-case[@id='TC-Types-35']/@rating, ')') else $rating-TS-Entit " />
  <xsl:variable name="rating-alt-TC-Types-35" select="if ($TS-Entit-alt-seq/test-case[@id='TC-Types-35']/@rating) then concat(' (', $TS-Entit-alt-seq/test-case[@id='TC-Types-35']/@rating, ')') else $rating-alt-TS-Entit " />
  <xsl:variable name="rating-TC-Types-36" select="if ($TS-Entit-seq/test-case[@id='TC-Types-36']/@rating) then concat(' (', $TS-Entit-seq/test-case[@id='TC-Types-36']/@rating, ')') else $rating-TS-Entit " />
  <xsl:variable name="rating-alt-TC-Types-36" select="if ($TS-Entit-alt-seq/test-case[@id='TC-Types-36']/@rating) then concat(' (', $TS-Entit-alt-seq/test-case[@id='TC-Types-36']/@rating, ')') else $rating-alt-TS-Entit " />
  <xsl:variable name="rating-TC-Types-37" select="if ($TS-Entit-seq/test-case[@id='TC-Types-37']/@rating) then concat(' (', $TS-Entit-seq/test-case[@id='TC-Types-37']/@rating, ')') else $rating-TS-Entit " />
  <xsl:variable name="rating-alt-TC-Types-37" select="if ($TS-Entit-alt-seq/test-case[@id='TC-Types-37']/@rating) then concat(' (', $TS-Entit-alt-seq/test-case[@id='TC-Types-37']/@rating, ')') else $rating-alt-TS-Entit " />
  <xsl:variable name="rating-TC-Types-38" select="if ($TS-Entit-seq/test-case[@id='TC-Types-38']/@rating) then concat(' (', $TS-Entit-seq/test-case[@id='TC-Types-38']/@rating, ')') else $rating-TS-Entit " />
  <xsl:variable name="rating-alt-TC-Types-38" select="if ($TS-Entit-alt-seq/test-case[@id='TC-Types-38']/@rating) then concat(' (', $TS-Entit-alt-seq/test-case[@id='TC-Types-38']/@rating, ')') else $rating-alt-TS-Entit " />
  <xsl:variable name="rating-TC-Types-39" select="if ($TS-Entit-seq/test-case[@id='TC-Types-39']/@rating) then concat(' (', $TS-Entit-seq/test-case[@id='TC-Types-39']/@rating, ')') else $rating-TS-Entit " />
  <xsl:variable name="rating-alt-TC-Types-39" select="if ($TS-Entit-alt-seq/test-case[@id='TC-Types-39']/@rating) then concat(' (', $TS-Entit-alt-seq/test-case[@id='TC-Types-39']/@rating, ')') else $rating-alt-TS-Entit " />
  <xsl:variable name="rating-TC-Types-10" select="if ($TS-IL-seq/test-case[@id='TC-Types-10']/@rating) then concat(' (', $TS-IL-seq/test-case[@id='TC-Types-10']/@rating, ')') else $rating-TS-IL " />
  <xsl:variable name="rating-alt-TC-Types-10" select="if ($TS-IL-alt-seq/test-case[@id='TC-Types-10']/@rating) then concat(' (', $TS-IL-alt-seq/test-case[@id='TC-Types-10']/@rating, ')') else $rating-alt-TS-IL " />
  <xsl:variable name="rating-TC-Types-11" select="if ($TS-IL-seq/test-case[@id='TC-Types-11']/@rating) then concat(' (', $TS-IL-seq/test-case[@id='TC-Types-11']/@rating, ')') else $rating-TS-IL " />
  <xsl:variable name="rating-alt-TC-Types-11" select="if ($TS-IL-alt-seq/test-case[@id='TC-Types-11']/@rating) then concat(' (', $TS-IL-alt-seq/test-case[@id='TC-Types-11']/@rating, ')') else $rating-alt-TS-IL " />
  <xsl:variable name="rating-TC-Types-98" select="if ($TS-PQ.TIME-seq/test-case[@id='TC-Types-98']/@rating) then concat(' (', $TS-PQ.TIME-seq/test-case[@id='TC-Types-98']/@rating, ')') else $rating-TS-PQ.TIME " />
  <xsl:variable name="rating-alt-TC-Types-98" select="if ($TS-PQ.TIME-alt-seq/test-case[@id='TC-Types-98']/@rating) then concat(' (', $TS-PQ.TIME-alt-seq/test-case[@id='TC-Types-98']/@rating, ')') else $rating-alt-TS-PQ.TIME " />
  <xsl:variable name="rating-TC-Types-13" select="if ($TS-Quant-seq/test-case[@id='TC-Types-13']/@rating) then concat(' (', $TS-Quant-seq/test-case[@id='TC-Types-13']/@rating, ')') else $rating-TS-Quant " />
  <xsl:variable name="rating-alt-TC-Types-13" select="if ($TS-Quant-alt-seq/test-case[@id='TC-Types-13']/@rating) then concat(' (', $TS-Quant-alt-seq/test-case[@id='TC-Types-13']/@rating, ')') else $rating-alt-TS-Quant " />
  <xsl:variable name="rating-TC-Types-14" select="if ($TS-Quant-seq/test-case[@id='TC-Types-14']/@rating) then concat(' (', $TS-Quant-seq/test-case[@id='TC-Types-14']/@rating, ')') else $rating-TS-Quant " />
  <xsl:variable name="rating-alt-TC-Types-14" select="if ($TS-Quant-alt-seq/test-case[@id='TC-Types-14']/@rating) then concat(' (', $TS-Quant-alt-seq/test-case[@id='TC-Types-14']/@rating, ')') else $rating-alt-TS-Quant " />
  <xsl:variable name="rating-TC-Types-15" select="if ($TS-Quant-seq/test-case[@id='TC-Types-15']/@rating) then concat(' (', $TS-Quant-seq/test-case[@id='TC-Types-15']/@rating, ')') else $rating-TS-Quant " />
  <xsl:variable name="rating-alt-TC-Types-15" select="if ($TS-Quant-alt-seq/test-case[@id='TC-Types-15']/@rating) then concat(' (', $TS-Quant-alt-seq/test-case[@id='TC-Types-15']/@rating, ')') else $rating-alt-TS-Quant " />
  <xsl:variable name="rating-TC-Types-16" select="if ($TS-Quant-seq/test-case[@id='TC-Types-16']/@rating) then concat(' (', $TS-Quant-seq/test-case[@id='TC-Types-16']/@rating, ')') else $rating-TS-Quant " />
  <xsl:variable name="rating-alt-TC-Types-16" select="if ($TS-Quant-alt-seq/test-case[@id='TC-Types-16']/@rating) then concat(' (', $TS-Quant-alt-seq/test-case[@id='TC-Types-16']/@rating, ')') else $rating-alt-TS-Quant " />
  <xsl:variable name="rating-TC-Types-17" select="if ($TS-Quant-seq/test-case[@id='TC-Types-17']/@rating) then concat(' (', $TS-Quant-seq/test-case[@id='TC-Types-17']/@rating, ')') else $rating-TS-Quant " />
  <xsl:variable name="rating-alt-TC-Types-17" select="if ($TS-Quant-alt-seq/test-case[@id='TC-Types-17']/@rating) then concat(' (', $TS-Quant-alt-seq/test-case[@id='TC-Types-17']/@rating, ')') else $rating-alt-TS-Quant " />
  <xsl:variable name="rating-TC-Types-18" select="if ($TS-Quant-seq/test-case[@id='TC-Types-18']/@rating) then concat(' (', $TS-Quant-seq/test-case[@id='TC-Types-18']/@rating, ')') else $rating-TS-Quant " />
  <xsl:variable name="rating-alt-TC-Types-18" select="if ($TS-Quant-alt-seq/test-case[@id='TC-Types-18']/@rating) then concat(' (', $TS-Quant-alt-seq/test-case[@id='TC-Types-18']/@rating, ')') else $rating-alt-TS-Quant " />
  <xsl:variable name="rating-TC-Types-50" select="if ($TS-BL-seq/test-case[@id='TC-Types-50']/@rating) then concat(' (', $TS-BL-seq/test-case[@id='TC-Types-50']/@rating, ')') else $rating-TS-BL " />
  <xsl:variable name="rating-alt-TC-Types-50" select="if ($TS-BL-alt-seq/test-case[@id='TC-Types-50']/@rating) then concat(' (', $TS-BL-alt-seq/test-case[@id='TC-Types-50']/@rating, ')') else $rating-alt-TS-BL " />
  <xsl:variable name="rating-TC-Types-57" select="if ($TS-CD-seq/test-case[@id='TC-Types-57' and @context='default']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-57' and @context='default']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-container-TC-Types-57" select="if ($TS-CD-seq/test-case[@id='TC-Types-57' and @context='container']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-57' and @context='container']/@rating, ')') else $rating-TC-Types-57 " />
  <xsl:variable name="rating-alt-TC-Types-57" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-57' and @context='default']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-57' and @context='default']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-med-TC-Types-57" select="if ($TS-CD-seq/test-case[@id='TC-Types-57' and @context='medium']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-57' and @context='medium']/@rating, ')') else $rating-TC-Types-57 " />
  <xsl:variable name="rating-med-alt-TC-Types-57" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-57' and @context='medium']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-57' and @context='medium']/@rating, ')') else $rating-alt-TC-Types-57 " />
  <xsl:variable name="rating-TC-Types-58" select="if ($TS-CD-seq/test-case[@id='TC-Types-58' and @context='default']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-58' and @context='default']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-58" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-58' and @context='default']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-58' and @context='default']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-dn-no-code-TC-Types-58" select="if ($TS-CD-seq/test-case[@id='TC-Types-58' and @context='displayName-no-code']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-58' and @context='displayName-no-code']/@rating, ')') else $rating-TC-Types-58 " />
  <xsl:variable name="rating-dn-no-code-alt-TC-Types-58" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-58' and @context='displayName-no-code']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-58' and @context='displayName-no-code']/@rating, ')') else $rating-alt-TC-Types-58 " />
  <xsl:variable name="rating-TC-Types-59" select="if ($TS-CD-seq/test-case[@id='TC-Types-59' and @context='default']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-59' and @context='default']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-59" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-59' and @context='default']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-59' and @context='default']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-inactive-TC-Types-59" select="if ($TS-CD-seq/test-case[@id='TC-Types-59' and @context='inactive']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-59' and @context='inactive']/@rating, ')') else $rating-TC-Types-59 " />
  <xsl:variable name="rating-inactive-alt-TC-Types-59" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-59' and @context='inactive']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-59' and @context='inactive']/@rating, ')') else $rating-alt-TC-Types-59 " />
  <xsl:variable name="rating-TC-Types-60" select="if ($TS-CD-seq/test-case[@id='TC-Types-60']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-60']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-60" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-60']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-60']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-61" select="if ($TS-CD-seq/test-case[@id='TC-Types-61']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-61']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-61" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-61']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-61']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-62" select="if ($TS-CD-seq/test-case[@id='TC-Types-62']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-62']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-62" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-62']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-62']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-63" select="if ($TS-CD-seq/test-case[@id='TC-Types-63' and @context='default']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-63' and @context='default']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-old-TC-Types-63" select="if ($TS-CD-seq/test-case[@id='TC-Types-63' and @context='old']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-63' and @context='old']/@rating, ')') else $rating-TC-Types-63 " />
  <xsl:variable name="rating-alt-TC-Types-63" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-63' and @context='default']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-63' and @context='default']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-old-alt-TC-Types-63" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-63' and @context='old']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-63' and @context='old']/@rating, ')') else $rating-alt-TC-Types-63 " />
  <xsl:variable name="rating-TC-Types-64" select="if ($TS-CD-seq/test-case[@id='TC-Types-64']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-64']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-64" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-64']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-64']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-65" select="if ($TS-CD-seq/test-case[@id='TC-Types-65' and @context='default']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-65' and @context='default']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-high-TC-Types-65" select="if ($TS-CD-seq/test-case[@id='TC-Types-65' and @context='high']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-65' and @context='high']/@rating, ')') else $rating-TC-Types-65 " />
  <xsl:variable name="rating-medium-TC-Types-65" select="if ($TS-CD-seq/test-case[@id='TC-Types-65' and @context='medium']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-65' and @context='medium']/@rating, ')') else $rating-TC-Types-65 " />
  <xsl:variable name="rating-low-TC-Types-65" select="if ($TS-CD-seq/test-case[@id='TC-Types-65' and @context='low']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-65' and @context='low']/@rating, ')') else $rating-TC-Types-65 " />
  <xsl:variable name="rating-alt-TC-Types-65" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-65' and @context='default']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-65' and @context='default']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-66-step-1" select="if ($TS-CD-seq/test-case[@id='TC-Types-66-step-1' and @context='default']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-66-step-1' and @context='default']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-66-step-1" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-66-step-1' and @context='default']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-66-step-1' and @context='default']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-trans-TC-Types-66-step-1" select="if ($TS-CD-seq/test-case[@id='TC-Types-66-step-1' and @context='translation']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-66-step-1' and @context='translation']/@rating, ')') else $rating-TC-Types-66-step-1 " />
  <xsl:variable name="rating-trans-alt-TC-Types-66-step-1" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-66-step-1' and @context='translation']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-66-step-1' and @context='translation']/@rating, ')') else $rating-alt-TC-Types-66-step-1 " />
  <xsl:variable name="rating-TC-Types-66-step-2" select="if ($TS-CD-seq/test-case[@id='TC-Types-66-step-2']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-66-step-2']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-66-step-2" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-66-step-2']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-66-step-2']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-67-step-1" select="if ($TS-CD-seq/test-case[@id='TC-Types-67-step-1']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-67-step-1']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-67-step-1" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-67-step-1']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-67-step-1']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-67-step-2" select="if ($TS-CD-seq/test-case[@id='TC-Types-67-step-2']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-67-step-2']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-67-step-2" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-67-step-2']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-67-step-2']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-68" select="if ($TS-CD-seq/test-case[@id='TC-Types-68']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-Types-68']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-Types-68" select="if ($TS-CD-alt-seq/test-case[@id='TC-Types-68']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-Types-68']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-CD-Version" select="if ($TS-CD-seq/test-case[@id='TC-CD-Version']/@rating) then concat(' (', $TS-CD-seq/test-case[@id='TC-CD-Version']/@rating, ')') else $rating-TS-CD " />
  <xsl:variable name="rating-alt-TC-CD-Version" select="if ($TS-CD-alt-seq/test-case[@id='TC-CD-Version']/@rating) then concat(' (', $TS-CD-alt-seq/test-case[@id='TC-CD-Version']/@rating, ')') else $rating-alt-TS-CD " />
  <xsl:variable name="rating-TC-Types-115" select="if ($TS-CS-seq/test-case[@id='TC-Types-115']/@rating) then concat(' (', $TS-CS-seq/test-case[@id='TC-Types-115']/@rating, ')') else $rating-TS-CS " />
  <xsl:variable name="rating-alt-TC-Types-115" select="if ($TS-CS-alt-seq/test-case[@id='TC-Types-115']/@rating) then concat(' (', $TS-CS-alt-seq/test-case[@id='TC-Types-115']/@rating, ')') else $rating-alt-TS-CS " />
  <xsl:variable name="rating-TC-Types-116" select="if ($TS-CS-seq/test-case[@id='TC-Types-116']/@rating) then concat(' (', $TS-CS-seq/test-case[@id='TC-Types-116']/@rating, ')') else $rating-TS-CS " />
  <xsl:variable name="rating-alt-TC-Types-116" select="if ($TS-CS-alt-seq/test-case[@id='TC-Types-116']/@rating) then concat(' (', $TS-CS-alt-seq/test-case[@id='TC-Types-116']/@rating, ')') else $rating-alt-TS-CS " />
  <xsl:variable name="rating-TC-Types-51" select="if ($TS-ED-seq/test-case[@id='TC-Types-51']/@rating) then concat(' (', $TS-ED-seq/test-case[@id='TC-Types-51']/@rating, ')') else $rating-TS-ED " />
  <xsl:variable name="rating-alt-TC-Types-51" select="if ($TS-ED-alt-seq/test-case[@id='TC-Types-51']/@rating) then concat(' (', $TS-ED-alt-seq/test-case[@id='TC-Types-51']/@rating, ')') else $rating-alt-TS-ED " />
  <xsl:variable name="rating-TC-Types-52" select="if ($TS-ED-seq/test-case[@id='TC-Types-52']/@rating) then concat(' (', $TS-ED-seq/test-case[@id='TC-Types-52']/@rating, ')') else $rating-TS-ED " />
  <xsl:variable name="rating-alt-TC-Types-52" select="if ($TS-ED-alt-seq/test-case[@id='TC-Types-52']/@rating) then concat(' (', $TS-ED-alt-seq/test-case[@id='TC-Types-52']/@rating, ')') else $rating-alt-TS-ED " />
  <xsl:variable name="rating-TC-Types-53" select="if ($TS-ED-seq/test-case[@id='TC-Types-53']/@rating) then concat(' (', $TS-ED-seq/test-case[@id='TC-Types-53']/@rating, ')') else $rating-TS-ED " />
  <xsl:variable name="rating-alt-TC-Types-53" select="if ($TS-ED-alt-seq/test-case[@id='TC-Types-53']/@rating) then concat(' (', $TS-ED-alt-seq/test-case[@id='TC-Types-53']/@rating, ')') else $rating-alt-TS-ED " />
  <xsl:variable name="rating-TC-Types-54" select="if ($TS-ED-seq/test-case[@id='TC-Types-54']/@rating) then concat(' (', $TS-ED-seq/test-case[@id='TC-Types-54']/@rating, ')') else $rating-TS-ED " />
  <xsl:variable name="rating-alt-TC-Types-54" select="if ($TS-ED-alt-seq/test-case[@id='TC-Types-54']/@rating) then concat(' (', $TS-ED-alt-seq/test-case[@id='TC-Types-54']/@rating, ')') else $rating-alt-TS-ED " />
  <xsl:variable name="rating-TC-Types-70" select="if ($TS-II-seq/test-case[@id='TC-Types-70']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-70']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-70" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-70']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-70']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-71" select="if ($TS-II-seq/test-case[@id='TC-Types-71']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-71']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-71" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-71']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-71']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-72" select="if ($TS-II-seq/test-case[@id='TC-Types-72']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-72']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-72" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-72']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-72']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-73" select="if ($TS-II-seq/test-case[@id='TC-Types-73']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-73']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-73" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-73']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-73']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-74" select="if ($TS-II-seq/test-case[@id='TC-Types-74']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-74']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-74" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-74']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-74']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-75-step-1" select="if ($TS-II-seq/test-case[@id='TC-Types-75-step-1']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-75-step-1']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-75-step-1" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-75-step-1' and @context='default']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-75-step-1' and @context='default']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-tech-alt-TC-Types-75-step-1" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-75-step-1' and @context='tech-id']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-75-step-1' and @context='tech-id']/@rating, ')') else $rating-alt-TC-Types-75-step-1 " />
  <xsl:variable name="rating-TC-Types-75-step-2" select="if ($TS-II-seq/test-case[@id='TC-Types-75-step-2']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-75-step-2']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-75-step-2" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-75-step-2']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-75-step-2']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-76" select="if ($TS-II-seq/test-case[@id='TC-Types-76']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-76']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-76" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-76']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-76']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-77" select="if ($TS-II-seq/test-case[@id='TC-Types-77']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-77']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-77" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-77']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-77']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-78" select="if ($TS-II-seq/test-case[@id='TC-Types-78']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-78']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-78" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-78']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-78']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-79" select="if ($TS-II-seq/test-case[@id='TC-Types-79']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-79']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-79" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-79']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-79']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-80" select="if ($TS-II-seq/test-case[@id='TC-Types-80']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-80']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-80" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-80']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-80']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-81" select="if ($TS-II-seq/test-case[@id='TC-Types-81']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-81']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-81" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-81']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-81']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-82" select="if ($TS-II-seq/test-case[@id='TC-Types-82']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-82']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-82" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-82']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-82']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-83" select="if ($TS-II-seq/test-case[@id='TC-Types-83']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-83']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-83" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-83']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-83']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-84" select="if ($TS-II-seq/test-case[@id='TC-Types-84']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-84']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-84" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-84']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-84']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-85" select="if ($TS-II-seq/test-case[@id='TC-Types-85']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-85']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-85" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-85']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-85']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-86" select="if ($TS-II-seq/test-case[@id='TC-Types-86']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-86']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-86" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-86']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-86']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-87" select="if ($TS-II-seq/test-case[@id='TC-Types-87']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-87']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-87" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-87']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-87']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-88" select="if ($TS-II-seq/test-case[@id='TC-Types-88']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-88']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-88" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-88']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-88']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-89" select="if ($TS-II-seq/test-case[@id='TC-Types-89']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-89']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-89" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-89']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-89']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-90" select="if ($TS-II-seq/test-case[@id='TC-Types-90']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-90']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-90" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-90']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-90']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-91" select="if ($TS-II-seq/test-case[@id='TC-Types-91']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-91']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-91" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-91']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-91']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-92" select="if ($TS-II-seq/test-case[@id='TC-Types-92']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-92']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-92" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-92']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-92']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-111" select="if ($TS-II-seq/test-case[@id='TC-Types-111']/@rating) then concat(' (', $TS-II-seq/test-case[@id='TC-Types-111']/@rating, ')') else $rating-TS-II " />
  <xsl:variable name="rating-alt-TC-Types-111" select="if ($TS-II-alt-seq/test-case[@id='TC-Types-111']/@rating) then concat(' (', $TS-II-alt-seq/test-case[@id='TC-Types-111']/@rating, ')') else $rating-alt-TS-II " />
  <xsl:variable name="rating-TC-Types-95" select="if ($TS-INT-seq/test-case[@id='TC-Types-95']/@rating) then concat(' (', $TS-INT-seq/test-case[@id='TC-Types-95']/@rating, ')') else $rating-TS-INT " />
  <xsl:variable name="rating-alt-TC-Types-95" select="if ($TS-INT-alt-seq/test-case[@id='TC-Types-95']/@rating) then concat(' (', $TS-INT-alt-seq/test-case[@id='TC-Types-95']/@rating, ')') else $rating-alt-TS-INT " />
  <xsl:variable name="rating-TC-Types-102" select="if ($TS-IVL-seq/test-case[@id='TC-Types-102']/@rating) then concat(' (', $TS-IVL-seq/test-case[@id='TC-Types-102']/@rating, ')') else $rating-TS-IVL " />
  <xsl:variable name="rating-alt-TC-Types-102" select="if ($TS-IVL-alt-seq/test-case[@id='TC-Types-102']/@rating) then concat(' (', $TS-IVL-alt-seq/test-case[@id='TC-Types-102']/@rating, ')') else $rating-alt-TS-IVL " />
  <xsl:variable name="rating-TC-Types-103" select="if ($TS-IVL-seq/test-case[@id='TC-Types-103' and @context='default']/@rating) then concat(' (', $TS-IVL-seq/test-case[@id='TC-Types-103' and @context='default']/@rating, ')') else $rating-TS-IVL " />
  <xsl:variable name="rating-alt-TC-Types-103" select="if ($TS-IVL-alt-seq/test-case[@id='TC-Types-103' and @context='default']/@rating) then concat(' (', $TS-IVL-alt-seq/test-case[@id='TC-Types-103' and @context='default']/@rating, ')') else $rating-alt-TS-IVL " />
  <xsl:variable name="rating-eq-TC-Types-103" select="if ($TS-IVL-seq/test-case[@id='TC-Types-103' and @context='equal']/@rating) then concat(' (', $TS-IVL-seq/test-case[@id='TC-Types-103' and @context='equal']/@rating, ')') else $rating-TC-Types-103 " />
  <xsl:variable name="rating-eq-alt-TC-Types-103" select="if ($TS-IVL-alt-seq/test-case[@id='TC-Types-103' and @context='equal']/@rating) then concat(' (', $TS-IVL-alt-seq/test-case[@id='TC-Types-103' and @context='equal']/@rating, ')') else $rating-alt-TC-Types-103 " />
  <xsl:variable name="rating-TC-Types-104" select="if ($TS-IVL-seq/test-case[@id='TC-Types-104']/@rating) then concat(' (', $TS-IVL-seq/test-case[@id='TC-Types-104']/@rating, ')') else $rating-TS-IVL " />
  <xsl:variable name="rating-alt-TC-Types-104" select="if ($TS-IVL-alt-seq/test-case[@id='TC-Types-104']/@rating) then concat(' (', $TS-IVL-alt-seq/test-case[@id='TC-Types-104']/@rating, ')') else $rating-alt-TS-IVL " />
  <xsl:variable name="rating-TC-Types-48" select="if ($TS-NF-seq/test-case[@id='TC-Types-48']/@rating) then concat(' (', $TS-NF-seq/test-case[@id='TC-Types-48']/@rating, ')') else $rating-TS-NF " />
  <xsl:variable name="rating-alt-TC-Types-48" select="if ($TS-NF-alt-seq/test-case[@id='TC-Types-48']/@rating) then concat(' (', $TS-NF-alt-seq/test-case[@id='TC-Types-48']/@rating, ')') else $rating-alt-TS-NF " />
  <xsl:variable name="rating-TC-Types-49" select="if ($TS-NF-seq/test-case[@id='TC-Types-49']/@rating) then concat(' (', $TS-NF-seq/test-case[@id='TC-Types-49']/@rating, ')') else $rating-TS-NF " />
  <xsl:variable name="rating-alt-TC-Types-49" select="if ($TS-NF-alt-seq/test-case[@id='TC-Types-49']/@rating) then concat(' (', $TS-NF-alt-seq/test-case[@id='TC-Types-49']/@rating, ')') else $rating-alt-TS-NF " />
  <xsl:variable name="rating-TC-Types-117" select="if ($TS-PIVL-seq/test-case[@id='TC-Types-117']/@rating) then concat(' (', $TS-PIVL-seq/test-case[@id='TC-Types-117']/@rating, ')') else $rating-TS-PIVL " />
  <xsl:variable name="rating-alt-TC-Types-117" select="if ($TS-PIVL-alt-seq/test-case[@id='TC-Types-117']/@rating) then concat(' (', $TS-PIVL-alt-seq/test-case[@id='TC-Types-117']/@rating, ')') else $rating-alt-TS-PIVL " />
  <xsl:variable name="rating-TC-Types-93" select="if ($TS-PQ-seq/test-case[@id='TC-Types-93']/@rating) then concat(' (', $TS-PQ-seq/test-case[@id='TC-Types-93']/@rating, ')') else $rating-TS-PQ " />
  <xsl:variable name="rating-alt-TC-Types-93" select="if ($TS-PQ-alt-seq/test-case[@id='TC-Types-93']/@rating) then concat(' (', $TS-PQ-alt-seq/test-case[@id='TC-Types-93']/@rating, ')') else $rating-alt-TS-PQ " />
  <xsl:variable name="rating-TC-Types-94" select="if ($TS-PQ-seq/test-case[@id='TC-Types-94']/@rating) then concat(' (', $TS-PQ-seq/test-case[@id='TC-Types-94']/@rating, ')') else $rating-TS-PQ " />
  <xsl:variable name="rating-alt-TC-Types-94" select="if ($TS-PQ-alt-seq/test-case[@id='TC-Types-94']/@rating) then concat(' (', $TS-PQ-alt-seq/test-case[@id='TC-Types-94']/@rating, ')') else $rating-alt-TS-PQ " />
  <xsl:variable name="rating-TC-Types-96" select="if ($TS-REAL-seq/test-case[@id='TC-Types-96']/@rating) then concat(' (', $TS-REAL-seq/test-case[@id='TC-Types-96']/@rating, ')') else $rating-TS-REAL " />
  <xsl:variable name="rating-alt-TC-Types-96" select="if ($TS-REAL-alt-seq/test-case[@id='TC-Types-96']/@rating) then concat(' (', $TS-REAL-alt-seq/test-case[@id='TC-Types-96']/@rating, ')') else $rating-alt-TS-REAL " />
  <xsl:variable name="rating-TC-Types-97" select="if ($TS-RTO-seq/test-case[@id='TC-Types-97']/@rating) then concat(' (', $TS-RTO-seq/test-case[@id='TC-Types-97']/@rating, ')') else $rating-TS-RTO " />
  <xsl:variable name="rating-alt-TC-Types-97" select="if ($TS-RTO-alt-seq/test-case[@id='TC-Types-97']/@rating) then concat(' (', $TS-RTO-alt-seq/test-case[@id='TC-Types-97']/@rating, ')') else $rating-alt-TS-RTO " />
  <xsl:variable name="rating-TC-Types-55" select="if ($TS-ST-seq/test-case[@id='TC-Types-55' and @context='default']/@rating) then concat(' (', $TS-ST-seq/test-case[@id='TC-Types-55' and @context='default']/@rating, ')') else $rating-TS-ST " />
  <xsl:variable name="rating-alt-TC-Types-55" select="if ($TS-ST-alt-seq/test-case[@id='TC-Types-55' and @context='default']/@rating) then concat(' (', $TS-ST-alt-seq/test-case[@id='TC-Types-55' and @context='default']/@rating, ')') else $rating-alt-TS-ST " />
  <xsl:variable name="rating-ADI-TC-Types-55" select="if ($TS-ST-seq/test-case[@id='TC-Types-55' and @context='ADI']/@rating) then concat(' (', $TS-ST-seq/test-case[@id='TC-Types-55' and @context='ADI']/@rating, ')') else $rating-TC-Types-55 " />
  <xsl:variable name="rating-ADI-alt-TC-Types-55" select="if ($TS-ST-alt-seq/test-case[@id='TC-Types-55' and @context='ADI']/@rating) then concat(' (', $TS-ST-alt-seq/test-case[@id='TC-Types-55' and @context='ADI']/@rating, ')') else $rating-alt-TC-Types-55 " />
  <xsl:variable name="rating-TC-Types-56" select="if ($TS-ST-seq/test-case[@id='TC-Types-56' and @context='default']/@rating) then concat(' (', $TS-ST-seq/test-case[@id='TC-Types-56' and @context='default']/@rating, ')') else $rating-TS-ST " />
  <xsl:variable name="rating-MHRView-TC-Types-56" select="if ($TS-ST-seq/test-case[@id='TC-Types-56' and @context='MHRView']/@rating) then concat(' (', $TS-ST-seq/test-case[@id='TC-Types-56' and @context='MHRView']/@rating, ')') else $rating-TC-Types-56 " />
  <xsl:variable name="rating-alt-TC-Types-56" select="if ($TS-ST-alt-seq/test-case[@id='TC-Types-56' and @context='default']/@rating) then concat(' (', $TS-ST-alt-seq/test-case[@id='TC-Types-56' and @context='default']/@rating, ')') else $rating-alt-TS-ST " />
  <xsl:variable name="rating-MHRView-alt-TC-Types-56" select="if ($TS-ST-alt-seq/test-case[@id='TC-Types-56' and @context='MHRView']/@rating) then concat(' (', $TS-ST-alt-seq/test-case[@id='TC-Types-56' and @context='MHRView']/@rating, ')') else $rating-alt-TC-Types-56 " />
  <xsl:variable name="rating-TC-Types-118" select="if ($TS-TEL-seq/test-case[@id='TC-Types-118']/@rating) then concat(' (', $TS-TEL-seq/test-case[@id='TC-Types-118']/@rating, ')') else $rating-TS-TEL " />
  <xsl:variable name="rating-alt-TC-Types-118" select="if ($TS-TEL-alt-seq/test-case[@id='TC-Types-118']/@rating) then concat(' (', $TS-TEL-alt-seq/test-case[@id='TC-Types-118']/@rating, ')') else $rating-alt-TS-TEL " />
  <xsl:variable name="rating-TC-Types-99" select="if ($TS-TS-seq/test-case[@id='TC-Types-99']/@rating) then concat(' (', $TS-TS-seq/test-case[@id='TC-Types-99']/@rating, ')') else $rating-TS-TS " />
  <xsl:variable name="rating-alt-TC-Types-99" select="if ($TS-TS-alt-seq/test-case[@id='TC-Types-99']/@rating) then concat(' (', $TS-TS-alt-seq/test-case[@id='TC-Types-99']/@rating, ')') else $rating-alt-TS-TS " />
  <xsl:variable name="rating-TC-Types-100" select="if ($TS-TS-seq/test-case[@id='TC-Types-100']/@rating) then concat(' (', $TS-TS-seq/test-case[@id='TC-Types-100']/@rating, ')') else $rating-TS-TS " />
  <xsl:variable name="rating-alt-TC-Types-100" select="if ($TS-TS-alt-seq/test-case[@id='TC-Types-100']/@rating) then concat(' (', $TS-TS-alt-seq/test-case[@id='TC-Types-100']/@rating, ')') else $rating-alt-TS-TS " />
  <xsl:variable name="rating-TC-Types-101" select="if ($TS-TS-seq/test-case[@id='TC-Types-101']/@rating) then concat(' (', $TS-TS-seq/test-case[@id='TC-Types-101']/@rating, ')') else $rating-TS-TS " />
  <xsl:variable name="rating-alt-TC-Types-101" select="if ($TS-TS-alt-seq/test-case[@id='TC-Types-101']/@rating) then concat(' (', $TS-TS-alt-seq/test-case[@id='TC-Types-101']/@rating, ')') else $rating-alt-TS-TS " />
  <xsl:variable name="rating-TC-Types-105" select="if ($TS-UID-seq/test-case[@id='TC-Types-105']/@rating) then concat(' (', $TS-UID-seq/test-case[@id='TC-Types-105']/@rating, ')') else $rating-TS-UID " />
  <xsl:variable name="rating-alt-TC-Types-105" select="if ($TS-UID-alt-seq/test-case[@id='TC-Types-105']/@rating) then concat(' (', $TS-UID-alt-seq/test-case[@id='TC-Types-105']/@rating, ')') else $rating-alt-TS-UID " />
  <xsl:variable name="rating-TC-Types-106" select="if ($TS-UID-seq/test-case[@id='TC-Types-106']/@rating) then concat(' (', $TS-UID-seq/test-case[@id='TC-Types-106']/@rating, ')') else $rating-TS-UID " />
  <xsl:variable name="rating-alt-TC-Types-106" select="if ($TS-UID-alt-seq/test-case[@id='TC-Types-106']/@rating) then concat(' (', $TS-UID-alt-seq/test-case[@id='TC-Types-106']/@rating, ')') else $rating-alt-TS-UID " />
  <xsl:variable name="rating-TC-Types-107" select="if ($TS-UID-seq/test-case[@id='TC-Types-107']/@rating) then concat(' (', $TS-UID-seq/test-case[@id='TC-Types-107']/@rating, ')') else $rating-TS-UID " />
  <xsl:variable name="rating-alt-TC-Types-107" select="if ($TS-UID-alt-seq/test-case[@id='TC-Types-107']/@rating) then concat(' (', $TS-UID-alt-seq/test-case[@id='TC-Types-107']/@rating, ')') else $rating-alt-TS-UID " />
  <xsl:variable name="rating-TC-Types-108" select="if ($TS-UID-seq/test-case[@id='TC-Types-108']/@rating) then concat(' (', $TS-UID-seq/test-case[@id='TC-Types-108']/@rating, ')') else $rating-TS-UID " />
  <xsl:variable name="rating-alt-TC-Types-108" select="if ($TS-UID-alt-seq/test-case[@id='TC-Types-108']/@rating) then concat(' (', $TS-UID-alt-seq/test-case[@id='TC-Types-108']/@rating, ')') else $rating-alt-TS-UID " />
  <xsl:variable name="rating-TC-Types-109" select="if ($TS-UID-seq/test-case[@id='TC-Types-109']/@rating) then concat(' (', $TS-UID-seq/test-case[@id='TC-Types-109']/@rating, ')') else $rating-TS-UID " />
  <xsl:variable name="rating-alt-TC-Types-109" select="if ($TS-UID-alt-seq/test-case[@id='TC-Types-109']/@rating) then concat(' (', $TS-UID-alt-seq/test-case[@id='TC-Types-109']/@rating, ')') else $rating-alt-TS-UID " />
  <xsl:variable name="rating-TC-Auth-53" select="if ($TS-Addr-seq/test-case[@id='TC-Auth-53']/@rating) then concat(' (', $TS-Addr-seq/test-case[@id='TC-Auth-53']/@rating, ')') else $rating-TS-Addr " />
  <xsl:variable name="rating-TC-Auth-07" select="if ($TS-Content-seq/test-case[@id='TC-Auth-07']/@rating) then concat(' (', $TS-Content-seq/test-case[@id='TC-Auth-07']/@rating, ')') else $rating-TS-Content " />
  <xsl:variable name="rating-TC-Auth-09" select="if ($TS-Content-seq/test-case[@id='TC-Auth-09']/@rating) then concat(' (', $TS-Content-seq/test-case[@id='TC-Auth-09']/@rating, ')') else $rating-TS-Content " />
  <xsl:variable name="rating-TC-Auth-12" select="if ($TS-Content-seq/test-case[@id='TC-Auth-12']/@rating) then concat(' (', $TS-Content-seq/test-case[@id='TC-Auth-12']/@rating, ')') else $rating-TS-Content " />
  <xsl:variable name="rating-TC-Auth-13" select="if ($TS-Content-seq/test-case[@id='TC-Auth-13' and @context='default']/@rating) then concat(' (', $TS-Content-seq/test-case[@id='TC-Auth-13' and @context='default']/@rating, ')') else $rating-TS-Content " />
  <xsl:variable name="rating-alt-TC-Auth-13" select="if ($TS-Content-seq/test-case[@id='TC-Auth-13' and @context='alternative']/@rating) then concat(' (', $TS-Content-seq/test-case[@id='TC-Auth-13' and @context='alternative']/@rating, ')') else $rating-TC-Auth-13 " />
  <xsl:variable name="rating-TC-Auth-55" select="if ($TS-Content-seq/test-case[@id='TC-Auth-55']/@rating) then concat(' (', $TS-Content-seq/test-case[@id='TC-Auth-55']/@rating, ')') else $rating-TS-Content " />
  <xsl:variable name="rating-TC-Auth-50" select="if ($TS-eComm-seq/test-case[@id='TC-Auth-50']/@rating) then concat(' (', $TS-eComm-seq/test-case[@id='TC-Auth-50']/@rating, ')') else $rating-TS-eComm " />
  <xsl:variable name="rating-TC-Auth-39" select="if ($TS-Pers-seq/test-case[@id='TC-Auth-39']/@rating) then concat(' (', $TS-Pers-seq/test-case[@id='TC-Auth-39']/@rating, ')') else $rating-TS-Pers " />
  <xsl:variable name="rating-TC-Auth-42" select="if ($TS-Pers-seq/test-case[@id='TC-Auth-42']/@rating) then concat(' (', $TS-Pers-seq/test-case[@id='TC-Auth-42']/@rating, ')') else $rating-TS-Pers " />
  <xsl:variable name="rating-TC-Auth-46" select="if ($TS-Pers-seq/test-case[@id='TC-Auth-46']/@rating) then concat(' (', $TS-Pers-seq/test-case[@id='TC-Auth-46']/@rating, ')') else $rating-TS-Pers " />
  <xsl:variable name="rating-TC-Auth-47" select="if ($TS-Pers-seq/test-case[@id='TC-Auth-47']/@rating) then concat(' (', $TS-Pers-seq/test-case[@id='TC-Auth-47']/@rating, ')') else $rating-TS-Pers " />
  <xsl:variable name="rating-TC-Auth-48" select="if ($TS-Pers-seq/test-case[@id='TC-Auth-48']/@rating) then concat(' (', $TS-Pers-seq/test-case[@id='TC-Auth-48']/@rating, ')') else $rating-TS-Pers " />
  <xsl:variable name="rating-TC-DS-Display" select="if ($TS-Usability-seq/test-case[@id='TC-DS-Display' and @context='default']/@rating) then concat(' (', $TS-Usability-seq/test-case[@id='TC-DS-Display' and @context='default']/@rating, ')') else $rating-TS-Usability " />
  <xsl:variable name="rating-alt-TC-DS-Display" select="if ($TS-Usability-seq/test-case[@id='TC-DS-Display' and @context='alternative']/@rating) then concat(' (', $TS-Usability-seq/test-case[@id='TC-DS-Display' and @context='alternative']/@rating, ')') else $rating-TC-DS-Display " />
  <xsl:variable name="rating-TC-Med-Display" select="if ($TS-Usability-seq/test-case[@id='TC-Med-Display' and @context='default']/@rating) then concat(' (', $TS-Usability-seq/test-case[@id='TC-Med-Display' and @context='default']/@rating, ')') else $rating-TS-Usability " />
  <xsl:variable name="rating-dir-TC-Med-Display" select="if ($TS-Usability-seq/test-case[@id='TC-Med-Display' and @context='directions']/@rating) then concat(' (', $TS-Usability-seq/test-case[@id='TC-Med-Display' and @context='directions']/@rating, ')') else $rating-TC-Med-Display " />
  <xsl:variable name="rating-TC-None-Supplied" select="if ($TS-Usability-seq/test-case[@id='TC-None-Supplied']/@rating) then concat(' (', $TS-Usability-seq/test-case[@id='TC-None-Supplied']/@rating, ')') else $rating-TS-Usability " />
  <xsl:variable name="rating-TC-Usability" select="if ($TS-Usability-seq/test-case[@id='TC-Usability']/@rating) then concat(' (', $TS-Usability-seq/test-case[@id='TC-Usability']/@rating, ')') else $rating-TS-Usability " />
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-number" as="xs:string">
    <xsl:param name="number" as="xs:string" />
    <xsl:choose>
      <xsl:when test="exists($number) and exists($numbers/number[@value = $number])">
        <xsl:value-of select="$numbers/number[@value = $number]/@name" />
      </xsl:when>
      <xsl:when test="exists($number) and not(exists($numbers/number[@value = $number]))">
        <xsl:value-of select="$number" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-date" as="xs:string">
    <xsl:param name="date-time" as="xs:string" />
    <xsl:variable name="dt-year" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($date-time) and string-length($date-time) &gt; 3 ">
          <xsl:value-of select="substring($date-time, 1, 4)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-month-num" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($date-time) and string-length($date-time) &gt; 5 ">
          <xsl:value-of select="substring($date-time, 5, 2)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-day" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($date-time) and string-length($date-time) &gt; 7 ">
          <xsl:value-of select="substring($date-time, 7, 2)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-month" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-month-num = '01' ">
          <xsl:value-of select="'Jan'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '02' ">
          <xsl:value-of select="'Feb'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '03' ">
          <xsl:value-of select="'Mar'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '04' ">
          <xsl:value-of select="'Apr'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '05' ">
          <xsl:value-of select="'May'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '06' ">
          <xsl:value-of select="'Jun'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '07' ">
          <xsl:value-of select="'Jul'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '08' ">
          <xsl:value-of select="'Aug'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '09' ">
          <xsl:value-of select="'Sep'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '10' ">
          <xsl:value-of select="'Oct'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '11' ">
          <xsl:value-of select="'Nov'" />
        </xsl:when>
        <xsl:when test="$dt-month-num = '12' ">
          <xsl:value-of select="'Dec'" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$dt-day != ''">
        <xsl:value-of select="concat($dt-day, ' ', $dt-month, ' ', $dt-year)" />
      </xsl:when>
      <xsl:when test="$dt-month != ''">
        <xsl:value-of select="concat($dt-month, ' ', $dt-year)" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$dt-year" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-date-diff" as="xs:string*">
    <xsl:param name="first-dt" as="xs:string" />
    <xsl:param name="second-dt" as="xs:string" />
    <xsl:variable name="first-dt-xs" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($first-dt) and string-length($first-dt) &gt; 7 ">
          <xsl:value-of select="concat(substring($first-dt, 1, 4), '-', substring($first-dt, 5, 2), '-', substring($first-dt, 7, 2)) " />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="second-dt-xs" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($second-dt) and string-length($second-dt) &gt; 7 ">
          <xsl:value-of select="concat(substring($second-dt, 1, 4), '-', substring($second-dt, 5, 2), '-', substring($second-dt, 7, 2)) " />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-difference-1" as="xs:string">
      <xsl:choose>
        <xsl:when test="$first-dt-xs = '' or $second-dt-xs = '' ">
          <xsl:value-of select=" '' " />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="string(xs:date($second-dt-xs) - xs:date($first-dt-xs))" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-difference" as="xs:string">
      <xsl:choose>
        <xsl:when test="matches($dt-difference-1, '^\-?P[0-9]+D')">
          <xsl:value-of select="replace($dt-difference-1, '^(\-?)(P)([0-9]+)(D)', '$1$3')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$dt-difference = ''">
        <xsl:sequence select="('', '')" />
      </xsl:when>
      <xsl:when test="$dt-difference = '1'">
        <xsl:sequence select="('1 day', '1')" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="(concat($dt-difference, ' days'), $dt-difference)" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-originalText" as="xs:string">
    <xsl:param name="cd" as="node()" />
    <xsl:variable name="cd-otext-1" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($cd/cda:originalText)">
          <xsl:value-of select="normalize-space($cd/cda:originalText)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-otext" as="xs:string">
      <xsl:choose>
        <xsl:when test="string-length($cd-otext-1) &gt; 200">
          <xsl:value-of select="concat('commencing with ', codepoints-to-string(34),       normalize-space(dh:XQueryRecursiveReplace(substring(dh:XQueryRecursiveReplace($cd-otext-1, $p-name-pattern-replacement, 'ic'), 1, 200),       $markup-pattern-replacement, 'ic')), ' . . . ', codepoints-to-string(34))" />
        </xsl:when>
        <xsl:when test="exists($cd/cda:originalText) and string-length($cd-otext-1) &gt; 0">
          <xsl:value-of select="concat(codepoints-to-string(34), normalize-space(dh:XQueryRecursiveReplace($cd-otext-1, $text-pattern-replacement, 'ic')), codepoints-to-string(34))" />
        </xsl:when>
        <xsl:when test="exists($cd/cda:originalText) and string-length($cd-otext-1) = 0">
          <xsl:value-of select="concat(codepoints-to-string(34), '', codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-otext-nullFlavor" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($cd/cda:originalText/@nullFlavor)">
          <xsl:value-of select="concat('nullFlavor ', codepoints-to-string(34), $cd/cda:originalText/@nullFlavor, codepoints-to-string(34), ' (',          $nullFlavors/nullFlavor[@value = $cd/cda:originalText/@nullFlavor]/@name, ')')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-components" as="xs:string*">
      <xsl:sequence select="($cd-otext, $cd-otext-nullFlavor)[. != '']" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="count($cd-components) &gt; 1">
        <xsl:value-of select="concat(string-join($cd-components[position() &lt; last()], ', '), ' and ', $cd-components[last()])" />
      </xsl:when>
      <xsl:when test="count($cd-components) = 1">
        <xsl:value-of select="$cd-components[1]" />
      </xsl:when>
      <xsl:when test="exists($cd)">
        <xsl:value-of select="'no originalText element'" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:location" as="xs:string">
    <xsl:param name="context" as="node()" />
    <xsl:param name="default-section-name" as="xs:string" />
    <xsl:variable name="sec-pos-1" as="xs:integer">
      <xsl:choose>
        <xsl:when test="not(exists($context)) or not(exists($context/ancestor::cda:section))">
          <xsl:value-of select="0" />
        </xsl:when>
        <xsl:when test="$num-pathTestRes &gt; 1 and (exists($context/ancestor::cda:section[position()=1]/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16144']) or     (local-name($context) = 'section' and exists($context/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16144'])))">
          <xsl:value-of select="1 + count($context/preceding::cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16144']])" />
        </xsl:when>
        <xsl:when test="$num-imExamRes &gt; 1 and (exists($context/ancestor::cda:section[position()=1]/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16145']) or     (local-name($context) = 'section' and exists($context/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16145'])))">
          <xsl:value-of select="1 + count($context/preceding::cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16145']])" />
        </xsl:when>
        <xsl:when test="$num-undiffDiag &gt; 1 and (exists($context/ancestor::cda:section[position()=1]/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16029']) or     (local-name($context) = 'section' and exists($context/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16029'])))">
          <xsl:value-of select="1 + count($context/preceding::cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16029']])" />
        </xsl:when>
        <xsl:when test="$num-reqService &gt; 1 and (exists($context/ancestor::cda:section[position()=1]/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.20158']) or     (local-name($context) = 'section' and exists($context/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.20158'])))">
          <xsl:value-of select="1 + count($context/preceding::cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.20158']])" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="0" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="sec-pos" as="xs:string">
      <xsl:choose>
        <xsl:when test="$sec-pos-1 = 0">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="$sec-pos-1 = 1">
          <xsl:value-of select="'first '" />
        </xsl:when>
        <xsl:when test="$sec-pos-1 = 2">
          <xsl:value-of select="'second '" />
        </xsl:when>
        <xsl:when test="$sec-pos-1 = 3">
          <xsl:value-of select="'third '" />
        </xsl:when>
        <xsl:when test="matches(string($sec-pos-1), '^[0-9]+1$')">
          <xsl:value-of select="concat(string($sec-pos-1), 'st ')" />
        </xsl:when>
        <xsl:when test="matches(string($sec-pos-1), '^[0-9]+2$')">
          <xsl:value-of select="concat(string($sec-pos-1), 'nd ')" />
        </xsl:when>
        <xsl:when test="matches(string($sec-pos-1), '^[0-9]+3$')">
          <xsl:value-of select="concat(string($sec-pos-1), 'rd ')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(string($sec-pos-1), 'th ')" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="sec-name" as="xs:string">
      <xsl:choose>
        <xsl:when test="not(exists($context))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:section[position()=1]/cda:title)">
          <xsl:value-of select="$context/ancestor::cda:section[position()=1]/cda:title" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:section[position()=1]/cda:code/@displayName)">
          <xsl:value-of select="$context/ancestor::cda:section[position()=1]/cda:code/@displayName" />
        </xsl:when>
        <xsl:when test="local-name($context) = 'section' and exists($context/cda:title)">
          <xsl:value-of select="$context/cda:title" />
        </xsl:when>
        <xsl:when test="local-name($context) = 'section' and exists($context/cda:code/@displayName)">
          <xsl:value-of select="$context/cda:code/@displayName" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:section) or local-name($context) = 'section' and exists($default-section-name) and $default-section-name != ''">
          <xsl:value-of select="$default-section-name" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:section) or local-name($context) = 'section'">
          <xsl:value-of select="'unknown'" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="ir-pos" as="xs:integer">
      <xsl:choose>
        <xsl:when test="not(exists($context)) or $sec-name != ''">
          <xsl:value-of select="0" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:informationRecipient)">
          <xsl:value-of select="1 + count($context/preceding::cda:informationRecipient[position()=1])" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="0" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="part-pos" as="xs:integer">
      <xsl:choose>
        <xsl:when test="not(exists($context)) or $sec-name != ''">
          <xsl:value-of select="0" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:participant)">
          <xsl:value-of select="1 + count($context/preceding::cda:participant[position()=1])" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="0" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="header-de" as="xs:string">
      <xsl:choose>
        <xsl:when test="not(exists($context)) or $sec-name != ''">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:author)">
          <xsl:value-of select="'''author'''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:componentOf)">
          <xsl:value-of select="'''componentOf'''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:custodian)">
          <xsl:value-of select="'''custodian'''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:legalAuthenticator)">
          <xsl:value-of select="'''legalAuthenticator'''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:recordTarget)">
          <xsl:value-of select="'''recordTarget'''" />
        </xsl:when>
        <xsl:when test="$ir-pos &gt; 3">
          <xsl:value-of select="concat(string($ir-pos), 'th ''informationRecipient''')" />
        </xsl:when>
        <xsl:when test="$ir-pos &gt; 3">
          <xsl:value-of select="concat(string($ir-pos), 'th ''informationRecipient''')" />
        </xsl:when>
        <xsl:when test="$ir-pos = 3">
          <xsl:value-of select="'third ''informationRecipient'''" />
        </xsl:when>
        <xsl:when test="$ir-pos = 2">
          <xsl:value-of select="'second ''informationRecipient'''" />
        </xsl:when>
        <xsl:when test="$ir-pos = 1 and count($context/ancestor::cda:ClinicalDocument/cda:informationRecipient) = 1">
          <xsl:value-of select="'''informationRecipient '''" />
        </xsl:when>
        <xsl:when test="$ir-pos = 1">
          <xsl:value-of select="'first ''informationRecipient'''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:inFulfillmentOf)">
          <xsl:value-of select="'''inFulfillmentOf'''" />
        </xsl:when>
        <xsl:when test="$part-pos &gt; 3">
          <xsl:value-of select="concat(string($part-pos), 'th ''participant''')" />
        </xsl:when>
        <xsl:when test="$part-pos = 3">
          <xsl:value-of select="'third ''participant'''" />
        </xsl:when>
        <xsl:when test="$part-pos = 2">
          <xsl:value-of select="'second ''participant'''" />
        </xsl:when>
        <xsl:when test="$part-pos = 1 and count($context/ancestor::cda:ClinicalDocument/cda:participant) = 1">
          <xsl:value-of select="'''participant'''" />
        </xsl:when>
        <xsl:when test="$part-pos = 1">
          <xsl:value-of select="'first ''participant'''" />
        </xsl:when>
        <xsl:when test="exists($context/ancestor::cda:relatedDocument)">
          <xsl:value-of select="'''relatedDocument'''" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="not(exists($context))">
        <xsl:value-of select="''" />
      </xsl:when>
      <xsl:when test="exists($context/ancestor::cda:section) or local-name($context) = 'section' ">
        <xsl:value-of select="concat($sec-pos, $sec-name, ' section')" />
      </xsl:when>
      <xsl:when test="local-name($context) = 'structuredBody'">
        <xsl:value-of select="'document body'" />
      </xsl:when>
      <xsl:when test="$header-de != ''">
        <xsl:value-of select="concat($header-de, ' component of the document header')" />
      </xsl:when>
      <xsl:when test="$header-de = ''">
        <xsl:value-of select="'document header'" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'unknown location'" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-text-list" as="xs:string">
    <xsl:param name="text-list" as="xs:string*" />
    <xsl:param name="sort" as="xs:integer" />
    <xsl:param name="de-duplicate" as="xs:boolean" />
    <xsl:param name="displayable" as="xs:boolean" />
    <xsl:variable name="joined-text-1" as="xs:string*">
      <xsl:choose>
        <xsl:when test="not(exists($text-list))">
          <xsl:sequence select="()" />
        </xsl:when>
        <xsl:when test="$de-duplicate">
          <xsl:sequence select="distinct-values((for $text in $text-list return normalize-space($text))[. != ''])" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="for $text in $text-list return normalize-space($text)" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="joined-text-2" as="xs:string*">
      <xsl:choose>
        <xsl:when test="not(exists($joined-text-1)) or $sort = 0">
          <xsl:sequence select="$joined-text-1" />
        </xsl:when>
        <xsl:when test="$sort = 1">
          <xsl:sequence select="tokenize(dh:Reorder(string-join($joined-text-1, '|'), true()), '\|')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="tokenize(dh:Reorder(string-join($joined-text-1, '|'), false()), '\|')" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="joined-text" as="xs:string">
      <xsl:choose>
        <xsl:when test="not(exists($joined-text-2))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="count($joined-text-2) = 1">
          <xsl:value-of select="concat(codepoints-to-string(34), $joined-text-1[1], codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat(codepoints-to-string(34), string-join($joined-text-2[position() &lt; last()], concat(codepoints-to-string(34), ', ', codepoints-to-string(34))),       codepoints-to-string(34), ' and ', codepoints-to-string(34), $joined-text-2[last()], codepoints-to-string(34))" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$displayable">
        <xsl:value-of select="dh:XQueryRecursiveReplace($joined-text, $markup-pattern-replacement, 'ic')" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$joined-text" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:convert-narr-dateTime" as="xs:string*">
    <xsl:param name="narr-element" as="xs:string" />
    <xsl:variable name="dt-type" as="xs:string">
      <xsl:choose>
        <xsl:when test="matches($narr-element, $regex-date-type-1, 'is')">
          <xsl:value-of select="'1'" />
        </xsl:when>
        <xsl:when test="matches($narr-element, $regex-date-type-2, 'is')">
          <xsl:value-of select="'2'" />
        </xsl:when>
        <xsl:when test="matches($narr-element, $regex-date-type-3)">
          <xsl:value-of select="'3'" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="'0'" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-day" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = ('1', '2') and matches($narr-element, '^\s*[0-9]{1,2}[^0-9a-z]', 'is')">
          <xsl:value-of select="replace($narr-element, '(^\s*)([0-9]{1,2})([^0-9a-z].*)', '$2', 'is')" />
        </xsl:when>
        <xsl:when test="$dt-type = '3'">
          <xsl:value-of select="substring($narr-element, 7, 2)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-month-actual-alpha" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = '2' and matches($narr-element, '^\s*[0-9]{1,2}[^0-9a-z]+[a-z]+', 'is')">
          <xsl:value-of select="replace($narr-element, '(^\s*)(^[0-9]{1,2})([^0-9a-z]+)([a-z]+)(.*)', '$4', 'is')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-month-corr-alpha" as="xs:string">
      <xsl:choose>
        <xsl:when test="string-length($dt-month-actual-alpha) = 3">
          <xsl:value-of select="concat(upper-case(substring($dt-month-actual-alpha, 1, 1)), lower-case(substring($dt-month-actual-alpha, 2, 2)))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-type-1-month" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = '1'">
          <xsl:value-of select="substring-before(substring-after($narr-element,'/'),'/')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-type-3-month" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = '3'">
          <xsl:value-of select="substring($narr-element, 5, 2)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-month" as="xs:string">
      <xsl:choose>
        <xsl:when test="not($dt-type = ('1', '2'))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="string-length($dt-type-1-month) = 2">
          <xsl:value-of select="$dt-type-1-month" />
        </xsl:when>
        <xsl:when test="string-length($dt-type-1-month) = 1">
          <xsl:value-of select="concat('0', $dt-type-1-month)" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^jan', 'i')">
          <xsl:value-of select="'01'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^feb', 'i')">
          <xsl:value-of select="'02'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^mar', 'i')">
          <xsl:value-of select="'03'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^apr', 'i')">
          <xsl:value-of select="'04'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^may', 'i')">
          <xsl:value-of select="'05'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^jun', 'i')">
          <xsl:value-of select="'06'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^jul', 'i')">
          <xsl:value-of select="'07'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^aug', 'i')">
          <xsl:value-of select="'08'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^sep', 'i')">
          <xsl:value-of select="'09'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^oct', 'i')">
          <xsl:value-of select="'10'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^nov', 'i')">
          <xsl:value-of select="'11'" />
        </xsl:when>
        <xsl:when test="matches($dt-month-actual-alpha, '^dec', 'i')">
          <xsl:value-of select="'12'" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-without-time" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = ('1', '2')">
          <xsl:value-of select="replace(normalize-space($narr-element), concat($narr-time-regex, '$'), '')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-year" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = ('1', '2') and matches($dt-without-time, '([0-9]{2}$|[0-9]{4})(\s*$)', 'is')">
          <xsl:value-of select="replace($dt-without-time, '(^.*?)([0-9]{2}$|[0-9]{4})(\s*$)', '$2', 'is')" />
        </xsl:when>
        <xsl:when test="$dt-type = '3'">
          <xsl:value-of select="substring($narr-element, 1, 4)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-date" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = ('1', '2') and string-length($dt-day) = 1">
          <xsl:value-of select="concat($dt-year, $dt-month, '0', $dt-day)" />
        </xsl:when>
        <xsl:when test="$dt-type = ('1', '2')">
          <xsl:value-of select="concat($dt-year, $dt-month, $dt-day)" />
        </xsl:when>
        <xsl:when test="$dt-type = '3'">
          <xsl:value-of select="if ($dt-year = '') then '0001-01-01'        else if ($dt-type-3-month = '') then concat($dt-year, '-01-01')        else if ($dt-day = '') then concat($dt-year, '-', $dt-type-3-month, '-01')        else concat($dt-year, '-', $dt-type-3-month, '-', $dt-day)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-time-and-timezone" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = '1'">
          <xsl:value-of select="normalize-space(replace($narr-element, $regex-date-type-1, '', 'is'))" />
        </xsl:when>
        <xsl:when test="$dt-type = '2'">
          <xsl:value-of select="normalize-space(replace($narr-element, $regex-date-type-2, '', 'is'))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-type-3-seconds" as="xs:string">
      <xsl:choose>
        <xsl:when test="not($dt-type = '3')">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="contains($narr-element, '-')">
          <xsl:value-of select="substring-before(substring($narr-element, 13), '-')" />
        </xsl:when>
        <xsl:when test="contains($narr-element, '+')">
          <xsl:value-of select="substring-before(substring($narr-element, 13), '+')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="substring($narr-element, 13)" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-time-1" as="xs:string*">
      <xsl:choose>
        <xsl:when test="$dt-type = ('1', '2') and matches($dt-time-and-timezone, $regex-time)">
          <xsl:sequence select="(        substring-before($dt-time-and-timezone, ':'),         substring(substring-after($dt-time-and-timezone, ':'), 1, 2),        substring(substring-after(substring-after($dt-time-and-timezone, ':'), ':'), 1, 2),        if (contains($dt-time-and-timezone, '+')) then concat('+', substring-after($dt-time-and-timezone, '+'))         else if (contains($dt-time-and-timezone, '-')) then concat('-', substring-after($dt-time-and-timezone, '-'))         else '')" />
        </xsl:when>
        <xsl:when test="$dt-type = '3'">
          <xsl:sequence select="(        substring($narr-element, 9, 2),         substring($narr-element, 11, 2),        if (matches($dt-type-3-seconds, '\.[1-9]+0+$')) then replace($dt-type-3-seconds, '0+$', '')          else if (matches($dt-type-3-seconds, '\.0+$')) then replace($dt-type-3-seconds, '\.0+$', '')         else $dt-type-3-seconds,        if (contains($narr-element, '-')) then concat('-', substring-after($narr-element, '-'))         else if (contains($narr-element, '+')) then concat('+', substring-after($narr-element, '+'))         else '')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="()" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-time" as="xs:string">
      <xsl:choose>
        <xsl:when test="$dt-type = ('1', '2') and string-length($dt-time-1[1]) = 1">
          <xsl:value-of select="concat('0', $dt-time-1[1], $dt-time-1[2], $dt-time-1[3])" />
        </xsl:when>
        <xsl:when test="$dt-type = ('1', '2')">
          <xsl:value-of select="concat($dt-time-1[1], $dt-time-1[2], $dt-time-1[3])" />
        </xsl:when>
        <xsl:when test="$dt-type = '3'">
          <xsl:value-of select="if ($dt-time-1[1] = '') then '00:00:00'        else if ($dt-time-1[2] = '') then concat($dt-time-1[1], ':00:00')        else if ($dt-time-1[3] = '') then concat($dt-time-1[1], ':', $dt-time-1[2], ':00')        else concat($dt-time-1[1], ':', $dt-time-1[2], ':', $dt-time-1[3])" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="dt-type-3-time-tz" as="xs:string">
      <xsl:choose>
        <xsl:when test="not($dt-type = '3')">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="$dt-time-1[4] = ''">
          <xsl:value-of select="$dt-time" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($dt-time, substring($dt-time-1[4], 1, 3), ':', substring($dt-time-1[4], 4, 2))" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="$dt-type = '3' and $dt-date castable as xs:date and $dt-type-3-time-tz castable as xs:time">
        <xsl:sequence select="('3', '', '', '', '', '', '', '', '')" />
      </xsl:when>
      <xsl:when test="not($dt-type = ('1', '2'))">
        <xsl:sequence select="('0', '', '', '', '', '', '', '', '')" />
      </xsl:when>
      <xsl:when test="($dt-day != '' and number($dt-day) &gt; 31)       or     ($dt-month != '' and number($dt-month) &gt; 12)       or     ($dt-time-1[1] != '' and number($dt-time-1[1]) &gt; 24)      or     ($dt-time-1[2] != '' and number($dt-time-1[2]) &gt; 60)      or     ($dt-time-1[3] != '' and number($dt-time-1[3]) &gt; 60)      or     ($dt-time-and-timezone != '' and not(matches($dt-time-and-timezone, $regex-time)))  or     ($dt-time-1[4] != '' and not(matches($dt-time-1[4], $regex-timezone)))    or     ($dt-time-1[4] != '' and normalize-space(replace($dt-time-1[4], $regex-timezone, '')) != '') ">
        <xsl:sequence select="('0', '', '', '', '', '', '', '', '')" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="(        $dt-type,        $dt-day,        $dt-month-actual-alpha,        $dt-month-corr-alpha,        $dt-year,        $dt-date,       $dt-time,        $dt-time-1[4],       if (matches($dt-time-1[4], '^(\+|\-)')) then concat('^', $dt-date, $dt-time, '[0-9]*\', $dt-time-1[4])        else concat('^', $dt-date, $dt-time, '[0-9]*'))" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:SearchForCodesInHierarchyFuzzyUsingTS" as="xs:string*">
    <xsl:param name="codeSystem" as="xs:string" />
    <xsl:param name="codeSystemVersion" as="xs:string" />
    <xsl:param name="action" as="xs:string" />
    <xsl:param name="formula" as="xs:string" />
    <xsl:param name="filter" as="xs:string" />
    <xsl:param name="automap" as="xs:string" />
    <xsl:variable name="maps" as="xs:string*">
      <xsl:choose>
        <xsl:when test="exists($codeSystem) and exists($codeSystemVersion) and exists($action) and exists($formula) and exists($filter) and exists($automap)">
          <xsl:sequence select="tokenize(dh:SearchForCodesInHierarchyFuzzyUsingTS($codeSystem, $codeSystemVersion, $action, $formula, $filter, $automap), '\|')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="()" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="'Error' = $maps or not(exists($maps))">
        <xsl:sequence select="$maps" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:sequence select="tokenize(dh:SearchForCodesInHierarchyUsingTS($codeSystem, $codeSystemVersion, $action,      concat('(', string-join(for $code in $maps return replace($code, '^([0-9]+)(\[.+?\])$', '$1', 'is'), ' OR '), ') AND (',       $formula, ')'), '', string(count($maps)), false()), '\|')" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:invalidityExplanationUsingTS" as="xs:string">
    <xsl:param name="codeSystem" as="xs:string" />
    <xsl:param name="codeSystemVersion" as="xs:string" />
    <xsl:param name="invalid-codes-h" as="xs:string*" />
    <xsl:param name="invalid-hierarchy" as="node()*" />
    <xsl:param name="invalid-codes-r" as="xs:string*" />
    <xsl:param name="invalid-refset" as="node()*" />
    <xsl:variable name="formula-h" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($invalid-codes-h) and exists($invalid-hierarchy)">
          <xsl:value-of select="concat('&gt;&gt;(', string-join($invalid-codes-h, ' OR '), ') AND (', string-join($invalid-hierarchy/@code, ' OR '), ')')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="explanation-h" as="xs:string">
      <xsl:choose>
        <xsl:when test="$formula-h = ''">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="dh:SearchForCodesInHierarchyUsingTS($codeSystem, $codeSystemVersion, 'ecl', $formula-h, '', string(count($invalid-codes-h)), true())" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="explanation" as="xs:string*">
      <xsl:choose>
        <xsl:when test="$explanation-h = 'Error'">
          <xsl:sequence select="()" />
        </xsl:when>
        <xsl:when test="$explanation-h != ''">
          <xsl:sequence select="for $code in tokenize(replace($explanation-h, '(\[.*?\])(\||$)', '$2'), '\|') return $invalid-hierarchy[@code = $code]/@description" />
        </xsl:when>
        <xsl:when test="exists($invalid-codes-r)">
          <xsl:sequence select="for $code in $invalid-codes-r return      $invalid-refset[index-of(for $x in (for $refset in $invalid-refset return        dh:SearchForCodesInHierarchyUsingTS($codeSystem, $codeSystemVersion, 'ecl', concat($code, ' AND ^', $refset/@code), '', '1', true()), '|')      return matches($x, '^[0-9]'), true())[1]]/@description" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:sequence select="()" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="'Error' = $explanation or not(exists($explanation))">
        <xsl:value-of select="''" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="string-join(tokenize(dh:OrderByLength(string-join(distinct-values($explanation), '|'), true()), '\|')[position() = (1 to 2)], ' and ')" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-CD" as="xs:string">
    <xsl:param name="cd" as="node()" />
    <xsl:variable name="cd-otext-nullFlavor" as="xs:string">
      <xsl:choose>
        <xsl:when test="not(exists($cd))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($cd/cda:originalText/@nullFlavor)">
          <xsl:value-of select="concat('originalText/nullFlavor ', codepoints-to-string(34), $cd/cda:originalText/@nullFlavor, codepoints-to-string(34), ' (',          $nullFlavors/nullFlavor[@value = $cd/cda:originalText/@nullFlavor]/@name, ')')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-otext-1" as="xs:string">
      <xsl:choose>
        <xsl:when test="not(exists($cd))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($cd/cda:originalText)">
          <xsl:value-of select="normalize-space($cd/cda:originalText)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-otext" as="xs:string">
      <xsl:choose>
        <xsl:when test="string-length($cd-otext-1) &gt; 200">
          <xsl:value-of select="concat('originalText ', 'commencing with ', codepoints-to-string(34),       normalize-space(dh:XQueryRecursiveReplace(substring(dh:XQueryRecursiveReplace($cd-otext-1, $p-name-pattern-replacement, 'ic'), 1, 200),       $markup-pattern-replacement, 'ic')), ' . . . ', codepoints-to-string(34))" />
        </xsl:when>
        <xsl:when test="exists($cd/cda:originalText) and string-length($cd-otext-1) &gt; 0">
          <xsl:value-of select="concat('originalText ', codepoints-to-string(34), normalize-space(dh:XQueryRecursiveReplace($cd-otext-1, $text-pattern-replacement, 'ic')), codepoints-to-string(34))" />
        </xsl:when>
        <xsl:when test="exists($cd/cda:originalText) and string-length($cd-otext-1) = 0">
          <xsl:value-of select="concat('originalText ', codepoints-to-string(34), '', codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-version" as="xs:string">
      <xsl:choose>
        <xsl:when test="not(exists($cd))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($cd/@codeSystemVersion)">
          <xsl:value-of select="concat(' with codeSystemVersion ', codepoints-to-string(34), $cd/@codeSystemVersion, codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-components-1" as="xs:string*">
      <xsl:choose>
        <xsl:when test="$cd-otext = '' and $cd-otext-nullFlavor = ''">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="not($cd-otext = '') and $cd-otext-nullFlavor = ''">
          <xsl:value-of select="$cd-otext" />
        </xsl:when>
        <xsl:when test="not($cd-otext = '') and not($cd-otext-nullFlavor = '')">
          <xsl:value-of select="concat($cd-otext, ' and ', $cd-otext-nullFlavor)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="not(exists($cd))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($cd/@code)">
          <xsl:value-of select="concat('code ', codepoints-to-string(34), $cd/@code, codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="not(exists($cd))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($cd/@displayName)">
          <xsl:value-of select="concat('displayName ', codepoints-to-string(34),       dh:XQueryRecursiveReplace($cd/@displayName, $markup-pattern-replacement, 'ic'), codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="not(exists($cd))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($cd/@codeSystem) and exists($cd/@codeSystemName)">
          <xsl:value-of select="concat('codeSystem ', codepoints-to-string(34), $cd/@codeSystem, codepoints-to-string(34), ' (', $cd/@codeSystemName, ')', $cd-version)" />
        </xsl:when>
        <xsl:when test="exists($cd/@codeSystem) and not(exists($cd/@codeSystemName))">
          <xsl:value-of select="concat('codeSystem ', codepoints-to-string(34), $cd/@codeSystem, codepoints-to-string(34), $cd-version)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="not(exists($cd))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($cd/@nullFlavor)">
          <xsl:value-of select="concat('nullFlavor ', codepoints-to-string(34), $cd/@nullFlavor, codepoints-to-string(34), ' (',          $nullFlavors/nullFlavor[@value = $cd/@nullFlavor]/@name, ')')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="cd-components" as="xs:string*">
      <xsl:sequence select="$cd-components-1[. != '']" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="count($cd-components) &gt; 1">
        <xsl:value-of select="concat(string-join($cd-components[position() &lt; last()], ', '), ' and ', $cd-components[last()])" />
      </xsl:when>
      <xsl:when test="count($cd-components) = 1">
        <xsl:value-of select="$cd-components[1]" />
      </xsl:when>
      <xsl:when test="exists($cd)">
        <xsl:value-of select="'no attributes or originalText element'" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-II" as="xs:string">
    <xsl:param name="id" as="node()" />
    <xsl:variable name="id-components-1" as="xs:string*">
      <xsl:choose>
        <xsl:when test="not(exists($id))">
          <xsl:value-of select="''" />
        </xsl:when>
        <xsl:when test="exists($id/@root)">
          <xsl:value-of select="concat('root ', codepoints-to-string(34), $id/@root, codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="exists($id/@extension)">
          <xsl:value-of select="concat('extension ', codepoints-to-string(34), $id/@extension, codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="exists($id/@assigningAuthorityName)">
          <xsl:value-of select="concat('assigningAuthorityName ', codepoints-to-string(34), $id/@assigningAuthorityName, codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="exists($id/@nullFlavor)">
          <xsl:value-of select="concat('nullFlavor ', codepoints-to-string(34), $id/@nullFlavor, codepoints-to-string(34), ' (',          $nullFlavors/nullFlavor[@value = $id/@nullFlavor]/@name, ')')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="exists($id/@displayable)">
          <xsl:value-of select="concat('displayable ', codepoints-to-string(34), $id/@displayable, codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="id-components" as="xs:string*">
      <xsl:sequence select="$id-components-1[. != '']" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="count($id-components) &gt; 1">
        <xsl:value-of select="dh:XQueryRecursiveReplace(concat(string-join($id-components[position() &lt; last()], ', '), ' and ', $id-components[last()]), $markup-pattern-replacement, 'ic')" />
      </xsl:when>
      <xsl:when test="count($id-components) = 1">
        <xsl:value-of select="dh:XQueryRecursiveReplace($id-components[1], $markup-pattern-replacement, 'ic')" />
      </xsl:when>
      <xsl:when test="exists($id)">
        <xsl:value-of select="'no attributes'" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-ST" as="xs:string">
    <xsl:param name="st" as="node()" />
    <xsl:variable name="the-text" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($st)">
          <xsl:value-of select="string-join($st/text(), '')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="text-is-present" as="xs:boolean">
      <xsl:choose>
        <xsl:when test="exists($st)">
          <xsl:value-of select="not($the-text = '')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="false()" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="st-text-1" as="xs:string">
      <xsl:choose>
        <xsl:when test="$text-is-present">
          <xsl:value-of select="normalize-space($the-text)" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="st-text" as="xs:string">
      <xsl:choose>
        <xsl:when test="string-length($st-text-1) &gt; 200">
          <xsl:value-of select="concat('text commencing with ', codepoints-to-string(34),       normalize-space(dh:XQueryRecursiveReplace(substring(dh:XQueryRecursiveReplace($st-text-1, $p-name-pattern-replacement, 'ic'), 1, 200),       $markup-pattern-replacement, 'ic')), ' . . . ', codepoints-to-string(34))" />
        </xsl:when>
        <xsl:when test="$text-is-present">
          <xsl:value-of select="concat('the text ', codepoints-to-string(34), normalize-space(dh:XQueryRecursiveReplace($st-text-1, $text-pattern-replacement, 'ic')), codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="whitespace-string" as="xs:boolean">
      <xsl:choose>
        <xsl:when test="exists($st)">
          <xsl:value-of select="$text-is-present and normalize-space($the-text) = ''" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="false()" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="st-nullFlavor" as="xs:string">
      <xsl:choose>
        <xsl:when test="exists($st/@nullFlavor)">
          <xsl:value-of select="concat('nullFlavor ', codepoints-to-string(34), $st/@nullFlavor, codepoints-to-string(34), ' (',          $nullFlavors/nullFlavor[@value = $st/@nullFlavor]/@name, ')')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="not(exists($st))">
        <xsl:value-of select="''" />
      </xsl:when>
      <xsl:when test="$whitespace-string and $st-nullFlavor != ''">
        <xsl:value-of select="concat('text with whitespace only and ', $st-nullFlavor)" />
      </xsl:when>
      <xsl:when test="$whitespace-string and $st-nullFlavor = ''">
        <xsl:value-of select="'text with whitespace only'" />
      </xsl:when>
      <xsl:when test="$text-is-present and  $st-nullFlavor != ''">
        <xsl:value-of select="concat($st-text, ' and ', $st-nullFlavor)" />
      </xsl:when>
      <xsl:when test="$text-is-present and $st-nullFlavor = ''">
        <xsl:value-of select="$st-text" />
      </xsl:when>
      <xsl:when test="not($text-is-present) and $st-nullFlavor != ''">
        <xsl:value-of select="$st-nullFlavor" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="'no nullFlavor attribute and an empty character string'" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <xsl:function xmlns="http://purl.oclc.org/dsdl/schematron" name="iq:display-TS" as="xs:string">
    <xsl:param name="ts" as="node()" />
    <xsl:variable name="ts-components-1" as="xs:string*">
      <xsl:choose>
        <xsl:when test="exists($ts/@value)">
          <xsl:value-of select="concat('a ''value'' attribute with the value ', codepoints-to-string(34), $ts/@value, codepoints-to-string(34))" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="exists($ts/@nullFlavor)">
          <xsl:value-of select="concat('a nullFlavor attribute with the value ', codepoints-to-string(34), $ts/@nullFlavor, codepoints-to-string(34), ' (',          $nullFlavors/nullFlavor[@value = $ts/@nullFlavor]/@name, ')')" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="''" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="ts-components" as="xs:string*">
      <xsl:sequence select="$ts-components-1[. != '']" />
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="count($ts-components) &gt; 1">
        <xsl:value-of select="concat(string-join($ts-components[position() &lt; last()], ', '), ' and ', $ts-components[last()])" />
      </xsl:when>
      <xsl:when test="count($ts-components) = 1">
        <xsl:value-of select="$ts-components[1]" />
      </xsl:when>
      <xsl:when test="exists($ts)">
        <xsl:value-of select="'no attributes'" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="''" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:function>
  <!--PATTERN p-About-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument[not($flags/@about-IQ-Rules = 'false')] " priority="1000" mode="M21">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument[not($flags/@about-IQ-Rules = 'false')] " />
    <xsl:variable name="about-IQ-Rules" select="if ($flags/@about-IQ-Rules) then $flags/@about-IQ-Rules else 'true (default value)' " />
    <xsl:variable name="test-data" select="if ($flags/@test-data) then $flags/@test-data else 'false (default value)' " />
    <xsl:variable name="allow-debug" select="if ($flags/@allow-debug) then $flags/@allow-debug else 'false (default value)' " />
    <xsl:variable name="allow-hints" select="if ($flags/@allow-hints) then $flags/@allow-hints else 'true (default value)' " />
    <xsl:variable name="allow-ratings" select="if ($test-data = 'true') then 'false (test-data is ''true'')'          else if ($flags/@allow-ratings) then $flags/@allow-ratings else 'false (default value)' " />
    <xsl:variable name="assess-values" select="if ($test-data = 'true') then 'false (test-data is ''true'')'          else if ($flags/@assess-values) then $flags/@assess-values else 'true (default value)' " />
    <xsl:variable name="coding" select="if ($flags/@coding) then $flags/@coding else 'false (default value)' " />
    <xsl:variable name="collection-same-record" select="if ($flags/@collection-same-record) then $flags/@collection-same-record else 'false (default value)' " />
    <xsl:variable name="collection-same-system" select="if ($flags/@collection-same-system) then $flags/@collection-same-system else 'true (default value)' " />
    <xsl:variable name="narrative-auto-generated" select="if ($flags/@narrative-auto-generated) then $flags/@narrative-auto-generated else 'false (default value)' " />
    <xsl:variable name="narrative-derived" select="if ($flags/@narrative-derived) then $flags/@narrative-derived else 'false (default value)' " />
    <xsl:variable name="report-data" select="if ($flags/@report-data) then $flags/@report-data else 'false (default value)' " />
    <xsl:variable name="report-data-quality" select="if ($flags/@report-data-quality) then $flags/@report-data-quality else 'false (default value)' " />
    <xsl:variable name="report-statistics" select="if ($flags/@report-statistics) then $flags/@report-statistics else 'false (default value)' " />
    <xsl:variable name="report-terminology-concepts" select="if ($flags/@report-terminology-concepts) then $flags/@report-terminology-concepts else 'false (default value)' " />
    <xsl:variable name="iq-config-msg" select="if (exists($iq-config)) then '' else           ' The IQ Rules configuration file was not found so default values have been used for the configuration.' " />
    <xsl:variable name="validator-msg" select="if(exists($v-amtv2) or exists($v-amtv3) or exists($v-pbs) or exists($v-pbsman) or exists($v-snomedctau))        then ' The Clinical Package Validator''s database contains the following code systems and versions:' else '' " />
    <xsl:variable name="v-amtv2-msg" select="if (exists($v-amtv2)) then concat(' AMT v2 (', string-join($v-amtv2, ', '), ')') else '' " />
    <xsl:variable name="separator-1" select="if (exists($v-amtv2) and (exists($v-amtv3) or exists($v-pbs) or exists($v-pbsman) or exists($v-snomedctau))) then ';' else '' " />
    <xsl:variable name="v-amtv3-msg" select="if (exists($v-amtv3)) then concat(' AMT v3 (', string-join($v-amtv3, ', '), ')') else '' " />
    <xsl:variable name="separator-2" select="if (exists($v-amtv3) and (exists($v-pbs) or exists($v-pbsman) or exists($v-snomedctau))) then ';' else '' " />
    <xsl:variable name="v-pbs-msg" select="if (exists($v-pbs)) then concat(' PBS (', string-join($v-pbs, ', '), ')') else '' " />
    <xsl:variable name="separator-3" select="if (exists($v-pbs) and (exists($v-pbsman) or exists($v-snomedctau))) then ';' else '' " />
    <xsl:variable name="v-pbsman-msg" select="if (exists($v-pbsman)) then concat(' PBS Manufacturer (', string-join($v-pbsman, ', '), ')') else '' " />
    <xsl:variable name="separator-4" select="if (exists($v-pbsman) and exists($v-snomedctau)) then ';' else '' " />
    <xsl:variable name="v-snomedctau-msg" select="if (exists($v-snomedctau)) then concat(' SNOMED CT-AU (', string-join($v-snomedctau, ', '), ')') else '' " />
    <xsl:variable name="separator-5" select="if (exists($v-amtv2) or exists($v-amtv3) or exists($v-pbs) or exists($v-pbsman) or exists($v-snomedctau)) then '.' else '' " />
    <xsl:variable name="display-l-sct-date" select="if (exists($ts-sctau-dates)) then iq:display-date($ts-sctau-dates[last()]) else '' " />
    <xsl:variable name="display-h-sct-date" select="if (exists($ts-sctau-dates)) then iq:display-date($ts-sctau-dates[1]) else '' " />
    <xsl:variable name="display-l-pbs-date" select="if (exists($ts-pbs-dates)) then iq:display-date($ts-pbs-dates[last()]) else '' " />
    <xsl:variable name="display-h-pbs-date" select="if (exists($ts-pbs-dates)) then iq:display-date($ts-pbs-dates[1]) else '' " />
    <xsl:variable name="display-l-pbsman-date" select="if (exists($ts-pbsman-dates)) then iq:display-date($ts-pbsman-dates[last()]) else '' " />
    <xsl:variable name="display-h-pbsman-date" select="if (exists($ts-pbsman-dates)) then iq:display-date($ts-pbsman-dates[1]) else '' " />
    <xsl:variable name="report-ts-1" select="(if (not($use-ts-for-sctau)) then ''        else if (count($ts-sctau-dates) = 1) then concat('SNOMED CT-AU codes published on ', $display-l-sct-date)        else concat('SNOMED CT-AU codes published from ', $display-l-sct-date, ' to ', $display-h-sct-date),        if ($use-ts-for-loinc) then 'LOINC codes' else '',        if ($use-ts-for-anzsco) then 'ANZSCO codes' else '',        if ($use-ts-for-vaccines) then 'Australian Vaccines codes' else '',        if ($use-ts-for-ncts-data-comp) then 'NCTS Data Components codes' else '',        if (count($ts-pbs-dates) = 1) then concat('Pharmaceutical Benefits Scheme (PBS) codes published on ', $display-l-pbs-date)          else if (count($ts-pbs-dates) &gt; 1) then concat('Pharmaceutical Benefits Scheme (PBS) codes published from ', $display-l-pbs-date, ' to ', $display-h-pbs-date) else '',        if (count($ts-pbsman-dates) = 1) then concat('Pharmaceutical Benefits Scheme (PBS) codes published on ', $display-l-pbsman-date)          else if (count($ts-pbsman-dates) &gt; 1) then concat('Pharmaceutical Benefits Scheme (PBS) codes published from ', $display-l-pbsman-date, ' to ', $display-h-pbsman-date) else ''        )[. != ''] " />
    <xsl:variable name="report-ts" select="if (not(exists($report-ts-1))) then ' The IQ Rules did not have access to a Terminology Server.'        else if (count($report-ts-1) = 1) then concat(' The IQ Rules had access to a Terminology Server containing ', $report-ts-1[1], '.')        else concat(' The IQ Rules had access to a Terminology Server containing ',           string-join($report-ts-1[position() &lt; last()], ', '), ' and ', $report-ts-1[last()], '.') " />
    <xsl:variable name="report-no-ts-1" select="(if ($use-ts-for-sctau) then '' else 'SNOMED CT-AU',        if ($use-ts-for-loinc) then '' else 'LOINC',        if ($use-ts-for-anzsco) then '' else 'ANZSCO',        if ($use-ts-for-vaccines) then '' else 'Australian Vaccines',        if ($use-ts-for-ncts-data-comp) then '' else 'NCTS Data Components',        if ($use-ts-for-pbs) then '' else 'Pharmaceutical Benefits Scheme (PBS) Item',        if ($use-ts-for-pbsman) then '' else 'Pharmaceutical Benefits Scheme (PBS) Manufacturer'        )[. != ''] " />
    <xsl:variable name="report-no-ts" select="if (not(exists($report-no-ts-1))) then ''        else if (count($report-no-ts-1) = 1) then concat(' The IQ Rules could not use a Terminology Server for ', $report-no-ts-1[1], ' codes.')        else concat(' The IQ Rules could not use a Terminology Server for ',           string-join($report-no-ts-1[position() &lt; last()], ', '), ' or ', $report-no-ts-1[last()], ' codes.') " />
    <xsl:variable name="ts-error-1" select="(if ($ts-snomedctau-temp = 'Error') then 'SNOMED CT-AU' else '',         if ($ts-loinc-temp = 'Error') then 'LOINC' else '',         if ($ts-anzsco-temp = 'Error') then 'ANZSCO' else '',         if ($ts-vaccines-temp = 'Error') then 'Australian Vaccines' else '',         if ($ts-ncts-data-comp-temp = 'Error') then 'NCTS Data Components' else '',         if ($ts-pbs-temp = 'Error') then 'Pharmaceutical Benefits Scheme (PBS) Item' else '',         if ($ts-pbsman-temp = 'Error') then 'Pharmaceutical Benefits Scheme (PBS) Manufacturer' else ''        )[. != ''] " />
    <xsl:variable name="ts-error" select="if (not(exists($ts-error-1))) then ''        else if (count($ts-error-1) = 1)         then concat(' An error was reported when accessing the terminology server using function GetCodeSystemVersionsUsingTS to obtain code system versions for ', $ts-error-1[1], ' codes.')        else concat(' An error was reported when accessing the terminology server using function GetCodeSystemVersionsUsingTS to obtain code system versions for ',           string-join($ts-error-1[position() &lt; last()], ', '), ' and ', $ts-error-1[last()], ' codes.') " />
    <!--REPORT -->
    <xsl:if test=" . ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		This report was generated by IQ Rules version 1.6 with the following configuration:

		about-IQ-Rules = '<xsl:text /><xsl:value-of select="$about-IQ-Rules" /><xsl:text />'
		test-data = '<xsl:text /><xsl:value-of select="$test-data" /><xsl:text />'
		allow-debug = '<xsl:text /><xsl:value-of select="$allow-debug" /><xsl:text />'
		allow-hints = '<xsl:text /><xsl:value-of select="$allow-hints" /><xsl:text />'
		allow-ratings = '<xsl:text /><xsl:value-of select="$allow-ratings" /><xsl:text />'
		assess-values = '<xsl:text /><xsl:value-of select="$assess-values" /><xsl:text />'
		coding = '<xsl:text /><xsl:value-of select="$coding" /><xsl:text />'
		collection-same-record = '<xsl:text /><xsl:value-of select="$collection-same-record" /><xsl:text />'
		collection-same-system = '<xsl:text /><xsl:value-of select="$collection-same-system" /><xsl:text />'
		narrative-auto-generated = '<xsl:text /><xsl:value-of select="$narrative-auto-generated" /><xsl:text />'
		narrative-derived = '<xsl:text /><xsl:value-of select="$narrative-derived" /><xsl:text />'
		report-data = '<xsl:text /><xsl:value-of select="$report-data" /><xsl:text />'
		report-data-quality = '<xsl:text /><xsl:value-of select="$report-data-quality" /><xsl:text />'
		report-statistics = '<xsl:text /><xsl:value-of select="$report-statistics" /><xsl:text />'
		report-terminology-concepts = '<xsl:text /><xsl:value-of select="$report-terminology-concepts" /><xsl:text />'
		<xsl:text /><xsl:value-of select="$iq-config-msg" /><xsl:text /><xsl:text /><xsl:value-of select="$validator-msg" /><xsl:text /><xsl:text /><xsl:value-of select="$v-amtv2-msg" /><xsl:text /><xsl:text /><xsl:value-of select="$separator-1" /><xsl:text /><xsl:text /><xsl:value-of select="$v-amtv3-msg" /><xsl:text /><xsl:text /><xsl:value-of select="$separator-2" /><xsl:text /><xsl:text /><xsl:value-of select="$v-pbs-msg" /><xsl:text /><xsl:text /><xsl:value-of select="$separator-3" /><xsl:text /><xsl:text /><xsl:value-of select="$v-pbsman-msg" /><xsl:text /><xsl:text /><xsl:value-of select="$separator-4" /><xsl:text /><xsl:text /><xsl:value-of select="$v-snomedctau-msg" /><xsl:text /><xsl:text /><xsl:value-of select="$separator-5" /><xsl:text /><xsl:text /><xsl:value-of select="$report-ts" /><xsl:text /><xsl:text /><xsl:value-of select="$report-no-ts" /><xsl:text /><xsl:text /><xsl:value-of select="if ($ts-error = '') then '' else concat($ts-error,     ' The analysis should be retried as the terminology server may have been temporarily unavailable.',    ' If the problem persists then report the issue to the Australian Digital Health Agency for investigation.')" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M21" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M21" />
  <xsl:template match="@*|node()" priority="-2" mode="M21">
    <xsl:apply-templates select="@*|*" mode="M21" />
  </xsl:template>
  <!--PATTERN p-About-test-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument " priority="1000" mode="M22">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument " />
    <!--REPORT -->
    <xsl:if test=" $log-concepts-created = 'ERROR' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$log-concepts-created = 'ERROR'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: The CreateLog function returned 'ERROR' when requested to create the concepts log '<xsl:text /><xsl:value-of select="$log-concepts-name" /><xsl:text />'.

           </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M22" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M22" />
  <xsl:template match="@*|node()" priority="-2" mode="M22">
    <xsl:apply-templates select="@*|*" mode="M22" />
  </xsl:template>
  <!--PATTERN p-TS-Coding-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument[$flags/@coding = 'true'] " priority="1000" mode="M23">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument[$flags/@coding = 'true'] " />
    <xsl:variable name="concepts-for-coding" select="document('file:///C:/ClinicalDocuments/Concepts-for-coding.xml')/concepts" />
    <xsl:variable name="term-num" select="count($concepts-for-coding/concept)" />
    <xsl:variable name="coding" select="$iq-config/coding" />
    <xsl:variable name="coding-start" select="if ($coding/@start) then $coding/@start else '1' " />
    <xsl:variable name="coding-end" select="if ($coding/@end and $coding/@end &lt; $term-num) then $coding/@end else $term-num" />
    <xsl:variable name="number-to-code" select="xs:integer($coding-end - $coding-start + '1') " />
    <xsl:variable name="is-problem-diagnosis" select="$iq-config/coding/@data-element = 'med-hist-diag' " />
    <xsl:variable name="is-procedure" select="$iq-config/coding/@data-element = 'med-hist-proc'" />
    <xsl:variable name="is-uncategorised" select="$iq-config/coding/@data-element = 'med-hist-uncategorised'" />
    <xsl:variable name="p-classification" select="if ($is-problem-diagnosis and exists($coding/primary-diag-classification)) then $coding/primary-diag-classification        else if ($is-procedure and exists($coding/primary-proc-classification)) then $coding/primary-proc-classification         else if ($is-uncategorised and (exists($coding/primary-diag-classification) or exists($coding/primary-proc-classification)))         then ($coding/primary-diag-classification, $coding/primary-proc-classification)        else () " />
    <xsl:variable name="p-number" select="count($p-classification) " />
    <xsl:variable name="p-formula" select="string-join(for $class in $p-classification return $class/@code, ' OR ')" />
    <xsl:variable name="s-classification" select="if ($is-problem-diagnosis and exists($coding/secondary-diag-classification)) then $coding/secondary-diag-classification         else if ($is-procedure and exists($coding/secondary-proc-classification)) then $coding/secondary-proc-classification         else if ($is-uncategorised and (exists($coding/secondary-diag-classification) or exists($coding/secondary-proc-classification)))         then ($coding/secondary-diag-classification, $coding/secondary-proc-classification)        else () " />
    <xsl:variable name="s-number" select="count($s-classification) " />
    <xsl:variable name="s-formula" select="string-join(for $class in $s-classification return $class/@code, ' OR ')" />
    <xsl:variable name="t-classification" select="if ($is-problem-diagnosis and exists($coding/tertiary-diag-classification)) then $coding/tertiary-diag-classification         else if ($is-procedure and exists($coding/tertiary-proc-classification)) then $coding/tertiary-proc-classification         else if ($is-uncategorised and (exists($coding/tertiary-diag-classification) or exists($coding/tertiary-proc-classification)))         then ($coding/tertiary-diag-classification, $coding/tertiary-proc-classification)        else () " />
    <xsl:variable name="t-number" select="count($t-classification) " />
    <xsl:variable name="t-formula" select="string-join(for $class in $t-classification return $class/@code, ' OR ')" />
    <xsl:variable name="max-code-number" select="if ($knowledge/search-for-term/max-sct-code-number/@value &gt; '5') then $knowledge/search-for-term/max-sct-code-number/@value else '5' " />
    <xsl:variable name="codesystemvalues" select="$code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']" />
    <xsl:variable name="defn-common-inv-regex" select="if (not($cd-definitions/diag-proc/@invalid-regex)) then () else tokenize($cd-definitions/diag-proc/@invalid-regex, '\|\|') " />
    <xsl:variable name="defn-diag-inv-regex" select="if (not($is-problem-diagnosis) or not($cd-definitions/diag/@invalid-regex)) then ()        else tokenize($cd-definitions/diag/@invalid-regex, '\|\|') " />
    <xsl:variable name="defn-proc-inv-regex" select="if (not($is-procedure) or not($cd-definitions/proc/@invalid-regex)) then ()        else tokenize($cd-definitions/proc/@invalid-regex, '\|\|') " />
    <xsl:variable name="defn-invalid-regex" select="($defn-common-inv-regex, $defn-diag-inv-regex, $defn-proc-inv-regex)[. != ''] " />
    <xsl:variable name="defn-invalid-txt-regex" select="(for $i in (1 to count($defn-invalid-regex)) return normalize-space(substring-before($defn-invalid-regex[$i], '[[')))[. != '']" />
    <xsl:variable name="vaccine-codes" select="$code-systems/system[@codeSystem = '1.2.36.1.2001.1005.17']/code " />
    <xsl:variable name="vaccine-text" select="($vaccine-codes/@displayName, tokenize(string-join(($vaccine-codes/@synonyms, $vaccine-codes/@related-terms), '|'), '\|'))[. != '']" />
    <xsl:variable name="vaccine-text-normalised" select="for $vaccine in $vaccine-text return translate(normalize-space(lower-case($vaccine)), $chars-to-remove, '')" />
    <xsl:variable name="diag-formula" select="'&lt;&lt;404684003 OR &lt;&lt;272379006 OR &lt;&lt;243796009' " />
    <xsl:variable name="proc-formula" select="'&lt;&lt;71388002' " />
    <xsl:variable name="formula" select="if ($is-problem-diagnosis) then concat($diag-formula, ' OR ', $inactive-refSets)        else if ($is-procedure) then concat($proc-formula, ' OR ', $inactive-refSets)        else if ($is-uncategorised) then concat($diag-formula, ' OR ', $proc-formula, ' OR ', $inactive-refSets)        else '' " />
    <xsl:variable name="der-text-1" select="for $i in (xs:integer($coding-start) to xs:integer($coding-end)) return         normalize-space(replace($concepts-for-coding/concept[$i]/@value, $confirmed-markup-regex, ' ')) " />
    <xsl:variable name="display-text-to-code" select="for $i in (1 to $number-to-code) return        normalize-space(replace(dh:XQueryRecursiveReplace($der-text-1[$i], $text-pattern-replacement, 'ic'),          '([^a-zA-Z])(Doctor|Dr\.?)(\s+[\.a-zA-Z]+\s+[\.a-zA-Z]+\s+[''\-a-zA-Z]+|\s+[\.a-zA-Z]+\s+[''\-a-zA-Z]+|\s+[''\-a-zA-Z]+)([^a-zA-Z]|$)', '$1$2 XXX $4'))" />
    <xsl:variable name="der-negated-text" select="for $i in (1 to $number-to-code) return matches($der-text-1[$i], '\?\s*no(^[a-z]|$)', 'i') " />
    <xsl:variable name="typo-replacements" select="if ($der-text-1 = '') then ''         else if ($is-problem-diagnosis and not($diag-typo = '')) then $diag-typo        else if ($is-procedure and not($proc-typo = '')) then $proc-typo        else if ($is-uncategorised and not($diag-typo = '') and not($proc-typo = '')) then concat($diag-typo, '~', $proc-typo)        else if ($is-uncategorised and $diag-typo = '' and not($proc-typo = '')) then $proc-typo        else if ($is-uncategorised and not($diag-typo = '') and $proc-typo = '') then $diag-typo        else '' " />
    <xsl:variable name="diag-proc-fir-pattern-replacement" select="if ($typo-replacements = '') then concat($diag-proc-fir-1, '~', $month-replacements, '~secondary to.+$~ ')           else concat($diag-proc-fir-1, '~', $typo-replacements, '~', $month-replacements, '~secondary to.+$~ ') " />
    <xsl:variable name="der-text-2" select="for $i in (1 to $number-to-code) return if ($der-negated-text[$i]) then '' else         normalize-space(replace(dh:XQueryRecursiveReplace($der-text-1[$i],          concat($diag-proc-fir-pattern-replacement, '~(^|[^0-9])[1-2]{1}[0-9]{3}([^0-9]|$)~$1 $2'), 'ic'),          '([^a-zA-Z])(Doctor|Dr\.?)(\s+[\.a-zA-Z]+\s+[\.a-zA-Z]+\s+[''\-a-zA-Z]+|\s+[\.a-zA-Z]+\s+[''\-a-zA-Z]+|\s+[''\-a-zA-Z]+)([^a-zA-Z]|$)', '$1 $4'))" />
    <xsl:variable name="der-text-2-laterality" select="for $i in (1 to $number-to-code) return if (matches($der-text-2[$i], $laterality-regex, 'is'))         then replace($der-text-2[$i], $laterality-regex, '$1 $3', 'is') else '' " />
    <xsl:variable name="defn-valid-regex" select="for $i in (1 to $number-to-code) return concat('(^|\|)', translate($der-text-2[$i], $chars-to-remove, ''), '(\||$)') " />
    <xsl:variable name="defn-laterality-regex" select="for $i in (1 to $number-to-code) return if ($der-text-2-laterality[$i] = '') then ''         else concat('(^|\|)', translate($der-text-2-laterality[$i], $chars-to-remove, ''), '(\||$)') " />
    <xsl:variable name="der-text-3" select="for $i in (1 to $number-to-code) return if ($der-negated-text[$i] or $der-text-2[$i] = '') then ''         else if ($is-problem-diagnosis and not($diag-replacements = '')) then dh:XQueryRecursiveReplace($der-text-2[$i], $diag-replacements, 'ic')        else if ($is-procedure and not($proc-replacements = '')) then dh:XQueryRecursiveReplace($der-text-2[$i], $proc-replacements, 'ic')        else if ($is-uncategorised and not($diag-replacements = '') and not($proc-replacements = ''))          then dh:XQueryRecursiveReplace($der-text-2[$i], concat($diag-replacements, '~', $proc-replacements), 'ic')        else if ($is-uncategorised and $diag-replacements = '' and not($proc-replacements = ''))          then dh:XQueryRecursiveReplace($der-text-2[$i], $proc-replacements, 'ic')        else if ($is-uncategorised and not($diag-replacements = '') and $proc-replacements = '')          then dh:XQueryRecursiveReplace($der-text-2[$i], $diag-replacements, 'ic')        else $der-text-2[$i] " />
    <xsl:variable name="der-text" select="for $i in (1 to $number-to-code) return         normalize-space(replace(dh:XQueryRecursiveReplace($der-text-3[$i],          '(^|[^a-z])r([^a-z]|$)~$1 right $2~(^|[^a-z])l([^a-z]|$)~$1 left $2', 'ic'), '([a-z])''s', '$1', 'i')) " />
    <xsl:variable name="der-text-to-match" select="for $i in (1 to $number-to-code) return translate(lower-case($der-text-2[$i]), $chars-to-remove, '') " />
    <xsl:variable name="der-text-non-value" select="for $i in (1 to $number-to-code) return         if ($der-negated-text[$i]) then false()        else if ($der-text-to-match[$i] = '' or not(matches($der-text-2[$i], '[a-z0-9]', 'i')) or         ($cd-definitions/non-value/@regex != '' and matches($der-text-2[$i], $cd-definitions/non-value/@regex, 'i'))) then true()         else if ($is-problem-diagnosis) then          exists($cd-definitions/diag/@non-value-regex) and matches($der-text-2[$i], $cd-definitions/diag/@non-value-regex, 'i')        else if ($is-procedure) then          exists($cd-definitions/proc/@non-value-regex) and matches($der-text-2[$i], $cd-definitions/proc/@non-value-regex, 'i')        else if ($is-uncategorised) then          (exists($cd-definitions/diag/@non-value-regex) and matches($der-text-2[$i], $cd-definitions/diag/@non-value-regex, 'i')) or         (exists($cd-definitions/proc/@non-value-regex) and matches($der-text-2[$i], $cd-definitions/proc/@non-value-regex, 'i'))        else false() " />
    <xsl:variable name="der-invalid-text" select="for $i in (1 to $number-to-code) return        if (matches($der-text-2[$i], '800360[0-9]{10}') or matches($der-text-2[$i], '(^|\W+)(Dear (Doctor|Dr)|Thank\W+you)\W+', 'is')) then true()        else if (exists($defn-invalid-txt-regex))        then exists(index-of(for $j in (1 to count($defn-invalid-txt-regex)) return matches($der-text-2[$i], $defn-invalid-txt-regex[$j], 'i'), true()))        else false() " />
    <xsl:variable name="related-terms-1" select="($codesystemvalues/code[@related-terms], $codesystemvalues/related-terms[@related-terms]) " />
    <xsl:variable name="related-terms-2" select="for $i in (1 to $number-to-code) return string-join(for $j in index-of(for $concept in $related-terms-1 return         matches(translate($concept/@related-terms, $chars-no-pipe, ''), $defn-valid-regex[$i], 'i') or        ($defn-laterality-regex[$i] != '' and matches(translate($concept/@related-terms, $chars-no-pipe, ''), $defn-laterality-regex[$i], 'i')), true())         return $related-terms-1[$j]/@code, '|') " />
    <xsl:variable name="try-immun" select="for $i in (1 to $number-to-code) return false() " />
    <xsl:variable name="an-immun-1" select="for $i in (1 to $number-to-code) return $try-immun[$i] and (matches($der-text[$i], '(^|[^a-z])(immunizations?|immunisations?)([^a-z]|$)', 'i') or         (exists($vaccine-text-normalised) and $der-text-to-match[$i] = $vaccine-text-normalised)) " />
    <xsl:variable name="ts-not-needed" select="for $i in (1 to $number-to-code) return        $related-terms-2[$i] != '' or $der-text[$i] = '' or matches($der-text[$i], '^NARRATIVE$', 'i') or $der-negated-text[$i] or $der-text-non-value[$i] or          $der-invalid-text[$i] or $an-immun-1[$i] " />
    <xsl:variable name="der-diag-proc-codes-1" select="for $i in (1 to $number-to-code) return        if ($related-terms-2[$i] != '') then $related-terms-2[$i]        else if ($ts-not-needed[$i] or not($use-ts-for-sctau)) then ''         else dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $formula, $der-text[$i],          $max-code-number, false()) " />
    <xsl:variable name="error-usingTS-1" select="for $i in (1 to $number-to-code) return $der-diag-proc-codes-1[$i] = 'Error' " />
    <xsl:variable name="der-diag-proc-code-found-1" select="for $i in (1 to $number-to-code) return matches($der-diag-proc-codes-1[$i], '^[0-9]') " />
    <xsl:variable name="der-no-qual-text" select="for $i in (1 to $number-to-code) return        if ($ts-not-needed[$i] or $error-usingTS-1[$i] or $der-diag-proc-code-found-1[$i]) then ''        else normalize-space(dh:XQueryRecursiveReplace($der-text[$i], $no-qual-pattern, 'ic')) " />
    <xsl:variable name="use-no-qual-text" select="for $i in (1 to $number-to-code) return $der-no-qual-text[$i] != '' and $der-no-qual-text[$i] != $der-text[$i] " />
    <xsl:variable name="der-diag-proc-codes-2" select="for $i in (1 to $number-to-code) return        if ($der-diag-proc-code-found-1[$i]) then $der-diag-proc-codes-1[$i]        else if ($ts-not-needed[$i] or $error-usingTS-1[$i]) then ''        else if ($use-no-qual-text[$i] and $use-ts-for-sctau) then          dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $formula, $der-no-qual-text[$i],           $max-code-number, false())        else '' " />
    <xsl:variable name="error-usingTS-2" select="for $i in (1 to $number-to-code) return $error-usingTS-1[$i] or $der-diag-proc-codes-2[$i] = 'Error' " />
    <xsl:variable name="der-diag-proc-code-found-2" select="for $i in (1 to $number-to-code) return matches($der-diag-proc-codes-2[$i], '^[0-9]') " />
    <xsl:variable name="der-stem-text-1" select="for $i in (1 to $number-to-code) return        if ($der-diag-proc-code-found-2[$i] or $ts-not-needed[$i]) then ''         else if ($use-no-qual-text[$i]) then $der-no-qual-text[$i]        else $der-text[$i] " />
    <xsl:variable name="der-stem-text" select="for $i in (1 to $number-to-code) return if ($der-stem-text-1[$i] = '') then ''         else dh:XQueryRecursiveReplace($der-stem-text-1[$i],          '(^|[^a-z])of([^a-z]|$)~$1$2~([a-z]{3,})[a-z]{1}($|[^a-z])~$1$2~(^|[^a-z])[a-z]{1}([^a-z]|$)~$1$2~(^|[^0-9])[0-9]{1}([^0-9z]|$)~$1$2',          'ic') " />
    <xsl:variable name="use-stem-text" select="for $i in (1 to $number-to-code) return $der-stem-text[$i] != '' and $der-stem-text[$i] != $der-stem-text-1[$i] " />
    <xsl:variable name="der-diag-proc-codes-3" select="for $i in (1 to $number-to-code) return        if ($der-diag-proc-code-found-2[$i]) then $der-diag-proc-codes-2[$i]        else if ($ts-not-needed[$i] or $error-usingTS-2[$i]) then ''        else if ($use-stem-text[$i] and $use-ts-for-sctau) then          dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $formula, $der-stem-text[$i],           $max-code-number, false())        else '' " />
    <xsl:variable name="error-usingTS-3" select="for $i in (1 to $number-to-code) return $error-usingTS-2[$i] or $der-diag-proc-codes-3[$i] = 'Error' " />
    <xsl:variable name="der-code-1" select="for $i in (1 to $number-to-code) return         replace(string-join(tokenize($der-diag-proc-codes-3[$i], '\|')[not(contains(., '~inactive'))], '|'), '^([0-9]+)\[.+?\](\||$)', '$1$2', 'is') " />
    <xsl:variable name="inactive-terms-1" select="for $i in (1 to $number-to-code) return if (contains($der-diag-proc-codes-3[$i], '~inactive'))         then replace(string-join(tokenize($der-diag-proc-codes-3[$i], '\|')[contains(., '~inactive')], '|'), '^([0-9]+)\[.+?\](\||$)', '$1$2', 'is')         else '' " />
    <xsl:variable name="inactive-terms-2" select="for $i in (1 to $number-to-code) return        if ($ts-not-needed[$i] or $error-usingTS-3[$i] or not(matches($inactive-terms-1[$i], '^[0-9]'))) then ''        else replace(string-join(tokenize(dh:IsCodeAssociatedWithAnotherCode(tokenize($inactive-terms-1[$i], '\|')[1], '2.16.840.1.113883.6.96', $v-current-sctau),          '\|')[matches(., '(REPLACED BY|SAME AS|ALTERNATIVE|POSSIBLY EQUIVALENT TO|MAY BE A|WAS A)')], '|'), '[0-9]+~[A-Z ]+~([0-9]+)', '$1') " />
    <xsl:variable name="der-code-2" select="for $i in (1 to $number-to-code) return        if ($der-code-1[$i] != '') then $der-code-1[$i]        else if ($ts-not-needed[$i] or $error-usingTS-3[$i] or not($is-problem-diagnosis) or not($use-ts-for-sctau)) then ''        else replace(dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $proc-formula, $der-no-qual-text[$i],           $max-code-number, false()), '([0-9]+)\[.+?\](\||$)', '$1$2', 'is') " />
    <xsl:variable name="error-usingTS-4" select="for $i in (1 to $number-to-code) return $error-usingTS-3[$i] or $der-code-2[$i] = 'Error' " />
    <xsl:variable name="der-code-3" select="for $i in (1 to $number-to-code) return         string-join(distinct-values((tokenize($inactive-terms-2[$i], '\|'), tokenize($der-code-2[$i], '\|'))[. != '']), '|') " />
    <xsl:variable name="valid-refset" select="if ($is-problem-diagnosis) then '^32570581000036105'         else if ($is-procedure) then '^32570141000036105'         else if ($is-uncategorised) then '(^32570581000036105 OR ^32570141000036105)'        else '' " />
    <xsl:variable name="invalid-refset" select="if ($is-problem-diagnosis) then $diag-invalid-refset         else if ($is-procedure) then $proc-invalid-refset         else if ($is-uncategorised) then $diag-proc-invalid-refset         else '' " />
    <xsl:variable name="code-set" select="for $i in (1 to $number-to-code) return if ($der-code-3[$i] = '') then '' else concat('(', replace($der-code-3[$i], '\|', ' OR '), ')') " />
    <xsl:variable name="der-code-num-1" select="for $i in (1 to $number-to-code) return string(count(tokenize($der-code-3[$i], '\|'))) " />
    <xsl:variable name="refset-formula" select="for $i in (1 to $number-to-code) return if ($code-set[$i] = '') then ''         else if ($invalid-refset = '') then concat($code-set[$i], ' AND ', $valid-refset)        else concat('(', $code-set[$i], ' AND ', $valid-refset, ') MINUS ', $invalid-refset) " />
    <xsl:variable name="refset-code-set" select="for $i in (1 to $number-to-code) return if ($refset-formula[$i] = '' or $error-usingTS-4[$i] or not($use-ts-for-sctau)) then ''        else replace(dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $refset-formula[$i], '',          $der-code-num-1[$i], false()), '([0-9]+)\[.+?\](\||$)', '$1$2') " />
    <xsl:variable name="error-usingTS-5" select="for $i in (1 to $number-to-code) return $error-usingTS-4[$i] or $refset-code-set[$i] = 'Error' " />
    <xsl:variable name="invalid-hierarchy" select="if ($is-problem-diagnosis) then $diag-invalid-hierarchy         else if ($is-procedure) then $proc-invalid-hierarchy         else if ($is-uncategorised) then $diag-proc-invalid-hierarchy        else '' " />
    <xsl:variable name="valid-code-set" select="for $i in (1 to $number-to-code) return if ($invalid-hierarchy = '' or $error-usingTS-5[$i] or not($use-ts-for-sctau)) then ''        else string-join((for $code in tokenize($refset-code-set[$i], '\|') return          if (matches(dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl',           concat('&gt;&gt;', $code, ' MINUS ', $invalid-hierarchy), '', '1', false()), '^[0-9]')) then $code else '')[. != ''], '|') " />
    <xsl:variable name="valid-codes-1" select="for $i in (1 to $number-to-code) return string-join(tokenize($der-code-3[$i], '\|')        [matches($valid-code-set[$i], concat('(^|\|)', ., '(\||$)'))], '|') " />
    <xsl:variable name="valid-codes-2" select="for $i in (1 to $number-to-code) return if ($valid-codes-1[$i] = '') then 'no code' else (tokenize($valid-codes-1[$i], '\|'))[1]" />
    <xsl:variable name="valid-class-1" select="for $i in (1 to $number-to-code) return         if ($error-usingTS-5[$i] or not($p-number &gt; 0) or not(matches($valid-codes-2[$i], '[0-9]+')) or not($use-ts-for-sctau)) then ''        else replace(replace(dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl',          concat('&gt;&gt;', $valid-codes-2[$i], ' AND (', $p-formula, ')'), '', string($p-number), true()), '(\[|\]\|)', '~'), '\]$', '') " />
    <xsl:variable name="error-usingTS-6" select="for $i in (1 to $number-to-code) return $error-usingTS-5[$i] or $valid-class-1[$i] = 'Error' " />
    <xsl:variable name="valid-class-2" select="for $i in (1 to $number-to-code) return if ($valid-class-1[$i] != '') then $valid-class-1[$i]        else if ($error-usingTS-6[$i] or not($s-number &gt; 0) or not(matches($valid-codes-2[$i], '[0-9]+')) or not($use-ts-for-sctau)) then ''        else replace(replace(dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl',          concat('&gt;&gt;', $valid-codes-2[$i], ' AND (', $s-formula, ')'), '', string($s-number), true()), '(\[|\]\|)', '~'), '\]$', '') " />
    <xsl:variable name="error-usingTS-7" select="for $i in (1 to $number-to-code) return $error-usingTS-6[$i] or $valid-class-2[$i] = 'Error' " />
    <xsl:variable name="valid-class-3" select="for $i in (1 to $number-to-code) return if ($valid-class-2[$i] != '') then $valid-class-2[$i]        else if ($error-usingTS-7[$i] or not($t-number &gt; 0) or not(matches($valid-codes-2[$i], '[0-9]+')) or not($use-ts-for-sctau)) then ''        else replace(replace(dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl',          concat('&gt;&gt;', $valid-codes-2[$i], ' AND (', $t-formula, ')'), '', string($t-number), true()), '(\[|\]\|)', '~'), '\]$', '') " />
    <xsl:variable name="error-usingTS-8" select="for $i in (1 to $number-to-code) return $error-usingTS-7[$i] or $valid-class-3[$i] = 'Error' " />
    <xsl:variable name="valid-class" select="for $i in (1 to $number-to-code) return if ($valid-class-3[$i] = '') then 'unclassified' else concat('isa|', $valid-class-3[$i]) " />
    <xsl:variable name="valid-codes" select="for $i in (1 to $number-to-code) return         if ($error-usingTS-8[$i] or not($use-ts-for-sctau)) then ''        else if (matches($valid-codes-2[$i], '[0-9]+')) then concat($valid-codes-2[$i], '~',          dh:FindPreferredTermUsingTS($valid-codes-2[$i], '2.16.840.1.113883.6.96', $ts-current-sctau), '|', $valid-class[$i])         else '' " />
    <xsl:variable name="error-name-usingTS" select="for $i in (1 to $number-to-code) return $valid-codes[$i] = 'Error' " />
    <xsl:variable name="an-immun" select="for $i in (1 to $number-to-code) return $valid-codes[$i] = '' and $try-immun[$i] and $an-immun-1[$i] " />
    <xsl:variable name="der-invalid-domain" select="for $i in (1 to $number-to-code) return not($an-immun[$i]) and ($der-code-3[$i] != '' and not($valid-codes[$i] != '')) " />
    <xsl:variable name="try-tgi" select="for $i in (1 to $number-to-code) return        not($is-problem-diagnosis) and not($der-code-3[$i] != '' or $der-text[$i] = '' or $der-negated-text[$i] or $der-text-non-value[$i] or         $der-invalid-text[$i] or $an-immun[$i] or $valid-codes[$i] != '' or $der-invalid-domain[$i]) " />
    <xsl:variable name="try-tgi" select="for $i in (1 to $number-to-code) return false() " />
    <xsl:variable name="der-tgi-text-1" select="for $i in (1 to $number-to-code) return        if ($try-tgi[$i]) then normalize-space(dh:XQueryRecursiveReplace($der-text-1[$i], $tgi-fir-pattern-replacement, 'ic')) else '' " />
    <xsl:variable name="der-tgi-text" select="for $i in (1 to $number-to-code) return        if ($der-tgi-text-1[$i] = '' or $tgi-regex = '') then $der-tgi-text-1[$i]        else normalize-space(dh:XQueryRecursiveReplace($der-tgi-text-1[$i], $tgi-regex, 'ic')) " />
    <xsl:variable name="a-sas-tgi" select="for $i in (1 to $number-to-code) return $try-tgi[$i] and $tgi-sas-regex != '' and matches($der-tgi-text[$i], $tgi-sas-regex, 'is')" />
    <xsl:variable name="an-uncoded-tgi" select="for $i in (1 to $number-to-code) return $try-tgi[$i] and $tgi-otheru-regex != '' and matches($der-tgi-text[$i], $tgi-otheru-regex, 'is')" />
    <xsl:variable name="der-tgi-codes-1" select="for $i in (1 to $number-to-code) return         if ($error-usingTS-8[$i]) then ''        else if ($try-tgi[$i] and not($a-sas-tgi[$i] or $an-uncoded-tgi[$i]) and $use-ts-for-sctau)         then dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $tgi-formula, $der-tgi-text[$i],           $max-code-number, false())         else '' " />
    <xsl:variable name="error-usingTS-9" select="for $i in (1 to $number-to-code) return $error-usingTS-8[$i] or $der-tgi-codes-1[$i] = 'Error' " />
    <xsl:variable name="a-tgi-1" select="for $i in (1 to $number-to-code) return        $try-tgi[$i] and ($a-sas-tgi[$i] or $an-uncoded-tgi[$i] or contains($der-tgi-codes-1[$i], '[')) " />
    <xsl:variable name="der-revised-tgi-text" select="for $i in (1 to $number-to-code) return        if ($try-tgi[$i] and not($a-tgi-1[$i]))        then normalize-space(dh:XQueryRecursiveReplace($der-tgi-text[$i], $tgi-sec-pattern-replacement, 'ic'))         else '' " />
    <xsl:variable name="use-revised-tgi-text" select="for $i in (1 to $number-to-code) return $der-revised-tgi-text[$i] != '' and $der-revised-tgi-text[$i] != $der-tgi-text[$i] " />
    <xsl:variable name="der-tgi-codes-2" select="for $i in (1 to $number-to-code) return        if ($error-usingTS-9[$i]) then ''        else if ($try-tgi[$i] and not($a-tgi-1[$i]) and $use-revised-tgi-text[$i] and $use-ts-for-sctau)        then dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $tgi-formula, $der-revised-tgi-text[$i],          $max-code-number, false())         else '' " />
    <xsl:variable name="error-usingTS-10" select="for $i in (1 to $number-to-code) return $error-usingTS-9[$i] or $der-tgi-codes-2[$i] = 'Error' " />
    <xsl:variable name="a-tgi-2" select="for $i in (1 to $number-to-code) return $a-tgi-1[$i] or contains($der-tgi-codes-2[$i], '[') " />
    <xsl:variable name="der-final-revised-tgi-text" select="for $i in (1 to $number-to-code) return        if ($try-tgi[$i] and not($a-tgi-2[$i]))          then normalize-space(dh:XQueryRecursiveReplace($der-revised-tgi-text[$i], $tgi-thi-pattern-replacement, 'ic'))         else '' " />
    <xsl:variable name="use-final-revised-tgi-text" select="for $i in (1 to $number-to-code) return         $der-final-revised-tgi-text[$i] != '' and $der-final-revised-tgi-text[$i] != $der-revised-tgi-text[$i] " />
    <xsl:variable name="der-tgi-codes-3" select="for $i in (1 to $number-to-code) return        if ($error-usingTS-10[$i]) then ''        else if ($try-tgi[$i] and not($a-tgi-2[$i]) and $use-final-revised-tgi-text[$i] and $use-ts-for-sctau)          then dh:SearchForCodesInHierarchyUsingTS('2.16.840.1.113883.6.96', $ts-current-sctau, 'ecl', $tgi-formula, $der-final-revised-tgi-text[$i],          $max-code-number, false())        else '' " />
    <xsl:variable name="error-usingTS-11" select="for $i in (1 to $number-to-code) return $error-usingTS-10[$i] or $der-tgi-codes-3[$i] = 'Error' " />
    <xsl:variable name="a-tgi" select="for $i in (1 to $number-to-code) return $a-tgi-2[$i] or contains($der-tgi-codes-3[$i], '[') " />
    <xsl:variable name="display-result" select="for $i in (1 to $number-to-code) return         if ($error-usingTS-11[$i]) then concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start, ')[error]')        else if ($der-text-1[$i] = '' or $der-text-non-value[$i]) then concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start, ')[not a value]')        else if ($der-invalid-text[$i]) then concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start, ')[an invalid term]')        else if (not($is-problem-diagnosis) and $an-immun[$i]) then concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start,          ')[administering an immunisation is not a medical procedure]')        else if (not($is-problem-diagnosis) and $a-tgi[$i]) then concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start,          ')[a medication is not a medical procedure]')        else if ($der-invalid-domain[$i])          then concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start, ')[an invalid term]')        else if ($der-code-3[$i] = '') then concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start, ')[no codes found]')        else concat($display-text-to-code[$i], '(Term ', $i - 1 + $coding-start, ')[',          dh:XQueryRecursiveReplace($valid-codes[$i], $term-pattern-replacement, 'ic'), ']') " />
    <xsl:variable name="number-coded" select="count((for $i in (1 to $number-to-code) return if (matches($display-result[$i], '\[[0-9]+~')) then '1' else '0')[. = '1']) " />
    <xsl:variable name="term-notcoded" select="(for $i in (1 to $number-to-code) return         if (matches($display-result[$i], 'no codes', 'i')) then substring-before($display-result[$i], '[') else '')[. != ''] " />
    <xsl:variable name="number-notcoded" select="count($term-notcoded) " />
    <xsl:variable name="simple-term-notcoded" select="(for $term in $term-notcoded return if (not(matches($term, '^([^a-z]|L|Lt|Left|R|Rt|Right|MRI)\W+', 'i')) and not(matches($term, '\(\)\[\]', 'i')) and        count(tokenize(substring-before($term, '('), ' ')) &lt; 3) then $term else '')[. != ''] " />
    <xsl:variable name="term-incomplete" select="(for $i in (1 to $number-to-code) return if (matches($display-result[$i], 'not determined the value domain', 'i'))          then $display-result[$i] else '')[. != ''] " />
    <xsl:variable name="number-incomplete" select="count($term-incomplete) " />
    <xsl:variable name="group-size" select="if ($coding/@group-size) then $coding/@group-size else '400'  " />
    <xsl:variable name="term-unclassified" select="(for $i in (1 to $number-to-code) return if (matches($display-result[$i], 'unclassified\]', 'i')) then $display-result[$i] else '')[. != ''] " />
    <xsl:variable name="number-unclassified" select="count($term-unclassified) " />
    <xsl:variable name="term-error" select="(for $i in (1 to $number-to-code) return if (matches($display-result[$i], '[~\[]error\]', 'i') or $error-name-usingTS[$i])         then $display-result[$i] else '')[. != ''] " />
    <xsl:variable name="number-error" select="count($term-error) " />
    <!--REPORT -->
    <xsl:if test=" . ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding:
		Number of terms to code: <xsl:text /><xsl:value-of select="$number-to-code" /><xsl:text />.
		Number of terms coded: <xsl:text /><xsl:value-of select="$number-coded" /><xsl:text />.
		Number of terms not coded: <xsl:text /><xsl:value-of select="$number-notcoded" /><xsl:text />.
		Number of terms with incomplete coding: <xsl:text /><xsl:value-of select="$number-incomplete" /><xsl:text />.
		Number of invalid terms: <xsl:text /><xsl:value-of select="$number-to-code - ($number-coded + $number-notcoded + $number-incomplete)" /><xsl:text />.
		Number of terms coded but unclassified: <xsl:text /><xsl:value-of select="$number-unclassified" /><xsl:text />.
		Number of errors: <xsl:text /><xsl:value-of select="$number-error" /><xsl:text />.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" . ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (1 to xs:integer($group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + $group-size) to xs:integer(2 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 2 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 2 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 2 * $group-size) to xs:integer(3 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 3 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 3 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 3 * $group-size) to xs:integer(4 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 4 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 4 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 4 * $group-size) to xs:integer(5 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 5 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 5 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 5 * $group-size) to xs:integer(6 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 6 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 6 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 6 * $group-size) to xs:integer(7 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 7 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 7 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 7 * $group-size) to xs:integer(8 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 8 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 8 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 8 * $group-size) to xs:integer(9 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 9 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 9 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 9 * $group-size) to xs:integer(10 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 10 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 10 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 10 * $group-size) to xs:integer(11 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 11 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 11 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 11 * $group-size) to xs:integer(12 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 12 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 12 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 12 * $group-size) to xs:integer(13 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 13 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 13 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 13 * $group-size) to xs:integer(14 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 14 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 14 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 14 * $group-size) to xs:integer(15 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 15 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 15 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 15 * $group-size) to xs:integer(16 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 16 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 16 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 16 * $group-size) to xs:integer(17 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 17 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 17 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 17 * $group-size) to xs:integer(18 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 18 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 18 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 18 * $group-size) to xs:integer(19 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 19 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 19 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 19 * $group-size) to xs:integer(20 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 20 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 20 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 20 * $group-size) to xs:integer(21 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 21 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 21 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 21 * $group-size) to xs:integer(22 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 22 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 22 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 22 * $group-size) to xs:integer(23 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 23 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 23 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 23 * $group-size) to xs:integer(24 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 24 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 24 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 24 * $group-size) to xs:integer(25 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 25 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 25 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 25 * $group-size) to xs:integer(26 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 26 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 26 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 26 * $group-size) to xs:integer(27 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 27 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 27 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 27 * $group-size) to xs:integer(28 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 28 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 28 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 28 * $group-size) to xs:integer(29 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 29 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 29 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 29 * $group-size) to xs:integer(30 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 30 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 30 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 30 * $group-size) to xs:integer(31 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 31 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 31 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 31 * $group-size) to xs:integer(32 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 32 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 32 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 32 * $group-size) to xs:integer(33 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 33 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 33 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 33 * $group-size) to xs:integer(34 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 34 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 34 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 34 * $group-size) to xs:integer(35 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 35 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 35 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 35 * $group-size) to xs:integer(36 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 36 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 36 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 36 * $group-size) to xs:integer(37 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 37 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 37 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 37 * $group-size) to xs:integer(38 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 38 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 38 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 38 * $group-size) to xs:integer(39 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 39 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 39 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 39 * $group-size) to xs:integer(40 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 40 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 40 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 40 * $group-size) to xs:integer(41 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 41 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 41 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 41 * $group-size) to xs:integer(42 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 42 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 42 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 42 * $group-size) to xs:integer(43 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 43 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 43 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 43 * $group-size) to xs:integer(44 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 44 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 44 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 44 * $group-size) to xs:integer(45 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 45 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 45 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 45 * $group-size) to xs:integer(46 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 46 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 46 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 46 * $group-size) to xs:integer(47 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 47 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 47 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 47 * $group-size) to xs:integer(48 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 48 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 48 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 48 * $group-size) to xs:integer(49 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 49 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 49 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 49 * $group-size) to xs:integer(50 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 50 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 50 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 50 * $group-size) to xs:integer(51 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 51 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 51 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 51 * $group-size) to xs:integer(52 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 52 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 52 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 52 * $group-size) to xs:integer(53 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 53 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 53 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 53 * $group-size) to xs:integer(54 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 54 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 54 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 54 * $group-size) to xs:integer(55 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 55 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 55 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 55 * $group-size) to xs:integer(56 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 56 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 56 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 56 * $group-size) to xs:integer(57 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 57 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 57 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 57 * $group-size) to xs:integer(58 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 58 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 58 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 58 * $group-size) to xs:integer(59 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 59 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 59 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 59 * $group-size) to xs:integer(60 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 60 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 60 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 60 * $group-size) to xs:integer(61 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 61 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 61 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 61 * $group-size) to xs:integer(62 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 62 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 62 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 62 * $group-size) to xs:integer(63 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 63 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 63 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 63 * $group-size) to xs:integer(64 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 64 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 64 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 64 * $group-size) to xs:integer(65 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 65 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 65 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 65 * $group-size) to xs:integer(66 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 66 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 66 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 66 * $group-size) to xs:integer(67 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 67 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 67 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 67 * $group-size) to xs:integer(68 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 68 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 68 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 68 * $group-size) to xs:integer(69 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 69 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 69 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 69 * $group-size) to xs:integer(70 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 70 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 70 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 70 * $group-size) to xs:integer(71 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 71 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 71 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 71 * $group-size) to xs:integer(72 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 72 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 72 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 72 * $group-size) to xs:integer(73 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 73 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 73 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 73 * $group-size) to xs:integer(74 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 74 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 74 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 74 * $group-size) to xs:integer(75 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 75 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 75 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 75 * $group-size) to xs:integer(76 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 76 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 76 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 76 * $group-size) to xs:integer(77 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 77 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 77 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 77 * $group-size) to xs:integer(78 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 78 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 78 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 78 * $group-size) to xs:integer(79 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 79 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 79 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 79 * $group-size) to xs:integer(80 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 80 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 80 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 80 * $group-size) to xs:integer(81 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 81 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 81 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 81 * $group-size) to xs:integer(82 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 82 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 82 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 82 * $group-size) to xs:integer(83 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 83 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 83 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 83 * $group-size) to xs:integer(84 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 84 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 84 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 84 * $group-size) to xs:integer(85 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 85 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 85 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 85 * $group-size) to xs:integer(86 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 86 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 86 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 86 * $group-size) to xs:integer(87 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 87 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 87 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 87 * $group-size) to xs:integer(88 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 88 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 88 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 88 * $group-size) to xs:integer(89 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 89 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 89 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 89 * $group-size) to xs:integer(90 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 90 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 90 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 90 * $group-size) to xs:integer(91 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 91 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 91 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 91 * $group-size) to xs:integer(92 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 92 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 92 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 92 * $group-size) to xs:integer(93 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 93 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 93 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 93 * $group-size) to xs:integer(94 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 94 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 94 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 94 * $group-size) to xs:integer(95 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 95 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 95 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 95 * $group-size) to xs:integer(96 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 96 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 96 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 96 * $group-size) to xs:integer(97 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 97 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 97 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 97 * $group-size) to xs:integer(98 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 98 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 98 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 98 * $group-size) to xs:integer(99 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $number-to-code &gt; 99 * $group-size ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$number-to-code &gt; 99 * $group-size">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>
          <xsl:text />
          <xsl:value-of select="string-join($display-result[position() = (xs:integer(1 + 99 * $group-size) to xs:integer(100 * $group-size))], '|')" />
          <xsl:text />
        </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding:
		der-text-1 '<xsl:text /><xsl:value-of select="string-join(for $x in $der-text-1 return dh:XQueryRecursiveReplace($x, $term-pattern-replacement, 'ic'), '~')" /><xsl:text />'
		der-text-2 '<xsl:text /><xsl:value-of select="string-join(for $x in $der-text-2 return dh:XQueryRecursiveReplace($x, $term-pattern-replacement, 'ic'), '~')" /><xsl:text />'
		der-text-to-match '<xsl:text /><xsl:value-of select="string-join(for $x in $der-text-to-match return dh:XQueryRecursiveReplace($x, $term-pattern-replacement, 'ic'), '~')" /><xsl:text />'
		
	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding:
		der-text-3 '<xsl:text /><xsl:value-of select="string-join($der-text-3, '~')" /><xsl:text />'
		der-text '<xsl:text /><xsl:value-of select="string-join($der-text, '~')" /><xsl:text />'
		der-negated-text '<xsl:text /><xsl:value-of select="string-join(for $n in $der-negated-text return string($n), '~')" /><xsl:text />'
		der-text-non-value '<xsl:text /><xsl:value-of select="string-join(for $n in $der-text-non-value return string($n), '~')" /><xsl:text />'
		der-invalid-text '<xsl:text /><xsl:value-of select="string-join(for $n in $der-invalid-text return string($n), '~')" /><xsl:text />'
		try-immun '<xsl:text /><xsl:value-of select="string-join(for $n in $try-immun return string($n), '~')" /><xsl:text />'
		an-immun '<xsl:text /><xsl:value-of select="string-join(for $n in $an-immun return string($n), '~')" /><xsl:text />'
		ts-not-needed '<xsl:text /><xsl:value-of select="string-join(for $n in $ts-not-needed return string($n), '~')" /><xsl:text />'
		try-tgi '<xsl:text /><xsl:value-of select="string-join(for $n in $try-tgi return string($n), '~')" /><xsl:text />'

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding:
		display-text-to-code '<xsl:text /><xsl:value-of select="string-join($display-text-to-code, '~')" /><xsl:text />'
		der-diag-proc-codes-1 '<xsl:text /><xsl:value-of select="dh:XQueryRecursiveReplace(string-join($der-diag-proc-codes-1, '~'), $term-pattern-replacement, 'ic')" /><xsl:text />'
		der-diag-proc-codes-2 '<xsl:text /><xsl:value-of select="dh:XQueryRecursiveReplace(string-join($der-diag-proc-codes-2, '~'), $term-pattern-replacement, 'ic')" /><xsl:text />'
		der-diag-proc-codes-3 '<xsl:text /><xsl:value-of select="dh:XQueryRecursiveReplace(string-join($der-diag-proc-codes-3, '~'), $term-pattern-replacement, 'ic')" /><xsl:text />'

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		der-code-1 '<xsl:text /><xsl:value-of select="string-join($der-code-1, '~')" /><xsl:text />'
		der-code-2 '<xsl:text /><xsl:value-of select="string-join($der-code-2, '~')" /><xsl:text />'
		der-code-3 '<xsl:text /><xsl:value-of select="string-join($der-code-3, '~')" /><xsl:text />'

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding:
		refset-code-set '<xsl:text /><xsl:value-of select="string-join($refset-code-set, '~')" /><xsl:text />'
		valid-code-set '<xsl:text /><xsl:value-of select="string-join($valid-code-set, '~')" /><xsl:text />'
		valid-codes-1 '<xsl:text /><xsl:value-of select="string-join($valid-codes-1, '~')" /><xsl:text />'
		valid-codes-2 '<xsl:text /><xsl:value-of select="string-join($valid-codes-2, '~')" /><xsl:text />'
		valid-class '<xsl:text /><xsl:value-of select="string-join($valid-class, '~')" /><xsl:text />'
		valid-codes '<xsl:text /><xsl:value-of select="string-join($valid-codes, '~')" /><xsl:text />'
		der-invalid-domain '<xsl:text /><xsl:value-of select="string-join(for $n in $der-invalid-domain return string($n), '~')" /><xsl:text />'

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: 
		inactive-terms-1 '<xsl:text /><xsl:value-of select="string-join($inactive-terms-1[. != ''], '~')" /><xsl:text />'
		inactive-terms-2 '<xsl:text /><xsl:value-of select="string-join($inactive-terms-2[. != ''], '~')" /><xsl:text />'

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' and exists($term-notcoded) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true' and exists($term-notcoded)">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: terms not coded: <xsl:text /><xsl:value-of select="string-join($term-notcoded, '|')" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" exists($simple-term-notcoded) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="exists($simple-term-notcoded)">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: simple terms not coded: <xsl:text /><xsl:value-of select="string-join($simple-term-notcoded, '|')" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" exists($term-incomplete) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="exists($term-incomplete)">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding:  terms with coding incomplete: <xsl:text /><xsl:value-of select="string-join($term-incomplete, '|')" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" exists($term-unclassified) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="exists($term-unclassified)">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: terms unclassified: <xsl:text /><xsl:value-of select="string-join($term-unclassified, '|')" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" exists($term-error) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="exists($term-error)">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: An error was reported when accessing the terminology server for the following terms: <xsl:text /><xsl:value-of select="string-join($term-error, '|')" /><xsl:text />.
		The analysis of these terms should be retried as the terminology server may have been temporarily unavailable.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M23" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M23" />
  <xsl:template match="@*|node()" priority="-2" mode="M23">
    <xsl:apply-templates select="@*|*" mode="M23" />
  </xsl:template>
  <!--PATTERN p-TS-Records-1-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument[$flags/@collection-same-record = 'true' and $document-number &gt; 1] " priority="1000" mode="M24">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument[$flags/@collection-same-record = 'true' and $document-number &gt; 1] " />
    <xsl:variable name="IHIs" select="$documents/cda:ClinicalDocument/cda:recordTarget/cda:patientRole/cda:patient/        ext:asEntityIdentifier[starts-with(ext:id/@root, '1.2.36.1.2001.1003.0.800360')]/ext:id/@root " />
    <xsl:variable name="IHI-values" select="distinct-values(for $i in (1 to count($IHIs)) return substring-after($IHIs[$i], '1.2.36.1.2001.1003.0.')) " />
    <xsl:variable name="IHI-number" select="count($IHI-values)" />
    <xsl:variable name="IHI-count" select="if ($numbers/number[@value = $IHI-number]) then $numbers/number[number(@value) = $IHI-number]/@name else $IHI-number" />
    <xsl:variable name="IHI-display" select="if ($IHI-number = 1) then $IHI-values[1] else        if ($IHI-number = 2) then concat('''', $IHI-values[1], ''' and ''', $IHI-values[2], '''') else        if ($IHI-number = 3) then concat('''', $IHI-values[1], ''', ''', $IHI-values[2], ''' and ''', $IHI-values[3], '''') else        if ($IHI-number &gt; 3) then concat('''', $IHI-values[1], ''', ''', $IHI-values[2], ''', ''', $IHI-values[3], ''' and others') else '' " />
    <!--REPORT -->
    <xsl:if test=" $IHI-number &gt; 1 ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$IHI-number &gt; 1">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error: The <xsl:text /><xsl:value-of select="$document-count" /><xsl:text /> documents obtained from the digital health record were examined and <xsl:text /><xsl:value-of select="$IHI-count" /><xsl:text /> individual healthcare
		identifiers were found to identify the healthcare consumer with this digital health record. They are <xsl:text /><xsl:value-of select="$IHI-display" /><xsl:text />.

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M24" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M24" />
  <xsl:template match="@*|node()" priority="-2" mode="M24">
    <xsl:apply-templates select="@*|*" mode="M24" />
  </xsl:template>
  <!--PATTERN p-TS-Records-2-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument[$flags/@collection-same-record = 'true' and $document-number &gt; 1] " priority="1000" mode="M25">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument[$flags/@collection-same-record = 'true' and $document-number &gt; 1] " />
    <xsl:variable name="substances" select="      $documents/cda:ClinicalDocument[cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.4' and @extension = '3.4']]/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16011']]/cda:component/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20113']]/cda:entry/cda:observation     [cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.15517']]/cda:participant/cda:participantRole/cda:playingEntity/cda:code  |     $documents/cda:ClinicalDocument[cda:templateId[     (@root = '1.2.36.1.2001.1001.101.100.1002.2' and @extension = '2.2')   or     (@root = '1.2.36.1.2001.1001.101.100.1002.120' and @extension = ('1.3', '1.4')) or     (@root = '1.2.36.1.2001.1001.101.100.1002.132' and @extension = '1.3')   or     (@root = '1.2.36.1.2001.1001.101.100.1002.136' and @extension = ('1.2', '1.3')) ]]/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20113']]/cda:entry/cda:act[cda:code     [@codeSystem='1.2.36.1.2001.1001.101' and @code='102.15517']]/cda:participant[@typeCode='CAGNT']/cda:participantRole/cda:playingEntity/cda:code " />
    <xsl:variable name="substance-text" select="if (count($substances) = 0) then () else distinct-values(for $i in (1 to count($substances)) return         if ($substances[$i]/cda:originalText != '' ) then $substances[$i]/cda:originalText        else if ($substances[$i]/@displayName != '' ) then $substances[$i]/@displayName        else if ($substances[$i]/@code != '' ) then $substances[$i]/@code        else 'no name or code') " />
    <xsl:variable name="substance-number" select="count($substance-text)" />
    <xsl:variable name="substance-count" select="if ($numbers/number[@value = $substance-number]) then $numbers/number[number(@value) = $substance-number]/@name else $substance-number" />
    <xsl:variable name="substance-display" select="if ($substance-number = 1) then $substance-text[1] else        if ($substance-number = 2) then concat('''', $substance-text[1], ''' and ''', $substance-text[2], '''') else        if ($substance-number = 3) then concat('''', $substance-text[1], ''', ''', $substance-text[2], ''' and ''', $substance-text[3], '''') else        if ($substance-number &gt; 3) then concat('''', $substance-text[1], ''', ''', $substance-text[2], ''', ''', $substance-text[3], ''' and others') else ''" />
    <xsl:variable name="medications" select="      $documents/cda:ClinicalDocument[cda:templateId[     (@root = '1.2.36.1.2001.1001.101.100.1002.2' and @extension = '2.2')     or     (@root = '1.2.36.1.2001.1001.101.100.1002.120' and (@extension = '1.3' or @extension = '1.4'))  or     (@root = '1.2.36.1.2001.1001.101.100.1002.132' and @extension = '1.3')     or     (@root = '1.2.36.1.2001.1001.101.100.1002.136' and (@extension = '1.2' or @extension = '1.3'))  ]]/cda:component/cda:structuredBody/cda:component/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16146']]/cda:entry/cda:substanceAdministration/cda:consumable/     cda:manufacturedProduct/cda:manufacturedMaterial/cda:code           |     $documents/cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16022']]/cda:component/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16146.4.1.1']]/cda:entry/     cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:code      |     $documents/cda:ClinicalDocument/cda:component/cda:structuredBody/cda:component/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16022']]/cda:component/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16146.4.1.2']]/     cda:entry/cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:code     |     $documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/cda:consumable/     cda:manufacturedProduct/cda:manufacturedMaterial/cda:code           |     $documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/     cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/cda:code      |     $documents/cda:component/cda:structuredBody/cda:component/     cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16638']]/cda:entry/cda:substanceAdministration/cda:consumable/     cda:manufacturedProduct/cda:manufacturedMaterial/cda:code           " />
    <xsl:variable name="medication-text" select="if (count($medications) = 0) then () else distinct-values(for $i in (1 to count($medications)) return         if ($medications[$i]/cda:originalText != '') then $medications[$i]/cda:originalText        else if ($medications[$i]/@displayName != '') then $medications[$i]/@displayName        else if ($medications[$i]/@code != '') then $medications[$i]/@code        else 'no name or code') " />
    <xsl:variable name="medication-number" select="count($medication-text)" />
    <xsl:variable name="medication-count" select="if ($numbers/number[@value = $medication-number]) then $numbers/number[number(@value) = $medication-number]/@name else $medication-number" />
    <xsl:variable name="medication-display" select="if ($medication-number = 1) then $medication-text[1] else        if ($medication-number = 2) then concat('''', $medication-text[1], ''' and ''', $medication-text[2], '''') else        if ($medication-number = 3) then concat('''', $medication-text[1], ''', ''', $medication-text[2], ''' and ''', $medication-text[3], '''') else        if ($medication-number &gt; 3) then concat('''', $medication-text[1], ''', ''', $medication-text[2], ''', ''', $medication-text[3], ''' and others') else ''" />
    <xsl:variable name="substance-codes" select="$substances[@code != '']/@code" />
    <xsl:variable name="substance-displayNames" select="$substances[@displayName != '']/@displayName" />
    <xsl:variable name="substance-originalText" select="$substances[cda:originalText != '']/cda:originalText" />
    <xsl:variable name="temp-1" select="if (count($medications) = 0) then () else (for $i in (1 to count($medications)) return          if (not($medications[$i]/@code) or $medications[$i]/@code = '' or not(exists(index-of($substance-codes, $medications[$i]/@code))))         then '' else         if ($medications[$i]/@displayName != '') then $medications[$i]/@displayName         else $medications[$i]/cda:originalText)[. != '']" />
    <xsl:variable name="temp-2" select="if (count($medications) = 0) then () else (for $i in (1 to count($medications)) return          if ($medications[$i]/@displayName != '' and exists(index-of($substance-displayNames, $medications[$i]/@displayName)))          then $medications[$i]/@displayName else         if ($medications[$i]/cda:originalText != '' and exists(index-of($substance-originalText, $medications[$i]/cda:originalText)))          then $medications[$i]/cda:originalText else '')[. != ''] " />
    <xsl:variable name="reactions" select="distinct-values($temp-1 | $temp-2) " />
    <xsl:variable name="reaction-number" select="count($reactions)" />
    <xsl:variable name="reaction-count" select="if ($numbers/number[@value = $reaction-number]) then $numbers/number[number(@value) = $reaction-number]/@name else $reaction-number" />
    <xsl:variable name="reaction-display" select="if ($reaction-number = 1) then $reactions[1] else          if ($reaction-number = 2) then concat('''', $reactions[1], ''' and ''', $reactions[2], '''') else          if ($reaction-number = 3) then concat('''', $reactions[1], ''', ''', $reactions[2], ''' and ''', $reactions[3], '''') else          if ($reaction-number &gt; 3) then concat('''', $reactions[1], ''', ''', $reactions[2], ''', ''', $reactions[3], ''' and others') else '' " />
    <xsl:variable name="adv-docs" select=" if ($reaction-number = 0) then () else      $documents/cda:ClinicalDocument[cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.4' and @extension = '3.4']]      [.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20113']]/cda:entry/cda:observation      [cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.15517']]/cda:participant/cda:participantRole/cda:playingEntity/      cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]]     |      $documents/cda:ClinicalDocument[cda:templateId[      (@root = '1.2.36.1.2001.1001.101.100.1002.2' and @extension = '2.2')     or      (@root = '1.2.36.1.2001.1001.101.100.1002.120' and (@extension = '1.3' or @extension = '1.4'))  or      (@root = '1.2.36.1.2001.1001.101.100.1002.132' and @extension = '1.3')     or      (@root = '1.2.36.1.2001.1001.101.100.1002.136' and (@extension = '1.2' or @extension = '1.3'))  ]]      [.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20113']]/cda:entry/cda:act[cda:code      [@codeSystem='1.2.36.1.2001.1001.101' and @code='102.15517']]/cda:participant[@typeCode='CAGNT']/cda:participantRole/cda:playingEntity/      cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]]     " />
    <xsl:variable name="adv-dates" select=" for $i in (1 to count($adv-docs)) return $adv-docs[$i]/cda:effectiveTime/@value " />
    <xsl:variable name="templateId-root" select="$adv-docs[1]/cda:templateId[exists(index-of($known-templateIds, @root))]/@root" />
    <xsl:variable name="templateId-ext" select="$adv-docs[1]/cda:templateId[exists(index-of($known-templateIds, @root))]/@extension" />
    <xsl:variable name="adv-document-name" select="if ($document-types/doc-type[@templateId = $templateId-root])         then $document-types/doc-type[@templateId = $templateId-root]/@name else 'unknown document type' " />
    <xsl:variable name="med-docs" select=" if ($reaction-number = 0) then () else     $documents/cda:ClinicalDocument[cda:templateId[     (@root = '1.2.36.1.2001.1001.101.100.1002.2' and @extension = '2.2')     or     (@root = '1.2.36.1.2001.1001.101.100.1002.120' and (@extension = '1.3' or @extension = '1.4'))  or     (@root = '1.2.36.1.2001.1001.101.100.1002.132' and @extension = '1.3')     or     (@root = '1.2.36.1.2001.1001.101.100.1002.136' and (@extension = '1.2' or @extension = '1.3'))  ]]     [.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16146']]/cda:entry/cda:substanceAdministration/cda:consumable/     cda:manufacturedProduct/cda:manufacturedMaterial/cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]]        |     $documents/cda:ClinicalDocument[.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16146.4.1.1']]/cda:entry/     cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]]   |     $documents/cda:ClinicalDocument[.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/cda:consumable/     cda:manufacturedProduct/cda:manufacturedMaterial/cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]]        |     $documents/cda:ClinicalDocument[.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/     cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]] |     $documents/cda:ClinicalDocument[.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16638']]/cda:entry/cda:substanceAdministration/cda:consumable/     cda:manufacturedProduct/cda:manufacturedMaterial/cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]]        " />
    <xsl:variable name="med-dates" select=" for $i in (1 to count($med-docs)) return $med-docs[$i]/cda:effectiveTime/@value " />
    <xsl:variable name="SHS-adv-message" select=" if (not($last-SHS)) then '' else          if($last-SHS[.//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20113']]/cda:entry/cda:act[cda:code         [@codeSystem='1.2.36.1.2001.1001.101' and @code='102.15517']]/cda:participant[@typeCode='CAGNT']/cda:participantRole/cda:playingEntity/         cda:code[@displayName = $reactions[1] or cda:originalText = $reactions[1]]])          then ' The adverse reaction to the substance was noted in the last Shared Health Summary.'         else ' The adverse reaction to the substance was not noted in the last Shared Health Summary.' " />
    <xsl:variable name="SHS-message" select=" if (not($last-SHS)) then 'There is no Shared Health Summary in this digital health record.'        else concat('The last Shared Health Summary was created ', $last-SHS/cda:effectiveTime/@value, '.') " />
    <!--REPORT -->
    <xsl:if test=" . ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: The digital health record contains <xsl:text /><xsl:value-of select="$SHS-count" /><xsl:text /> Shared Health Summaries.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $substance-number &gt; 0 ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$substance-number &gt; 0">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: The <xsl:text /><xsl:value-of select="$document-count" /><xsl:text /> documents obtained from the digital health record state that the healthcare consumer has an adverse reaction to
		<xsl:text /><xsl:value-of select="$substance-count" /><xsl:text /> medications. They are <xsl:text /><xsl:value-of select="$substance-display" /><xsl:text />.

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $medication-number &gt; 0 ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$medication-number &gt; 0">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: The <xsl:text /><xsl:value-of select="$document-count" /><xsl:text /> documents obtained from the digital health record list <xsl:text /><xsl:value-of select="$medication-count" /><xsl:text /> medications and other therapeutic goods
		prescribed, dispensed or taken by the healthcare consumer. They are <xsl:text /><xsl:value-of select="$medication-display" /><xsl:text />.

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $reaction-number &gt; 0 ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$reaction-number &gt; 0">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: The <xsl:text /><xsl:value-of select="$document-count" /><xsl:text /> documents obtained from the digital health record list <xsl:text /><xsl:value-of select="$medication-count" /><xsl:text /> medications and other therapeutic goods
		prescribed, dispensed or taken by the healthcare consumer and the healthcare consumer has an adverse reaction to <xsl:text /><xsl:value-of select="$reaction-count" /><xsl:text /> of these
		(<xsl:text /><xsl:value-of select="$reaction-display" /><xsl:text />, first recorded <xsl:text /><xsl:value-of select="$adv-dates[1]" /><xsl:text />  in a <xsl:text /><xsl:value-of select="$adv-document-name" /><xsl:text /> and last dispensed or being used on <xsl:text /><xsl:value-of select="$med-dates[1]" /><xsl:text />.).
		<xsl:text /><xsl:value-of select="$SHS-message" /><xsl:text /><xsl:text /><xsl:value-of select="$SHS-adv-message" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M25" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M25" />
  <xsl:template match="@*|node()" priority="-2" mode="M25">
    <xsl:apply-templates select="@*|*" mode="M25" />
  </xsl:template>
  <!--PATTERN p-TS-Statistics-1-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument[not($flags/@collection-same-system = 'false') and $document-number &gt; 1 and cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.4' and @extension = '3.4']]" priority="1000" mode="M26">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument[not($flags/@collection-same-system = 'false') and $document-number &gt; 1 and cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.4' and @extension = '3.4']]" />
    <xsl:variable name="discharge-docs" select="$documents/cda:ClinicalDocument[cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.4']] " />
    <xsl:variable name="discharge-num" select="count($discharge-docs) " />
    <xsl:variable name="encounter-de" select="$discharge-docs/cda:componentOf/cda:encompassingEncounter/cda:effectiveTime" />
    <xsl:variable name="encounter-start" select="($encounter-de/@value, $encounter-de/cda:low/@value)" />
    <xsl:variable name="encounter-start-num" select="count($encounter-start) " />
    <xsl:variable name="encounter-end" select="($encounter-de/@value, $encounter-de/cda:high/@value)" />
    <xsl:variable name="encounter-end-num" select="count($encounter-end) " />
    <xsl:variable name="problems-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16006']]/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16142']] " />
    <xsl:variable name="problems-sec-num" select="count($problems-sec) " />
    <xsl:variable name="problems-de" select="$problems-sec/cda:entry/cda:observation[@classCode='OBS' and         not(cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16302.4.3.1'])]/cda:value" />
    <xsl:variable name="problems-de-num" select="count($problems-de) " />
    <xsl:variable name="problems-sct-num" select="count($problems-de[(@code and @codeSystem='2.16.840.1.113883.6.96') or cda:translation[@code and @codeSystem='2.16.840.1.113883.6.96']])" />
    <xsl:variable name="problems-excl" select="$problems-sec/cda:entry/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16302.4.3.1']]/cda:value" />
    <xsl:variable name="problems-excl-num" select="count($problems-excl) " />
    <xsl:variable name="interventions-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16006']]/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20109']] " />
    <xsl:variable name="interventions-sec-num" select="count($interventions-sec) " />
    <xsl:variable name="interventions-de" select="$interventions-sec/cda:entry/cda:procedure[@classCode='PROC']/cda:code" />
    <xsl:variable name="interventions-de-num" select="count($interventions-de) " />
    <xsl:variable name="interventions-sct-num" select="count($interventions-de[(@code and @codeSystem='2.16.840.1.113883.6.96') or cda:translation[@code and @codeSystem='2.16.840.1.113883.6.96']])" />
    <xsl:variable name="synopsis-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16006']]/        cda:component/cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.15513.4.1.1']] " />
    <xsl:variable name="synopsis-sec-num" select="count($synopsis-sec) " />
    <xsl:variable name="current-meds-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16022']]/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16146.4.1.1']]" />
    <xsl:variable name="current-meds-sec-num" select="count($current-meds-sec)" />
    <xsl:variable name="current-meds-de" select="$current-meds-sec/cda:entry/        cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:code" />
    <xsl:variable name="current-meds-de-num" select="count($current-meds-de)" />
    <xsl:variable name="current-meds-sct-num" select="count($current-meds-de[(@code and @codeSystem='2.16.840.1.113883.6.96') or cda:translation[@code and @codeSystem='2.16.840.1.113883.6.96']])" />
    <xsl:variable name="current-meds-reason-de" select="$current-meds-sec/cda:entry/cda:substanceAdministration/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.10141']]/cda:text " />
    <xsl:variable name="current-meds-reason-de-num" select="count($current-meds-reason-de)" />
    <xsl:variable name="current-meds-crsn-de" select="$current-meds-sec/cda:entry/cda:substanceAdministration/        cda:entryRelationship[@typeCode='SPRT']/cda:observation[@moodCode='EVN']/cda:entryRelationship/        cda:act[@moodCode='EVN' and cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.10177']]/cda:text " />
    <xsl:variable name="current-meds-crsn-de-num" select="count($current-meds-crsn-de)" />
    <xsl:variable name="current-meds-excl" select="$current-meds-sec/cda:entry/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16302.4.3.2']]/cda:value" />
    <xsl:variable name="current-meds-excl-num" select="count($current-meds-excl)" />
    <xsl:variable name="ceased-meds-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16022']]/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16146.4.1.2']]" />
    <xsl:variable name="ceased-meds-sec-num" select="count($ceased-meds-sec)" />
    <xsl:variable name="ceased-meds-de" select="$ceased-meds-sec/cda:entry/cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:code" />
    <xsl:variable name="ceased-meds-de-num" select="count($ceased-meds-de)" />
    <xsl:variable name="ceased-meds-sct-num" select="count($ceased-meds-de[(@code and @codeSystem='2.16.840.1.113883.6.96') or cda:translation[@code and @codeSystem='2.16.840.1.113883.6.96']])" />
    <xsl:variable name="ceased-meds-crsn-de" select="/cda:entry/cda:substanceAdministration/        cda:entryRelationship/cda:observation/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.10177']]/cda:text" />
    <xsl:variable name="ceased-meds-crsn-de-num" select="count($ceased-meds-crsn-de)" />
    <xsl:variable name="ceased-meds-excl" select="$ceased-meds-sec/cda:entry/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16302.4.3.3']]/cda:value" />
    <xsl:variable name="ceased-meds-excl-num" select="count($ceased-meds-excl)" />
    <xsl:variable name="adverse-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16011']]/        cda:component/cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20113']]" />
    <xsl:variable name="adverse-sec-num" select="count($adverse-sec)" />
    <xsl:variable name="adverse-de" select="$adverse-sec/cda:entry/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.15517']]/        cda:participant/cda:participantRole/cda:playingEntity/cda:code" />
    <xsl:variable name="adverse-de-num" select="count($adverse-de)" />
    <xsl:variable name="adverse-sct-num" select="count($adverse-de[(@code and @codeSystem='2.16.840.1.113883.6.96') or cda:translation[@code and @codeSystem='2.16.840.1.113883.6.96']])" />
    <xsl:variable name="adverse-excl" select="$adverse-sec/cda:entry/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16302.4.3.4']]/cda:value" />
    <xsl:variable name="adverse-excl-num" select="count($adverse-excl)" />
    <xsl:variable name="mfst-de" select="$adverse-sec/cda:entry/cda:observation/cda:entryRelationship[@typeCode='MFST']/cda:observation/cda:code" />
    <xsl:variable name="mfst-de-num" select="count($mfst-de)" />
    <xsl:variable name="mfst-sct-num" select="count($mfst-de[(@code and @codeSystem='2.16.840.1.113883.6.96') or cda:translation[@code and @codeSystem='2.16.840.1.113883.6.96']])" />
    <xsl:variable name="diagnostics-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16006']]/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20117']]" />
    <xsl:variable name="pathology-sec" select="$diagnostics-sec/cda:component/cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16144']" />
    <xsl:variable name="pathology-sec-num" select="count($pathology-sec)" />
    <xsl:variable name="imaging-sec" select="$diagnostics-sec/cda:component/cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16145']" />
    <xsl:variable name="imaging-sec-num" select="count($imaging-sec)" />
    <xsl:variable name="diag-sec" select="$diagnostics-sec/cda:component/cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16029']" />
    <xsl:variable name="diag-sec-num" select="count($diag-sec)" />
    <xsl:variable name="arranged-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16020']]/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16021']] " />
    <xsl:variable name="arranged-sec-num" select="count($arranged-sec) " />
    <xsl:variable name="recommend-sec" select="$discharge-docs/cda:component/cda:structuredBody/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16020']]/cda:component/        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.20016']] " />
    <xsl:variable name="recommend-sec-num" select="count($recommend-sec) " />
    <!--REPORT -->
    <xsl:if test=" $discharge-num &gt; 1 ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$discharge-num &gt; 1">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: The collection of documents contains
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $discharge-num]) then $numbers/number[number(@value) = $discharge-num]/@name else $discharge-num" /><xsl:text />
		Discharge Summaries from the same source system.
		The start of the encounter is recorded in
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $encounter-start-num]) then $numbers/number[number(@value) = $encounter-start-num]/@name else $encounter-start-num" /><xsl:text />
		Discharge Summaries and the end of the encounter (the discharge date) is recorded in
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $encounter-end-num]) then $numbers/number[number(@value) = $encounter-end-num]/@name else $encounter-end-num" /><xsl:text />
		Discharge Summaries.
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $problems-sec-num]) then $numbers/number[number(@value) = $problems-sec-num]/@name else $problems-sec-num" /><xsl:text />
		Problems/Diagnoses This Visit sections and a total of
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $problems-de-num]) then $numbers/number[number(@value) = $problems-de-num]/@name else $problems-de-num" /><xsl:text />
		medical problems (i.e. Problem/Diagnosis Description data elements<xsl:text /><xsl:value-of select="if ($problems-de-num = 0) then ').'   else concat(', ', if ($numbers/number[number(@value) = $problems-sct-num]) then $numbers/number[number(@value) = $problems-sct-num]/@name else $problems-sct-num,    ' have SNOMED CT-AU codes).') " /><xsl:text />
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $problems-excl-num]) then $numbers/number[number(@value) = $problems-excl-num]/@name else $problems-excl-num" /><xsl:text />
		exclusion statements in the Problems/Diagnoses This Visit sections.

		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $interventions-sec-num]) then $numbers/number[number(@value) = $interventions-sec-num]/@name else $interventions-sec-num" /><xsl:text />
		Clinical Interventions Performed This Visit sections and a total of
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $interventions-de-num]) then $numbers/number[number(@value) = $interventions-de-num]/@name else $interventions-de-num" /><xsl:text />
		procedures (i.e. Clinical Intervention Description data elements<xsl:text /><xsl:value-of select="if ($interventions-de-num = 0) then ').'   else concat(', ', if ($numbers/number[number(@value) = $interventions-sct-num]) then $numbers/number[number(@value) = $interventions-sct-num]/@name else $interventions-sct-num,    ' have SNOMED CT-AU codes).') " /><xsl:text />

		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $synopsis-sec-num]) then $numbers/number[number(@value) = $synopsis-sec-num]/@name else $synopsis-sec-num" /><xsl:text />
		Clinical Synopsis sections.
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $current-meds-sec-num]) then $numbers/number[number(@value) = $current-meds-sec-num]/@name else $current-meds-sec-num" /><xsl:text />
		Current Medications on Discharge sections and a total of
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $current-meds-de-num]) then $numbers/number[number(@value) = $current-meds-de-num]/@name else $current-meds-de-num" /><xsl:text />
		medications on discharge<xsl:text /><xsl:value-of select="if ($current-meds-de-num = 0) then '.'   else concat(' (', if ($numbers/number[number(@value) = $current-meds-sct-num]) then $numbers/number[number(@value) = $current-meds-sct-num]/@name else $current-meds-sct-num,    ' have SNOMED CT-AU codes).') " /><xsl:text />
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $current-meds-reason-de-num]) then $numbers/number[number(@value) = $current-meds-reason-de-num]/@name else $current-meds-reason-de-num" /><xsl:text />
		medicines on discharge provided with a reason for the medicine and
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $current-meds-crsn-de-num]) then $numbers/number[number(@value) = $current-meds-crsn-de-num]/@name else $current-meds-crsn-de-num" /><xsl:text />
		have a reason for changing the medicine.
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $current-meds-excl-num]) then $numbers/number[number(@value) = $current-meds-excl-num]/@name else $current-meds-excl-num" /><xsl:text />
		exclusion statements in the Current Medications on Discharge sections.

		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $ceased-meds-sec-num]) then $numbers/number[number(@value) = $ceased-meds-sec-num]/@name else $ceased-meds-sec-num" /><xsl:text />
		Ceased Medications sections and a total of
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $ceased-meds-de-num]) then $numbers/number[number(@value) = $ceased-meds-de-num]/@name else $ceased-meds-de-num" /><xsl:text />
		ceased medications<xsl:text /><xsl:value-of select="if ($ceased-meds-de-num = 0) then '.'   else concat('(', if ($numbers/number[number(@value) = $ceased-meds-sct-num]) then $numbers/number[number(@value) = $ceased-meds-sct-num]/@name else $ceased-meds-sct-num,    ' have SNOMED CT-AU codes).') " /><xsl:text />
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $ceased-meds-crsn-de-num]) then $numbers/number[number(@value) = $ceased-meds-crsn-de-num]/@name else $ceased-meds-crsn-de-num" /><xsl:text />
		ceased medicines with a reason for ceasing the medicine.
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $ceased-meds-excl-num]) then $numbers/number[number(@value) = $ceased-meds-excl-num]/@name else $ceased-meds-excl-num" /><xsl:text />
		exclusion statements in the Ceased Medications sections.

		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $adverse-sec-num]) then $numbers/number[number(@value) = $adverse-sec-num]/@name else $adverse-sec-num" /><xsl:text />
		Adverse Reactions sections, a total of
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $adverse-de-num]) then $numbers/number[number(@value) = $adverse-de-num]/@name else $adverse-de-num" /><xsl:text />
		adverse reaction substances (Agent Description, also called Substance/Agent) data elements<xsl:text /><xsl:value-of select="if ($adverse-de-num = 0) then ','   else concat(' (', if ($numbers/number[number(@value) = $adverse-sct-num]) then $numbers/number[number(@value) = $adverse-sct-num]/@name else $adverse-sct-num,    ' have SNOMED CT-AU codes),') " /><xsl:text /> and a total of
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $mfst-de-num]) then $numbers/number[number(@value) = $mfst-de-num]/@name else $mfst-de-num" /><xsl:text />
		adverse reaction description (also called Manifestation) data elements<xsl:text /><xsl:value-of select="if ($mfst-de-num = 0) then '.'   else concat(' (', if ($numbers/number[number(@value) = $mfst-sct-num]) then $numbers/number[number(@value) = $mfst-sct-num]/@name else $mfst-sct-num,    ' have SNOMED CT-AU codes).') " /><xsl:text />
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $adverse-excl-num]) then $numbers/number[number(@value) = $adverse-excl-num]/@name else $adverse-excl-num" /><xsl:text />
		exclusion statements in the Adverse Reactions sections.

		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $pathology-sec-num]) then $numbers/number[number(@value) = $pathology-sec-num]/@name else $pathology-sec-num" /><xsl:text />
		Pathology Test Result sections,
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $imaging-sec-num]) then $numbers/number[number(@value) = $imaging-sec-num]/@name else $imaging-sec-num" /><xsl:text />
		Imaging Examination Result sections and
		<xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $diag-sec-num]) then $numbers/number[number(@value) = $diag-sec-num]/@name else $diag-sec-num" /><xsl:text />
		Diagnostic Investigation sections.
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $arranged-sec-num]) then $numbers/number[number(@value) = $arranged-sec-num]/@name else $arranged-sec-num" /><xsl:text />
		Arranged Services sections.
		There are <xsl:text /><xsl:value-of select="if ($numbers/number[number(@value) = $recommend-sec-num]) then $numbers/number[number(@value) = $recommend-sec-num]/@name else $recommend-sec-num" /><xsl:text />
		Record Of Recommendations And Information Provided sections.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M26" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M26" />
  <xsl:template match="@*|node()" priority="-2" mode="M26">
    <xsl:apply-templates select="@*|*" mode="M26" />
  </xsl:template>
  <!--PATTERN p-TS-Statistics-2-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument[$flags/@report-statistics = 'true' and '102.16211' = $doc-sections]   [count($documents) &gt; 100 and count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]]) &gt; 100] " priority="1000" mode="M27">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument[$flags/@report-statistics = 'true' and '102.16211' = $doc-sections]   [count($documents) &gt; 100 and count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]]) &gt; 100] " />
    <xsl:variable name="doc-with-pres-item-count" select="if ($numbers/number[@value = count($documents/cda:ClinicalDocument[   //cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]])])    then $numbers/number[number(@value) = count($documents/cda:ClinicalDocument[    //cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]])]/@name    else count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]])" />
    <xsl:variable name="TGS-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16769.170.1.1']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16769.170.1.1']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16769.170.1.1']]/cda:text)" />
    <xsl:variable name="TGGN-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/    cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:name)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:name)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:consumable/cda:manufacturedProduct/cda:manufacturedMaterial/cda:name)" />
    <xsl:variable name="form-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:consumable/    cda:manufacturedProduct/cda:manufacturedMaterial/ext:formCode)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:consumable/    cda:manufacturedProduct/cda:manufacturedMaterial/ext:formCode)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/cda:consumable/    cda:manufacturedProduct/cda:manufacturedMaterial/ext:formCode)" />
    <xsl:variable name="directions-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/   cda:entry/cda:substanceAdministration/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/cda:text)" />
    <xsl:variable name="route-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:routeCode)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:routeCode)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/cda:routeCode)" />
    <xsl:variable name="formula-count" select="if ($numbers/number[@value = count($documents//cda:section[    cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16272']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16272']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16272']]/cda:text)" />
    <xsl:variable name="indication-count" select="if ($numbers/number[@value = count($documents//cda:section[    cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.10141']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.10141']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.10141']]/cda:text)" />
    <xsl:variable name="comment-count" select="if ($numbers/number[@value = count($documents//cda:section[    cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16044']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16044']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16044']]/cda:text)" />
    <xsl:variable name="max-repeat-count" select="if ($numbers/number[@value = count($documents//cda:section[    cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/cda:repeatNumber/cda:high)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:repeatNumber/cda:high)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/cda:repeatNumber/cda:high)" />
    <xsl:variable name="min-interval-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:effectiveTime/cda:period)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:effectiveTime/cda:period)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:entryRelationship/cda:supply/cda:effectiveTime/cda:period)" />
    <xsl:variable name="PBS-man-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturerOrganization/cda:id)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturerOrganization/cda:id)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16211']]/    cda:entry/cda:substanceAdministration/cda:consumable/cda:manufacturedProduct/cda:manufacturerOrganization/cda:id)" />
    <!--REPORT -->
    <xsl:if test=" . ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

	    	Finding: In the collection of <xsl:text /><xsl:value-of select="$document-count" /><xsl:text /> documents there are <xsl:text /><xsl:value-of select="$doc-with-pres-item-count" /><xsl:text /> documents with information about medication 
		prescribing. The optional data elements about prescribed medications are listed here along with the number of times the data element was found:

		Therapeutic Good Strength (<xsl:text /><xsl:value-of select="$TGS-count" /><xsl:text />);
		Therapeutic Good Generic Name (<xsl:text /><xsl:value-of select="$TGGN-count" /><xsl:text />);
		Form (<xsl:text /><xsl:value-of select="$form-count" /><xsl:text />);
		Directions (<xsl:text /><xsl:value-of select="$directions-count" /><xsl:text />);
		Route (<xsl:text /><xsl:value-of select="$route-count" /><xsl:text />);
		Formula (<xsl:text /><xsl:value-of select="$formula-count" /><xsl:text />);
		Clinical Indication (<xsl:text /><xsl:value-of select="$indication-count" /><xsl:text />);
		Comment (<xsl:text /><xsl:value-of select="$comment-count" /><xsl:text />);
		Maximum Number of Repeats (<xsl:text /><xsl:value-of select="$max-repeat-count" /><xsl:text />);
		Minimum Interval Between Repeats (<xsl:text /><xsl:value-of select="$min-interval-count" /><xsl:text />); and
		PBS Manufacturer Code (<xsl:text /><xsl:value-of select="$PBS-man-count" /><xsl:text />).

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M27" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M27" />
  <xsl:template match="@*|node()" priority="-2" mode="M27">
    <xsl:apply-templates select="@*|*" mode="M27" />
  </xsl:template>
  <!--PATTERN p-TS-Statistics-3-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument[$flags/@report-statistics = 'true' and '102.16210' = $doc-sections]   [count($documents) &gt; 100 and count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]]) &gt; 100] " priority="1000" mode="M28">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument[$flags/@report-statistics = 'true' and '102.16210' = $doc-sections]   [count($documents) &gt; 100 and count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]]) &gt; 100] " />
    <xsl:variable name="doc-with-disp-item-count" select="if ($numbers/number[@value = count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]])])    then $numbers/number[number(@value) = count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]])]/@name    else count($documents/cda:ClinicalDocument[//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]])" />
    <xsl:variable name="TGS-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16769.171.1.1']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16769.171.1.1']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16769.171.1.1']]/cda:text)" />
    <xsl:variable name="TGGN-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/cda:name)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/cda:name)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/cda:name)" />
    <xsl:variable name="formula-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16272']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16272']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16272']]/cda:text)" />
    <xsl:variable name="form-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/    cda:substanceAdministration/cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/ext:formCode)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/    cda:substanceAdministration/cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/ext:formCode)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/    cda:substanceAdministration/cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/ext:formCode)" />
    <xsl:variable name="label-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16109']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16109']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16109']]/cda:text)" />
    <xsl:variable name="quantity-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='2.16.840.1.113883.6.96' and @code='246205007']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='2.16.840.1.113883.6.96' and @code='246205007']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='2.16.840.1.113883.6.96' and @code='246205007']]/cda:text)" />
    <xsl:variable name="description-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/ext:desc)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/ext:desc)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturedMaterial/ext:desc)" />
    <xsl:variable name="brand-sub-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16064']]/cda:value)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16064']]/cda:value)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:observation[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16064']]/cda:value)" />
    <xsl:variable name="disp-number-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:sequenceNumber)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:sequenceNumber)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:sequenceNumber)" />
    <xsl:variable name="repeat-number-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/    cda:entry/cda:substanceAdministration/cda:repeatNumber/cda:high)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/cda:repeatNumber/cda:high)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/cda:repeatNumber/cda:high)" />
    <xsl:variable name="comment-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16044']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16044']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16044']]/cda:text)" />
    <xsl:variable name="PBS-man-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturerOrganization/cda:id)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturerOrganization/cda:id)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:product/cda:manufacturedProduct/cda:manufacturerOrganization/cda:id)" />
    <xsl:variable name="PII-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/cda:id)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/cda:id)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/cda:id)" />
    <xsl:variable name="UPPN-count" select="if ($numbers/number[@value = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16786']]/cda:text)])    then $numbers/number[number(@value) = count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16786']]/cda:text)]/@name    else count($documents//cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16210']]/cda:entry/cda:substanceAdministration/    cda:entryRelationship/cda:supply/cda:entryRelationship/cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='103.16786']]/cda:text)" />
    <!--REPORT -->
    <xsl:if test=" . ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test=".">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

	    	Finding: In the collection of <xsl:text /><xsl:value-of select="$document-count" /><xsl:text /> documents there are <xsl:text /><xsl:value-of select="$doc-with-disp-item-count" /><xsl:text /> documents with information about medication dispensing.
		The optional data elements about dispensed items are listed here along with the number of times the data element was found:

		Therapeutic Good Strength (<xsl:text /><xsl:value-of select="$TGS-count" /><xsl:text />);
		Therapeutic Good Generic Name (<xsl:text /><xsl:value-of select="$TGGN-count" /><xsl:text />);
		Formula (<xsl:text /><xsl:value-of select="$formula-count" /><xsl:text />);
		Form (<xsl:text /><xsl:value-of select="$form-count" /><xsl:text />);
		Label Instruction (<xsl:text /><xsl:value-of select="$label-count" /><xsl:text />);
		Quantity Description (<xsl:text /><xsl:value-of select="$quantity-count" /><xsl:text />);
		Additional Dispensed Item Description (<xsl:text /><xsl:value-of select="$description-count" /><xsl:text />);
		Brand Substitution Occurred (<xsl:text /><xsl:value-of select="$brand-sub-count" /><xsl:text />);
		Number of this Dispense (<xsl:text /><xsl:value-of select="$disp-number-count" /><xsl:text />);
		Maximum Number of Repeats (<xsl:text /><xsl:value-of select="$repeat-number-count" /><xsl:text />);
		Comment (<xsl:text /><xsl:value-of select="$comment-count" /><xsl:text />);
		PBS Manufacturer Code (<xsl:text /><xsl:value-of select="$PBS-man-count" /><xsl:text />);
		Prescription Item Identifier (<xsl:text /><xsl:value-of select="$PII-count" /><xsl:text />); and
		Unique Pharmacy Prescription Number (<xsl:text /><xsl:value-of select="$UPPN-count" /><xsl:text />).

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M28" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M28" />
  <xsl:template match="@*|node()" priority="-2" mode="M28">
    <xsl:apply-templates select="@*|*" mode="M28" />
  </xsl:template>
  <!--PATTERN p-TS-ACDCustodian-1-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16694' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16694'] " priority="1000" mode="M29">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16694' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16694'] " />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="rating" select="if ($initial-priority) then $initial-rating else if ($FS-Types-seq/@rating) then concat(' (', $FS-Types-seq/@rating, ')') else '' " />
    <!--REPORT -->
    <xsl:if test="not($flags/@allow-hints = 'false') and not(/cda:ClinicalDocument/cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.156' and @extension = '1.0']) and $extensions-allowed">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and not(/cda:ClinicalDocument/cda:templateId[@root = '1.2.36.1.2001.1001.101.100.1002.156' and @extension = '1.0']) and $extensions-allowed">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating" /><xsl:text />: FS-Types: The Advance Care Directive Custodian Entries section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16694') has been found in a <xsl:text /><xsl:value-of select="$document-name" /><xsl:text />. The Advance Care Directive Custodian Entries section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16694') is defined in the digital health specifications but
		although tests have been applied to the data elements the specification of the data elements may have been varied for inclusion in this document
		so further examination may be needed. The rules have been validated for <xsl:text /><xsl:value-of select="normalize-space('Advance Care Directive Custodian Record CDA Implementation Guide version 1.0')" /><xsl:text />.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M29" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M29" />
  <xsl:template match="@*|node()" priority="-2" mode="M29">
    <xsl:apply-templates select="@*|*" mode="M29" />
  </xsl:template>
  <!--PATTERN p-TS-ACDCustodian-2-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16694' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16694']]/cda:component/cda:section " priority="1000" mode="M30">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16694' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16694']]/cda:component/cda:section " />
    <xsl:variable name="agency-section" select=" cda:code/@codeSystem = '1.2.36.1.2001.1001.101' " />
    <xsl:variable name="test-step" select=" if (not($extensions-allowed)) then 'step 4'        else if ($agency-section) then 'step 3' else 'step 1' " />
    <xsl:variable name="title-and-code" select=" if (cda:title and cda:code/@code) then concat('title ''', cda:title, ''', code/code ''', cda:code/@code, '''')        else if (cda:title and not(cda:code/@code)) then concat('title ''', cda:title, '''')        else if (not(cda:title) and cda:code/@code) then concat('code/code ''', cda:code/@code, '''')        else '' " />
    <xsl:variable name="other-section-names" select=" if (cda:code/@displayName and not(cda:code/cda:originalText)) then concat(' and code/displayName ''', cda:code/@displayName, '''')         else if (cda:code/@displayName and cda:code/cda:originalText)          then concat(', code/displayName ''', cda:code/@displayName,''' and code/originalText ''', cda:code/cda:originalText, '''')        else if (not(cda:code/@displayName) and cda:code/cda:originalText) then concat(' and code/originalText ''', cda:code/cda:originalText, '''')        else '' " />
    <xsl:variable name="section-names" select="concat($title-and-code, $other-section-names)" />
    <xsl:variable name="doc-code" select="/cda:ClinicalDocument/cda:code" />
    <xsl:variable name="parent-section" select="ancestor::cda:section[position()=1]" />
    <xsl:variable name="custom-section-info" select="($iq-config/custom-sections/section, $knowledge/custom-sections/section)[        @doc-code  = $doc-code/@code          and        @doc-codeSystem  = $doc-code/@codeSystem          and        @parent-code   = $parent-section/cda:code/@code         and         @parent-codeSystem  = $parent-section/cda:code/@codeSystem        and         (@title = current()/cda:title or (@code = current()/cda:code/@code and @codeSystem = current()/cda:code/@codeSystem)) ] " />
    <xsl:variable name="section-disallowed" select="$custom-section-info/@disallowed = 'yes' " />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="rating-28" select="if ($initial-priority) then $initial-rating        else if ($test-step = 'step 1' and ($section-disallowed or not(exists($custom-section-info)))) then $rating-alt-TC-Doc-28-step-1        else if ($test-step = 'step 1' and cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code=$meds-view-sections]) then $rating-MHRView-TC-Doc-28-step-1       else if ($test-step = 'step 1') then $rating-TC-Doc-28-step-1        else if ($test-step = 'step 3') then $rating-TC-Doc-28-step-3 else if ($test-step = 'step 4') then $rating-TC-Doc-28-step-4 else '' " />
    <!--REPORT -->
    <xsl:if test=" $extensions-allowed and $section-disallowed ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$extensions-allowed and $section-disallowed">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Directive Custodian Entries section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16694') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> which
		is an extension to the information model however the inclusion of this section conflicts with sections defined in the digital health specifications.
		<xsl:text /><xsl:value-of select="$custom-section-info[@disallowed = 'yes']/@reason" /><xsl:text /> (Also see <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and not(false()) and $extensions-allowed and not(exists($custom-section-info)) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and not(false()) and $extensions-allowed and not(exists($custom-section-info))">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Directive Custodian Entries section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16694') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text />. No subsection is expected so this
		is an extension to the information model. Confirm if the subsection meets the requirement that extensions must not qualify or negate any of the 
		data elements defined in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide. (See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not(false()) and not($extensions-allowed) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(false()) and not($extensions-allowed)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Directive Custodian Entries section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16694') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> but no subsections were
		expected so the document fails to meet the requirement that it must not contain additional data elements. (See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and false() and $extensions-allowed and not(exists($custom-section-info)) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and false() and $extensions-allowed and not(exists($custom-section-info))">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Directive Custodian Entries section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16694') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text />. Sections with
		none are expected but a section with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> is present which is an extension to the information model.
		Confirm if the subsection meets the requirement that extensions must not qualify or negate any of the
		data elements defined in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide. (See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" false() and not($extensions-allowed) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false() and not($extensions-allowed)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Directive Custodian Entries section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16694') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text />. Sections with
		none are expected but the inclusion of the section with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> fails to meet the requirement that it must not contain additional data elements.
		(See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M30" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M30" />
  <xsl:template match="@*|node()" priority="-2" mode="M30">
    <xsl:apply-templates select="@*|*" mode="M30" />
  </xsl:template>
  <!--PATTERN p-TS-ACI-1-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973'] " priority="1000" mode="M31">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973'] " />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="rating" select="if ($initial-priority) then $initial-rating else if ($FS-Types-seq/@rating) then concat(' (', $FS-Types-seq/@rating, ')') else '' " />
    <!--REPORT -->
    <xsl:if test="not($flags/@allow-hints = 'false') and not(/cda:ClinicalDocument/cda:templateId[@root = '1.2.36.1.2001.1001.100.1002.226' and @extension = '1.0']) and $extensions-allowed">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and not(/cda:ClinicalDocument/cda:templateId[@root = '1.2.36.1.2001.1001.100.1002.226' and @extension = '1.0']) and $extensions-allowed">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating" /><xsl:text />: FS-Types: The Advance Care Information section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16973') has been found in a <xsl:text /><xsl:value-of select="$document-name" /><xsl:text />. The Advance Care Information section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16973') is defined in the digital health specifications but
		although tests have been applied to the data elements the specification of the data elements may have been varied for inclusion in this document
		so further examination may be needed. The rules have been validated for <xsl:text /><xsl:value-of select="normalize-space('Advance Care Information CDA Implementation Guide version 1.0')" /><xsl:text />.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M31" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M31" />
  <xsl:template match="@*|node()" priority="-2" mode="M31">
    <xsl:apply-templates select="@*|*" mode="M31" />
  </xsl:template>
  <!--PATTERN p-TS-ACI-2-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:component/cda:section " priority="1000" mode="M32">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//        cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:component/cda:section " />
    <xsl:variable name="agency-section" select=" cda:code/@codeSystem = '1.2.36.1.2001.1001.101' " />
    <xsl:variable name="test-step" select=" if (not($extensions-allowed)) then 'step 4'        else if ($agency-section) then 'step 3' else 'step 1' " />
    <xsl:variable name="title-and-code" select=" if (cda:title and cda:code/@code) then concat('title ''', cda:title, ''', code/code ''', cda:code/@code, '''')        else if (cda:title and not(cda:code/@code)) then concat('title ''', cda:title, '''')        else if (not(cda:title) and cda:code/@code) then concat('code/code ''', cda:code/@code, '''')        else '' " />
    <xsl:variable name="other-section-names" select=" if (cda:code/@displayName and not(cda:code/cda:originalText)) then concat(' and code/displayName ''', cda:code/@displayName, '''')         else if (cda:code/@displayName and cda:code/cda:originalText)          then concat(', code/displayName ''', cda:code/@displayName,''' and code/originalText ''', cda:code/cda:originalText, '''')        else if (not(cda:code/@displayName) and cda:code/cda:originalText) then concat(' and code/originalText ''', cda:code/cda:originalText, '''')        else '' " />
    <xsl:variable name="section-names" select="concat($title-and-code, $other-section-names)" />
    <xsl:variable name="doc-code" select="/cda:ClinicalDocument/cda:code" />
    <xsl:variable name="parent-section" select="ancestor::cda:section[position()=1]" />
    <xsl:variable name="custom-section-info" select="($iq-config/custom-sections/section, $knowledge/custom-sections/section)[        @doc-code  = $doc-code/@code          and        @doc-codeSystem  = $doc-code/@codeSystem          and        @parent-code   = $parent-section/cda:code/@code         and         @parent-codeSystem  = $parent-section/cda:code/@codeSystem        and         (@title = current()/cda:title or (@code = current()/cda:code/@code and @codeSystem = current()/cda:code/@codeSystem)) ] " />
    <xsl:variable name="section-disallowed" select="$custom-section-info/@disallowed = 'yes' " />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="rating-28" select="if ($initial-priority) then $initial-rating        else if ($test-step = 'step 1' and ($section-disallowed or not(exists($custom-section-info)))) then $rating-alt-TC-Doc-28-step-1        else if ($test-step = 'step 1' and cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code=$meds-view-sections]) then $rating-MHRView-TC-Doc-28-step-1       else if ($test-step = 'step 1') then $rating-TC-Doc-28-step-1        else if ($test-step = 'step 3') then $rating-TC-Doc-28-step-3 else if ($test-step = 'step 4') then $rating-TC-Doc-28-step-4 else '' " />
    <!--REPORT -->
    <xsl:if test=" $extensions-allowed and $section-disallowed ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$extensions-allowed and $section-disallowed">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Information section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16973') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> which
		is an extension to the information model however the inclusion of this section conflicts with sections defined in the digital health specifications.
		<xsl:text /><xsl:value-of select="$custom-section-info[@disallowed = 'yes']/@reason" /><xsl:text /> (Also see <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and not(false()) and $extensions-allowed and not(exists($custom-section-info)) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and not(false()) and $extensions-allowed and not(exists($custom-section-info))">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Information section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16973') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text />. No subsection is expected so this
		is an extension to the information model. Confirm if the subsection meets the requirement that extensions must not qualify or negate any of the 
		data elements defined in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide. (See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not(false()) and not($extensions-allowed) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(false()) and not($extensions-allowed)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Information section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16973') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> but no subsections were
		expected so the document fails to meet the requirement that it must not contain additional data elements. (See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and false() and $extensions-allowed and not(exists($custom-section-info)) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and false() and $extensions-allowed and not(exists($custom-section-info))">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Information section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16973') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text />. Sections with
		none are expected but a section with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> is present which is an extension to the information model.
		Confirm if the subsection meets the requirement that extensions must not qualify or negate any of the
		data elements defined in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide. (See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" false() and not($extensions-allowed) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false() and not($extensions-allowed)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: The Advance Care Information section (codeSystem '1.2.36.1.2001.1001.101' and code '101.16973') has a subsection with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text />. Sections with
		none are expected but the inclusion of the section with <xsl:text /><xsl:value-of select="$section-names" /><xsl:text /> fails to meet the requirement that it must not contain additional data elements.
		(See <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M32" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M32" />
  <xsl:template match="@*|node()" priority="-2" mode="M32">
    <xsl:apply-templates select="@*|*" mode="M32" />
  </xsl:template>
  <!--PATTERN p-TS-ACI-CodedText-1-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//          cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/          cda:act/cda:reference/cda:externalDocument/cda:code[(@code and not(@code = '')) or (cda:originalText and not(normalize-space(cda:originalText) = ''))]          [not(cda:originalText and (string-length(cda:originalText) &gt; $length-err-max or ($family-regex != '' and matches(cda:originalText, $family-regex, 'is'))))] " priority="1000" mode="M33">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//          cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/          cda:act/cda:reference/cda:externalDocument/cda:code[(@code and not(@code = '')) or (cda:originalText and not(normalize-space(cda:originalText) = ''))]          [not(cda:originalText and (string-length(cda:originalText) &gt; $length-err-max or ($family-regex != '' and matches(cda:originalText, $family-regex, 'is'))))] " />
    <xsl:variable name="tc-types-49-err" select="@nullFlavor = ('PINF', 'NINF', 'QS', 'TRC') or (@nullFlavor='UNC' and (not(cda:originalText) or normalize-space(cda:originalText) = '')) " />
    <xsl:variable name="tc-doc-04-err" select="@codeSystem and @xsi:type and not(@xsi:type = ('CD', 'CE', 'CO', 'CV') or normalize-space(substring-after(@xsi:type, ':')) = ('CD', 'CE', 'CO', 'CV')) " />
    <xsl:variable name="no-cd-value-1" select="if (@xsi:type and (@xsi:type = ('CV', 'CO') or normalize-space(substring-after(@xsi:type, ':')) = ('CV', 'CO'))) then not(@nullFlavor or @code)        else not(@nullFlavor or @code or cda:originalText) " />
    <xsl:variable name="family-err" select="cda:originalText and matches(cda:originalText, $family-regex, 'i')" />
    <xsl:variable name="length-err" select="cda:originalText and string-length(cda:originalText) &gt; 200" />
    <xsl:variable name="psnomed-id" select="if (not(@codeSystem = '2.16.840.1.113883.6.96')) then 'not-snomed'        else if (not(@codeSystemVersion)) then 'snomedctau'        else if (matches(@codeSystemVersion, $snomed-version-regex-1)) then 'snomedct'        else if (matches(@codeSystemVersion, $amtv3-version-regex)) then 'amtv3'        else if (matches(@codeSystemVersion, $snomedctau-version-regex)) then 'snomedctau'        else if (matches(@codeSystemVersion, $snomed-version-regex-2)) then 'snomedct'        else 'snomed' " />
    <xsl:variable name="v-psnomed-version" select="if (not(@codeSystem = '2.16.840.1.113883.6.96')) then ''        else if (not(@codeSystemVersion)) then $v-latest-snomedctau        else if ($psnomed-id = 'amtv3' and exists($v-amtv3[. = current()/@codeSystemVersion])) then @codeSystemVersion        else if ($psnomed-id = 'amtv3' and not(exists($v-amtv3[. = current()/@codeSystemVersion]))) then $v-latest-amtv3        else if ($psnomed-id = 'snomedctau' and exists($v-snomedctau[. = current()/@codeSystemVersion])) then @codeSystemVersion        else if ($psnomed-id = 'snomedctau' and exists($sctau-versions-old[. = current()/@codeSystemVersion])) then $v-latest-snomedctau        else $v-latest-snomedctau " />
    <xsl:variable name="v-psnomed-version-msg" select="if ($v-psnomed-version = '' or not(@codeSystem = '2.16.840.1.113883.6.96' and @code != '')) then ''        else if (not(@codeSystemVersion)) then concat(' The primary code did not contain the codeSystemVersion attribute so the ''',          $v-psnomed-version, ''' version of the SNOMED CT-AU code system was used with the Clinical Package Validator to assess the code.')         else if ($psnomed-id = 'amtv3') then concat(' The ''', $v-psnomed-version,          ''' version of the code system was used with the Clinical Package Validator to assess the AMT version 3 primary code.')        else if ($psnomed-id = 'snomedctau') then concat(' The ''', $v-psnomed-version,          ''' version of the code system was used with the Clinical Package Validator to assess the SNOMED CT-AU primary code.')        else if (matches(@codeSystemVersion, $snomed-version-regex-1)) then          concat(' The ''', @codeSystemVersion, ''' version of the code system is not available so the ''',          $v-psnomed-version, ''' version of the code system was used with the Clinical Package Validator to assess the primary code.')         else concat(' The codeSystemVersion attribute has an invalid value ''', @codeSystemVersion, ''' so the ''', $v-psnomed-version,          ''' version of the code system was used with the Clinical Package Validator to assess the primary code.') " />
    <xsl:variable name="test-step" select="if($extensions-allowed) then 'step 1' else 'step 4' " />
    <xsl:variable name="message-text" select="if($extensions-allowed) then normalize-space(concat('Any extension must meet the requirements to not   qualify or negate content described by the clinical document specifications and it must be clinically safe for receivers of the document to ignore information in the extension.   Confirm if the extension meets these requirements. If these requirements are not met then the presence of the extension is an error.   (See section 6.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0, section 1.8 of the ', $document-name, ' CDA Implementation Guide and ',   $extension-requirement, '.)'))        else concat('The presence of an extension fails to meet the requirement that the document must not contain additional data elements. (See ',         $extension-requirement, '.)')" />
    <xsl:variable name="assess-medical-nomenclature-1" select="$flags/@report-data-quality = 'true' and @code and @codeSystem and ancestor::cda:section and             not(ancestor::cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']] or @codeSystem = $excluded-nomenclatures) " />
    <xsl:variable name="code-format-valid" select="if (not($assess-medical-nomenclature-1)) then false()        else if (@codeSystem = '1.2.36.1.2001.1004.100') then matches(@code, $amtv2-code-regex)        else if (@codeSystem = '1.2.36.1.2001.1005.11.1') then matches(@code, $mims-code-regex)        else if (@codeSystem = '1.2.36.1.2001.1005.22') then matches(@code, $pbs-code-regex)        else if (@codeSystem = '1.2.36.1.2001.1005.23') then matches(@code, $pbsman-code-regex)        else if (@codeSystem = '2.16.840.1.113883.6.1') then matches(@code, $loinc-code-regex, 'i')        else if (@codeSystem = '2.16.840.1.113883.6.96') then matches(@code, $snomed-code-regex) and matches(@code, $sctau-concept-id-regex)        else if (@codeSystem = '1.2.36.1.2001.1005.17') then true()        else not(@code = '') " />
    <xsl:variable name="assess-medical-nomenclature" select="$assess-medical-nomenclature-1 and $code-format-valid " />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="default-context" select="not($initial-priority) and ancestor::cda:entry and not(ancestor::cda:performer) " />
    <xsl:variable name="rating-06-step-2" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-06-step-2 else $rating-alt-TC-Types-06-step-2 " />
    <xsl:variable name="rating-07-step-1" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-07-step-1 else $rating-alt-TC-Types-07-step-1 " />
    <xsl:variable name="rating-07-step-2" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-07-step-2 else $rating-alt-TC-Types-07-step-2 " />
    <xsl:variable name="rating-08" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-08 else $rating-alt-TC-Types-08 " />
    <xsl:variable name="rating-28" select="if ($initial-priority) then $initial-rating        else if ($test-step = 'step 1' and exists(ancestor::cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code=$meds-view-sections])) then $rating-MHRView-TC-Doc-28-step-1       else if ($test-step = 'step 1') then $rating-TC-Doc-28-step-1        else if ($test-step = 'step 4') then $rating-TC-Doc-28-step-4 else '' " />
    <xsl:variable name="rating-48" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-48 else $rating-alt-TC-Types-48 " />
    <xsl:variable name="rating-57" select="if ($initial-priority) then $initial-rating else $rating-TC-Types-57 " />
    <xsl:variable name="rating-Terminology" select="if ($initial-priority) then $initial-rating else $rating-TS-Terminology " />
    <!--REPORT -->
    <xsl:if test=" ($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: TC-Types-07: The Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data
		type and <xsl:text /><xsl:value-of select="iq:display-CD(.)" /><xsl:text />.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="not($tc-doc-04-err) and @xsi:type and not(@xsi:type = ('CD', 'CE', 'CO', 'CV') or normalize-space(substring-after(@xsi:type, ':')) = ('CD', 'CE', 'CO', 'CV')) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($tc-doc-04-err) and @xsi:type and not(@xsi:type = ('CD', 'CE', 'CO', 'CV') or normalize-space(substring-after(@xsi:type, ':')) = ('CD', 'CE', 'CO', 'CV'))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-07-step-1" /><xsl:text />: TC-Types-07 step 1: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'
		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type
		which is derived from the HL7 'CD' data type however xsi:type '<xsl:text /><xsl:value-of select="@xsi:type" /><xsl:text />' is present.
		(See section 6.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" local-name(.) = ('name', 'value') and not(local-name(..) = 'qualifier') and not(@xsi:type) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="local-name(.) = ('name', 'value') and not(local-name(..) = 'qualifier') and not(@xsi:type)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-07-step-1" /><xsl:text />: TC-Types-07 step 1: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element
		in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type which is derived from the HL7 'CD' data type however no xsi:type attribute is present.
		An xsi:type attribute must be present with the value 'CD' or one of the specialisations 'CE', 'CO' or 'CV'.
		(See section 6.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="cda:translation">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="cda:translation">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-07-step-2" /><xsl:text />: TC-Types-07 step 2: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element
		in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type
		however a child element 'translation' is present that is not expected for the CodedText data type. Values of a data element of the CodedText data type must come from the bound value
		domain, with no exceptions. A translation translates the value into a code from another code systems, so translations are not allowed for CodedText.
		(See section B.3 of the <xsl:text /><xsl:value-of select="$logical-spec" /><xsl:text /> and section 6.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="cda:qualifier">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="cda:qualifier">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-07-step-2" /><xsl:text />: TC-Types-07 step 2: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type
		however a child element 'qualifier' is present that is not expected for the CodedText data type. Values of a data element of the CodedText data type must come from the bound value domain,
		with no exceptions. A qualifier constrains the value, so qualifiers are not allowed for CodedText.
		(See section B.3 of the <xsl:text /><xsl:value-of select="$logical-spec" /><xsl:text /> and section 6.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="@codeSystem = '1.2.36.1.2001.1001.101' or cda:translation/@codeSystem = '1.2.36.1.2001.1001.101' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem = '1.2.36.1.2001.1001.101' or cda:translation/@codeSystem = '1.2.36.1.2001.1001.101'">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-57" /><xsl:text />: TC-Types-57: The Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has <xsl:text /><xsl:value-of select="iq:display-CD(.)" /><xsl:text />.
		This is an error as the NCTIS Data Components code system is used to identify data elements and is not the correct code system to use for a value of the data element.
		(See the list of CodeSystem OIDs in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide and 
		section 7.5.2 of ISO 21090 'Health informatics - Harmonized data types for information interchange'.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($extensions-allowed) and *[not(local-name() = ('originalText', 'translation', 'qualifier'))] ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($extensions-allowed) and *[not(local-name() = ('originalText', 'translation', 'qualifier'))]">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type however
		a child element '<xsl:text /><xsl:value-of select="local-name(*[not(local-name() = ('originalText', 'translation', 'qualifier'))])" /><xsl:text />' is present and
		is not expected for the CodedText data type so this data element is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and $extensions-allowed and *[not(local-name() = ('originalText', 'translation', 'qualifier'))] ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and $extensions-allowed and *[not(local-name() = ('originalText', 'translation', 'qualifier'))]">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type however
		a child element '<xsl:text /><xsl:value-of select="local-name(*[not(local-name() = ('originalText', 'translation', 'qualifier'))])" /><xsl:text />' is present and
		is not expected for the CodedText data type so this data element is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($extensions-allowed) and    @*[not(name() = ('xsi:type', 'code', 'codeSystem', 'codeSystemName', 'codeSystemVersion', 'displayName', 'nullFlavor'))] and not(@xsi:type and     not(@xsi:type = ('CD', 'CE', 'CO', 'CV') or normalize-space(substring-after(@xsi:type, ':')) = ('CD', 'CE', 'CO', 'CV')))">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($extensions-allowed) and @*[not(name() = ('xsi:type', 'code', 'codeSystem', 'codeSystemName', 'codeSystemVersion', 'displayName', 'nullFlavor'))] and not(@xsi:type and not(@xsi:type = ('CD', 'CE', 'CO', 'CV') or normalize-space(substring-after(@xsi:type, ':')) = ('CD', 'CE', 'CO', 'CV')))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type however an attribute
		'<xsl:text /><xsl:value-of select="name(@*[not(name() = ('xsi:type', 'code', 'codeSystem', 'codeSystemName', 'codeSystemVersion', 'displayName', 'nullFlavor'))])" /><xsl:text />' is present and is not expected
		for the CodedText data type so this attribute is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and $extensions-allowed and    @*[not(name() = ('xsi:type', 'code', 'codeSystem', 'codeSystemName', 'codeSystemVersion', 'displayName', 'nullFlavor'))] and not(@xsi:type and     not(@xsi:type = ('CD', 'CE', 'CO', 'CV') or normalize-space(substring-after(@xsi:type, ':')) = ('CD', 'CE', 'CO', 'CV')))">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and $extensions-allowed and @*[not(name() = ('xsi:type', 'code', 'codeSystem', 'codeSystemName', 'codeSystemVersion', 'displayName', 'nullFlavor'))] and not(@xsi:type and not(@xsi:type = ('CD', 'CE', 'CO', 'CV') or normalize-space(substring-after(@xsi:type, ':')) = ('CD', 'CE', 'CO', 'CV')))">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type however
		an attribute '<xsl:text /><xsl:value-of select="name(@*[not(name() = ('xsi:type', 'code', 'codeSystem', 'codeSystemName', 'codeSystemVersion', 'displayName', 'nullFlavor'))])" /><xsl:text />'
		is present and is not expected for the CodedText data type so this attribute is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="$flags/@report-terminology-concepts = 'true' and not(true() or false() or $family-err or $length-err) and    not(@nullFlavor) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@report-terminology-concepts = 'true' and not(true() or false() or $family-err or $length-err) and not(@nullFlavor)">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text> 

		Finding: (value domain not specified): The Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the
		CodedText data type and <xsl:text /><xsl:value-of select="iq:display-CD(.)" /><xsl:text />.
		The CodedText data type has the requirement that values must come from the specified bound value domain with no exceptions but a value domain has not been specified for the
		Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element.
		<xsl:text /><xsl:value-of select="if (not(cda:originalText or @code or @displayName) or $log-concepts-created = 'ERROR') then '' else if (dh:AppendLog($log-concepts-name, concat(                  $display-creation-date,   $log-tab,                  $document-id,    $log-tab,                  $document-name,    $log-tab,                  iq:location(., ''),    $log-tab,                   'Document Type',     $log-tab,                   'no',     $log-tab,                   iq:display-CD(.),    $log-tab,                   '',      $log-tab,                  '',      $log-tab,                  '',      $log-tab,                  ''      )) = ('NOTFOUND', 'ERROR'))    then concat('A failure occurred when the AppendLog function was requested to append the concepts log ''', $log-concepts-name, '''.') else '' " /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="false() and not(@nullFlavor) and (not(@codeSystem) or (@codeSystem and @codeSystem != '1.2.36.1.2001.1001.101'))  ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="false() and not(@nullFlavor) and (not(@codeSystem) or (@codeSystem and @codeSystem != '1.2.36.1.2001.1001.101'))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-06-step-2" /><xsl:text />: TC-Types-06 step 2: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element
		in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type. The
		CodedText data type has the requirement that values must come from the bound value domain with no exceptions. Therefore the value of the codeSystem attribute must be a publicly available
		code system. The Document Type data element has <xsl:text /><xsl:value-of select="iq:display-CD(.)" /><xsl:text />.
		The <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide states the code system is 'NS' (not stated) with the requirement 'When national standard code sets become
		available, they SHALL be used'. The <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> was created <xsl:text /><xsl:value-of select="$display-creation-date" /><xsl:text /> which is after the national standard code set became available
		for use on the <xsl:text /><xsl:value-of select="''" /><xsl:text />. The code system that must be used is
		<xsl:text /><xsl:value-of select="if ('1.2.36.1.2001.1001.101' = '2.16.840.1.113883.6.96') then concat(' the SNOMED CT-AU ',    $code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/coded-data[@referenceSetID = 'none']/@referenceSetName, ' (ConceptId ''', 'none', ''')')   else concat('1.2.36.1.2001.1001.101', ' (', $code-systems/system[@codeSystem = '1.2.36.1.2001.1001.101']/@codeSystemName, ')')" /><xsl:text /><xsl:text /><xsl:value-of select="if (not(@codeSystem)) then '.'    else if (@codeSystemName) then concat(' however codeSystem ''', @codeSystem, ''' (', @codeSystemName, ') is present.')   else concat(' however a codeSystem attribute with the value ''', @codeSystem, ''' is present.') " /><xsl:text />
		(See section 1.8 of the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide, <xsl:text /><xsl:value-of select="$doc-type/@data-types-legend" /><xsl:text /> and section 2.16 of the Advance Care Information Structured Content Specification v1.0 for the
		information about the value domain.)
		<xsl:text /><xsl:value-of select="if ('none' = '11000036103') then concat('Some members of the ',     $code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/coded-data[@referenceSetID = 'none']/@referenceSetName,     ' are Allergic reaction (''419076005''), Medication side-effect (''401207004'') and Drug interaction (''79899007'').')    else if ('none' = '15071000036100') then concat('Some members of the ',     $code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/coded-data[@referenceSetID = 'none']/@referenceSetName,     ' are Prescribed (''105681000036100''), Suspended (''385655000'') and Unchanged (''105701000036103'').')    else '' " /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @nullFlavor = 'OTH' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor = 'OTH'">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text> 

		Error<xsl:text /><xsl:value-of select="$rating-07-step-2" /><xsl:text />: TC-Types-07 step 2: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element
		in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type
		which has the requirement that values must come from the bound value domain with no exceptions. Therefore it is not valid for the data element to have nullFlavor 'OTH' to indicate that the
		actual value is not a member of the set of permitted data values in the constrained value domain. 
		(See the requirements for Document Type and <xsl:text /><xsl:value-of select="$doc-type/@data-types-legend" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @nullFlavor and not($tc-types-49-err) and not(@nullFlavor = ('OTH', 'NI', 'UNK', 'ASKU', 'NAV', 'NASK', 'MSK', 'NA')) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor and not($tc-types-49-err) and not(@nullFlavor = ('OTH', 'NI', 'UNK', 'ASKU', 'NAV', 'NASK', 'MSK', 'NA'))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-48" /><xsl:text />: TC-Types-48: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type<xsl:text /><xsl:value-of select="if (not(false())) then '.' else   concat(' and section 2.16 of the Advance Care Information Structured Content Specification v1.0 states the vocabulary is ''', '1.2.36.1.2001.1001.101', ''' (', $code-systems/system[@codeSystem = '1.2.36.1.2001.1001.101']/@codeSystemName, ').') " /><xsl:text />
		The CodedText data type has
		the requirement that values must come from the bound value domain with no exceptions. Therefore the data element must have a code attribute to provide a value or a nullFlavor attribute
		to indicate there is no value, however a nullFlavor attribute with the value '<xsl:text /><xsl:value-of select="@nullFlavor" /><xsl:text />'
		(<xsl:text /><xsl:value-of select="$nullFlavors/nullFlavor[@value = current()/@nullFlavor]/@name" /><xsl:text />) is present and is not one of the nullFlavor values that indicate there is no value.
		(See <xsl:text /><xsl:value-of select="$doc-type/@data-types-legend" /><xsl:text /> and sections 7.1.4 and 7.3.3.3 of ISO 21090 'Health informatics - Harmonized data types for information interchange'.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not(@nullFlavor or @code) and not(false() and not(@nullFlavor) and not(@codeSystem)) and cda:originalText ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor or @code) and not(false() and not(@nullFlavor) and not(@codeSystem)) and cda:originalText">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-07-step-2" /><xsl:text />: TC-Types-07 step 2: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element
		in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type
		which has the requirement that values must come from the bound value domain with no exceptions. Therefore the data element must have a code attribute to provide a value or a nullFlavor
		attribute to indicate there is no value. The only information found in the data element is originalText '<xsl:text /><xsl:value-of select="cda:originalText" /><xsl:text />'.
		(See the requirements for Document Type and <xsl:text /><xsl:value-of select="$doc-type/@data-types-legend" /><xsl:text />.)
		<xsl:text /><xsl:value-of select="if (local-name(.) = 'jobClassCode') then concat('Consider using the METeOR 314867 ''Employment type'' code system (codeSystem ''2.16.840.1.113883.3.879.314867'') which has ',   'codes for ''Permanent'', ''Fixed term contract'', ''Casual'' and ''Not stated/inadequately described''; or the  METeOR 691891 ''Full-time/part-time status'' code system ',   '(codeSystem ''2.16.840.1.113883.3.879.691891'') which has codes for ''Full-time'', ''Part-time'' and ''Not stated/inadequately described''. ',   '(See the the METeOR 314867 webpage http://meteor.aihw.gov.au/content/index.phtml/itemId/314867 and the METeOR 691891 webpage http://meteor.aihw.gov.au/content/index.phtml/itemId/691891.)')   else '' " /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="true() and @codeSystem and @codeSystem != '1.2.36.1.2001.1001.101' and not(false()) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="true() and @codeSystem and @codeSystem != '1.2.36.1.2001.1001.101' and not(false())">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-07-step-2" /><xsl:text />: TC-Types-07 step 2: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element
		in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type and section 2.16 of the Advance Care Information Structured Content Specification v1.0 states the vocabulary is
		<xsl:text /><xsl:value-of select="if ('1.2.36.1.2001.1001.101' = '2.16.840.1.113883.6.96') then concat(' the SNOMED CT-AU ',    $code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/coded-data[@referenceSetID = 'none']/@referenceSetName, ' (ConceptId ''', 'none', ''').')   else concat('1.2.36.1.2001.1001.101', ' (', $code-systems/system[@codeSystem = '1.2.36.1.2001.1001.101']/@codeSystemName, ').')" /><xsl:text />
		The CodedText data type has the requirement that values must come from the bound value domain with no exceptions.
		Therefore the value of codeSystem must be '1.2.36.1.2001.1001.101' but codeSystem '<xsl:text /><xsl:value-of select="@codeSystem" /><xsl:text />' (<xsl:text /><xsl:value-of select="@codeSystemName" /><xsl:text />) is present.
		(See <xsl:text /><xsl:value-of select="$doc-type/@data-types-legend" /><xsl:text />.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="true() and '1.2.36.1.2001.1001.101' = '2.16.840.1.113883.6.96' and @codeSystem = '2.16.840.1.113883.6.96' and @code and    not(dh:IsCodeInValueDomainValid(@code, '2.16.840.1.113883.6.96', $v-psnomed-version,    $code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/coded-data[@referenceSetID = 'none']/@refSet) = 'CodeFound') ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="true() and '1.2.36.1.2001.1001.101' = '2.16.840.1.113883.6.96' and @codeSystem = '2.16.840.1.113883.6.96' and @code and not(dh:IsCodeInValueDomainValid(@code, '2.16.840.1.113883.6.96', $v-psnomed-version, $code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/coded-data[@referenceSetID = 'none']/@refSet) = 'CodeFound')">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-07-step-2" /><xsl:text />: TC-Types-07 step 2: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element
		in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type
		which has the requirement that values must come from the bound value domain with no exceptions. The applicable value domain is the SNOMED CT-AU
		<xsl:text /><xsl:value-of select="$code-systems/system[@codeSystem = '2.16.840.1.113883.6.96']/coded-data[@referenceSetID = 'none']/@referenceSetName" /><xsl:text />
		(Concept ID: 'none'). The data element has <xsl:text /><xsl:value-of select="iq:display-CD(.)" /><xsl:text /> and the code is not a member of the value domain.
		(See <xsl:text /><xsl:value-of select="$doc-type/@data-types-legend" /><xsl:text /> and section 2.16 of the Advance Care Information Structured Content Specification v1.0 for the information about the value domain.)<xsl:text /><xsl:value-of select="$v-psnomed-version-msg" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="not($no-cd-value-1) and ancestor::cda:section and not(@nullFlavor) and not(@displayName or cda:originalText) and local-name(..) != 'asEntityIdentifier' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($no-cd-value-1) and ancestor::cda:section and not(@nullFlavor) and not(@displayName or cda:originalText) and local-name(..) != 'asEntityIdentifier'">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text> 

		Error<xsl:text /><xsl:value-of select="$rating-08" /><xsl:text />: TC-Types-08: According to section 2.15 of the Advance Care Information Structured Content Specification v1.0 the Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type. It has <xsl:text /><xsl:value-of select="iq:display-CD(.)" /><xsl:text /> but has neither an originalText nor a displayName
		so it fails to conform to the requirement 'In accordance with the requirement to completely represent section contents, values of CodedText or CodeableText data elements defined in
		the SCS SHALL include an originalText or a displayName component (or both)'.
		(See Appendix A of the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide and sections 6.1 and 6.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090
		Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $assess-medical-nomenclature and not(cda:originalText) and not(false()) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$assess-medical-nomenclature and not(cda:originalText) and not(false())">
        <xsl:attribute name="flag">RECOMMENDATION</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text> 

		Recommendation<xsl:text /><xsl:value-of select="$rating-Terminology" /><xsl:text />: Out.CDA.Doc.Nat-01: The Document Type '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the
		<xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the CodedText data type and <xsl:text /><xsl:value-of select="iq:display-CD(.)" /><xsl:text />.
		<xsl:text /><xsl:value-of select="if (@codeSystem = '2.16.840.1.113883.6.96') then 'This indicates that there is no mapping to SNOMED CT-AU and SNOMED CT-AU is the primary code system.' else '' " /><xsl:text />
		The originalText element is not present but it should be included to ensure the original meaning of the clinical statement is
		not lost during the authoring of the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text />. (See requirement 020638 in Guidance for Use of Medical Nomenclatures in Information Exchange v1.2.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M33" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M33" />
  <xsl:template match="@*|node()" priority="-2" mode="M33">
    <xsl:apply-templates select="@*|*" mode="M33" />
  </xsl:template>
  <!--PATTERN p-TS-ACI-EncapsulatedData-1-->
  <!--RULE -->
  <xsl:template match="/cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:reference/cda:externalDocument/cda:text" priority="1000" mode="M34">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context="/cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:reference/cda:externalDocument/cda:text" />
    <xsl:variable name="the-text" select="normalize-space(string-join(text(), '')) " />
    <xsl:variable name="text-is-present" select="not($the-text = '') " />
    <xsl:variable name="test-step" select="if($extensions-allowed) then 'step 1' else 'step 4' " />
    <xsl:variable name="message-text" select="if($extensions-allowed) then normalize-space(concat('Any extension must meet the requirements to not   qualify or negate content described by the clinical document specifications and it must be clinically safe for receivers of the document to ignore information in the extension.   Confirm if the extension meets these requirements. If these requirements are not met then the presence of the extension is an error.   (See section 5.1 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0, section 1.8 of the ', $document-name, ' CDA Implementation Guide and ',   $extension-requirement, '.)'))       else concat('The presence of an extension fails to meet the requirement that the document must not contain additional data elements. (See ',        $extension-requirement, '.)')" />
    <xsl:variable name="display-text-1" select="$the-text " />
    <xsl:variable name="display-text" select="if ($display-text-1 = '') then '' else if (string-length($display-text-1) &lt; 200)        then concat(codepoints-to-string(34), normalize-space(dh:XQueryRecursiveReplace($display-text-1, $text-pattern-replacement, 'ic')), codepoints-to-string(34))       else concat('commencing with ', codepoints-to-string(34),         normalize-space(dh:XQueryRecursiveReplace(substring(dh:XQueryRecursiveReplace($display-text-1, $p-name-pattern-replacement, 'ic'), 1, 200),         $markup-pattern-replacement, 'ic')), ' . . . ', codepoints-to-string(34))" />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="default-context" select="not($initial-priority) and ancestor::cda:entry and not(ancestor::cda:performer) " />
    <xsl:variable name="rating-02" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-02 else $rating-alt-TC-Types-02 " />
    <xsl:variable name="rating-28" select="if ($initial-priority) then $initial-rating        else if ($test-step = 'step 1' and exists(ancestor::cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code=$meds-view-sections])) then $rating-MHRView-TC-Doc-28-step-1       else if ($test-step = 'step 1') then $rating-TC-Doc-28-step-1        else if ($test-step = 'step 4') then $rating-TC-Doc-28-step-4 else '' " />
    <xsl:variable name="rating-48" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-48 else $rating-alt-TC-Types-48 " />
    <!--REPORT -->
    <xsl:if test=" ($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: TC-Types-02: The Document Target
 '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'

		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type and
		<xsl:text /><xsl:value-of select="if (cda:reference/@value and $text-is-present) then concat('has a reference to ''', cda:reference/@value, ''' and contains the character string ',    $display-text)   else if (cda:reference/@value and not($text-is-present)) then concat('has a reference to ''', cda:reference/@value, '''')   else if (not(cda:reference/@value) and $text-is-present) then concat('contains the character string ', $display-text)   else 'has no reference and does not contain a character string' " /><xsl:text />.
		<xsl:text /><xsl:value-of select="if (@nullFlavor) then concat(' The nullFlavor attribute has the value ''', @nullFlavor, '''.') else '' " /><xsl:text /><xsl:text /><xsl:value-of select="if (@mediaType) then concat(' The mediaType attribute has the ', if (@mediaType = 'text/plain') then 'default' else '', ' value ''', @mediaType, '''.') else '' " /><xsl:text /><xsl:text /><xsl:value-of select="if (@integrityCheckAlgorithm) then concat(' The integrityCheckAlgorithm attribute has the value ''', @integrityCheckAlgorithm, '''.') else '' " /><xsl:text /><xsl:text /><xsl:value-of select="if (@integrityCheck) then concat(' The integrityCheck attribute has the value ''', @integrityCheck, '''.') else '' " /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @xsi:type and not(@xsi:type = 'ED' or normalize-space(substring-after(@xsi:type, ':')) = 'ED') ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xsi:type and not(@xsi:type = 'ED' or normalize-space(substring-after(@xsi:type, ':')) = 'ED')">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-02" /><xsl:text />: TC-Types-02: According to section 2.13 of the Advance Care Information Structured Content Specification v1.0 the Document Target

		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'

		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type
		which is derived from the HL7 'ED' data type however the xsi:type attribute has the value <xsl:text /><xsl:value-of select="@xsi:type" /><xsl:text />'.
		(See section 5.1 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" local-name(.) = 'value' and not(local-name(..) = 'observationMedia') and not(@xsi:type) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="local-name(.) = 'value' and not(local-name(..) = 'observationMedia') and not(@xsi:type)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-02" /><xsl:text />: TC-Types-02: According to section 2.13 of the Advance Care Information Structured Content Specification v1.0 the Document Target
 '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'

		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type which is derived from the HL7 'ED' data type however no xsi:type attribute is present.
		An xsi:type attribute must be present with the value 'ED'.
		(See section 5.1 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" matches($the-text, '^[0-9]*xsitypeED') ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="matches($the-text, '^[0-9]*xsitypeED')">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-48" /><xsl:text />: TC-Types-48: According to section 2.13 of the Advance Care Information Structured Content Specification v1.0 the Document Target
		'<xsl:text /><xsl:value-of select="local-name(../..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'
		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type.
		The data element's value '<xsl:text /><xsl:value-of select="$display-text-1" /><xsl:text />' contains "xsitypeED" which is an invalid attempt to assign the data element's type to be the HL7 'ED' data type.
		The correct way to assign the type is for the '<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element to contain an attribute with the name 'xsi:type' and the value 'ED'.
		(See section 2.6.1 of XML Schema Part 1: Structures Second Edition.)
		If a proper value cannot be included then it must have a nullFlavor attribute such as "INV" (<xsl:text /><xsl:value-of select="$nullFlavors/nullFlavor[@value = 'INV']/@name" /><xsl:text /> to indicate a proper value is not provided.
		(See sections 7.1.4 and 7.3.3.3 of ISO 21090 'Health informatics - Harmonized data types for information interchange'.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not(@integrityCheckAlgorithm) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@integrityCheckAlgorithm)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-02" /><xsl:text />: TC-Types-02: The Document Target
 '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'

		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type but does not have the
		integrityCheckAlgorithm attribute which indicates the data element does not have the HL7 'ED' data type. The Encapsulated Data data type is derived from the HL7 'ED' data type so the
		attribute xsi:type with the value 'ED' needs to be added to the data element.
		(See section 5.1 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($extensions-allowed) and *[not(local-name() = ('reference', 'thumbnail'))] ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($extensions-allowed) and *[not(local-name() = ('reference', 'thumbnail'))]">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.13 of the Advance Care Information Structured Content Specification v1.0 the Document Target

		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'
 data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type however a child element
		'<xsl:text /><xsl:value-of select="local-name(*[not(local-name() = ('reference', 'thumbnail'))])" /><xsl:text />' was found that is not expected for the EncapsulatedData data type
		so this element is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and $extensions-allowed and *[not(local-name() = ('reference', 'thumbnail'))] ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and $extensions-allowed and *[not(local-name() = ('reference', 'thumbnail'))]">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.13 of the Advance Care Information Structured Content Specification v1.0 the Document Target

		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'
 data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type however a child element
		'<xsl:text /><xsl:value-of select="local-name(*[not(local-name() = ('reference', 'thumbnail'))])" /><xsl:text />' was found that is not expected for the EncapsulatedData data type
		so this element is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($extensions-allowed) and    @*[not(name() = ('xsi:type', 'nullFlavor', 'language', 'mediaType', 'charset', 'integrityCheck', 'integrityCheckAlgorithm', 'compression', 'representation'))] and    not(@xsi:type and not(@xsi:type = 'ED' or normalize-space(substring-after(@xsi:type, ':')) = 'ED'))">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($extensions-allowed) and @*[not(name() = ('xsi:type', 'nullFlavor', 'language', 'mediaType', 'charset', 'integrityCheck', 'integrityCheckAlgorithm', 'compression', 'representation'))] and not(@xsi:type and not(@xsi:type = 'ED' or normalize-space(substring-after(@xsi:type, ':')) = 'ED'))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.13 of the Advance Care Information Structured Content Specification v1.0 the Document Target

		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'
 data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type however an attribute
		'<xsl:text /><xsl:value-of select="name(@*[not(name() = ('xsi:type', 'nullFlavor', 'language', 'mediaType', 'charset', 'integrityCheck', 'integrityCheckAlgorithm', 'compression', 'representation'))])" /><xsl:text />' was
		found that is not expected for the EncapsulatedData data type.
		The definition of the EncapsulatedData data type does not include this attribute so this is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and $extensions-allowed and    @*[not(name() = ('xsi:type', 'nullFlavor', 'language', 'mediaType', 'charset', 'integrityCheck', 'integrityCheckAlgorithm', 'compression', 'representation'))] and    not(@xsi:type and not(@xsi:type = 'ED' or normalize-space(substring-after(@xsi:type, ':')) = 'ED'))">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and $extensions-allowed and @*[not(name() = ('xsi:type', 'nullFlavor', 'language', 'mediaType', 'charset', 'integrityCheck', 'integrityCheckAlgorithm', 'compression', 'representation'))] and not(@xsi:type and not(@xsi:type = 'ED' or normalize-space(substring-after(@xsi:type, ':')) = 'ED'))">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.13 of the Advance Care Information Structured Content Specification v1.0 the Document Target

		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'
 data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type however an attribute
		'<xsl:text /><xsl:value-of select="name(@*[not(name() = ('xsi:type', 'nullFlavor', 'language', 'mediaType', 'charset', 'integrityCheck', 'integrityCheckAlgorithm', 'compression', 'representation'))])" /><xsl:text />' was
		found that is not expected for the EncapsulatedData data type.
		The definition of the EncapsulatedData data type does not include this attribute so this is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and @language ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and @language">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-02" /><xsl:text />: TC-Types-02: The Document Target
 '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'

		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type and has the attribute
		language='<xsl:text /><xsl:value-of select="@language" /><xsl:text />'. Confirm that this is a valid value for this attribute.
		(See section 5.1 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and @charset ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and @charset">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-02" /><xsl:text />: TC-Types-02: The Document Target
 '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />'

		data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the EncapsulatedData data type and has the attribute
		charset='<xsl:text /><xsl:value-of select="@charset" /><xsl:text />'. Confirm that this is a valid value for this attribute.
		(See section 5.1 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M34" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M34" />
  <xsl:template match="@*|node()" priority="-2" mode="M34">
    <xsl:apply-templates select="@*|*" mode="M34" />
  </xsl:template>
  <!--PATTERN p-TS-ACI-EncapsulatedData-2-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:reference/cda:externalDocument/cda:text " priority="1000" mode="M35">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:reference/cda:externalDocument/cda:text " />
    <xsl:variable name="l-text-1" select="replace(string-join(text(), ' '), '^[0-9]*xsitype(ED|ST)', '')" />
    <xsl:variable name="l-text-2" select="if (matches($l-text-1, '^(.*?\s*DisplayName:)(.*?)(,?\s*Comments:.*)$', 's'))         then replace($l-text-1, '^(.*?\s*DisplayName:)(.*?)(,?\s*Comments:.*)$', '$2', 's')        else if (matches($l-text-1, '^(.*?)(,?\s*Effective Date:.*?)$', 's')) then replace($l-text-1, '^(.*?)(,?\s*Effective Date:.*?)$', '$1', 's')        else $l-text-1 " />
    <xsl:variable name="l-text" select="normalize-space(lower-case($l-text-2))" />
    <xsl:variable name="text-without-markup" select="normalize-space(replace($l-text, $confirmed-markup-regex, ' ', 'is'))" />
    <xsl:variable name="normalised-text-orig" select="normalize-space(translate($text-without-markup, $chars-to-remove, '')) " />
    <xsl:variable name="normalised-text" select="normalize-space(translate(dh:XQueryRecursiveReplace(normalize-space(translate($text-without-markup, $chars-no-space, '')),         $fixed-text-pattern, 'ic'), $chars-to-remove, '')) " />
    <xsl:variable name="text-to-find" select="$normalised-text != '' and not(matches($normalised-text, $regex-non-values, 'is')) " />
    <xsl:variable name="info-to-find" select="$text-to-find or @nullFlavor " />
    <xsl:variable name="target-section" select="if (not($info-to-find)) then () else ancestor::cda:section[normalize-space(cda:text) != ''][position()=1]" />
    <xsl:variable name="target-title" select="if (not($info-to-find)) then () else translate(normalize-space(lower-case($target-section/cda:title)), $chars-to-remove, '') " />
    <xsl:variable name="sec-target-section" select="if (not($info-to-find)) then ()         else if (count($target-section/cda:component/cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and          (@code='102.16144' or @code='102.16145')]]/cda:text) = 1)         then $target-section/cda:component/cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and (@code='102.16144' or @code='102.16145')]]         else () " />
    <xsl:variable name="fir-narr-node" select="$target-section/cda:text" />
    <xsl:variable name="sec-narr-node" select="if (count($sec-target-section/cda:text) = 1) then $sec-target-section/cda:text else () " />
    <xsl:variable name="text-sequence" select="($target-title, $fir-narr-node//text(), $sec-narr-node//text()) " />
    <xsl:variable name="narr-text-el" select="(for $text in $text-sequence return normalize-space(lower-case($text)))[matches(., '[0-9a-z]', 'is')] " />
    <xsl:variable name="text-found" select="exists($narr-text-el[. = $l-text]) " />
    <xsl:variable name="text-wom-found" select="exists($narr-text-el[. = $text-without-markup]) " />
    <xsl:variable name="ss-success" select="$text-to-find and ($text-found or $text-wom-found) " />
    <xsl:variable name="narrative-1" select="if ($ss-success or not($info-to-find)) then '' else        normalize-space(translate(normalize-space(lower-case(string-join(($target-title, $narr-text-el), ''))), $chars-to-remove, ''))" />
    <xsl:variable name="text-match-1" select="$text-to-find and ($ss-success or contains($narrative-1, $normalised-text-orig))" />
    <xsl:variable name="narrative-2" select="if ($text-match-1 or not($text-to-find)) then $narrative-1 else        normalize-space(translate(normalize-space(lower-case(string-join(for $text in ($target-title, $narr-text-el) return       dh:XQueryRecursiveReplace(normalize-space(translate($text, $chars-no-space, '')), $fixed-text-pattern, 'ic'), ''))), $chars-to-remove, ''))" />
    <xsl:variable name="text-match-2" select="$text-to-find and ($text-match-1 or contains($narrative-2, $normalised-text))" />
    <xsl:variable name="fir-narr-2" select="if ($text-match-2 or not($text-to-find)) then '' else        normalize-space(translate(normalize-space(lower-case(string-join(for $text in $fir-narr-node//text()[not(ancestor::cda:th)] return       dh:XQueryRecursiveReplace(normalize-space(translate($text, $chars-no-space, '')), $fixed-text-pattern, 'ic'), ''))), $chars-to-remove, ''))" />
    <xsl:variable name="sec-narr-2" select="if ($text-match-2 or not($text-to-find)) then '' else        normalize-space(translate(normalize-space(lower-case(string-join(for $text in $sec-narr-node//text()[not(ancestor::cda:th)] return       dh:XQueryRecursiveReplace(normalize-space(translate($text, $chars-no-space, '')), $fixed-text-pattern, 'ic'), ''))), $chars-to-remove, ''))" />
    <xsl:variable name="narrative-3" select="if ($text-match-2 or not($text-to-find)) then $narrative-2 else concat($target-title, $fir-narr-2, $sec-narr-2)" />
    <xsl:variable name="text-match-3" select="$text-to-find and ($text-match-2 or contains($narrative-3, $normalised-text))" />
    <xsl:variable name="fir-narr-3" select="if ($text-match-3 or not($text-to-find)) then '' else       normalize-space(translate(normalize-space(lower-case(string-join(for $text in $fir-narr-node//text()[not(ancestor::cda:th or ancestor::cda:caption or        ancestor::cda:linkHtml or ancestor::cda:renderMultiMedia)] return       dh:XQueryRecursiveReplace(normalize-space(translate($text, $chars-no-space, '')), $fixed-text-pattern, 'ic'), ''))), $chars-to-remove, ''))" />
    <xsl:variable name="sec-narr-3" select="if ($text-match-3 or not($text-to-find)) then '' else       normalize-space(translate(normalize-space(lower-case(string-join(for $text in $sec-narr-node//text()[not(ancestor::cda:th or ancestor::cda:caption or        ancestor::cda:linkHtml or ancestor::cda:renderMultiMedia)] return       dh:XQueryRecursiveReplace(normalize-space(translate($text, $chars-no-space, '')), $fixed-text-pattern, 'ic'), ''))), $chars-to-remove, ''))" />
    <xsl:variable name="narrative-4" select="if ($text-match-3 or not($text-to-find)) then $narrative-3 else concat($target-title, $fir-narr-3, $sec-narr-3)" />
    <xsl:variable name="text-match" select="$text-to-find and ($text-match-3 or contains($narrative-4, $normalised-text))" />
    <xsl:variable name="narrative" select="if ($narrative-4 != '') then $narrative-4 else if ($narrative-3 != '') then $narrative-3 else if ($narrative-2 != '') then $narrative-2        else if ($narrative-1 != '') then $narrative-1 else '' " />
    <xsl:variable name="nullFlavor-values" select="if (@nullFlavor and @nullFlavor = ('PINF', 'NINF', 'ASKU', 'NAV', 'NASK', 'QS', 'TRC', 'MSK', 'NA'))         then $nullFlavors/nullFlavor[@value = current()/@nullFlavor] else () " />
    <xsl:variable name="null-to-find" select="exists($nullFlavor-values) " />
    <xsl:variable name="null-in-narr" select="($nullFlavor-values/@name-regex and exists($narr-text-el[matches(., $nullFlavor-values/@name-regex, 'is')])) or              ($nullFlavor-values/@syn-regex and exists($narr-text-el[matches(., $nullFlavor-values/@syn-regex, 'is')])) " />
    <xsl:variable name="multimedia" select="exists($target-section/cda:text//cda:renderMultiMedia) or exists($sec-target-section/cda:text//cda:renderMultiMedia) " />
    <xsl:variable name="no-content" select="$info-to-find and not(exists($narr-text-el) or $multimedia) " />
    <xsl:variable name="multimedia-msg" select="if ($multimedia) then ' The information may be included in multimedia referenced by renderMultiMedia elements in the narrative block.' else '' " />
    <xsl:variable name="linkHtml-msg" select="if (exists($target-section/cda:text//cda:linkHtml) or exists($sec-target-section/cda:text//cda:linkHtml))         then concat(' Note that a document that is referenced from a narrative using a linkHtml element is not an integral part of the narrative so the',         ' information must be in the narrative regardless of whether or not it is present in the document reference by the linkHtml element.',        ' (See section 4.3.5.2 of HL7 Clinical Document Architecture, Release 2.0.)') else '' " />
    <xsl:variable name="display-text-1" select=" normalize-space(.) " />
    <xsl:variable name="display-text" select="if ($display-text-1 = '') then '' else if (string-length($display-text-1) &lt; 200)         then concat(codepoints-to-string(34), normalize-space(dh:XQueryRecursiveReplace($display-text-1, $text-pattern-replacement, 'ic')),          codepoints-to-string(34))        else concat('commencing with ', codepoints-to-string(34),          normalize-space(dh:XQueryRecursiveReplace(substring(dh:XQueryRecursiveReplace($display-text-1, $p-name-pattern-replacement, 'ic'), 1, 200),          $markup-pattern-replacement, 'ic')), ' . . . ', codepoints-to-string(34))" />
    <xsl:variable name="markup-in-narrative" select="if ($narrative != '' and matches($narrative, $confirmed-markup-regex, 'is') and $text-without-markup != $l-text)         then normalize-space(' The narrative and the text data element both contain character entity references. These were removed from the   text data element before it was compared to the narrative so that may be the reason for the mismatch. Confirm that   the inclusion of character entity references in the narrative is valid. (See https://dev.w3.org/html5/html-author/charref for a list of character entity references.)') else ''" />
    <xsl:variable name="entities-in-narrative" select="if ($narrative != '' and matches($narrative, '(&lt;)|(&gt;)') and matches(string-join(text(), ''),         concat('(', $example2-markup-type-2, ')|(', $example3-markup-type-2, ')|(', $example2-markup-type-4, ')|(', $example3-markup-type-4, ')')))         then normalize-space(' The narrative contains one or more XML predefined entities and the data element contains markup derived from the XML        predefined entities. Markup was removed from the data element before it was compared to the narrative so that may be the reason for        the mismatch. Any XML predefined entities in the narrative should also be present in the data element. (See section 4.6 of Extensible Markup        Language (XML) 1.0 (Fifth Edition), https://www.w3.org/TR/xml/#sec-predefined-ent for information about XML predefined entities.)') else ''" />
    <xsl:variable name="debug-text" select="if ($flags/@allow-debug != 'true') then ''        else if (string-length($normalised-text) &lt; 1000)         then concat(codepoints-to-string(34), dh:XQueryRecursiveReplace($normalised-text, $markup-pattern-replacement, 'ic'), codepoints-to-string(34))        else concat('commencing with ', codepoints-to-string(34),          substring(dh:XQueryRecursiveReplace($normalised-text, $markup-pattern-replacement, 'ic'), 1, 1000), ' . . . ', codepoints-to-string(34))" />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="rating-step-7" select="if ($initial-priority) then $initial-rating else $rating-TC-Narr-09-step-7 " />
    <xsl:variable name="rating-step-9" select="if ($initial-priority) then $initial-rating else $rating-TC-Narr-09-step-9 " />
    <!--REPORT -->
    <xsl:if test=" $flags/@allow-debug = 'true' and $text-to-find and not($no-content) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$flags/@allow-debug = 'true' and $text-to-find and not($no-content)">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: TC-Narr-09 step 7 (p-TS-Info-Text): The Document Target '<xsl:text /><xsl:value-of select="local-name(../..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the normalised text <xsl:text /><xsl:value-of select="$debug-text" /><xsl:text />.
		Is the text in the narrative? <xsl:text /><xsl:value-of select="$text-match" /><xsl:text />.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $text-to-find and not($text-match or $no-content) and not(true() and not($multimedia)) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$text-to-find and not($text-match or $no-content) and not(true() and not($multimedia))">
        <xsl:attribute name="flag">WARNING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Warning<xsl:text /><xsl:value-of select="$rating-step-7" /><xsl:text />: TC-Narr-09 step 7: The Document Target
		'<xsl:text /><xsl:value-of select="local-name(../..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> contains the text <xsl:text /><xsl:value-of select="$display-text" /><xsl:text /> but this does not seem to be present in the narrative of the section.
		<xsl:text /><xsl:value-of select="if (true())    then ' The Document Target data element records clinical information and all clinical information in entry elements must be present in the narrative.'   else $clinical-info-question" /><xsl:text /><xsl:text /><xsl:value-of select="$multimedia-msg" /><xsl:text />
		(See requirements in Appendix A 'CDA Narratives' in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide.) <xsl:text /><xsl:value-of select="$markup-in-narrative" /><xsl:text /><xsl:text /><xsl:value-of select="$entities-in-narrative" /><xsl:text /><xsl:text /><xsl:value-of select="$linkHtml-msg" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $text-to-find and not($text-match or $no-content) and true() and not($multimedia) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$text-to-find and not($text-match or $no-content) and true() and not($multimedia)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-step-7" /><xsl:text />: TC-Narr-09 step 7: The Document Target
		'<xsl:text /><xsl:value-of select="local-name(../..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> contains the text <xsl:text /><xsl:value-of select="$display-text" /><xsl:text /> but this is not present in the narrative of the section.
		The Document Target data element records clinical information and all clinical information in entry elements must be present in the narrative.
		(See requirements in Appendix A 'CDA Narratives' in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide.) <xsl:text /><xsl:value-of select="$markup-in-narrative" /><xsl:text /><xsl:text /><xsl:value-of select="$entities-in-narrative" /><xsl:text /><xsl:text /><xsl:value-of select="$linkHtml-msg" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $no-content and $info-to-find and not($text-match or $null-in-narr) and not(true()) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$no-content and $info-to-find and not($text-match or $null-in-narr) and not(true())">
        <xsl:attribute name="flag">WARNING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Warning<xsl:text /><xsl:value-of select="$rating-step-7" /><xsl:text />: TC-Narr-09 step 7: The Document Target
		'<xsl:text /><xsl:value-of select="local-name(../..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> contains the text <xsl:text /><xsl:value-of select="$display-text" /><xsl:text /> but this is not present in the narrative of the section.
		<xsl:text /><xsl:value-of select="$clinical-info-question" /><xsl:text />
		(See requirements in Appendix A 'CDA Narratives' in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide.)<xsl:text /><xsl:value-of select="$linkHtml-msg" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $no-content and $info-to-find and not($text-match or $null-in-narr) and true() ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$no-content and $info-to-find and not($text-match or $null-in-narr) and true()">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-step-7" /><xsl:text />: TC-Narr-09 step 7: The Document Target
		'<xsl:text /><xsl:value-of select="local-name(../..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> contains the text <xsl:text /><xsl:value-of select="$display-text" /><xsl:text /> but this is not present in the narrative of the section.
		The Document Target data element records clinical information and all clinical information in entry elements must be present in the narrative.
		(See requirements in Appendix A 'CDA Narratives' in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide.)<xsl:text /><xsl:value-of select="$linkHtml-msg" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $null-to-find and @nullFlavor = ('ASKU', 'MSK', 'NA', 'NASK', 'NAV', 'UNK') and not($null-in-narr) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$null-to-find and @nullFlavor = ('ASKU', 'MSK', 'NA', 'NASK', 'NAV', 'UNK') and not($null-in-narr)">
        <xsl:attribute name="flag">WARNING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

 		Warning<xsl:text /><xsl:value-of select="$rating-step-9" /><xsl:text />: TC-Narr-09 step 9: The Document Target
		'<xsl:text /><xsl:value-of select="local-name(../..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> contains a nullFlavor attribute with the value '<xsl:text /><xsl:value-of select="@nullFlavor" /><xsl:text />' (<xsl:text /><xsl:value-of select="$nullFlavor-values/@name" /><xsl:text />)
		which has the explanation '<xsl:text /><xsl:value-of select="lower-case($nullFlavor-values/@explanation)" /><xsl:text />'. Text with the meaning of this nullFlavor does not seem to be present in
		the narrative of the section. If this is clinical information then confirm by manual inspection if the information provided by this nullFlavor attribute is present
		in the narrative perhaps using other text with the same meaning. All clinical information in entry elements must also be present in the narrative. <xsl:text /><xsl:value-of select="$multimedia-msg" /><xsl:text />
		(See requirements in Appendix A 'CDA Narratives' in the <xsl:text /><xsl:value-of select="$document-name" /><xsl:text /> CDA Implementation Guide and sections 7.1.4 and 7.3.3.3.1 of ISO 21090
		'Health informatics - Harmonized data types for information interchange'.)<xsl:text /><xsl:value-of select="$linkHtml-msg" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M35" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M35" />
  <xsl:template match="@*|node()" priority="-2" mode="M35">
    <xsl:apply-templates select="@*|*" mode="M35" />
  </xsl:template>
  <!--PATTERN p-TS-ACI-UniqueIdentifier-1-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:reference/cda:externalDocument/cda:id " priority="1000" mode="M36">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:reference/cda:externalDocument/cda:id " />
    <xsl:variable name="agency-namespace" select="@root and (matches(@root, '^1\.2\.36\.1\.2001\.1001\.10[0-4]{1}\.') or matches(@root, '^1\.2\.36\.1\.2001\.1006\.')) " />
    <xsl:variable name="test-step" select="if($extensions-allowed) then 'step 1' else 'step 4' " />
    <xsl:variable name="message-text" select="if($extensions-allowed) then normalize-space(concat('Any extension must meet the requirements to not   qualify or negate content described by the clinical document specifications and it must be clinically safe for receivers of the document to ignore information in the extension.   Confirm if the extension meets these requirements. If these requirements are not met then the presence of the extension is an error.   (See section 7.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0, section 1.8 of the ', $document-name, ' CDA Implementation Guide and ',   $extension-requirement, '.)'))       else concat('The presence of an extension fails to meet the requirement that the document must not contain additional data elements. (See ',        $extension-requirement, '.)')" />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="default-context" select="not($initial-priority) and ancestor::cda:entry and not(ancestor::cda:performer) " />
    <xsl:variable name="rating-11" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-11 else $rating-alt-TC-Types-11 " />
    <xsl:variable name="rating-28" select="if ($initial-priority) then $initial-rating        else if ($test-step = 'step 1' and exists(ancestor::cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code=$meds-view-sections])) then $rating-MHRView-TC-Doc-28-step-1       else if ($test-step = 'step 1') then $rating-TC-Doc-28-step-1        else if ($test-step = 'step 4') then $rating-TC-Doc-28-step-4 else '' " />
    <xsl:variable name="ii-context" select="if (ancestor::cda:recordTarget and ancestor::ext:asEntityIdentifier) then 'default' else 'alternative' " />
    <xsl:variable name="rating-73" select="if ($initial-priority) then $initial-rating       else if ($ratings/feature-set[@id='FS-Types']/test-set[@id='TS-II' and @context=$ii-context]/test-case[@id='TC-Types-73']/@rating)        then concat(' (', $ratings/feature-set[@id='FS-Types']/test-set[@id='TS-II' and @context=$ii-context]/test-case[@id='TC-Types-73']/@rating, ')')       else if ($ratings/feature-set[@id='FS-Types']/test-set[@id='TS-II' and @context=$ii-context]/@rating)       then concat(' (', $ratings/feature-set[@id='FS-Types']/test-set[@id='TS-II' and @context=$ii-context]/@rating, ')')       else '' " />
    <!--REPORT -->
    <xsl:if test=" ($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: TC-Types-11: The Document Identifier '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the UniqueIdentifier data type and has <xsl:text /><xsl:value-of select="iq:display-II(.)" /><xsl:text />.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @xsi:type and not(@xsi:type = 'II' or normalize-space(substring-after(@xsi:type, ':')) = 'II') ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xsi:type and not(@xsi:type = 'II' or normalize-space(substring-after(@xsi:type, ':')) = 'II')">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-11" /><xsl:text />: TC-Types-11: According to section 2.18 of the Advance Care Information Structured Content Specification v1.0 the Document Identifier '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the UniqueIdentifier data type which
		is derived from the HL7 'II' data type however an xsi:type attribute with the value '<xsl:text /><xsl:value-of select="@xsi:type" /><xsl:text />' is present.
		(See section 7.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" local-name(.) = 'value' and not(@xsi:type) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="local-name(.) = 'value' and not(@xsi:type)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-11" /><xsl:text />: TC-Types-11: According to section 2.18 of the Advance Care Information Structured Content Specification v1.0 the Document Identifier '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the UniqueIdentifier data type which is derived from the HL7 'II' data type however no xsi:type attribute is present.
		An xsi:type attribute must be present with the value 'II'. (See section 7.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($extensions-allowed) and * ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($extensions-allowed) and *">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.18 of the Advance Care Information Structured Content Specification v1.0 the Document Identifier
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the UniqueIdentifier data type however a child element '<xsl:text /><xsl:value-of select="local-name(*)" /><xsl:text />' was found
		that is not expected for the UniqueIdentifier data type so this element is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and $extensions-allowed and * ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and $extensions-allowed and *">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.18 of the Advance Care Information Structured Content Specification v1.0 the Document Identifier
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the UniqueIdentifier data type however a child element '<xsl:text /><xsl:value-of select="local-name(*)" /><xsl:text />' was found
		that is not expected for the UniqueIdentifier data type so this element is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($extensions-allowed) and    @*[not(name() = ('xsi:type', 'nullFlavor', 'root', 'extension', 'displayable', 'assigningAuthorityName'))] and   not(@xsi:type and not(@xsi:type = 'II' or normalize-space(substring-after(@xsi:type, ':')) = 'II'))">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($extensions-allowed) and @*[not(name() = ('xsi:type', 'nullFlavor', 'root', 'extension', 'displayable', 'assigningAuthorityName'))] and not(@xsi:type and not(@xsi:type = 'II' or normalize-space(substring-after(@xsi:type, ':')) = 'II'))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.18 of the Advance Care Information Structured Content Specification v1.0 the Document Identifier
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the UniqueIdentifier data type however the attribute
		'<xsl:text /><xsl:value-of select="name(@*[not(name() = ('xsi:type', 'nullFlavor', 'root', 'extension', 'displayable', 'assigningAuthorityName'))])" /><xsl:text />' was found that is not in the list of attributes
		expected for the UniqueIdentifier data type so this attribute is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and $extensions-allowed and    @*[not(name() = ('xsi:type', 'nullFlavor', 'root', 'extension', 'displayable', 'assigningAuthorityName'))] and   not(@xsi:type and not(@xsi:type = 'II' or normalize-space(substring-after(@xsi:type, ':')) = 'II'))">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and $extensions-allowed and @*[not(name() = ('xsi:type', 'nullFlavor', 'root', 'extension', 'displayable', 'assigningAuthorityName'))] and not(@xsi:type and not(@xsi:type = 'II' or normalize-space(substring-after(@xsi:type, ':')) = 'II'))">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.18 of the Advance Care Information Structured Content Specification v1.0 the Document Identifier
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the UniqueIdentifier data type however the attribute
		'<xsl:text /><xsl:value-of select="name(@*[not(name() = ('xsi:type', 'nullFlavor', 'root', 'extension', 'displayable', 'assigningAuthorityName'))])" /><xsl:text />' was found that is not in the list of attributes
		expected for the UniqueIdentifier data type so this attribute is an extension. <xsl:text /><xsl:value-of select="$message-text" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $agency-namespace ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$agency-namespace">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-73" /><xsl:text />: TC-Types-73:  The Document Identifier '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has <xsl:text /><xsl:value-of select="iq:display-II(.)" /><xsl:text />. The value of the root attribute identifies the
		'<xsl:text /><xsl:value-of select="$namespaces/namespace[starts-with(current()/@root, concat(@OID-prefix, '.'))]/@name" /><xsl:text />' namespace which is reserved for use by the Australian Digital Health Agency.
		The value of the root attribute must define the namespace for the extension attribute whose value is required to identify the document of interest.
		(See section 7.6.7.3.1 of ISO 21090 'Health informatics - Harmonized data types for information interchange' and the Document Identifier definition in section 2.18 of the Advance Care Information Structured Content Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <xsl:apply-templates select="@*|*" mode="M36" />
  </xsl:template>
  <xsl:template match="text()" priority="-1" mode="M36" />
  <xsl:template match="@*|node()" priority="-2" mode="M36">
    <xsl:apply-templates select="@*|*" mode="M36" />
  </xsl:template>
  <!--PATTERN p-TS-ACI-TimeInterval-1-->
  <!--RULE -->
  <xsl:template match=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:author/cda:time " priority="1000" mode="M37">
    <svrl:fired-rule xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" context=" /cda:ClinicalDocument['101.16973' = $doc-sections]/cda:component/cda:structuredBody/cda:component//   cda:section[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='101.16973']]/cda:entry/   cda:act[cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16971']]/cda:author/cda:time " />
    <xsl:variable name="test-step" select="if($extensions-allowed) then 'step 1' else 'step 4' " />
    <xsl:variable name="message-text1" select="if($extensions-allowed) then normalize-space(concat('Any extension must meet the requirements to not   qualify or negate content described by the clinical document specifications and it must be clinically safe for receivers of the document to ignore information in the extension.   Confirm if the extension meets these requirements. If these requirements are not met then the presence of the extension is an error.   (See section 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0, section 1.8 of the ', $document-name, ' CDA Implementation Guide and ',   $extension-requirement, '.)'))        else concat('The presence of an extension fails to meet the requirement that the document must not contain additional data elements. (See ',         $extension-requirement, '.)')" />
    <xsl:variable name="message-text2" select="if($extensions-allowed) then normalize-space(concat('Any extension must meet the requirements to not   qualify or negate content described by the clinical document specifications and it must be clinically safe for receivers of the document to ignore information in the extension.   Confirm if the extension meets these requirements. If these requirements are not met then the presence of the extension is an error.   (See sections 8.6 and 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0, section 1.8 of the ', $document-name, ' CDA Implementation Guide and ',   $extension-requirement, '.)'))        else concat('The presence of an extension fails to meet the requirement that the document must not contain additional data elements. (See ',         $extension-requirement, '.)')" />
    <xsl:variable name="nullFlavor-values" select="$nullFlavors/nullFlavor[@value = current()/@nullFlavor]" />
    <xsl:variable name="low-inclusive" select="if (not(cda:low)) then '' else if (cda:low/@inclusive='false') then ' (excluded)' else ' (included)' " />
    <xsl:variable name="high-inclusive" select="if (not(cda:high)) then '' else if (cda:high/@inclusive='false') then ' (excluded)' else ' (included)' " />
    <xsl:variable name="display-interval" select="if (@value and cda:low/@value and cda:high/@value)         then concat('value ', codepoints-to-string(34), @value, codepoints-to-string(34), ', low value ', codepoints-to-string(34), cda:low/@value,        codepoints-to-string(34), $low-inclusive, ' and high value ', codepoints-to-string(34), cda:high/@value, codepoints-to-string(34), $high-inclusive)        else if (@value and cda:low/@value and not(cda:high/@value))         then concat('value ', codepoints-to-string(34), @value, codepoints-to-string(34), ' and low value ', codepoints-to-string(34), cda:low/@value,        codepoints-to-string(34), $low-inclusive)       else if (@value and not(cda:low/@value) and cda:high/@value)         then concat('value ', codepoints-to-string(34), @value, codepoints-to-string(34), ' and high value ', codepoints-to-string(34),        cda:high/@value, codepoints-to-string(34), $high-inclusive)       else if (not(@value) and cda:low/@value and cda:high/@value)         then concat('low value ', codepoints-to-string(34), cda:low/@value, codepoints-to-string(34), $low-inclusive, ' and high value ',         codepoints-to-string(34), cda:high/@value, codepoints-to-string(34), $high-inclusive)       else if (@value and not(cda:low/@value) and not(cda:high/@value))         then concat('value ', codepoints-to-string(34), @value, codepoints-to-string(34))       else if (not(@value) and cda:low/@value and not(cda:high/@value))         then concat('low value ', codepoints-to-string(34), cda:low/@value, codepoints-to-string(34), $low-inclusive)       else if (not(@value) and not(cda:low/@value) and cda:high/@value)         then concat('high value ', codepoints-to-string(34), cda:high/@value, codepoints-to-string(34), $high-inclusive)       else '' " />
    <xsl:variable name="initial-priority" select="if ($flags/@allow-ratings = 'true')         then ancestor::cda:section[position()=1][cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code='102.16080']]    or          '1' = (for $node in ancestor-or-self::* return if (local-name($node) = $initial-priority-nodes) then '1' else '0')  or         ancestor::cda:participant[@typeCode = $initial-participants]        else false() " />
    <xsl:variable name="default-context" select="not($initial-priority) and ancestor::cda:entry and not(ancestor::cda:performer) " />
    <xsl:variable name="rating-22" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-22 else $rating-alt-TC-Types-22 " />
    <xsl:variable name="rating-28" select="if ($initial-priority) then $initial-rating        else if ($test-step = 'step 1' and exists(ancestor::cda:section/cda:code[@codeSystem='1.2.36.1.2001.1001.101' and @code=$meds-view-sections])) then $rating-MHRView-TC-Doc-28-step-1       else if ($test-step = 'step 1') then $rating-TC-Doc-28-step-1        else if ($test-step = 'step 4') then $rating-TC-Doc-28-step-4 else '' " />
    <xsl:variable name="rating-48" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-48 else $rating-alt-TC-Types-48 " />
    <xsl:variable name="rating-49" select="if ($initial-priority) then $initial-rating else if ($default-context) then $rating-TC-Types-49 else $rating-alt-TC-Types-49 " />
    <!--REPORT -->
    <xsl:if test=" ($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="($flags/@allow-debug = 'true' and true()) or $flags/@report-data = 'true'">
        <xsl:attribute name="flag">FINDING</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Finding: TC-Types-22: The Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type
		and <xsl:text /><xsl:value-of select="if (@value or cda:low/@value or cda:high/@value) then concat('has ', $display-interval)   else 'has no value attribute and no low or high data elements' " /><xsl:text />.
		<xsl:text /><xsl:value-of select="if (@nullFlavor) then concat('The nullFlavor attribute has the value ''', @nullFlavor, '''.') else '' " /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and @nullFlavor = 'DER' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and @nullFlavor = 'DER'">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-48" /><xsl:text />: TC-Types-48: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type.
		It contains a value of nullFlavor 'DER' (<xsl:text /><xsl:value-of select="$nullFlavor-values/@name" /><xsl:text />) which indicates a value
		may exist, but it must be derived from the information provided. Confirm if the use of this nullFlavor is valid.
		(See sections 7.1.4 and 7.3.3.3 of ISO 21090 'Health informatics - Harmonized data types for information interchange'.)

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @nullFlavor = 'NINF' or @nullFlavor = 'PINF' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor = 'NINF' or @nullFlavor = 'PINF'">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-49" /><xsl:text />: TC-Types-49 step 1: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data
		type which is derived from the HL7 'IVL_TS' data type. It has a nullFlavor attribute with the value '<xsl:text /><xsl:value-of select="@nullFlavor" /><xsl:text />'
		(<xsl:text /><xsl:value-of select="$nullFlavors/nullFlavor[@value = current()/@nullFlavor]/@name" /><xsl:text />) which is a
		value of nullFlavor that may not be used for data elements of the IVL data type.
		(See sections 7.1.4 and 7.3.3.3 of ISO 21090 'Health informatics - Harmonized data types for information interchange'.)

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not(cda:originalText) and @nullFlavor = 'UNC' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(cda:originalText) and @nullFlavor = 'UNC'">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-49" /><xsl:text />: TC-Types-49 step 2: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data
		type however it has nullFlavor = 'UNC' (unencoded) which may only be used when there is an originalText. An originalText is not present so it is an error to include
		nullFlavor = 'UNC'. (See section 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0 and section 7.3.3.3.1 of ISO 21090
		'Health informatics - Harmonized data types for information interchange'.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @nullFlavor = 'QS' or @nullFlavor = 'TRC' ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@nullFlavor = 'QS' or @nullFlavor = 'TRC'">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-49" /><xsl:text />: TC-Types-49 step 3: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data
		type which is derived from the HL7 'IVL_TS' data type. It has a nullFlavor attribute with the value '<xsl:text /><xsl:value-of select="@nullFlavor" /><xsl:text />'
		(<xsl:text /><xsl:value-of select="$nullFlavors/nullFlavor[@value = current()/@nullFlavor]/@name" /><xsl:text />) however
		that value of nullFlavor may not be used for data elements of the TS or IVL data types.
		(See sections 7.1.4 and 7.3.3.3 of ISO 21090 'Health informatics - Harmonized data types for information interchange'.)

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @xsi:type and not(@xsi:type = ('TS', 'IVL_TS') or normalize-space(substring-after(@xsi:type, ':')) = ('TS', 'IVL_TS')) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@xsi:type and not(@xsi:type = ('TS', 'IVL_TS') or normalize-space(substring-after(@xsi:type, ':')) = ('TS', 'IVL_TS'))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-22" /><xsl:text />: TC-Types-22: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type which is
		derived from the HL7 'IVL_TS' data type. The HL7 'TS' data type may also be used for a TimeInterval however an xsi:type attribute with the value '<xsl:text /><xsl:value-of select="@xsi:type" /><xsl:text />' was found.
		(See section 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0 and section 3.8.1 of HL7 Version 3 Standard: Data Types - Abstract Specification,
		Release 1.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" local-name(.) = 'value' and not(@xsi:type) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="local-name(.) = 'value' and not(@xsi:type)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-22" /><xsl:text />: TC-Types-22: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type which is
		derived from the HL7 'IVL_TS' data type. The HL7 'TS' data type may also be used for a TimeInterval however no xsi:type attribute is present.
		An xsi:type attribute must be present with the value 'IVL_TS' or 'TS'.
		(See section 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0 and section 3.8.1 of HL7 Version 3 Standard: Data Types - Abstract Specification,
		Release 1.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test="not(@nullFlavor or @value or cda:low or cda:high) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not(@nullFlavor or @value or cda:low or cda:high)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-22" /><xsl:text />: TC-Types-22: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type however
		it does not have a nullFlavor or value attribute or low or high elements. A TimeInterval may only contain a nullFlavor or value attribute or low or high elements with the optional
		'inclusive' attribute included in the low or high elements if there is a need to indicate that the low or high boundaries are excluded.
		(See section 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0.)

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" @value and (cda:low or cda:high) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value and (cda:low or cda:high)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-22" /><xsl:text />: TC-Types-22: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period '<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type.
		It has the element '<xsl:text /><xsl:value-of select="local-name(cda:*[local-name() = ('low', 'high')])" /><xsl:text />' which is used for the HL7 'IVL' data type
		but also has a 'value' attribute which is used by the HL7 'TS' data type and is not used by the HL7 'IVL' data type. The data element must either have a 'value' attribute
		or '<xsl:text /><xsl:value-of select="local-name(cda:*[local-name() = ('low', 'high')])" /><xsl:text />' but not both.
		(See section 7.10.9.5 of ISO 21090 'Health informatics - Harmonized data types for information interchange' and section 3.8.1 of
		HL7 Version 3 Standard: Data Types - Abstract Specification, Release 1.)

            </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($extensions-allowed) and *[not(local-name() = ('low', 'high'))] ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($extensions-allowed) and *[not(local-name() = ('low', 'high'))]">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type however a child element
		'<xsl:text /><xsl:value-of select="local-name(*[not(local-name() = ('low', 'high'))])" /><xsl:text />' was found
		that is not expected for the TimeInterval data type so this element is an extension. <xsl:text /><xsl:value-of select="$message-text1" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" not($flags/@allow-hints = 'false') and $extensions-allowed and *[not(local-name() = ('low', 'high', 'width'))] ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="not($flags/@allow-hints = 'false') and $extensions-allowed and *[not(local-name() = ('low', 'high', 'width'))]">
        <xsl:attribute name="flag">HINT</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Hint<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in
		the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type however a child element
		'<xsl:text /><xsl:value-of select="local-name(*[not(local-name() = ('low', 'high', 'width'))])" /><xsl:text />' was found
		that is not expected for the TimeInterval data type so this element is an extension. <xsl:text /><xsl:value-of select="$message-text1" /><xsl:text /></svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $extensions-allowed and cda:width/@value and ((cda:low/@value and not(cda:high/@value)) or (not(cda:low/@value) and cda:high/@value)) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$extensions-allowed and cda:width/@value and ((cda:low/@value and not(cda:high/@value)) or (not(cda:low/@value) and cda:high/@value))">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type however a width element is also
		present with the value '<xsl:text /><xsl:value-of select="cda:width/@value" /><xsl:text />' and unit '<xsl:text /><xsl:value-of select="cda:width/@unit" /><xsl:text />'.		
		This is an error as the presence of a <xsl:text /><xsl:value-of select="if (cda:low) then 'low' else 'high' " /><xsl:text /> element without a <xsl:text /><xsl:value-of select="if (cda:low) then 'high' else 'low' " /><xsl:text /> element
		means the TimeInterval is unbounded in one direction however the width element implies the interval is bounded. That is the width element is an extension that qualifies the
		time interval whereas an extension is allowed only if it does not qualify or negate the time interval.
		(See the definition of Document Author Participation Period in the <xsl:text /><xsl:value-of select="$logical-spec" /><xsl:text />, section 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0
		and <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)
		As the <xsl:text /><xsl:value-of select="if (cda:low) then 'start' else 'end' " /><xsl:text /> of the time interval is known then the Document Author Participation Period must also have a
		<xsl:text /><xsl:value-of select="if (cda:low) then ' high' else ' low' " /><xsl:text /> element as the TimeInterval data type uses low and high elements rather than width to define an interval.

	    </svrl:text>
      </svrl:successful-report>
    </xsl:if>
    <!--REPORT -->
    <xsl:if test=" $extensions-allowed and cda:width/@value and not(cda:high/@value or cda:low/@value) ">
      <svrl:successful-report xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="$extensions-allowed and cda:width/@value and not(cda:high/@value or cda:low/@value)">
        <xsl:attribute name="flag">ERROR</xsl:attribute>
        <xsl:attribute name="location">
          <xsl:apply-templates select="." mode="schematron-get-full-path" />
        </xsl:attribute>
        <svrl:text>

		Error<xsl:text /><xsl:value-of select="$rating-28" /><xsl:text />: TC-Doc-28 <xsl:text /><xsl:value-of select="$test-step" /><xsl:text />: According to section 2.4 of the Participation Data Specification v3.2 and section 7.1.1.1.1 of the Advance Care Information CDA Implementation Guide v1.0 the Document Author Participation Period
		'<xsl:text /><xsl:value-of select="local-name(..)" /><xsl:text />/<xsl:text /><xsl:value-of select="local-name(.)" /><xsl:text />' data element in the <xsl:text /><xsl:value-of select="iq:location(., '')" /><xsl:text /> has the TimeInterval data type however a width element is also
		present with the value '<xsl:text /><xsl:value-of select="cda:width/@value" /><xsl:text />' and unit '<xsl:text /><xsl:value-of select="cda:width/@unit" /><xsl:text />'.		
		This is an error as the Document Author Participation Period has no low or high elements so the TimeInterval is unbounded however the width element implies the interval is bounded. That is the width element is an
		extension that qualifies the time interval whereas an extension is allowed only if it does not qualify or negate the time interval.
		(See the definition of Document Author Participation Period in the <xsl:text /><xsl:value-of select="$logical-spec" /><xsl:text />, section 9.2 of Data Types in NEHTA Specifications - A Profile of ISO 21090 Specification v1.0
		and <xsl:text /><xsl:value-of select="$extension-requirement" /><xsl:text />.)
		The 